/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db.epo;

import com.nai.mcafee.common.db.epo.EpoPassword;
import com.nai.mcafee.common.util.FileUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EpoServerIni {
    private String m_dbServer = "";
    private String m_dbInstance = "";
    private String m_dbName = "";
    private String m_userName = "";
    private String m_password = "";
    private String m_domain = "";
    private String m_agentWakeupPort = "";
    private String m_serverConsolePort = "";

    public EpoServerIni(String string) throws IOException {
        String string2 = FileUtil.loadAsString(string);
        this.parseFile(string2);
    }

    public EpoServerIni(Reader reader) throws IOException {
        String string = FileUtil.loadAsString(reader);
        this.parseFile(string);
    }

    private void parseFile(String string) {
        boolean bl;
        this.m_dbServer = this.getString(string, "DataSource");
        this.m_dbName = this.getString(string, "Database");
        int n = this.m_dbServer.indexOf("\\");
        if (n != -1) {
            this.m_dbInstance = this.m_dbServer.substring(n + 1, this.m_dbServer.length());
            this.m_dbServer = this.m_dbServer.substring(0, n);
        }
        if (bl = this.getBoolean(string, "UseNTAccount")) {
            this.m_userName = this.getString(string, "NTUserName");
            n = this.m_userName.indexOf("\\");
            if (n != -1) {
                this.m_domain = this.m_userName.substring(0, n);
                this.m_userName = this.m_userName.substring(n + 1, this.m_userName.length());
            }
            this.m_password = this.getString(string, "NTPassword");
        } else {
            this.m_domain = "";
            this.m_userName = this.getString(string, "UserName");
            this.m_password = this.getString(string, "Password");
        }
        this.m_agentWakeupPort = this.getString(string, "AgentHttpPort");
        this.m_serverConsolePort = this.getString(string, "ConsoleHTTPPort");
    }

    public String getString(String string, String string2) {
        Pattern pattern = Pattern.compile("\\s" + string2 + "\\s*=\\s*(\\S+.*)\r\n");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    private boolean getBoolean(String string, String string2) {
        String string3 = this.getString(string, string2);
        return string3.equals("1");
    }

    public String getDbServer() {
        return this.m_dbServer;
    }

    public String getDbInstance() {
        return this.m_dbInstance;
    }

    public String getDbName() {
        return this.m_dbName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getAgentWakeupPort() {
        return this.m_agentWakeupPort;
    }

    public String getServerConsolePort() {
        return this.m_serverConsolePort;
    }

    public String getDecryptedPassword() {
        try {
            return EpoPassword.decryptPassphrase(this.m_password, 2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getDomain() {
        return this.m_domain;
    }
}

