/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.ui.tables;

import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.tables.InvalidTableException;
import com.nai.mcafee.common.ui.util.PaginationMgr;
import com.nai.mcafee.common.util.Resource;
import java.util.ArrayList;

public class HtmlTable {
    private HtmlTableHeader m_header = new HtmlTableHeader();
    private ArrayList m_rows = null;
    private boolean m_hasCheckbox = false;
    private String m_id = null;
    private PaginationMgr m_paginationMgr = null;
    protected boolean m_2col = false;

    public HtmlTable() {
        this.m_header.setParent(this);
        this.m_rows = new ArrayList();
    }

    public HtmlTableRow addRow() {
        this.m_rows.add(new HtmlTableRow());
        ((HtmlTableRow)this.m_rows.get(this.m_rows.size() - 1)).setParent(this);
        return (HtmlTableRow)this.m_rows.get(this.m_rows.size() - 1);
    }

    public HtmlTableRow addRow(int n) throws InvalidTableException {
        HtmlTableRow htmlTableRow = this.addRow();
        htmlTableRow.setRowType(n);
        return htmlTableRow;
    }

    public String getHtml(String string) throws InvalidTableException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table cellSpacing=0 cellPadding=0 border=0 class='' width='100%'");
        if (this.m_id != null) {
            stringBuffer.append(" id='").append(this.m_id).append("'");
        }
        stringBuffer.append(">\n");
        this.m_header.getHtml(stringBuffer, 0);
        int n = 0;
        while (n < this.m_rows.size()) {
            ((HtmlTableRow)this.m_rows.get(n)).getHtml(stringBuffer, n);
            ++n;
        }
        if (this.m_paginationMgr != null) {
            stringBuffer.append("    <tr><td colspan='").append(this.m_header.getNumCells()).append("' class='").append("TaskTableFooter").append("'>").append(this.m_paginationMgr.getHtml(string)).append("</td></tr>\n");
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public static String getSortMarker(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(" <img ");
        if (n == 2) {
            stringBuffer.append("src='images/ItemsSortedDown.gif' ").append("alt='").append(Resource.getString("htmltable_sorted_down", string)).append("' ").append("title='").append(Resource.getString("htmltable_sorted_down", string)).append("' ");
        } else {
            stringBuffer.append("src='images/ItemsSortedUp.gif' ").append("alt='").append(Resource.getString("htmltable_sorted_up", string)).append("' ").append("title='").append(Resource.getString("htmltable_sorted_up", string)).append("' ");
        }
        stringBuffer.append("width='14' height='14' align='absMiddle' border='0'>");
        return stringBuffer.toString();
    }

    public int getNumRows() {
        return this.m_rows.size();
    }

    public boolean getHasCheckbox() {
        return this.m_hasCheckbox;
    }

    public void setHasCheckbox(boolean bl) {
        this.m_hasCheckbox = bl;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public HtmlTableHeader getHeader() {
        return this.m_header;
    }

    public PaginationMgr getPaginationMgr() {
        return this.m_paginationMgr;
    }

    public void setPaginationMgr(PaginationMgr paginationMgr) {
        this.m_paginationMgr = paginationMgr;
    }

    public boolean is2col() {
        return this.m_2col;
    }

    public void set2col(boolean bl) {
        this.m_2col = bl;
    }
}

