/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseObjectTestBase;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.util.DateParser;
import com.nai.mcafee.common.util.DateParserException;
import com.nai.mcafee.snowcap.db.EventLog;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.QueryUtil;
import com.nai.mcafee.snowcap.db.Sensor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import junit.framework.Assert;

public class SnowcapDatabaseObjectTestBase
extends DatabaseObjectTestBase {
    public SnowcapDatabaseObjectTestBase(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.removeTestData();
        }
        catch (Exception exception) {
            DatabaseUtil.close((Connection)this.m_con);
            this.m_con = null;
            throw exception;
        }
    }

    private void removeTestData() throws SQLException {
        QueryUtil.clearAllTables(this.m_con);
        this.m_con.commit();
    }

    public static final Host createTestHost() throws DateParserException {
        Host host = new Host();
        host.setId(-1);
        host.setMAC("000000ffffff");
        host.setNetworkAddr("192.168.1.101");
        host.setProtocolID(1);
        host.setNetbiosName("rogue");
        host.setDnsName("rogue.foo.com");
        host.setLastDetectTime(SnowcapDatabaseObjectTestBase.timestampFromString("2002-05-03T07:11:11.000-08:00"));
        host.setFirstDetectTime(host.getLastDetectTime());
        host.setNetworkID(null);
        host.setException(false);
        host.setDeleted(false);
        host.setEpoIndex(null);
        host.setComments("I am rogue");
        host.setOSInfo("Windows", "NT", "2000 Pro");
        host.setNetbiosComment("nb comment");
        host.setUsers("Al,Bob");
        host.setDomain("domainA");
        host.setSid("111111112222222233333333444444445555555566666666");
        host.setFirstRogueTime(SnowcapDatabaseObjectTestBase.timestampFromString("2002-12-25T12:00:12.000-08:00"));
        host.setRogueType(0);
        host.setLastAgentCom(SnowcapDatabaseObjectTestBase.timestampFromString("2003-09-16T12:00:12.000-08:00"));
        host.setMarkedForAction(1);
        return host;
    }

    public static final Host createTestHost2() throws DateParserException {
        Host host = new Host();
        host.setId(-1);
        host.setMAC("dd0000dddddd");
        host.setNetworkAddr("10.1.2.3");
        host.setProtocolID(1);
        host.setNetbiosName("dog");
        host.setDnsName("dog.bark.com");
        host.setLastDetectTime(SnowcapDatabaseObjectTestBase.timestampFromString("2000-04-20T16:20:00.000-08:00"));
        host.setFirstDetectTime(host.getLastDetectTime());
        host.setNetworkID(null);
        host.setException(true);
        host.setDeleted(true);
        host.setEpoIndex(null);
        host.setComments("I'm not rogue");
        host.setOSInfo("Linux", "Redhat", "7.1");
        host.setNetbiosComment("my comment");
        host.setUsers("Chris,Dan");
        host.setDomain("domainB");
        host.setSid("444444445555555566666666111111112222222233333333");
        host.setFirstRogueTime(SnowcapDatabaseObjectTestBase.timestampFromString("2002-07-04T16:20:20.000-08:00"));
        host.setRogueType(1);
        host.setLastAgentCom(SnowcapDatabaseObjectTestBase.timestampFromString("2000-01-01T12:00:12.000-08:00"));
        host.setMarkedForAction(0);
        return host;
    }

    public static final Sensor createTestSensor(int n) throws DateParserException {
        Sensor sensor = new Sensor(n, "123456abcdef", "sensor", "192.168.1.1", "Windows", "NT", "2000 Pro", SnowcapDatabaseObjectTestBase.timestampFromString("2003-03-13T10:35:20.000-08:00"), "domainA", "111111112222222233333333444444445555555566666666", "11223344-aabb-ccdd-eeff-556677889900");
        return sensor;
    }

    public static final Sensor createTestSensor2(int n) throws DateParserException {
        Sensor sensor = new Sensor(n, "112233aabbcc", "sensor2", "10.10.10.10", "Linux", "Redhat", "6.5", SnowcapDatabaseObjectTestBase.timestampFromString("2002-02-12T10:25:30.000-08:00"), "domainB", "444444445555555566666666111111112222222233333333", "aabbccdd-eeff-0011-2233-445566778899");
        return sensor;
    }

    public static final Network createTestNetwork() {
        Network network = new Network();
        network.setNetworkName("Fred");
        network.setNetworkAddress("192.168.1.0");
        network.setSubnetMask("255.255.255.0");
        network.setCovered(true);
        return network;
    }

    public static final Network createTestNetwork2() {
        Network network = new Network();
        network.setNetworkName("George");
        network.setNetworkAddress("10.0.0.0");
        network.setSubnetMask("255.0.0.0");
        network.setCovered(false);
        return network;
    }

    public static final EventLog createTestEventLog(int n, int n2, int n3) {
        return new EventLog(1, n, n2, n3);
    }

    public static final Timestamp timestampFromString(String string) throws DateParserException {
        DateParser dateParser = new DateParser();
        return new Timestamp(dateParser.convert(string).getTime());
    }

    public static final void assertNotEquals(Object object, Object object2) {
        if (object == null && object2 != null) {
            return;
        }
        if (object != null && object2 == null) {
            return;
        }
        if (object == null && object2 == null) {
            Assert.fail((String)"Expected to be unequal; got two nulls!");
        }
        if (object.equals(object2)) {
            Assert.fail((String)("Expected to be non-equal:" + object + " " + object2));
        }
    }

    public static final void assertNotEquals(int n, int n2) {
        SnowcapDatabaseObjectTestBase.assertNotEquals(new Integer(n), new Integer(n2));
    }

    public static final void assertNotEquals(long l, long l2) {
        SnowcapDatabaseObjectTestBase.assertNotEquals(new Long(l), new Long(l2));
    }

    public static final void assertNotEquals(boolean bl, boolean bl2) {
        SnowcapDatabaseObjectTestBase.assertNotEquals(new Boolean(bl), new Boolean(bl2));
    }

    public void testProperties(DatabaseObject databaseObject) {
        int n = 1;
        while (n < databaseObject.getNumColumns()) {
            try {
                databaseObject.getProperty(n);
            }
            catch (Exception exception) {
                Assert.fail((String)("Error:" + exception + "getProperty failed for class " + databaseObject.getClass().toString() + " property index:" + n));
            }
            ++n;
        }
    }
}

