/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db.epo;

import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;

public class EpoDatabase {
    public static final int SORT_NONE = 1;
    public static final int SORT_ASCENDING = 2;
    public static final int SORT_DESCENDING = 3;
    public static final int LOOKUP_MAC = 1;
    public static final int LOOKUP_NAME = 2;
    public static final int LOOKUP_USE_DOMAIN = 4;
    public static final int LOOKUP_IP = 8;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_REPORT = 1;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_MANAGE = 2;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_DEPLOY = 4;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_PROTECTED = 8;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_HIDDEN = 16;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_UI = 32;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_PUSHABLE = 64;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_UNINSTALLABLE = 128;
    public static final int EPO_DAL_SOFTWARE_REPOFLAG_NAP_IS_REMOVEABLE = 256;
    public static final String EPO_AGENT_FAMILY = "EPO";
    public static final String SNOWCAP_SENSOR_FAMILY = "SECURE";
    public static final int LOOKUP_MAC_OR_NAME = 3;
    public static final int LOOKUP_MAC_OR_NAME_WITH_DOMAIN = 7;
    public static final int LOOKUP_MAC_OR_IP = 9;
    public static final String SQL_GET_LEAFNODE_PREFIX = "select ln.AutoID, ln.LastUpdate from ComputerProperties as cp inner join LeafNode as ln on cp.ParentID = ln.AutoID ";
    public static final String SQL_GET_LEAFNODE_SUFFIX = " and ln.ParentID != 0";
    public static final String SQL_GET_LEAFNODE_BY_MAC = "select ln.AutoID, ln.LastUpdate from ComputerProperties as cp inner join LeafNode as ln on cp.ParentID = ln.AutoID where (cp.NetAddress = ? or cp.NetAddress = ?) and ln.ParentID != 0";
    public static final String SQL_GET_LEAFNODE_BY_HOSTNAME = "select ln.AutoID, ln.LastUpdate from ComputerProperties as cp inner join LeafNode as ln on cp.ParentID = ln.AutoID where cp.ComputerName = ? and ln.ParentID != 0";
    public static final String SQL_GET_LEAFNODE_BY_HOSTNAME_AND_DOMAIN = "select ln.AutoID, ln.LastUpdate from ComputerProperties as cp inner join LeafNode as ln on cp.ParentID = ln.AutoID where cp.ComputerName = ? and cp.DomainName = ? and ln.ParentID != 0";
    public static final String SQL_GET_LEAFNODE_BY_IP = "select ln.AutoID, ln.LastUpdate from ComputerProperties as cp inner join LeafNode as ln on cp.ParentID = ln.AutoID where cp.IPAddress = ? and ln.ParentID != 0";
    public static final String SQL_GET_AGENT_GUID = "select AgentGUID from LeafNode where AutoID=?";
    public static final String SQL_GET_PASSWORD = "select Password from UserTable where UserName=?";
    public static final String SQL_GET_AGENTS = "select RepoFlag, SoftwareName, ProductVersion, OSType, PackDir from Software where ProductFamily=?";
    private static Pattern m_guidPattern = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    private static final Pattern m_ipPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");

    public static final long parseAgentTime(String string) {
        if (string == null || string.length() != 14) {
            return 0L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(string.substring(0, 4)));
        calendar.set(2, Integer.parseInt(string.substring(4, 6)) - 1);
        calendar.set(5, Integer.parseInt(string.substring(6, 8)));
        calendar.set(11, Integer.parseInt(string.substring(8, 10)));
        calendar.set(12, Integer.parseInt(string.substring(10, 12)));
        calendar.set(13, Integer.parseInt(string.substring(12, 14)));
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static final AgentInfo getAgentInfo(Connection connection, Host host) throws SQLException {
        return EpoDatabase.getAgentInfo(connection, host, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AgentInfo getAgentInfo(Connection connection, Host host, int n) throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        AgentInfo agentInfo = null;
        try {
            if (EpoDatabase.shouldLookupMAC(n, host)) {
                statement = connection.prepareStatement(SQL_GET_LEAFNODE_BY_MAC);
                statement.setString(1, host.getMAC());
                statement.setString(2, StringUtil.formatMAC((String)host.getMAC()));
                agentInfo = AgentInfo.create(statement.executeQuery());
            }
            if (agentInfo == null && EpoDatabase.shouldLookupName(n, host)) {
                if (EpoDatabase.shouldUseDomain(n, host)) {
                    statement2 = connection.prepareStatement(SQL_GET_LEAFNODE_BY_HOSTNAME_AND_DOMAIN);
                    statement2.setString(1, EpoDatabase.getHostname(host));
                    statement2.setString(2, host.getDomain());
                } else {
                    statement2 = connection.prepareStatement(SQL_GET_LEAFNODE_BY_HOSTNAME);
                    statement2.setString(1, EpoDatabase.getHostname(host));
                }
                agentInfo = AgentInfo.create(statement2.executeQuery());
            }
            if (agentInfo == null && EpoDatabase.shouldLookupIP(n, host)) {
                statement3 = connection.prepareStatement(SQL_GET_LEAFNODE_BY_IP);
                statement3.setString(1, host.getNetworkAddr());
                agentInfo = AgentInfo.create(statement3.executeQuery());
            }
            AgentInfo agentInfo2 = agentInfo;
            return agentInfo2;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
            if (statement3 != null) {
                statement3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Network[] getAllSubnets(Connection connection, int n) throws SQLException {
        Network[] networkArray;
        Vector<Network> vector;
        block7: {
            Statement statement = null;
            ResultSet resultSet = null;
            vector = new Vector<Network>();
            try {
                networkArray = "select distinct SubnetAddress, SubnetMask from ComputerProperties";
                if (n == 2) {
                    networkArray = (String)networkArray + " order by SubnetAddress asc";
                } else if (n == 3) {
                    networkArray = (String)networkArray + " order by SubnetAddress desc";
                }
                statement = connection.prepareStatement((String)networkArray);
                resultSet = statement.executeQuery();
                while (true) {
                    String string;
                    if (!resultSet.next()) {
                        Object var9_8 = null;
                        if (statement == null) break block7;
                        break;
                    }
                    String string2 = resultSet.getString(1);
                    if (!EpoDatabase.isSubnetValid(string2, string = resultSet.getString(2))) continue;
                    vector.add(new Network("", string2, string));
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
        }
        networkArray = new Network[]{};
        return vector.toArray(networkArray);
    }

    private static final boolean isSubnetValid(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        if (!m_ipPattern.matcher(string).matches()) {
            return false;
        }
        if (!m_ipPattern.matcher(string2).matches()) {
            return false;
        }
        return !string.equals("0.0.0.0");
    }

    public static final Network[] getAllSubnets(Connection connection) throws SQLException {
        return EpoDatabase.getAllSubnets(connection, 1);
    }

    public static final void copyEpoSubnetsIntoSnowcap(Connection connection, Network[] networkArray) throws SQLException {
        int n = 0;
        while (n < networkArray.length) {
            if (networkArray[n].getIdFromDatabase(connection) == -1) {
                networkArray[n].add(connection, false);
            }
            ++n;
        }
    }

    public static final boolean isValidAgentGUID(String string) {
        return m_guidPattern.matcher(string).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final HashMap getAgentList(Connection connection, String string, int n, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PreparedStatement preparedStatement = null;
        try {
            block5: {
                try {
                    preparedStatement = connection.prepareStatement(SQL_GET_AGENTS);
                    preparedStatement.setString(1, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet == null) break block5;
                    while (resultSet.next()) {
                        int n2 = resultSet.getInt(1) & n;
                        if (n2 != n) continue;
                        String string3 = Resource.getDataString(resultSet.getString(2), string2);
                        String string4 = string3 + " " + resultSet.getString(3);
                        String string5 = resultSet.getString(4);
                        String string6 = Resource.formatString("pushagent_agent_selection", new Object[]{string4, string5}, string2);
                        String string7 = resultSet.getString(5);
                        hashMap.put(string6, string7);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw sQLException;
                }
            }
            Object var14_14 = null;
            if (preparedStatement == null) return hashMap;
            preparedStatement.close();
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
    }

    private static final String getHostname(Host host) {
        if (host.getNetbiosName().length() > 0) {
            return host.getNetbiosName();
        }
        if (host.getDnsName().length() <= 0) {
            return null;
        }
        String string = host.getDnsName();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static final boolean shouldLookupMAC(int n, Host host) {
        return (n & 1) != 0;
    }

    private static final boolean shouldLookupName(int n, Host host) {
        return (n & 2) != 0 && EpoDatabase.getHostname(host) != null;
    }

    private static final boolean shouldUseDomain(int n, Host host) {
        return (n & 4) != 0 && host.getDomain().length() > 0;
    }

    private static final boolean shouldLookupIP(int n, Host host) {
        return (n & 8) != 0 && host.getNetworkAddr().length() > 0;
    }

    public static class AgentInfo {
        private String m_lastCommunication = "";
        private int m_leafNodeIndex = 0;

        public AgentInfo(int n, String string) {
            this.m_leafNodeIndex = n;
            this.m_lastCommunication = string;
        }

        public long getLastCommInMillis() {
            return EpoDatabase.parseAgentTime(this.m_lastCommunication);
        }

        public String getLastCommunication() {
            return this.m_lastCommunication;
        }

        public int getLeafNodeIndex() {
            return this.m_leafNodeIndex;
        }

        public void setLastCommunication(String string) {
            this.m_lastCommunication = string;
        }

        public static final AgentInfo create(ResultSet resultSet) throws SQLException {
            if (resultSet != null && resultSet.next()) {
                return new AgentInfo(resultSet.getInt(1), resultSet.getString(2));
            }
            return null;
        }
    }
}

