/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db.io;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.Tool;
import com.nai.mcafee.snowcap.action.concrete.ExternalToolAction;
import com.nai.mcafee.snowcap.db.ResponseDatabaseObject;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.action.ActionFactory;
import com.nai.mcafee.snowcap.db.action.ActionFactoryException;
import com.nai.mcafee.snowcap.db.action.ActionPropertyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResponseSet
implements Serializable {
    private ResponseDatabaseObject[] m_responses = null;
    private ArrayList m_actions = new ArrayList();
    private Tool[] m_tools = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$io$ResponseSet;

    public void load(Connection connection, ActionFactory actionFactory) throws SQLException, ActionPropertyException, ActionFactoryException {
        this.m_responses = ResponseDatabaseObject.getAll(connection);
        this.m_tools = Tool.getAll((Connection)connection, (int)1);
        int n = 0;
        while (n < this.m_responses.length) {
            this.m_responses[n].setResponseOrder(-1);
            this.m_actions.add(ActionBase.getByResponseId(connection, this.m_responses[n].getId(), actionFactory));
            ++n;
        }
    }

    public void save(Connection connection) throws SQLException, ActionPropertyException {
        if (!$assertionsDisabled && this.m_responses == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_responses.length != this.m_actions.size()) {
            throw new AssertionError();
        }
        try {
            int n = 0;
            while (n < this.m_responses.length) {
                ResponseDatabaseObject responseDatabaseObject = this.m_responses[n];
                responseDatabaseObject.setResponseOrder(-1);
                ResponseDatabaseObject.add(connection, true, responseDatabaseObject);
                ActionBase[] actionBaseArray = (ActionBase[])this.m_actions.get(n);
                int n2 = 0;
                while (n2 < actionBaseArray.length) {
                    if (actionBaseArray[n2] instanceof ExternalToolAction) {
                        this.addToolToDb(connection, (ExternalToolAction)actionBaseArray[n2]);
                    }
                    actionBaseArray[n2].setResponseId(responseDatabaseObject.getId());
                    actionBaseArray[n2].add(connection);
                    ++n2;
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            DatabaseUtil.rollback((Connection)connection);
            throw sQLException;
        }
        catch (ActionPropertyException actionPropertyException) {
            DatabaseUtil.rollback((Connection)connection);
            throw actionPropertyException;
        }
        connection.commit();
    }

    public byte[] saveToBinary() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this);
        return byteArrayOutputStream.toByteArray();
    }

    public static ResponseSet loadFromBinary(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return (ResponseSet)objectInputStream.readObject();
    }

    public ResponseDatabaseObject[] getResponses() {
        return this.m_responses;
    }

    public ArrayList getActions() {
        return this.m_actions;
    }

    public Tool[] getTools() {
        return this.m_tools;
    }

    private void addToolToDb(Connection connection, ExternalToolAction externalToolAction) throws SQLException {
        int n = externalToolAction.getToolId();
        Tool tool = this.findToolById(n);
        if (tool == null) {
            throw new SQLException("Internal error: External tool action missing required tool definition.");
        }
        int n2 = tool.lookupIdForTool(connection);
        if (n2 == -1) {
            tool.add(connection, false);
            n2 = tool.lookupIdForTool(connection);
        }
        externalToolAction.setToolId(n2);
    }

    private Tool findToolById(int n) {
        if (this.m_tools == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.m_tools.length) {
            if (this.m_tools[n2].getId() == n) {
                return this.m_tools[n2];
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$db$io$ResponseSet == null ? (class$com$nai$mcafee$snowcap$db$io$ResponseSet = ResponseSet.class$("com.nai.mcafee.snowcap.db.io.ResponseSet")) : class$com$nai$mcafee$snowcap$db$io$ResponseSet).desiredAssertionStatus();
    }
}

