/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.event;

import com.nai.mcafee.common.condition.EvalContext;
import com.nai.mcafee.common.condition.EvaluationException;
import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpBool;
import com.nai.mcafee.snowcap.action.Action;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.action.ActionInvoker;
import com.nai.mcafee.snowcap.db.EventTypes;
import com.nai.mcafee.snowcap.event.Event;
import com.nai.mcafee.snowcap.event.EventEvalContext;
import com.nai.mcafee.snowcap.event.EventHandler;
import com.nai.mcafee.snowcap.util.Resource;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Response
implements EventHandler {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$event$Response == null ? (class$com$nai$mcafee$snowcap$event$Response = Response.class$("com.nai.mcafee.snowcap.event.Response")) : class$com$nai$mcafee$snowcap$event$Response).getName());
    private String m_name = "";
    private ArrayList m_actions = new ArrayList();
    private ActionErrorHandler m_errorHandler = null;
    private Sexp m_condition = null;
    private ActionInvoker m_invoker = null;
    private int m_eventType = -1;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$event$Response;

    public Response() {
    }

    public Response(ActionErrorHandler actionErrorHandler, ActionInvoker actionInvoker) {
        this.setInvoker(actionInvoker);
        this.setErrorHandler(actionErrorHandler);
    }

    public void setErrorHandler(ActionErrorHandler actionErrorHandler) {
        this.m_errorHandler = actionErrorHandler;
        if (this.m_invoker != null) {
            this.m_invoker.setErrorHandler(actionErrorHandler);
        }
    }

    public void setInvoker(ActionInvoker actionInvoker) {
        this.m_invoker = actionInvoker;
    }

    public void addAction(Action action) {
        this.m_actions.add(action);
    }

    public void removeAction(Action action) {
        this.m_actions.remove(action);
    }

    public int numActions() {
        return this.m_actions.size();
    }

    public Action getAction(int n) {
        return (Action)this.m_actions.get(n);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void handleEvent(Event event) {
        m_log.debug((Object)("Handling new event: " + event.toString()));
        if (this.m_eventType == -2 || this.m_eventType != event.type() && this.m_eventType != -1) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("Response [" + this.m_name + "] - ignoring event; it is of type " + EventTypes.asString(event.type(), "en") + " and I process type: " + EventTypes.asString(event.type(), "en")));
            }
            return;
        }
        if (this.m_condition != null) {
            SexpBool sexpBool;
            block9: {
                m_log.info((Object)Resource.formatString("response_template_eval_condition", new Object[]{this.m_name, event}));
                sexpBool = SexpBool.FALSE;
                try {
                    sexpBool = this.m_condition.eval((EvalContext)new EventEvalContext(event));
                }
                catch (EvaluationException evaluationException) {
                    if (this.m_errorHandler == null) break block9;
                    this.m_errorHandler.handleError(event, this.m_name, evaluationException);
                }
            }
            if (sexpBool != SexpBool.TRUE) {
                return;
            }
        }
        int n = 0;
        while (n < this.m_actions.size()) {
            block10: {
                Action action = (Action)this.m_actions.get(n);
                ActionContext actionContext = event.createActionContext();
                m_log.debug((Object)"Invoking action directly.");
                try {
                    ActionInvoker.invokeAction(action, actionContext);
                    m_log.info((Object)Resource.formatString("response_template_took_action", new Object[]{action, event}));
                }
                catch (ActionInvocationException actionInvocationException) {
                    if (this.m_errorHandler == null) break block10;
                    this.m_errorHandler.handleError(action, actionContext, actionInvocationException);
                }
            }
            ++n;
        }
    }

    public Sexp getCondition() {
        return this.m_condition;
    }

    public void setCondition(Sexp sexp) {
        this.m_condition = sexp;
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public void setEventType(int n) {
        this.m_eventType = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DefaultErrorHandler
    implements ActionErrorHandler {
        public void handleError(Action action, ActionContext actionContext, ActionInvocationException actionInvocationException) {
            m_log.error((Object)Resource.formatString("response_template_error", new Object[]{actionInvocationException, action, actionContext}));
        }

        public void handleError(Event event, String string, EvaluationException evaluationException) {
            m_log.error((Object)Resource.formatString("response_template_cond_error", new Object[]{evaluationException, string, event}));
        }
    }

    public static interface ActionErrorHandler {
        public void handleError(Action var1, ActionContext var2, ActionInvocationException var3);

        public void handleError(Event var1, String var2, EvaluationException var3);
    }
}

