/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.HostStatus;
import com.nai.mcafee.snowcap.db.RogueTypes;
import com.nai.mcafee.snowcap.ui.util.PropDisplay;
import com.nai.mcafee.snowcap.util.Resource;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;

public class HostPropDisplay
implements PropDisplay {
    Host m_dbo;
    private String m_lang = null;
    public static final boolean[] DISPLAYABLE_PROPERTIES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$util$HostPropDisplay;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$Host;

    public DatabaseObject getDbo() {
        return this.m_dbo;
    }

    public void setDbo(DatabaseObject databaseObject) {
        this.m_dbo = (Host)databaseObject;
    }

    public HostPropDisplay(String string) {
        this.m_lang = string;
    }

    public String getTruncatedProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        if (!($assertionsDisabled || n > 0 && n <= this.m_dbo.getNumProperties())) {
            throw new AssertionError();
        }
        if (n == 29) {
            return HostStatus.asString(this.m_dbo.getStatus(), this.m_lang);
        }
        if (n == 23) {
            return RogueTypes.asString(this.m_dbo.getRogueType(), this.m_lang);
        }
        if (n == 25) {
            return Long.toString(this.m_dbo.getIpAddressNum());
        }
        if (n == 22) {
            if (this.m_dbo.isRogue()) {
                return StringUtil.formatDateTime((Timestamp)((Timestamp)this.m_dbo.getProperty(n)));
            }
            return "--";
        }
        if (n == 2) {
            return StringUtil.formatMAC((String)this.m_dbo.getMAC());
        }
        if (n == 26) {
            return StringUtil.safeHtml((String)this.m_dbo.getFriendlyName());
        }
        if (n == 27) {
            if (this.m_dbo.getMarkedForAction() == 1) {
                return "<img src='images/MarkedForAction.gif' align=absMiddle border=0 alt='" + Resource.getString("displaymachinesbean_action_required", this.m_lang) + "' title='" + Resource.getString("displaymachinesbean_action_required", this.m_lang) + "' />";
            }
            return "<img src='images/px_trans.gif' align=absMiddle border=0 height=11 width=11 alt='" + Resource.getString("displaymachinesbean_no_action_required", this.m_lang) + "' title='" + Resource.getString("displaymachinesbean_no_action_required", this.m_lang) + "' />";
        }
        if (this.m_dbo.getProperty(n) instanceof Timestamp) {
            return StringUtil.formatDateTime((Timestamp)((Timestamp)this.m_dbo.getProperty(n)));
        }
        Object object = this.m_dbo.getProperty(n);
        return StringUtil.safeHtml((String)(object == null ? "" : object.toString()));
    }

    public String getFullHeader(int n) {
        if (this.isPropertyDisplayable(n)) {
            return Resource.getString("hostpropdisplay_" + Host.PROPERTY_NAMES[n], this.m_lang);
        }
        return "";
    }

    public String getFullProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        return this.getTruncatedProperty(n);
    }

    public String getTruncatedHeader(int n) {
        return this.getFullHeader(n);
    }

    public boolean isPropertyDisplayable(int n) {
        if (n > DISPLAYABLE_PROPERTIES.length) {
            return false;
        }
        return DISPLAYABLE_PROPERTIES[n];
    }

    public int getRowStyle() {
        int n = this.m_dbo.getStatus();
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }

    public String getOrderByClause(int n, int n2) {
        String string;
        if (!($assertionsDisabled || n > 0 && n <= 29)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 != 1 && n2 != 2) {
            throw new AssertionError();
        }
        String string2 = n2 == 1 ? "asc " : "desc ";
        String string3 = string = n2 == 1 ? "desc " : "asc ";
        if (n == 29) {
            return "Exception " + string + ", RogueType " + string2 + ", LastDetectTime " + string2;
        }
        if (n == 4) {
            return "IpAddressNum " + string2;
        }
        return Integer.toString(n) + " " + string2;
    }

    public int getDefaultSortCol() {
        return 4;
    }

    public int getDefaultSortOrder() {
        return 1;
    }

    public String getTableName() {
        return "Hosts as H left join OUIs on H.OUI = OUIs.OUI";
    }

    public String getIdColumnName() {
        return "H.HostId";
    }

    public Class getDBClass() {
        return class$com$nai$mcafee$snowcap$db$Host == null ? (class$com$nai$mcafee$snowcap$db$Host = HostPropDisplay.class$("com.nai.mcafee.snowcap.db.Host")) : class$com$nai$mcafee$snowcap$db$Host;
    }

    public String getSelectColumns() {
        return "*";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$ui$util$HostPropDisplay == null ? (class$com$nai$mcafee$snowcap$ui$util$HostPropDisplay = HostPropDisplay.class$("com.nai.mcafee.snowcap.ui.util.HostPropDisplay")) : class$com$nai$mcafee$snowcap$ui$util$HostPropDisplay).desiredAssertionStatus();
        DISPLAYABLE_PROPERTIES = new boolean[]{false, false, true, false, true, false, true, true, true, false, false, false, true, true, true, true, true, false, true, true, true, false, true, true, true, false, true, true, true, true};
    }
}

