/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.RuleEngine.Service;

import com.nai.Mead.RuleEngine.MessageAdaptorInterface;
import com.nai.Mead.RuleEngine.Messages.GenericMessageAdaptor;
import com.nai.Mead.RuleEngine.RuleEngine;
import com.nai.Mead.RuleEngine.RuleInterface;
import com.nai.Mead.RuleEngine.Rules.RuleLogic;
import com.nai.Mead.db.AlertFamily;
import com.nai.Mead.db.EventCategory;
import com.nai.Mead.db.epo.EpoBranchNode;
import com.nai.Mead.server.ServerInitException;
import com.nai.Mead.util.MachineTypeParser;
import com.nai.Mead.util.Resource;
import com.nai.Utility.Cache.AlertAliasMappingCache;
import com.nai.Utility.Cache.EpoHostCache;
import com.nai.Utility.Cache.EventCategoryCache;
import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.epo.EpoHost;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class RuleEngineSingleton {
    private static Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$RuleEngine$Service$RuleEngineSingleton == null ? (class$com$nai$Mead$RuleEngine$Service$RuleEngineSingleton = RuleEngineSingleton.class$("com.nai.Mead.RuleEngine.Service.RuleEngineSingleton")) : class$com$nai$Mead$RuleEngine$Service$RuleEngineSingleton));
    private static RuleEngineSingleton m_singleton = null;
    private static boolean m_isInitialized = false;
    RuleEngine m_translationEngine;
    RuleEngine m_ruleEngine;
    String m_myName = "RuleEngineService";
    Hashtable m_globalData = new Hashtable();
    EventCategoryCache m_eventCatCache = null;
    AlertAliasMappingCache m_alertFamilyCache = null;
    EpoHostCache m_leafNodeCache = null;
    MachineTypeParser m_machineTypeLookup = null;
    Database m_mainDb = null;
    Database m_epoDb = null;
    Vector m_lostAndFound = null;
    public static final String AGENT_GUID_TAG = "AgentGuid";
    public static final String TRANSLATION_FILE_TAG = "TranslationFile";
    public static final String TRANSLATION_ENGINE_TAG = "TranslationEngine";
    public static final String RULE_ENGINE_TAG = "RuleEngine";
    public static final String RULE_SERVICE_TAG = "ServiceName";
    public static final String SHOW_RULE_STATUS_TAG = "ShowRuleStatus";
    public static final String DEFAULT_NAME = "RuleEngineService";
    public static final String MACHINE_TYPE_CONFIG = "MachineTypeConfig.xml";
    public static final String EVENT_ID_TAG = "EventID";
    public static final String PRODUCT_FAMILY_TAG = "ProductFamily";
    public static final String EVENT_CATEGORY_TAG = "EventCategory";
    public static final String LEAF_TYPE_TAG = "LeafType";
    public static final String UNKNOWN_LEAF_TAG = "Unknown Type";
    public static final String WORK_LEAF_TAG = "WorkStation";
    public static final String SERVER_LEAF_TAG = "Server";
    static /* synthetic */ Class class$com$nai$Mead$RuleEngine$Service$RuleEngineSingleton;

    protected RuleEngineSingleton() {
    }

    public void destroy() {
        if (m_singleton != null) {
            if (this.m_translationEngine != null) {
                this.m_translationEngine.stop();
                this.m_translationEngine = null;
            }
            if (this.m_ruleEngine != null) {
                this.m_ruleEngine.stop();
                this.m_ruleEngine = null;
            }
            m_singleton = null;
            m_log.info((Object)Resource.getString("ruleenginesingleton_stopped"));
        }
        m_isInitialized = false;
    }

    public static synchronized RuleEngineSingleton getService() {
        if (m_singleton == null) {
            m_log.debug((Object)"Rule engine singleton is null, creating a new one.");
            m_singleton = new RuleEngineSingleton();
        }
        return m_singleton;
    }

    public static final RuleEngineSingleton getSingleton() {
        return m_singleton;
    }

    public MessageAdaptorInterface getMessageAdaptor() {
        return new GenericMessageAdaptor(this.m_alertFamilyCache);
    }

    public void reloadRules() throws Exception {
        this.reloadUserRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reloadUserRules() throws Exception {
        block11: {
            Iterator iterator;
            Object object;
            if (this.m_translationEngine != null) {
                this.m_translationEngine.stop();
            }
            if (this.m_ruleEngine != null) {
                this.m_ruleEngine.stop();
            }
            Connection connection = null;
            Connection connection2 = null;
            try {
                try {
                    connection = this.m_mainDb.getConnection();
                    connection2 = this.m_epoDb.getConnection();
                    m_log.debug((Object)"Loading the rules from the database.");
                    object = RuleLogic.loadRules(connection, connection2);
                    m_log.debug((Object)"Done loading the user rules, setting them on the rule engine.");
                    this.m_ruleEngine.doUpdate((RuleInterface)object);
                    m_log.debug((Object)"User rules have been updated.");
                }
                catch (Exception exception) {
                    m_log.error((Object)Resource.getString("ruleenginesingleton_failed_to_load_user_rules"), (Throwable)exception);
                    throw exception;
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                DatabaseUtil.close((Connection)connection);
                DatabaseUtil.close((Connection)connection2);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            DatabaseUtil.close((Connection)connection2);
            m_log.debug((Object)"Setting up the caches.");
            this.m_alertFamilyCache = new AlertAliasMappingCache(this.m_mainDb);
            this.m_eventCatCache = new EventCategoryCache(this.m_mainDb, this.m_epoDb);
            this.m_leafNodeCache = new EpoHostCache(this.m_epoDb);
            m_log.debug((Object)"Finding the global lost & found");
            this.m_lostAndFound = new Vector();
            try {
                try {
                    connection2 = this.m_epoDb.getConnection();
                    object = EpoBranchNode.getGlobalLostAndFound(connection2);
                    LinkedList linkedList = EpoBranchNode.getAncestry(connection2, ((EpoBranchNode)((Object)object)).getAutoId());
                    iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        EpoBranchNode epoBranchNode = (EpoBranchNode)((Object)iterator.next());
                        this.m_lostAndFound.add(new Long(epoBranchNode.getAutoId()));
                    }
                }
                catch (SQLException sQLException) {
                    m_log.debug((Object)"Failed to load the global L&F, setting it to a reasonable default.", (Throwable)sQLException);
                    this.m_lostAndFound.add(new Long(2L));
                    this.m_lostAndFound.add(new Long(3L));
                    Object var8_12 = null;
                    DatabaseUtil.close((Connection)connection2);
                    break block11;
                }
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                DatabaseUtil.close((Connection)connection2);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection2);
        }
        m_log.debug((Object)("Global L&F    : " + this.m_lostAndFound));
        m_log.debug((Object)"Starting the rule engines.");
        this.m_ruleEngine.start();
        this.m_translationEngine.start();
    }

    private void loadRulesFromFile(ServletConfig servletConfig, RuleEngine ruleEngine, String string, String string2, String string3) throws ServerInitException {
        String string4 = string + "." + string2;
        m_log.debug((Object)("Getting init parameter for " + string4 + " from the web.xml"));
        String string5 = servletConfig.getServletContext().getInitParameter(string4);
        m_log.debug((Object)("The file can be found at: " + string5));
        if (string5 != null) {
            try {
                m_log.debug((Object)("Loading: " + string5 + " for " + string4));
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string5);
                if (inputStream == null) {
                    String string6 = "Failed to find the translation rules file.";
                    m_log.error((Object)string6);
                    throw new ServerInitException(string6);
                }
                ruleEngine.loadRules(inputStream);
                m_log.debug((Object)(string3 + " have been loaded: " + string5));
            }
            catch (Exception exception) {
                m_log.error((Object)Resource.formatString("ruleenginesingleton_failed_to_load_system_rules", new Object[]{string3, string5, exception.getMessage()}), (Throwable)exception);
            }
        } else {
            String string7 = Resource.formatString("ruleenginesingleton_no_init_parameter", string4);
            m_log.error((Object)string7);
            throw new ServerInitException(string7);
        }
    }

    public synchronized void init(ServletConfig servletConfig, Database database, Database database2) throws Exception {
        m_log.debug((Object)"Entering init...");
        this.m_mainDb = database;
        this.m_epoDb = database2;
        if (!m_isInitialized) {
            m_log.debug((Object)"Starting one-time initialization...");
            String string = servletConfig.getServletContext().getInitParameter(this.m_myName + "." + RULE_SERVICE_TAG);
            m_log.debug((Object)"Retrieved service name from servlet's context.");
            if (string != null) {
                this.m_myName = string;
            }
            m_log.debug((Object)("Service name is:" + this.m_myName));
            String string2 = servletConfig.getServletContext().getInitParameter(this.m_myName + "." + SHOW_RULE_STATUS_TAG);
            m_log.debug((Object)"Retrieved ShowRuleStatus from servlet's context.");
            if (string2 != null) {
                // empty if block
            }
            m_log.debug((Object)("Service name is:" + this.m_myName));
            m_log.debug((Object)"Starting to read translation rules for the Translation Engine...");
            this.m_translationEngine = new RuleEngine(this.m_myName + " Translation Engine");
            m_log.debug((Object)"Created new RuleEngine, loading translation rules from file.");
            this.loadRulesFromFile(servletConfig, this.m_translationEngine, this.m_myName, TRANSLATION_FILE_TAG, "Translation Rules");
            m_log.debug((Object)"Finished reading translation rules for the Translation Engine.");
            m_log.debug((Object)"Starting to Read Event Rules for the Event Engine...");
            this.m_ruleEngine = new RuleEngine(this.m_myName + " Rule Engine");
            m_log.debug((Object)"Finished Read Event Rules for the Event Engine.");
            this.m_globalData.put(RULE_ENGINE_TAG, this.m_ruleEngine);
            this.m_globalData.put(TRANSLATION_ENGINE_TAG, this.m_translationEngine);
            m_log.debug((Object)"Starting to load rules...");
            this.reloadUserRules();
            m_log.debug((Object)"Finished loading rules.");
            m_log.debug((Object)"Loading MachineTypeConfig.xml config and setting up to classify.");
            this.m_machineTypeLookup = MachineTypeParser.MachineTypeParserFactory(MACHINE_TYPE_CONFIG);
            m_log.debug((Object)"Finished loading and parsing MachineTypeConfig.xml config file.");
            m_isInitialized = true;
            m_log.debug((Object)"One-time initialization complete.");
        } else {
            m_log.debug((Object)"Init has already completed... skipping.");
        }
    }

    public void processMessage(String string, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (this.m_ruleEngine.size() > 0) {
            m_log.debug((Object)"Translate the received event");
            MessageAdaptorInterface messageAdaptorInterface = this.getMessageAdaptor();
            messageAdaptorInterface.setMessage(string, System.currentTimeMillis());
            messageAdaptorInterface.setValue("SERVLET_REQUEST", servletRequest);
            messageAdaptorInterface.setValue("SERVLET_RESPONSE", servletResponse);
            this.m_translationEngine.onMessage(messageAdaptorInterface, this.m_globalData);
        }
    }

    public void processRules(MessageAdaptorInterface messageAdaptorInterface) {
        m_log.debug((Object)"Prepare event for rule engine");
        String string = (String)messageAdaptorInterface.getValue(EVENT_ID_TAG);
        Integer n = new Integer(0);
        m_log.debug((Object)("Event ID is " + string));
        if (string != null) {
            n = Integer.decode(string);
        }
        m_log.debug((Object)("Event ID Integer is " + n));
        String string2 = null;
        EventCategory eventCategory = this.m_eventCatCache.get(n);
        if (eventCategory != null) {
            string2 = eventCategory.getName();
            m_log.debug((Object)("Event category is " + string2));
        } else {
            m_log.debug((Object)"Event category is null");
        }
        messageAdaptorInterface.setValue(EVENT_CATEGORY_TAG, string2);
        messageAdaptorInterface.setValue(string2, EVENT_CATEGORY_TAG);
        messageAdaptorInterface.setValue("ReceivedEventCategories", eventCategory.getName());
        String string3 = null;
        AlertFamily alertFamily = this.m_alertFamilyCache.getAlertFamily(messageAdaptorInterface);
        if (alertFamily != null) {
            string3 = alertFamily.getName();
            m_log.debug((Object)("Product family is " + string3));
            messageAdaptorInterface.setValue(string3, PRODUCT_FAMILY_TAG);
            messageAdaptorInterface.setValue(PRODUCT_FAMILY_TAG, string3);
            messageAdaptorInterface.setValue("ReceivedProductFamilies", alertFamily.getName());
        }
        String string4 = (String)messageAdaptorInterface.getValue(AGENT_GUID_TAG);
        try {
            m_log.debug((Object)("Agent GUID is " + string4));
            messageAdaptorInterface.setAncestorList(this.getAncestorList(string4));
        }
        catch (Exception exception) {
            m_log.debug((Object)"Failed to look-up directory path, setting to global lost&found.");
            messageAdaptorInterface.setAncestorList(this.m_lostAndFound);
        }
        switch (this.m_machineTypeLookup.classifyObject(this.m_leafNodeCache.get(string4))) {
            case 0: {
                m_log.debug((Object)("System " + string4 + " is classified as workstation"));
                messageAdaptorInterface.setValue(LEAF_TYPE_TAG, WORK_LEAF_TAG);
                break;
            }
            case 1: {
                m_log.debug((Object)("System " + string4 + " is classified as server"));
                messageAdaptorInterface.setValue(LEAF_TYPE_TAG, SERVER_LEAF_TAG);
                break;
            }
            default: {
                m_log.debug((Object)("System " + string4 + " is classified as unknown"));
                messageAdaptorInterface.setValue(LEAF_TYPE_TAG, UNKNOWN_LEAF_TAG);
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Submiting event to rule engine:\n-------------------------------\n" + messageAdaptorInterface + "\n" + "-------------------------------\n"));
        }
        this.m_ruleEngine.onMessage(messageAdaptorInterface, this.m_globalData);
        m_log.debug((Object)"Rule engine is done");
    }

    public RuleEngine getRuleEngine() {
        return this.m_ruleEngine;
    }

    public RuleEngine getTranslationEngine() {
        return this.m_translationEngine;
    }

    public Collection getAncestorList(String string) throws Exception {
        EpoHost epoHost = this.m_leafNodeCache.get(string);
        List<Object> list = epoHost != null ? Arrays.asList(epoHost.getNodePath().split("\\\\")) : this.m_lostAndFound;
        m_log.debug((Object)("Setting the ancestry for this node to: " + list));
        return list;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

