/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.db.epo;

import com.nai.Mead.util.Resource;
import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.epo.EpoUser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EpoBranchNode
extends DatabaseObject {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode));
    public static final int COL_ID = 1;
    public static final int COL_NODE_NAME = 2;
    public static final int COL_TYPE = 3;
    public static final int COL_PARENT_ID = 4;
    public static final int COL_POLICY_TIMESTAMP = 5;
    public static final int COL_THE_TIMESTAMP = 6;
    public static final int COL_THE_HIDDEN_TIMESTAMP = 7;
    public static final int COL_TASK_TIMESTAMP = 8;
    public static final int NUM_COLS = 8;
    public static final int NUM_PROPS = 8;
    public static String[] PROP_NAMES = new String[]{"", "AutoId", "NodeName", "Type", "ParentId", "PolicyTimestamp", "TheTimestamp", "TheHiddenTimestamp", "TaskTimestamp"};
    public static final String TABLE_NAME = "BranchNode";
    public static final String UNIQUE_SQL = "select * from BranchNode where AutoId=?";
    private static final String ROOT_NODE_QUERY = "select AutoId from BranchNode where " + PROP_NAMES[3] + "=" + 7;
    private long m_id = -1L;
    private String m_nodeName = "";
    private int m_type = 3;
    private long m_parentId = -1L;
    static /* synthetic */ Class class$com$nai$Mead$db$epo$EpoBranchNode;

    private static final LinkedList recurseAncestry(Connection connection, EpoBranchNode epoBranchNode) throws SQLException {
        LinkedList linkedList = null;
        if (epoBranchNode != null) {
            String string = "select b.* from BranchNode as b inner join BranchNode as c on b.AutoId=c.ParentId where c.AutoId=" + epoBranchNode.getAutoId();
            Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode));
            if (vector.size() < 1) {
                return null;
            }
            if (vector.size() > 1) {
                throw new SQLException(Resource.getString("db_morethan_one"));
            }
            EpoBranchNode epoBranchNode2 = (EpoBranchNode)((Object)vector.firstElement());
            m_log.debug((Object)("Found parent node: " + epoBranchNode2.getAutoId()));
            if (epoBranchNode2.getType() == 4) {
                linkedList = new LinkedList();
                linkedList.add(epoBranchNode2);
            } else {
                m_log.debug((Object)"Not the root node, recursing.");
                linkedList = EpoBranchNode.recurseAncestry(connection, epoBranchNode2);
                linkedList.addLast(epoBranchNode2);
            }
        }
        return linkedList;
    }

    public static final LinkedList getAncestry(Connection connection, long l) throws SQLException {
        m_log.debug((Object)("Finding ancestry for node: " + l));
        LinkedList linkedList = null;
        EpoBranchNode epoBranchNode = EpoBranchNode.getById(connection, l);
        if (epoBranchNode != null) {
            linkedList = epoBranchNode.getType() == 4 ? new LinkedList() : EpoBranchNode.recurseAncestry(connection, epoBranchNode);
            linkedList.addLast(epoBranchNode);
        }
        return linkedList;
    }

    public static final String getAncestryAsString(Connection connection, long l) throws SQLException {
        return EpoBranchNode.ancestryToString(EpoBranchNode.getAncestry(connection, l));
    }

    public static final String ancestryToString(LinkedList linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            if (linkedList.size() > 1) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                EpoBranchNode epoBranchNode = (EpoBranchNode)((Object)iterator.next());
                stringBuffer.append(epoBranchNode.getNodeName());
                while (iterator.hasNext()) {
                    epoBranchNode = (EpoBranchNode)((Object)iterator.next());
                    stringBuffer.append("/").append(epoBranchNode.getNodeName());
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LinkedList getAncestryByGuid(Connection connection, String string) throws SQLException {
        LinkedList linkedList = null;
        String string2 = "select b.* from BranchNode as b inner join LeafNode as l on l.ParentId=b.AutoId where AgentGuid='" + string + "'";
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                linkedList = EpoBranchNode.getAncestry(connection, l);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
        return linkedList;
    }

    public static final EpoBranchNode getById(Connection connection, long l) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(UNIQUE_SQL);
        preparedStatement.setLong(1, l);
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (PreparedStatement)preparedStatement, (Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode), (int)1, (int)1);
        if (vector.size() < 1) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (EpoBranchNode)((Object)vector.firstElement());
    }

    public static final EpoBranchNode[] getSiteList(Connection connection) throws SQLException {
        EpoBranchNode[] epoBranchNodeArray = new EpoBranchNode[]{};
        String string = "select * from BranchNode where " + PROP_NAMES[3] + "=" + 6;
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode));
        if (vector != null) {
            epoBranchNodeArray = vector.toArray(epoBranchNodeArray);
        }
        return epoBranchNodeArray;
    }

    private static final String makeFindParentSql(int n, String string) {
        return "select * from BranchNode where " + PROP_NAMES[3] + "=" + n + " AND " + PROP_NAMES[4] + "=(" + string + ")";
    }

    public static final EpoBranchNode getDirectoryRoot(Connection connection) throws SQLException {
        String string = EpoBranchNode.makeFindParentSql(4, ROOT_NODE_QUERY);
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode));
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("db_morethan_one"));
        }
        return (EpoBranchNode)((Object)vector.firstElement());
    }

    public static final EpoBranchNode getNodeForUser(Connection connection, EpoUser epoUser) throws SQLException {
        if (!epoUser.isSiteAccount()) {
            return EpoBranchNode.getDirectoryRoot(connection);
        }
        return EpoBranchNode.getById(connection, epoUser.getRootNodeId());
    }

    public static final EpoBranchNode getGlobalLostAndFound(Connection connection) throws SQLException {
        EpoBranchNode epoBranchNode = EpoBranchNode.getDirectoryRoot(connection);
        if (epoBranchNode != null) {
            String string = "select * from BranchNode where " + PROP_NAMES[3] + "=" + 5 + " AND " + PROP_NAMES[4] + "=" + epoBranchNode.getAutoId();
            Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$Mead$db$epo$EpoBranchNode == null ? (class$com$nai$Mead$db$epo$EpoBranchNode = EpoBranchNode.class$("com.nai.Mead.db.epo.EpoBranchNode")) : class$com$nai$Mead$db$epo$EpoBranchNode));
            if (vector.size() == 0) {
                return null;
            }
            if (vector.size() > 1) {
                throw new SQLException(Resource.getString("db_morethan_one"));
            }
            return (EpoBranchNode)((Object)vector.firstElement());
        }
        return null;
    }

    public int getNumColumns() {
        return 8;
    }

    public int getNumProperties() {
        return 8;
    }

    public String getPropertyName(int n) {
        return PROP_NAMES[n];
    }

    public String getInsertSql() {
        return "insert into BranchNode values(?,?,?, 0x0, @@DBTS, null, 0x0)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.m_nodeName);
        preparedStatement.setInt(2, this.m_type);
        preparedStatement.setLong(3, this.m_parentId);
    }

    public String getUpdateSql() {
        return "update BranchNode set NodeName=?, Type=?, ParentId=?, TheTimestamp=@@DBTS where AutoId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        preparedStatement.setLong(4, this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.m_id = n;
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_nodeName = resultSet.getString(2);
        if (resultSet.getMetaData().getColumnCount() > 2) {
            this.m_type = resultSet.getInt(3);
            this.m_parentId = resultSet.getLong(4);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Long) {
            Long l = (Long)object;
            return l == this.m_id;
        }
        return super.equals(object);
    }

    public void setId(long l) {
        this.m_id = l;
    }

    public long getId() {
        return this.m_id;
    }

    public long getAutoId() {
        return this.m_id;
    }

    public void setAutoId(long l) {
        this.m_id = l;
    }

    public void setNodeName(String string) {
        this.m_nodeName = string;
    }

    public String getNodeName() {
        String string = this.m_type == 4 ? "{Directory}" : this.m_nodeName;
        return string;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void setParentId(long l) {
        this.m_parentId = l;
    }

    public long getParentId() {
        return this.m_parentId;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

