/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.ui;

import com.nai.Mead.server.Server;
import com.nai.Mead.ui.ExeActionBase;
import com.nai.Mead.ui.util.SessionUtil;
import com.nai.Mead.util.Resource;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.ToolInstance;
import com.nai.mcafee.common.ui.MissingParameterException;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaveExeAction
extends ExeActionBase {
    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        super.validate(httpServletRequest);
        if (!SessionUtil.canEdit(httpServletRequest, "displaycommands.do")) {
            return "actiontaken.jsp";
        }
        if (!this.m_isLocal) {
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_action_failed", this.m_lang), Resource.getString("saveexeaction_must_be_local", this.m_lang), "displaycommands.do");
            return "actiontaken.jsp";
        }
        if (!SessionUtil.isNonEmptyString(this.m_exeName)) {
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_missing_input_error", this.m_lang), Resource.getString("saveexeaction_need_name", this.m_lang), "createexe.do");
            return "actiontaken.jsp";
        }
        if (this.m_exeName.length() > 255) {
            String string = Resource.formatString("addexe_name_too_long", 256, this.m_lang);
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_missing_input_error", this.m_lang), string, "createexe.do");
            return "actiontaken.jsp";
        }
        if (!SessionUtil.isNonEmptyString(this.m_exePath)) {
            SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_missing_input_error", this.m_lang), Resource.getString("saveexeaction_need_path", this.m_lang), "createexe.do");
            return "actiontaken.jsp";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.m_isLocal) {
            this.m_exeName = this.m_exeName.trim();
            this.m_exePath = this.m_exePath.trim();
            if (this.m_exeOldName != null && this.m_exeOldName.length() > 0 && this.m_exeOldName.compareTo(this.m_exeName) != 0) {
                Connection connection = null;
                try {
                    connection = Server.getDb().getConnection();
                    ToolInstance.updateToolInstanceNames((Connection)connection, (String)this.m_exeName, (String)this.m_exeOldName);
                    ToolInstance.removeExe((String)this.m_exeOldName);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    DatabaseUtil.close((Connection)connection);
                    throw throwable;
                }
                DatabaseUtil.close((Connection)connection);
                Server.reloadConfiguration();
            }
            if ((this.m_exeOldName == null || this.m_exeOldName.length() < 1) && ToolInstance.isExeNameSaved((String)this.m_exeName)) {
                SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString("common_db_error", this.m_lang), Resource.getString("saveexeaction_exe_name_exists", this.m_lang), "createexe.do");
                return "actiontaken.jsp";
            }
            ToolInstance.setRegisteredTool((String)this.m_exeName, (String)this.m_exePath);
            SaveExeAction.saveRegisteredExes(httpServletRequest);
        }
        return "displaycommands.do";
    }

    public static final String getRegExeNameFromIndex(HttpServletRequest httpServletRequest, int n) throws MissingParameterException {
        Vector vector = (Vector)SessionUtil.getSessionAttribute(httpServletRequest, "registeredExesCache");
        String string = null;
        if (vector.size() > n) {
            string = (String)vector.get(n);
        }
        return string;
    }

    public static final Vector saveRegisteredExes(HttpServletRequest httpServletRequest) throws MissingParameterException {
        Vector vector = new Vector();
        Iterator iterator = ToolInstance.getToolNames();
        int n = 0;
        while (iterator.hasNext()) {
            vector.add(n, iterator.next());
            ++n;
        }
        SessionUtil.setSessionAttribute(httpServletRequest, "registeredExesCache", vector);
        return vector;
    }
}

