/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Utility.Cache;

import com.nai.Mead.RuleEngine.MessageAdaptorInterface;
import com.nai.Mead.RuleEngine.Messages.FixtureInterface;
import com.nai.Mead.db.AlertAliasMapping;
import com.nai.Mead.db.AlertFamily;
import com.nai.Mead.util.Resource;
import com.nai.Utility.Cache.AliasCache;
import com.nai.Utility.Cache.BasicCache;
import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseUtil;
import java.sql.Connection;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AlertAliasMappingCache
extends BasicCache
implements BasicCache.CacheLoader {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Utility$Cache$AlertAliasMappingCache == null ? (class$com$nai$Utility$Cache$AlertAliasMappingCache = AlertAliasMappingCache.class$("com.nai.Utility.Cache.AlertAliasMappingCache")) : class$com$nai$Utility$Cache$AlertAliasMappingCache));
    public static final int DEFAULT_MAX_CACHE_AGE = 604800;
    private static long m_defCacheLifetime = 604800L;
    private Database m_db = null;
    private AliasCache m_aliasFiles = new AliasCache();
    static /* synthetic */ Class class$com$nai$Utility$Cache$AlertAliasMappingCache;

    public static void setDefaultCacheLifetime(long l) {
        m_defCacheLifetime = l > 0L && l < 604800L ? l : 604800L;
    }

    public AlertAliasMappingCache(Database database, long l) {
        m_log.debug((Object)"Creating a new AlertAliasMappingCache.");
        this.m_db = database;
        this.setLoader(this);
        this.setMaxCacheAge(l);
    }

    public AlertAliasMappingCache(Database database) {
        m_log.debug((Object)"Creating a new AlertAliasMappingCache.");
        this.m_db = database;
        this.setLoader(this);
        this.setMaxCacheAge(m_defCacheLifetime);
    }

    public Object getObject(Object object) throws Exception {
        MappingObject mappingObject = (MappingObject)object;
        Connection connection = null;
        AlertAliasMapping alertAliasMapping = null;
        try {
            block5: {
                try {
                    connection = this.m_db.getConnection();
                    m_log.debug((Object)("Getting the alias mapping for: " + mappingObject.getFixture() + ", " + mappingObject.getFirstMarker() + ", " + mappingObject.getSecondMarker()));
                    alertAliasMapping = AlertAliasMapping.getMapping(connection, mappingObject.getFixture(), mappingObject.getFirstMarker(), mappingObject.getSecondMarker());
                    if (alertAliasMapping == null) {
                        m_log.debug((Object)("Mapping was null, try alias mapping for: " + mappingObject.getFixture() + ", " + mappingObject.getFirstMarker()));
                        alertAliasMapping = AlertAliasMapping.getMapping(connection, mappingObject.getFixture(), mappingObject.getFirstMarker(), "");
                    }
                    if (alertAliasMapping != null) break block5;
                    m_log.debug((Object)"Mapping was still null, getting the unknown.");
                    alertAliasMapping = AlertAliasMapping.getMapping(connection, mappingObject.getFixture(), "", "");
                    if (alertAliasMapping != null) break block5;
                    m_log.debug((Object)"Unable to find the unknown mapping, returning null.");
                }
                catch (Exception exception) {
                    m_log.debug((Object)"error occured while retrieving alias ", (Throwable)exception);
                    throw exception;
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return alertAliasMapping;
    }

    public void putObject(Object object, Object object2) throws Exception {
        throw new NoSuchMethodError();
    }

    public AlertAliasMapping get(String string, String string2, String string3) {
        AlertAliasMapping alertAliasMapping = null;
        try {
            m_log.debug((Object)("Getting AlertAliasMapping for: " + string + ", " + string2 + ", " + string3));
            alertAliasMapping = (AlertAliasMapping)((Object)this.getAsObject(new MappingObject(string, string2, string3)));
            m_log.debug((Object)("Alias mapping found was: " + (Object)((Object)alertAliasMapping)));
            if (alertAliasMapping == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            m_log.error((Object)("Unable to retrieve alias mapping for \"" + string + "\", \"" + string2 + "\", \"" + string3 + "\""));
        }
        return alertAliasMapping;
    }

    public AlertFamily getAlertFamily(MessageAdaptorInterface messageAdaptorInterface) {
        m_log.debug((Object)"Getting alert family from cache.");
        FixtureInterface fixtureInterface = messageAdaptorInterface.getFixture();
        return this.getAlertFamily(fixtureInterface.getClass().getName(), fixtureInterface.getFirstMarker(messageAdaptorInterface), fixtureInterface.getSecondMarker(messageAdaptorInterface));
    }

    public AlertFamily getAlertFamily(String string, String string2, String string3) {
        m_log.debug((Object)("Getting alert family for " + string + ", " + string2 + ", " + string3));
        AlertAliasMapping alertAliasMapping = this.get(string, string2, string3);
        return alertAliasMapping != null ? alertAliasMapping.getAlertFamily() : null;
    }

    public Properties getAliasFile(String string, String string2, String string3) {
        Properties properties = new Properties();
        try {
            AlertAliasMapping alertAliasMapping = this.get(string, string2, string3);
            if (alertAliasMapping != null) {
                properties = this.m_aliasFiles.get(alertAliasMapping.getAliasFileName());
            }
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("alertaliasmappingcache_failed_to_load"), (Throwable)exception);
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MappingObject {
        private String m_fixture = "";
        private String m_firstMarker = "";
        private String m_secondMarker = "";

        public MappingObject(String string, String string2, String string3) {
            this.m_fixture = string;
            this.m_firstMarker = string2;
            this.m_secondMarker = string3;
        }

        public String getFixture() {
            return this.m_fixture;
        }

        public String getFirstMarker() {
            return this.m_firstMarker;
        }

        public String getSecondMarker() {
            return this.m_secondMarker;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (object == null) {
                bl = false;
            }
            MappingObject mappingObject = (MappingObject)object;
            if (bl && this.m_fixture != null && mappingObject.m_fixture != null) {
                bl = this.m_fixture.equals(mappingObject.m_fixture);
            }
            if (bl && this.m_firstMarker != null && mappingObject.m_firstMarker != null) {
                bl = this.m_firstMarker.equals(mappingObject.m_firstMarker);
            }
            if (bl && this.m_secondMarker != null && mappingObject.m_secondMarker != null) {
                bl = this.m_secondMarker.equals(mappingObject.m_secondMarker);
            }
            return bl;
        }

        public String toString() {
            return "{ " + this.m_fixture + " \"" + this.m_firstMarker + "\" \"" + this.m_secondMarker + "\" }";
        }

        public int hashCode() {
            String string = (this.m_fixture != null ? this.m_fixture : "") + (this.m_firstMarker != null ? this.m_firstMarker : "") + (this.m_secondMarker != null ? this.m_secondMarker : "");
            return string.hashCode();
        }
    }
}

