-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
-- Patch schema file: DB patch schema and metadata changes
-- This file need to be rerunable. All objects must be droped before recreated or changes
--	must be detected and applied only if they are missing
-- All objects must be created under dbo ownership

-- Merge instruction 
-- This file needs to be merged into the next releases schema file
--   	(for example for 3.6 its epo3.5-to-3.6.sql)
--	Some of these change should be merged into specific metadata scripts, these will be noted below.

-- This file should only contain schema and metadata changes, changes to stored procedures
--  	and triggers should be made to the separate procedure/trigger files.
-- There are a few exceptions to the stored procedure rule, the reasons are listed along with the 
--	procedure changes below.
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------


----------------------
-- epo3.5 patch1
-- fix 208182: Adjust column sizes on daily snapshot worktables so that they always fit data size.

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
   [NodeNameLeaf] nvarchar (255)
go
 
ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [NodeNameBranch] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [FullNodePath] nvarchar (500) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ProductName] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [EngineVer] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ComputerLanguage] nvarchar (50) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [DomainName] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSVersion] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ComputerName] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [IPAddress] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  VirusnameMax nvarchar(128) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  UnresolvedVirusnameMax nvarchar(128) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSPlatform] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSType] nvarchar (100) 
go





ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
   [NodeNameLeaf] nvarchar (255)
go
 
ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [NodeNameBranch] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [FullNodePath] nvarchar (500) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ProductName] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [EngineVer] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ComputerLanguage] nvarchar (50) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [DomainName] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSVersion] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ComputerName] nvarchar (255) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [IPAddress] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  VirusnameMax nvarchar(128) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  UnresolvedVirusnameMax nvarchar(128) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSPlatform] nvarchar (100) 
go

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSType] nvarchar (100) 
go


-- epo3.5 patch3 215279: revoke public permissions on objects which had it granted on previous
--	versions of epo

REVOKE EXECUTE ON dbo.VSE_InsertBehaviourBlockEvent TO PUBLIC
go

REVOKE EXECUTE ON dbo.VSE_InsertEnterceptEvent TO PUBLIC
go

REVOKE EXECUTE ON dbo.VSE_InsertPortBlockEvent TO PUBLIC
go

REVOKE EXECUTE ON dbo.VSE_InsertTaskStatusEvent TO PUBLIC
go

REVOKE EXECUTE ON dbo.VSE_InsertVirusDetectionEvent TO PUBLIC
go

REVOKE EXECUTE ON dbo.PATCHSCANSP_InsertViolation TO PUBLIC
go

REVOKE EXECUTE ON dbo.PATCHSCANSP_SetCompliance TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_AddTo_BranchNode_Enum TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_DeleteFrom_BranchNode_Enum TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_Generate_BranchNode_Enum TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_GetNodePath TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_GetNodePathID TO PUBLIC
go

REVOKE EXECUTE ON dbo.AVIDALSP_MoveWithin_BranchNode_Enum TO PUBLIC
go



------------------------------------------------------------------------------------------
-- metadata changes: These changes need to be merged into PopulateReportmetadata.sql

-- epo3.5 patch2: fix 212254 - set event category to Normal_Operation because this is not
--	a true virus detecting event. Its just an info event stating that a scan found infections.
--	Notification thus must not display this as a virus event (no virusname)
Update EventFilter 
	set EventCategory = 19	-- NORMAL_OPERATION
	where EventID = 1038 
GO

-- epo3.5 patch4: fix 236419 - Reset eventcategory for 1094 to 
--	Access protection rule violation detected and blocked (EventCategory table)
Update EventFilter 
	set EventCategory = 1  -- ACCESS_PROTECTION_VIOLATION_BLOCKED
	where EventID = 1094 
GO

-- epo3.5 patch4 bz220586  Fill in missing metadata writeback rotuine for DATENG reports
Update ReportUICustPages
set WritebackStoredProc = '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}'
where
(WritebackStoredProc = '' or WritebackStoredProc is null)
and ReportID in ('DAT','ENG','DATENG','COMPLIANCEISSUES')
GO

-- end of metadata changes
----------------------------------------------

-- epo3.5 patch2: fix 208253 - Remove any orphaned software table entries
delete software 
where
( InstallGuid is null )
and ( productfamily = '' or productfamily is null )
and ( PlatformsSupported = '' or PlatformsSupported is null )
and productcode in (
	select productcode from software
	where 
		( InstallGuid is not null )
		and ( productfamily > '' )
		and ( PlatformsSupported > '' )
)
GO




--  *** Block Events Data Filter Lookup ***
-- fix 213014: Rulename data filter lookup missing from VS8 access protection report
-- This proc will not be moved to enumprocedures, this is a special case fix to a VS8 proc that resides in its enap file
-- In included here so that the fix is immediately available to customers without having to reinstall the enap.
-- This fix is already merged into the VS8 enap scripts.

IF EXISTS(SELECT NAME 
	  FROM SYSOBJECTS 
	  WHERE NAME = 'AVISP_GetCust_EventsBehaviourBlock' AND TYPE = 'P')
BEGIN
	DROP PROCEDURE dbo.AVISP_GetCust_EventsBehaviourBlock
END
GO

CREATE PROCEDURE dbo.AVISP_GetCust_EventsBehaviourBlock 
(
    @iNameSpaceName  		INT,
    @iNameSpaceNode         	INT,
    @szEpoUserName           	VARCHAR(100),
    @szFilter			VARCHAR(20) = '',
    @szOptionalReportParms  	VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) IF users top node = root node AND no filter selected 
 DECLARE @FilterID INT
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   DECLARE @szLang VARCHAR(3)
   DECLARE @szFullLang VARCHAR(5)
   DECLARE @szDefaultLang VARCHAR(5)
   DECLARE @szLanguageID VARCHAR(5)
   DECLARE @szTime VARCHAR(10)
   DECLARE @szOPFilter VARCHAR(64)
   DECLARE @szReportID VARCHAR(64)
   DECLARE @szRptGroup VARCHAR(64)
   SET @szLanguageID = '0409'   
   SET @szLang = '09'
   SET @szFullLang = '0'
   SET @szTime = 'GMT'
   SET @szReportID = 'ASCI'


   IF @szOptionalReportParms > ''
   	EXECUTE AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   IF @szFilter = 'Year' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- quarter
   ELSE IF @szFilter = 'Quarter' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) AS char(1)) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- month
   ELSE IF @szFilter = 'Month' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) AS char(5)) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- week
   ELSE IF @szFilter = 'Week' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Week, EventDateTime) AS char(2))
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END


   ELSE IF @szFilter = 'DomainName'
   BEGIN
	SELECT DISTINCT ComputerProperties.DomainName AS Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
		    (
			@FilterID = 0 OR
			LeafNode.ParentID = @FilterID OR
			LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
						FROM BranchNodeEnum 
						WHERE BranchNodeEnum.StartAutoID = @FilterID)
		    )
		    AND ProductProperties.ParentID = LeafNode.AutoID 
			AND LeafNode.AutoID = ComputerProperties.ParentID
		    AND DomainName > ''
   END

   ELSE IF @szFilter = 'RuleName'
   BEGIN
	 SELECT DISTINCT RuleName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE tvdeventid > ''
   END


   ELSE IF @szFilter = 'NodeName' or @szFilter = 'GroupName'
   BEGIN
	 SELECT DISTINCT NodeName AS Value 
	 FROM BranchNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  BranchNode.AutoID = @FilterID OR
		  BranchNode.AutoID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 	 AND NodeName not in ('Directory','GlobalRoot')
   END

   ELSE IF @szFilter = 'OSVersion'
   BEGIN
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        AS VARCHAR(50)) AS Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 AND ComputerProperties.ParentID = LeafNode.AutoID 

   END

   ELSE IF @szFilter = 'OSType'
   BEGIN
	 SELECT  DISTINCT OSType AS Value
	 FROM ComputerProperties
	 WHERE ostype > ''
   END

   ELSE IF @szFilter = 'OSPlatform'
   BEGIN
	 SELECT  DISTINCT OSPlatform AS Value
	 FROM ComputerProperties
	 WHERE osplatform > ''
   END

   ELSE IF @szFilter = 'IPAddress' OR @szFilter = 'HostIPAddress' OR @szFilter = 'HostAddr'
   BEGIN
	 SELECT DISTINCT HostIPAddress AS Value 
	 FROM Events, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
		       FROM BranchNodeEnum 
		       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 AND Events.NodeID = LeafNode.AutoID
	 AND hostipaddress > ''
   END

   ELSE IF @szFilter = 'EventID' or @szFilter = 'TVDEventID'
   BEGIN
	 SELECT DISTINCT cast(TVDEventID AS VARCHAR(10)) AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE tvdeventid > ''
   END

   ELSE IF @szFilter = 'TVDTaskName'
   BEGIN
	 SELECT DISTINCT TVDTaskName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE Events_VSEBehaviourBlock.TVDTaskName > ''
	 ORDER BY TVDTaskName desc
   END


   ELSE IF @szFilter = 'FileName'
   BEGIN
	-- postepo3 Top 10 files report return the rightmost postion of the filename
	IF @szReportID = 'T10FILE' or @szReportID = 'RESOLVED' or @szReportID = 'UNRESOLVED'
	BEGIN
		 SELECT DISTINCT right(Events_VSEBehaviourBlock.FileName,15) AS Value 
		 FROM Events_VSEBehaviourBlock, LeafNode
		 WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
			       FROM BranchNodeEnum 
			       WHERE BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
			 AND filename > ''
	END
	ELSE
	BEGIN
		SELECT DISTINCT FileName AS Value 
		FROM Events_VSEBehaviourBlock, LeafNode
		WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
			       FROM BranchNodeEnum 
			       WHERE BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
			 AND filename > ''
	END
   END

   ELSE IF @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   BEGIN
	 SELECT DISTINCT HostName AS Value 
	 FROM Events_VSEBehaviourBlock, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
		       FROM BranchNodeEnum 
		       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
		 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
		 AND hostname > ''
   END

   ELSE IF @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   BEGIN
	 SELECT DISTINCT ProductName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE ProductName NOT LIKE '%Agent%'
	 AND productname > ''
   END

   ELSE IF @szFilter = 'ProductVersion'
   BEGIN
	 	SELECT DISTINCT ProductVersion AS Value 
	 	FROM Events_VSEBehaviourBlock
	       	WHERE Events_VSEBehaviourBlock.ProductName != 'ePO Agent' 
		AND productversion > ''
   END

   ELSE IF @szFilter = 'FullProductName'
   BEGIN
	 SELECT DISTINCT cast((Events_VSEBehaviourBlock.ProductName + ' ' + Events_VSEBehaviourBlock.ProductVersion) AS VARCHAR(50)) AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE Events_VSEBehaviourBlock.ProductName != 'ePO Agent' 
	 AND (Events_VSEBehaviourBlock.ProductName + ' ' + Events_VSEBehaviourBlock.ProductVersion) > ''
   END

   ELSE IF @szFilter = 'UserName'
   BEGIN
	 SELECT DISTINCT UserName AS Value 
	 FROM Events_VSEBehaviourBlock, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
		 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
		 AND username > ''
   END

   ELSE 
   BEGIN
	 SELECT '---' AS Value
   END

RETURN @@rowcount
END
GO




---------------------------------------------------------------------------------------------
-- Make any additional changes here, before last change which updated a proc in the master db




----------------------- Purge All Events changes ------------------------------------------
-- epo3.5 patch4 bz209429 - fix event removal algorithm to not timeout with a large dataset
-- ReportEventTables: Stores name of all event tables.
-- Allows remove operation to treat all these as one table, via AVISP_Util_RemoveFromAllEventTables

-- epo3.5 Patch: only create this table once, if it already exists leave it
--	Moved from aviprocedures.sql - schema changes should not be in this file.
--	If any new naps add additional entries this code will remove it.
if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReportEventTables]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
begin

CREATE TABLE [dbo].[ReportEventTables] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[EventTableName] [nvarchar] (255) NULL ,
	[DateTimeFieldName] [nvarchar] (255) NULL ,
	[Active] [int] default 1
) ON [PRIMARY]

end
go


-- epo3.5 populate ReportEventTables with default event tables (used in event removal routine)
-- make sure 3.5 tables are installed

-- epo3.5 patch4: make sure tables are readded for either new install or upgrade going forward
delete ReportEventTables 
where EventTableName in
(
'Events'
,'Events_VSEBehaviourBlock'
,'ServerEvents'
,'EntFWEvents'
,'EntIPSEvents'
,'Events_Statistics'
,'Events_Spam'
,'Events_ContentFilter'
,'RMD_SensorEvents'
,'DFW81_QuarentineEvents'
,'DFW81_BlockedApps'
,'DFW81_IDSEvents'
,'DFW80_QuarentineEvents'
,'DFW80_BlockedApps'
,'DFW80_IDSEvents'
,'CCSVirusScan'
,'CCSAudit'
,'CCSUpgrade'
,'CCSUpdate'
,'CCSAutoDiscovery'
,'CCSEvents'
,'CCSScanHostInfo'
,'CCSHostInfo'
,'PATCH_RuleViolations'
,'ProductEvents'
)
go


-- epo3.5 populate ReportEventTables with default event tables (used in event removal routine)

Insert ReportEventTables (EventTableName, DateTimeFieldName, Active) values ('Events', 'EventDateTime', 1)
go

-- Events: Common Updater 
Insert ReportEventTables (EventTableName, DateTimeFieldName, Active) values ('ProductEvents', 'EventDateTime', 1)
go

-- Events: SCP 1.0 / 1.1
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('PATCH_RuleViolations','EventTime',1)
go

-- Events: ThreatScan 2.5 / 2.1
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSHostInfo','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSScanHostInfo','EventTime ',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSEvents','EventDateTime', 1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSAutoDiscovery','EventDateTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSUpdate','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSUpgrade','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSAudit','Time',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('CCSVirusScan','Time',1)
go

-- Events: Desktop Firewall 
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW80_IDSEvents','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW80_BlockedApps','InvocationTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW80_QuarentineEvents','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW81_IDSEvents','EventTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW81_BlockedApps','InvocationTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('DFW81_QuarentineEvents','EventTime',1)
go

--Events: Rogue System detection 1.0 (SnowCap)
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('RMD_SensorEvents','EventDateTime',1)
go

--Events: Webshield 3.0
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('Events_ContentFilter','EventLocalDateTime',1) 
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('Events_Spam','EventLocalDateTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('Events_Statistics','EventLocalDateTime',1)
go

-- Events: IPS
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('EntIPSEvents','RecordingTime',1)
go

INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('EntFWEvents','IncidentTime',1)
go

-- Events: ePO Server
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('ServerEvents','GMTTime',1)
go

-- Events: VirusScan
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('Events_VSEBehaviourBlock','EventDateTime',1)
go


-------------------
-- Patch 4 changes
-- Remove events delete trigger, delete from EventDayResolution separately (performance gain) 
if  not exists (select * from sysobjects, syscolumns
			where sysobjects.id = syscolumns.id 
			and sysobjects.id = object_id(N'[dbo].[ReportEventTables]')
			and COL_NAME ( object_id(N'[dbo].[ReportEventTables]') , syscolumns.colid ) = 'IDFieldName'
			)
ALTER TABLE dbo.EventDayResolution 
  add 
	EventDateTime datetime NULL
go

-- for some reason these need to be within their own if statements or they wont run
if  not exists (select * from sysobjects, syscolumns
			where sysobjects.id = syscolumns.id 
			and sysobjects.id = object_id(N'[dbo].[ReportEventTables]')
			and COL_NAME ( object_id(N'[dbo].[ReportEventTables]') , syscolumns.colid ) = 'IDFieldName'
			)
ALTER TABLE [dbo].[ReportEventTables] 
  add 
	[IDFieldName] nvarchar (255) NULL	-- Name 
	, [IDRangeStart] int default 0		-- Starting ID for this delete session (multiple passes)		
	, [IDRangeCurrent] int default 0	-- current delete pass ID start
	, [IDRangeEnd] int default 0		-- Ending ID for this delete session
	, [EstimatedIterations] int default 0	-- Number of passes for this delete session 
	, [Session] nvarchar (100) default NULL	-- session ID to prevent concurrent delete sessions
	, [EstimationComplete] int default 0	-- Flag : Pass estimation completed for this table
	, [DeleteIDRange] int default 100000	-- total events to delete in each pass, configurable per table (#indexes affects performance)
go

-- epo3.5 patch3 209429 Remove events in segments based on autoid ranges (500k) to avoid 10 minute timeout problem
--	If any new naps add additional entries this code will not alter it.
if  not exists ( select * from ReportEventTables where IDFieldName > '')
begin

-- Remove events delete trigger, delete from EventDayResolution separately (performance gain) 
--ALTER TABLE dbo.EventDayResolution 
--  add 
--	EventDateTime datetime NULL

-- populate eventtime field in EventDayResolution so can delete by date range
update EventDayResolution set EventDayResolution.EventDateTime = events.EventDateTime
from events
where EventDayResolution.autoid = events.autoid


-- must remove events table delete trigger (EventDayResolution daat deleted separately)
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELEVENTS]'))
	drop trigger [dbo].[TR_EPO_DELEVENTS]

-- new fields needed to delete by ID range
-- Finds the starting and ending ID over the given date range 
-- Faster than delete passes through the whole table, each pass should complete < 10 min.
-- If an ID row does not exist it defaults to deleting the whole daterange in one pass
--ALTER TABLE [dbo].[ReportEventTables] 
--  add 
--	[IDFieldName] nvarchar (255) NULL	-- Name 
--	, [IDRangeStart] int default 0		-- Starting ID for this delete session (multiple passes)		
--	, [IDRangeCurrent] int default 0	-- current delete pass ID start
--	, [IDRangeEnd] int default 0		-- Ending ID for this delete session
--	, [EstimatedIterations] int default 0	-- Number of passes for this delete session 
--	, [Session] nvarchar (100) default NULL	-- session ID to prevent concurrent delete sessions
--	, [EstimationComplete] int default 0	-- Flag : Pass estimation completed for this table
--	, [DeleteIDRange] int default 100000	-- total events to delete in each pass, configurable per table (#indexes affects performance)


-- Events: EventDayResolution
INSERT INTO ReportEventTables (EventTableName,DateTimeFieldName,Active) VALUES ('EventDayResolution','EventDateTime',1)
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'EventDayResolution'

-- epo3.5 populate ReportEventTables with default event tables (used in event removal routine)

-- Events: infections
Declare @cnt1 int
select @cnt1=count(*) from ReportEventTables where EventTableName = 'Events'
if @cnt1 = 0
	Insert ReportEventTables (EventTableName, DateTimeFieldName, Active) values ('Events', 'EventDateTime', 1)

Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'Events'

-- Events: Common Updater 
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'ProductEvents'

--Events: Rogue System detection 1.0 (SnowCap)
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'RMD_SensorEvents'

-- Events: ePO Server
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'ServerEvents'

-- Events: Firewall tables
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW80_IDSEvents'
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW80_BlockedApps'
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW80_QuarentineEvents'
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW81_IDSEvents'
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW81_BlockedApps'
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'DFW81_QuarentineEvents'

-- Events: VirusScan
Update ReportEventTables Set IDFieldName = 'AutoID',DeleteIDRange=100000 where EventTableName = 'Events_VSEBehaviourBlock'

END
GO


-- epo3.5 patch4 bz234570
-- patch4 code review: dont hardcode global rootid=1
--	Fix groupshield report metadata where product and report productcodes are the same
--	Reset groupshield reports productcode to GROUPSHD6000RPT
begin
-- step 1 create separate GROUPSHD6000RPT reporting productcode and move over reporting policies

update software set productcode = 'GROUPSHD6000RPT'
where
productcode = 'GROUPSHD6000' and productfamily = 'epo_reports'

if (@@rowcount > 0)
begin
-- patch4 code review: dont hardcode global rootid=1
declare @grid int
set @grid=0  -- make sure it has a default
select @grid=autoid from branchnode where type=7 and parentid=0
if @grid=0   set @grid=1		-- make sure it has

if not exists(select * from policy where productcode = 'GROUPSHD6000RPT' and parenttype = 7)
insert policy (Parentid, parenttype, productcode)
values(@grid, 7, 'GROUPSHD6000RPT')

declare @aid int
select @aid=autoid from policy where productcode = 'GROUPSHD6000RPT'

if not exists (select * from policysettings where parentid = @aid)
insert policysettings
(parentid, sectionname, settingname, value)
select 
@aid, sectionname, settingname, value
from policysettings, policy
where
policysettings.parentid = policy.autoid
and policy.productcode= 'GROUPSHD6000'
and policy.ParentType = 7


-- step 2 delete all reporting policysetting entries from GROUPSHD6000

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('action1','action2','action3','action4','action5','action6','action7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('version','version1','version2','version3','version4','version5','version6','version7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('filename1','filename2','filename3','filename4','filename5','filename6','filename7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('numfiles','language')

--update software
--set productfamily = 'TVD',
--installguid = '{00000000-0000-0000-0000-000000000000}',
--softwarename = 'VirusScan Enterprise',
--platformssupported = 'WNTW:4:0:4|WNTS|W2KW|W2KS|WXPHE|WXPW|WXPS',
--ostype='Windows'
--where
--productcode = 'viruscan7100'
--and productfamily = ''


-- set timestamps for GROUPSHD6000

update policy set TheTimeStamp = @@dbts, DeleteTimestamp = @@dbts
where productcode = 'GROUPSHD6000'

update leafnode
set policytimestamp = @@dbts, TheTimestamp = @@dbts
from policy
where leafnode.autoid = policy.parentid
and productcode = 'GROUPSHD6000'
	and parenttype =1 

update branchnode
set policytimestamp = @@dbts, TheTimestamp = @@dbts
from policy
where branchnode.autoid = policy.parentid
and productcode = 'GROUPSHD6000'
	and parenttype in (3, 6, 5)

end

end
go



-------------------------------------------------------------------------------------
-- Bug Fix: 235472

declare @dtfirewall_family int;
select @dtfirewall_family=AlertFamilyId from AlertFamily where Name='DTFIREWALL';

-- Intentional mispelling of Quarantine in the line below, as the name of the file FirewallQuarentineCheck.xml already contains the incorrect spelling.
IF NOT(EXISTS(SELECT AlertFamilyId FROM [AlertAliasMapping] WHERE AlertFamilyId=@dtfirewall_family AND AliasFileName='Aliases.FirewallQuarentineCheck.xml.properties' AND FixtureClass='com.nai.Mead.RuleEngine.Messages.JDomFixture' AND FirstMarker='Firewall85QuarentineCheck' AND SecondMarker='')) 
BEGIN
	insert into [AlertAliasMapping] values(@dtfirewall_family, 'Aliases.FirewallQuarentineCheck.xml.properties', 'com.nai.Mead.RuleEngine.Messages.JDomFixture','Firewall85QuarentineCheck','')
END
IF NOT(EXISTS(SELECT AlertFamilyId FROM [AlertAliasMapping] WHERE AlertFamilyId=@dtfirewall_family AND AliasFileName='Aliases.FirewallIntrusionEvent.xml.properties' AND FixtureClass='com.nai.Mead.RuleEngine.Messages.JDomFixture' AND FirstMarker='Firewall85IntrusionEvent' AND SecondMarker='')) 
BEGIN
	insert into [AlertAliasMapping] values(@dtfirewall_family, 'Aliases.FirewallIntrusionEvent.xml.properties', 'com.nai.Mead.RuleEngine.Messages.JDomFixture','Firewall85IntrusionEvent','')
END
IF NOT(EXISTS(SELECT AlertFamilyId FROM [AlertAliasMapping] WHERE AlertFamilyId=@dtfirewall_family AND AliasFileName='Aliases.FirewallBlockedApplication.xml.properties' AND FixtureClass='com.nai.Mead.RuleEngine.Messages.JDomFixture' AND FirstMarker='Firewall85BlockedApplicationEvent' AND SecondMarker='')) 
BEGIN
	insert into [AlertAliasMapping] values(@dtfirewall_family, 'Aliases.FirewallBlockedApplication.xml.properties', 'com.nai.Mead.RuleEngine.Messages.JDomFixture','Firewall85BlockedApplicationEvent','')
END

GO

-- end of bug fix 235472
-------------------------------------------------------------------------------------


-------------------------------------------------------------------------------------
-- epo3.5 patch3 214249 - delete PolicyAudit table only if it exists
-- This proc is located in the master DB, this must be the last thing added to this script
-- This proc is not moved to enumprocedures because it is a special case to fix an auditing problem
-- These changes must be merged into the epoAuditingScripts.sql file under the auditing subsection
USE master
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.ePOSP_ProcessEpoTrace') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure dbo.ePOSP_ProcessEpoTrace
GO

CREATE  PROCEDURE dbo.ePOSP_ProcessEpoTrace
AS
BEGIN

DECLARE @traceid int

-- get traceid 
set @traceid = (select TraceID from dbo.ePOAuditInfo where process = 'ePOAuditing') 

-- stop and delete trace
exec sp_trace_setstatus @traceid, 0
exec sp_trace_setstatus @traceid, 2

-- 214249 delete PolicyAudit table only if it exists
IF EXISTS (select * from sysobjects where name = 'PolicyAudit' 
   		and xtype = 'U')
drop table dbo.PolicyAudit

-- copy trace file into database table
SELECT * INTO dbo.PolicyAudit
FROM ::fn_trace_gettable('c:\epoaudit\ePOAudit.trc', default)

-- delete flat file
exec xp_cmdshell 'del c:\epoaudit\ePOAudit.trc', NO_OUTPUT

-- restart capture
exec dbo.ePOSP_AuditTrace

-- call dll to process audit data
DECLARE @return varchar(255)
DECLARE @object int
DECLARE @hr int
DECLARE @src varchar(255), @desc varchar(255)
EXEC @hr = sp_OACreate 'ePOAuditLog.Process', @object OUT 
IF @hr <> 0
BEGIN
   EXEC sp_OAGetErrorInfo @object, @src OUT, @desc OUT 
   SELECT hr=convert(varbinary(4),@hr), Source=@src, Description=@desc
   UPDATE dbo.ePOAuditInfo SET Error = @src + @desc WHERE TraceID = @traceid
   RETURN
END

-- Call a method that returns a value.
EXEC @hr = sp_OAMethod @object, 'logger', @return OUT
IF @hr <> 0
BEGIN
   EXEC sp_OAGetErrorInfo @object, @src OUT, @desc OUT 
   SELECT hr=convert(varbinary(4),@hr), Source=@src, Description=@desc
   UPDATE dbo.ePOAuditInfo SET Error = @src + @desc WHERE TraceID = @traceid
    RETURN
END

-- Destroy the object.
EXEC @hr = sp_OADestroy @object
IF @hr <> 0
BEGIN
   EXEC sp_OAGetErrorInfo @object, @src OUT, @desc OUT 
   SELECT hr=convert(varbinary(4),@hr), Source=@src, Description=@desc
   UPDATE dbo.ePOAuditInfo SET Error = @src + @desc WHERE TraceID = @traceid
    RETURN
END

return
end
GO

exec sp_procoption N'dbo.ePOSP_AuditTrace', 'startup', 'on'
GO

---------------------------------------------------------------------------------------------
-- Do not make any additional changes here!!
-- Go up and put your changes before the ePOSP_ProcessEpoTrace change
-- This proc is in the master db and any change you put after the 'use master' will be applied
--	to the master db and not to the epo database.



-- end


