/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.action.concrete;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionImplBase;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AddToEPOTreeAction
extends ActionImplBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$snowcap$action$concrete$AddToEPOTreeAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$AddToEPOTreeAction = AddToEPOTreeAction.class$("com.nai.mcafee.snowcap.action.concrete.AddToEPOTreeAction")) : class$com$nai$mcafee$snowcap$action$concrete$AddToEPOTreeAction));
    public static final String TYPE = "add_to_epo";
    private static final String EPO_INSERT_SQL = "insert into LeafNode (TheTimestamp,ParentID,NodeName,Type,AgentGUID,ModifiedPropsDate,LastUpdate,AgentState,AgentPubKey,AgentPubKeyLen,UninstallFlag,AgentPolicyVersion,AgentTaskVersion,AgentSiteInfoVersion,AgentEventFilterVersion,NodePath,AgentPlatform,URL,LastMaxPolicyVersion,LastMaxTaskVersion,SuperAgent,SuperAgentRepo)VALUES (@@DBTS,?,?,1,0x0,'','',1,0x0,0,0,0x0,0x0,0x0,0x0,'','','',0x0,0x0,0,0)";
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$action$concrete$AddToEPOTreeAction;

    private boolean alreadyExistsInEpo(Host host, LookupInfo lookupInfo, Connection connection) throws SQLException {
        EpoDatabase.AgentInfo agentInfo;
        int n = 1;
        Configuration configuration = ActionEnvironment.instance().getConfiguration();
        if (configuration != null) {
            n = configuration.getEpoDbLookupMethod();
        }
        if ((agentInfo = EpoDatabase.getAgentInfo(connection, host, n)) != null) {
            m_log.debug((Object)"The system failed the RMD algorithm test.  It already exists in ePO.");
            return true;
        }
        String string = "select AutoId from LeafNode where ParentId=" + lookupInfo.parentId + " AND NodeName='" + host.getFriendlyName() + "'";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            m_log.debug((Object)("The name query found an entry in the LeafNode table by the name " + host.getFriendlyName()));
            return true;
        }
        m_log.debug((Object)"Didn't find the system in the ePO database, either by the RMD algorithm, or by looking the Rogue Machines node.");
        return false;
    }

    private synchronized LookupInfo findParentId(Connection connection) throws SQLException {
        String string;
        LookupInfo lookupInfo = new LookupInfo();
        String string2 = Resource.getString("addtoepotreeaction_groupnodename");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string = "Select AutoId from BranchNode where Type=7 AND NodeName='GlobalRoot'");
        if (resultSet.next()) {
            lookupInfo.rootId = resultSet.getInt(1);
            m_log.debug((Object)("Found root Id of: " + lookupInfo.rootId));
            string = "select AutoId from BranchNode where Type=4 and ParentId=" + lookupInfo.rootId;
            m_log.debug((Object)("Searching for directory ID with sql:" + string));
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                lookupInfo.dirId = resultSet.getInt(1);
                m_log.debug((Object)("Found directory Id of: " + lookupInfo.dirId));
            }
            if ((resultSet = statement.executeQuery(string = "select AutoId from BranchNode where Type=5 AND ParentId=" + lookupInfo.dirId)).next()) {
                lookupInfo.lostFoundId = resultSet.getInt(1);
                m_log.debug((Object)("Found lost&found ID of:" + lookupInfo.lostFoundId));
            } else {
                lookupInfo.lostFoundId = lookupInfo.dirId;
                m_log.debug((Object)("Could not find Lost&Found ID, using directory ID of:" + lookupInfo.lostFoundId));
            }
            string = "select AutoId from BranchNode where NodeName='" + string2 + "' AND ParentId=" + lookupInfo.lostFoundId;
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                lookupInfo.parentId = resultSet.getInt(1);
            } else {
                string = "insert into BranchNode VALUES('" + string2 + "'," + 3 + "," + lookupInfo.lostFoundId + ",0x0,@@DBTS,null, 0x0)";
                statement.execute(string);
                lookupInfo.parentId = DatabaseUtil.getLastId((Connection)connection);
                m_log.debug((Object)("Create Rogue Systems Id of:" + lookupInfo.parentId));
            }
            m_log.debug((Object)("Found parentId of: " + lookupInfo.parentId));
        }
        DatabaseUtil.close((Statement)statement);
        return lookupInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToEpo(Host host, LookupInfo lookupInfo, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            m_log.debug((Object)("Inserting new machine:" + host.getFriendlyName() + " into ePO tree using parent ID of :" + lookupInfo.parentId));
            preparedStatement = connection.prepareStatement(EPO_INSERT_SQL);
            preparedStatement.setInt(1, lookupInfo.parentId);
            preparedStatement.setString(2, host.getFriendlyName());
            preparedStatement.executeUpdate();
            m_log.debug((Object)"Updating the timestamps.");
            preparedStatement2 = connection.prepareStatement("update BranchNode set TheTimestamp=@@DBTS where AutoId = ? OR AutoId = ? OR AutoId = ?");
            preparedStatement2.setInt(1, lookupInfo.parentId);
            preparedStatement2.setInt(2, lookupInfo.dirId);
            preparedStatement2.setInt(3, lookupInfo.rootId);
            preparedStatement2.executeUpdate();
            connection.commit();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DatabaseUtil.close(preparedStatement);
            DatabaseUtil.close(preparedStatement2);
            throw throwable;
        }
        DatabaseUtil.close((Statement)preparedStatement);
        DatabaseUtil.close((Statement)preparedStatement2);
    }

    private boolean meetsMinRequirements(Host host) {
        String string = host.getFriendlyName();
        return string.indexOf(58) == -1;
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        Host host = actionContext.getHost();
        if (host == null) {
            throw new ActionInvocationException(Resource.getString("addtoepotreeaction_nullhost"));
        }
        Connection connection = null;
        try {
            try {
                connection = ActionEnvironment.instance().getEPODbConnection();
                LookupInfo lookupInfo = this.findParentId(connection);
                m_log.debug((Object)("Invoke found Parent ID of:" + lookupInfo.parentId));
                if (lookupInfo.parentId == -1) {
                    throw new SQLException(Resource.formatString("addtoepotreeaction_dirnodefound", host.getFriendlyName()));
                }
                if (!this.meetsMinRequirements(host)) {
                    throw new ActionInvocationException(Resource.formatString("addtoepotreeaction_minreqfailed", host.getFriendlyName()));
                }
                if (this.alreadyExistsInEpo(host, lookupInfo, connection)) {
                    throw new ActionInvocationException(Resource.formatString("addtoepotreeaction_leafnodeexists", host.getFriendlyName()));
                }
                this.addToEpo(host, lookupInfo, connection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw new ActionInvocationException(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return 0;
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return 0;
    }

    public String getPropertyName(int n) {
        return null;
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_addto_epo_tree";
    }

    public boolean appliesToStatus(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LookupInfo {
        public int rootId;
        public int dirId;
        public int lostFoundId;
        public int parentId;

        private LookupInfo() {
        }
    }
}

