/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.client.proxy;

import com.nai.mcafee.snowcap.client.MessageUtil;
import com.nai.mcafee.snowcap.client.proxy.ConnectionHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;

public class ProxyServer {
    private int m_listenPort;
    private String m_remoteHost;
    private int m_remotePort;
    private SSLContext m_SSLContext = null;

    public ProxyServer(int n, String string, int n2) {
        this.m_listenPort = n;
        this.m_remoteHost = string;
        this.m_remotePort = n2;
    }

    private final ServerSocket createServerSocket() throws IOException {
        if (this.m_SSLContext != null) {
            return this.m_SSLContext.getServerSocketFactory().createServerSocket(this.m_listenPort);
        }
        return new ServerSocket(this.m_listenPort);
    }

    private final Socket createSocket() throws Exception {
        if (this.m_SSLContext != null) {
            return this.m_SSLContext.getSocketFactory().createSocket(this.m_remoteHost, this.m_remotePort);
        }
        return new Socket(this.m_remoteHost, this.m_remotePort);
    }

    public void run() throws Exception {
        ServerSocket serverSocket = this.createServerSocket();
        ThreadGroup threadGroup = new ThreadGroup("WorkerThreadGroup");
        Socket socket = null;
        int n = 0;
        while ((socket = serverSocket.accept()) != null) {
            System.out.println("***New connection [" + n + "]");
            Socket socket2 = this.createSocket();
            this.spawnWorkerThread(threadGroup, socket, socket2, "ClientReader" + n);
            this.spawnWorkerThread(threadGroup, socket2, socket, "ServerReader" + n);
            ++n;
        }
    }

    private void spawnWorkerThread(ThreadGroup threadGroup, Socket socket, Socket socket2, String string) {
        Thread thread = new Thread(threadGroup, new ConnectionHandler(socket, socket2), string);
        thread.setDaemon(true);
        thread.start();
    }

    public final void initSSL(String string, String string2) throws Exception {
        this.m_SSLContext = MessageUtil.createSSLContext(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.out.println("Usage: ProxyServer <listen-port> <forward-ip-addr> <forward-ip-port> [<keystore> <keystore-passwd>]");
            System.exit(-1);
        }
        ProxyServer proxyServer = new ProxyServer(Integer.parseInt(stringArray[0]), stringArray[1], Integer.parseInt(stringArray[2]));
        if (stringArray.length >= 5) {
            proxyServer.initSSL(stringArray[3], stringArray[4]);
        }
        System.out.println("Proxy server listening on port: " + stringArray[0]);
        proxyServer.run();
    }
}

