/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.server;

import com.nai.mcafee.snowcap.server.SubnetStatus;
import java.util.HashMap;

public class SubnetStatusTable {
    public static final int DEFAULT_MAX_SENSORS_PER_SUBNET = 2;
    public static final long DEFAULT_ROTATION_PERIOD = 43200000L;
    public static final long DEFAULT_INACTIVE_SENSOR_PERIOD = 5400000L;
    private HashMap m_hashTable = new HashMap();
    private long m_sensorRotationPeriod = 0L;
    private long m_inactiveSensorPeriod = 0L;
    private int m_maxSensorsPerSubnet = 1;
    private boolean m_enabled = false;

    public SubnetStatusTable(boolean bl, int n, long l, long l2) {
        this.m_enabled = bl;
        this.m_maxSensorsPerSubnet = n;
        this.m_sensorRotationPeriod = l;
        this.m_inactiveSensorPeriod = l2;
    }

    public SubnetStatusTable() {
        this(false, 2, 43200000L, 5400000L);
    }

    public synchronized boolean processSensor(int n, int n2, long l) {
        if (!this.m_enabled) {
            return true;
        }
        Integer n3 = new Integer(n);
        SubnetStatus subnetStatus = (SubnetStatus)this.m_hashTable.get(n3);
        if (subnetStatus == null) {
            subnetStatus = new SubnetStatus();
            this.m_hashTable.put(n3, subnetStatus);
        }
        return subnetStatus.processSensor(n2, this.m_maxSensorsPerSubnet, l, this.m_sensorRotationPeriod, this.m_inactiveSensorPeriod);
    }

    public synchronized boolean isSensorActive(int n, int n2) {
        if (!this.m_enabled) {
            return true;
        }
        SubnetStatus subnetStatus = (SubnetStatus)this.m_hashTable.get(new Integer(n));
        if (subnetStatus == null) {
            return false;
        }
        return subnetStatus.isActive(n2);
    }

    public synchronized void clear() {
        this.m_hashTable.clear();
    }

    public final synchronized void setEnabled(boolean bl) {
        if (bl != this.m_enabled) {
            this.clear();
        }
        this.m_enabled = bl;
    }

    public final boolean getEnabled() {
        return this.m_enabled;
    }

    public long getSensorRotationPeriod() {
        return this.m_sensorRotationPeriod;
    }

    public void setSensorRotationPeriod(long l) {
        this.m_sensorRotationPeriod = l;
    }

    public long getInactiveSensorPeriod() {
        return this.m_inactiveSensorPeriod;
    }

    public void setInactiveSensorPeriod(long l) {
        this.m_inactiveSensorPeriod = l;
    }

    public int getMaxSensorsPerSubnet() {
        return this.m_maxSensorsPerSubnet;
    }

    public void setMaxSensorsPerSubnet(int n) {
        this.m_maxSensorsPerSubnet = n;
    }
}

