/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.action.ActionInvoker;
import com.nai.mcafee.snowcap.action.EPOActionContext;
import com.nai.mcafee.snowcap.action.concrete.DeploySensorAction;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.event.EventFactory;
import com.nai.mcafee.snowcap.event.concrete.UserRequestEvent;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.EpoHostList;
import com.nai.mcafee.snowcap.ui.util.SessionState;
import com.nai.mcafee.snowcap.ui.util.SubnetInfo;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DeploySensorsBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$ui$DeploySensorsBean == null ? (class$com$nai$mcafee$snowcap$ui$DeploySensorsBean = DeploySensorsBean.class$("com.nai.mcafee.snowcap.ui.DeploySensorsBean")) : class$com$nai$mcafee$snowcap$ui$DeploySensorsBean).getName());
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$DeploySensorsBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = httpServletRequest.getParameter("sensorInstallDir");
        if (!SessionUtil.isNonEmptyString((String)string2)) {
            String string3 = Resource.getString("deploysensorsbean_need_install_dir", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)string3, (String)"displaysensordeploy.do");
            return "actiontaken.jsp";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstallDir(Configuration configuration, String string) throws Exception {
        Connection connection = Server.getDb().getConnection();
        try {
            configuration.setSensorInstallDir(string);
            configuration.update(connection);
            connection.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        Server.reloadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserRequestEvent createUserRequestEvent() throws SQLException {
        UserRequestEvent userRequestEvent;
        Connection connection = Server.getDb().getConnection();
        try {
            userRequestEvent = EventFactory.createUserRequestEvent(connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return userRequestEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network getNetwork(SubnetInfo subnetInfo) throws SQLException {
        Network network;
        Connection connection = Server.getDb().getConnection();
        try {
            network = Network.getBySubnetInfo(connection, subnetInfo.getNetworkAddress(), subnetInfo.getSubnetMask());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return network;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        boolean bl = false;
        String string2 = httpServletRequest.getParameter("sensorInstallDir");
        Configuration configuration = Server.getConfiguration();
        UserRequestEvent userRequestEvent = null;
        DeploySensorAction deploySensorAction = new DeploySensorAction();
        EPOActionContext ePOActionContext = null;
        if (string2.compareTo(configuration.getSensorInstallDir()) != 0) {
            this.updateInstallDir(configuration, string2);
        }
        userRequestEvent = this.createUserRequestEvent();
        EpoHostList epoHostList = SessionState.getEpoHostList(httpServletRequest);
        int n = 0;
        while (n < epoHostList.size()) {
            object = epoHostList.getAt(n);
            Network network = this.getNetwork((SubnetInfo)object);
            if (network == null) {
                throw new ActionInvocationException(Resource.getString("deploysensorsbean_netfindfailed", string));
            }
            int n2 = 0;
            while (n2 < ((SubnetInfo)object).size()) {
                int n3 = Integer.parseInt(((SubnetInfo)object).getLeafNodeIdAt(n2));
                String string3 = ((SubnetInfo)object).getHostnameAt(n2);
                ePOActionContext = new EPOActionContext(userRequestEvent.getType(), userRequestEvent.getId(), network, n3, string3);
                try {
                    ActionInvoker.invokeAction(deploySensorAction, ePOActionContext);
                }
                catch (ActionInvocationException actionInvocationException) {
                    m_log.error((Object)Resource.getString("deploysensorsbean_failed"), (Throwable)actionInvocationException);
                    bl = true;
                }
                m_log.info((Object)Resource.formatString("deploysensorsbean_template_installed_to", string3));
                ++n2;
            }
            ++n;
        }
        epoHostList.clear();
        if (bl) {
            object = Resource.getString("deploysensorsbean_failures", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)object, (String)"displayactionlist.do");
            return "actiontaken.jsp";
        }
        return "displayactionlist.do";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

