/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.db.io.ResponseSet;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.util.Resource;
import com.nai.mcafee.snowcap.util.http.MultipartStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ImportResponseBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$ui$ImportResponseBean == null ? (class$com$nai$mcafee$snowcap$ui$ImportResponseBean = ImportResponseBean.class$("com.nai.mcafee.snowcap.ui.ImportResponseBean")) : class$com$nai$mcafee$snowcap$ui$ImportResponseBean).getName());
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$ImportResponseBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        if (httpServletRequest.getContentType().indexOf("multipart/form-data") == -1) {
            return ImportResponseBean.setErrorPage(httpServletRequest);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = ImportResponseBean.getBoundary(httpServletRequest.getContentType());
        if (string2.length() == 0) {
            return ImportResponseBean.setErrorPage(httpServletRequest);
        }
        byte[] byArray = string2.getBytes("UTF8");
        MultipartStream multipartStream = new MultipartStream((InputStream)httpServletRequest.getInputStream(), byArray);
        if (!multipartStream.skipPreamble()) {
            return ImportResponseBean.setErrorPage(httpServletRequest);
        }
        if (multipartStream.readHeaders().indexOf("importResponseFile") == -1) {
            return ImportResponseBean.setErrorPage(httpServletRequest);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        multipartStream.readBodyData(byteArrayOutputStream);
        Connection connection = null;
        try {
            try {
                connection = Server.getDb().getConnection();
                ResponseSet.loadFromBinary(byteArrayOutputStream.toByteArray()).save(connection);
            }
            catch (Exception exception) {
                DatabaseUtil.rollback((Connection)connection);
                SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_action_failed", string), (String)Resource.getString("importresponsebean_error"), (String)"displayuiconfig.do");
                m_log.error((Object)Resource.getString("importresponsebean_error"));
                m_log.error((Object)exception);
                String string3 = "actiontaken.jsp";
                Object var12_10 = null;
                DatabaseUtil.close((Connection)connection);
                return string3;
            }
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        Server.reloadConfiguration();
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_action_taken_confirmation", string), (String)Resource.getString("dbioactionbean_successful_import", string), (String)"displayresponselist.do");
        return "actiontaken.jsp";
    }

    private static final String getBoundary(String string) {
        Pattern pattern = Pattern.compile("boundary=(\\S+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private static final String setErrorPage(HttpServletRequest httpServletRequest) {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)Resource.getString("importresponsebean_input_error", string), (String)"displayuiconfig.do");
        return "actiontaken.jsp";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

