/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.ActionStatusTypes;
import com.nai.mcafee.snowcap.db.EventTypes;
import com.nai.mcafee.snowcap.db.QueryUtil;
import com.nai.mcafee.snowcap.ui.util.PropDisplay;
import com.nai.mcafee.snowcap.util.Resource;
import java.lang.reflect.InvocationTargetException;

public class ActionStatusPropDisplay
implements PropDisplay {
    ActionStatus m_dbo;
    private String m_lang = null;
    public static final boolean[] DISPLAYABLE_PROPERTIES = new boolean[]{false, false, false, false, false, false, false, false, true, true, false, false, false, false, true, true, true, false, false, true, true, false, false, false, true, true, true};
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$ActionStatus;

    public DatabaseObject getDbo() {
        return this.m_dbo;
    }

    public void setDbo(DatabaseObject databaseObject) {
        this.m_dbo = (ActionStatus)databaseObject;
    }

    public ActionStatusPropDisplay(String string) {
        this.m_lang = string;
    }

    public String getTruncatedProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String string = Resource.getString("actionstatuspropdisplay_na", this.m_lang);
        if (this.m_dbo != null) {
            String string2 = null;
            switch (n) {
                case 26: {
                    string2 = this.m_dbo.getType();
                    if (string2 == null) break;
                    string2 = Resource.getDataString(string2, this.m_lang);
                    break;
                }
                case 14: {
                    string2 = EventTypes.asString(this.m_dbo.getEventLogType(), this.m_lang);
                    break;
                }
                case 20: {
                    Integer n2 = this.m_dbo.getStatus();
                    if (n2 == null) break;
                    string2 = ActionStatusTypes.asString(n2, this.m_lang);
                    break;
                }
                case 24: {
                    string2 = this.m_dbo.getDescription(this.m_lang);
                    break;
                }
                default: {
                    Object object = this.m_dbo.getProperty(n);
                    string2 = object == null ? "" : object.toString();
                }
            }
            if (string2 != null && string2.length() > 0) {
                string = string2;
            }
        }
        return StringUtil.safeHtml((String)string);
    }

    public String getFullProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        return this.getTruncatedProperty(n);
    }

    public String getFullHeader(int n) {
        String string = "";
        if (n > 0 && n < DISPLAYABLE_PROPERTIES.length) {
            string = Resource.getString("actionstatuspropdisplay_" + ActionStatus.PROPERTY_NAMES[n], this.m_lang);
        }
        return string;
    }

    public String getTruncatedHeader(int n) {
        return this.getFullHeader(n);
    }

    public boolean isPropertyDisplayable(int n) {
        if (n > 0 && n < DISPLAYABLE_PROPERTIES.length) {
            return DISPLAYABLE_PROPERTIES[n];
        }
        return false;
    }

    public int getRowStyle() {
        return 0;
    }

    public String getOrderByClause(int n, int n2) {
        int n3;
        switch (n) {
            case 24: 
            case 26: {
                n3 = 6;
                break;
            }
            case 20: {
                n3 = 7;
                break;
            }
            case 25: {
                n3 = 18;
                break;
            }
            default: {
                n3 = n;
            }
        }
        return " order by " + n3 + " " + QueryUtil.getOrder(n2);
    }

    public int getDefaultSortCol() {
        return 8;
    }

    public int getDefaultSortOrder() {
        return 2;
    }

    public String getTableName() {
        return "ActionStatus as A left join EventLog as E on A.EventLogId=E.EventLogId left join Hosts as H on A.TargetHostId=H.HostID left join Networks as N on A.TargetNetworkId=N.NetworkId left join Sensors as S on A.TargetSensorId=S.SensorId  ";
    }

    public String getIdColumnName() {
        return "ActionStatusId";
    }

    public Class getDBClass() {
        return class$com$nai$mcafee$snowcap$db$ActionStatus == null ? (class$com$nai$mcafee$snowcap$db$ActionStatus = ActionStatusPropDisplay.class$("com.nai.mcafee.snowcap.db.ActionStatus")) : class$com$nai$mcafee$snowcap$db$ActionStatus;
    }

    public String getSelectColumns() {
        return "A.*, E.Type, E.CreateTime, H.FriendlyName, N.SubnetMask, N.NetworkAddress, S.SensorName";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

