/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.NetworkStatus;
import com.nai.mcafee.snowcap.ui.util.PropDisplay;
import com.nai.mcafee.snowcap.util.Resource;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;

public class NetworkPropDisplay
implements PropDisplay {
    Network m_dbo;
    private String m_lang;
    public static final boolean[] DISPLAYABLE_PROPERTIES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$util$NetworkPropDisplay;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$Network;

    public DatabaseObject getDbo() {
        return this.m_dbo;
    }

    public void setDbo(DatabaseObject databaseObject) {
        this.m_dbo = (Network)databaseObject;
    }

    public NetworkPropDisplay(String string) {
        this.m_lang = string;
    }

    public String getTruncatedProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        if (!($assertionsDisabled || n > 0 && n <= this.m_dbo.getNumProperties())) {
            throw new AssertionError();
        }
        Object object = this.m_dbo.getProperty(n);
        if (n == 9) {
            return NetworkStatus.asString(this.m_dbo.getStatus(), this.m_lang);
        }
        if (object instanceof Timestamp) {
            return StringUtil.formatDateTime((Timestamp)((Timestamp)this.m_dbo.getProperty(n)));
        }
        if (n == 6) {
            return Long.toString(this.m_dbo.getNetworkAddressNum());
        }
        return StringUtil.safeHtml((String)(object == null ? "" : object.toString()));
    }

    public String getFullHeader(int n) {
        if (this.isPropertyDisplayable(n)) {
            return Resource.getString("networkpropdisplay_" + Network.PROPERTY_NAMES[n], this.m_lang);
        }
        return "";
    }

    public String getFullProperty(int n) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IPFormatException {
        return this.getTruncatedProperty(n);
    }

    public String getTruncatedHeader(int n) {
        return this.getFullHeader(n);
    }

    public boolean isPropertyDisplayable(int n) {
        if (n > DISPLAYABLE_PROPERTIES.length) {
            return false;
        }
        return DISPLAYABLE_PROPERTIES[n];
    }

    public int getRowStyle() {
        int n = this.m_dbo.getStatus();
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 7;
            }
        }
        return 1;
    }

    public String getOrderByClause(int n, int n2) {
        String string;
        if (!($assertionsDisabled || n > 0 && n <= 10)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 != 1 && n2 != 2) {
            throw new AssertionError();
        }
        String string2 = string = n2 == 1 ? "asc " : "desc ";
        if (n == 8) {
            return "max(LastCommunicationTime) " + string;
        }
        if (n == 7) {
            return "count(S.SensorID) " + string;
        }
        if (n == 9) {
            return "max(LastCommunicationTime) " + string;
        }
        if (n == 4) {
            return Integer.toString(6) + " " + string;
        }
        if (n == 10) {
            return Integer.toString(6) + " " + string + ", " + Integer.toString(3) + " " + string;
        }
        return Integer.toString(n) + " " + string;
    }

    public int getDefaultSortCol() {
        return 10;
    }

    public int getDefaultSortOrder() {
        return 1;
    }

    public String getTableName() {
        return "Networks";
    }

    public String getIdColumnName() {
        return "NetworkId";
    }

    public Class getDBClass() {
        return class$com$nai$mcafee$snowcap$db$Network == null ? (class$com$nai$mcafee$snowcap$db$Network = NetworkPropDisplay.class$("com.nai.mcafee.snowcap.db.Network")) : class$com$nai$mcafee$snowcap$db$Network;
    }

    public String getSelectColumns() {
        return "*";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$ui$util$NetworkPropDisplay == null ? (class$com$nai$mcafee$snowcap$ui$util$NetworkPropDisplay = NetworkPropDisplay.class$("com.nai.mcafee.snowcap.ui.util.NetworkPropDisplay")) : class$com$nai$mcafee$snowcap$ui$util$NetworkPropDisplay).desiredAssertionStatus();
        DISPLAYABLE_PROPERTIES = new boolean[]{false, false, true, false, false, false, false, true, true, true, true};
    }
}

