/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.server;

import com.nai.Mead.RuleEngine.Rules.Actions.ExtToolAction;
import com.nai.Mead.RuleEngine.Rules.HandleDesktopFireWall;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.ActionEnvironment;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetFactory;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetFactoryException;
import com.nai.Mead.RuleEngine.Service.RuleEngineSingleton;
import com.nai.Mead.db.AlertingConfig;
import com.nai.Mead.db.MappingUtil;
import com.nai.Mead.db.SchemaVersion;
import com.nai.Mead.server.ActionEnvironmentImpl;
import com.nai.Mead.server.ServerInitException;
import com.nai.Utility.Cache.AlertAliasMappingCache;
import com.nai.Utility.Cache.AliasCache;
import com.nai.Utility.Cache.EpoHostCache;
import com.nai.Utility.Cache.EventCategoryCache;
import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.Queries;
import com.nai.mcafee.common.db.Tool;
import com.nai.mcafee.common.util.Resource;
import com.nai.mcafee.common.util.ResourceException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class Server {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$Mead$server$Server == null ? (class$com$nai$Mead$server$Server = Server.class$("com.nai.Mead.server.Server")) : class$com$nai$Mead$server$Server).getName());
    public static final String DEFAULT_LOG_FILENAME = "c:/alerting.log";
    public static final String LOG_CONFIG_FILENAME = "log_config.xml";
    public static final String SERVER_CONFIG_FILENAME = "Alerting.properties";
    public static final String LOCAL_IP = "127.0.0.1";
    private static Database m_db = null;
    private static Database m_epoDb = null;
    private static boolean m_logAllEvents = false;
    private static boolean m_logErrorEvents = false;
    private static boolean m_sInitialized = false;
    private static boolean m_sInitFailed = false;
    private static String m_initErrorString = "";
    private static String m_tomcatPort = "";
    private static String m_ePOInstallDir = "";
    private static String m_agentHttpPort = "8080";
    private static Tool[] m_tools = null;
    private static AlertingConfig m_config = null;
    private static NotificationTargetFactory m_notificationTargetFactory = null;
    private static String m_defaultLocale = null;
    private static InetAddress m_localHost = null;
    private static int m_aamCacheLifetime;
    private static int m_epoHostCacheLifetime;
    private static int m_ecCacheLifetime;
    private static boolean m_allowServletGet;
    static /* synthetic */ Class class$com$nai$Mead$server$Server;

    public static synchronized void init() throws Exception {
        if (m_sInitialized) {
            return;
        }
        m_sInitFailed = true;
        try {
            Server.initLogging();
            m_log.debug((Object)"Starting to load our config file...");
            Properties properties = Server.loadProperties();
            m_log.debug((Object)"Starting to read the general properties...");
            Server.setGeneralProperties(properties);
            m_log.debug((Object)"Starting to initialize the database system...");
            Server.initDatabase(properties);
            m_log.debug((Object)"Starting to confirm schema version is correct...");
            SchemaVersion.verifyDbSchemaVersion(Server.getDb());
            ActionEnvironment.setInstance(new ActionEnvironmentImpl());
            m_log.debug((Object)"Starting to reload configuration info from the database...");
            Server.reloadConfiguration();
            m_log.debug((Object)"Starting to load MappingUtil info from the database...");
            Server.loadMappingUtil();
            m_sInitFailed = false;
            m_initErrorString = "";
            m_sInitialized = true;
        }
        catch (Exception exception) {
            m_log.error((Object)exception);
            m_initErrorString = exception.getMessage();
            throw exception;
        }
    }

    public static synchronized void shutdown() {
        if (!m_sInitialized) {
            return;
        }
        m_sInitialized = false;
    }

    public static Database getDb() {
        return m_db;
    }

    public static Database getEpoDb() {
        return m_epoDb;
    }

    public static String getInitErrorString() {
        return m_initErrorString;
    }

    public static final String getTomcatPort() {
        return m_tomcatPort;
    }

    public static final String getLocalHostName() {
        return m_localHost.getHostName();
    }

    public static final InetAddress getLocalHost() {
        return m_localHost;
    }

    public static final String getEPOInstallDir() {
        return m_ePOInstallDir;
    }

    public static final String getAgentHttpPort() {
        return m_agentHttpPort;
    }

    public static NotificationTargetFactory getNotificationTargetFactory() {
        return m_notificationTargetFactory;
    }

    public static final boolean shouldLogAllEvents() {
        return m_logAllEvents;
    }

    public static final boolean shouldLogErrorEvents() {
        return m_logErrorEvents;
    }

    public static synchronized void cleanup() {
    }

    public static final synchronized boolean initialized() {
        return m_sInitialized;
    }

    public static final synchronized boolean initFailed() {
        return m_sInitFailed;
    }

    public static final boolean getAllowServletGet() {
        return m_allowServletGet;
    }

    public static final void logError(String string) {
        m_log.error((Object)string);
    }

    private static void initLogging() {
        FileAppender fileAppender;
        Enumeration enumeration;
        URL uRL = (class$com$nai$Mead$server$Server == null ? (class$com$nai$Mead$server$Server = Server.class$("com.nai.Mead.server.Server")) : class$com$nai$Mead$server$Server).getClassLoader().getResource(LOG_CONFIG_FILENAME);
        if (uRL != null) {
            DOMConfigurator.configureAndWatch((String)uRL.getFile());
        }
        Logger logger = Logger.getRootLogger();
        boolean bl = false;
        if (!logger.getAllAppenders().hasMoreElements()) {
            bl = true;
            enumeration = new PatternLayout("%d{ISO8601} %-5p %-15c{2} %x - %m%n");
            fileAppender = new FileAppender();
            ConsoleAppender consoleAppender = new ConsoleAppender();
            fileAppender.setName("ToFile");
            fileAppender.setLayout((Layout)enumeration);
            fileAppender.setBufferedIO(false);
            fileAppender.setFile(DEFAULT_LOG_FILENAME);
            fileAppender.setAppend(true);
            fileAppender.activateOptions();
            consoleAppender.setName("ToStdout");
            consoleAppender.setLayout((Layout)enumeration);
            consoleAppender.setTarget("System.out");
            consoleAppender.activateOptions();
            logger.addAppender((Appender)fileAppender);
            logger.addAppender((Appender)consoleAppender);
            logger.setLevel(Level.INFO);
        }
        if (bl) {
            m_log.warn((Object)com.nai.Mead.util.Resource.formatString("server_template_init_failed", LOG_CONFIG_FILENAME));
        }
        enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            fileAppender = (Appender)enumeration.nextElement();
            if (!(fileAppender instanceof FileAppender)) continue;
            m_log.info((Object)com.nai.Mead.util.Resource.formatString("server_template_writing_log_file", fileAppender.getFile()));
        }
    }

    public static void initDatabase(Properties properties) throws ServerInitException {
        String string = "";
        boolean bl = com.nai.Mead.util.Resource.getStringOrDefault(properties, "epo.use.server.ini", "false").equals("true");
        try {
            string = "alerting";
            if (bl) {
                m_log.debug((Object)"Initializing salt database with ePO server.ini");
                m_db = Database.createFromServerINI((Properties)properties, (String)string, (String)Queries.VALIDATE_SALT_DB);
            } else {
                m_log.debug((Object)"Initializing salt database with properties file.");
                m_db = Database.createFromPropertiesFile((Properties)properties, (String)string, (String)Queries.VALIDATE_SALT_DB);
            }
            m_log.info((Object)com.nai.Mead.util.Resource.getString("server_alerting_db_init_success"));
            string = "epo";
            if (bl) {
                m_log.debug((Object)"Initializing ePO database with ePO server.ini");
                m_epoDb = Database.createFromServerINI((Properties)properties, (String)string, (String)Queries.VALIDATE_SALT_DB);
            } else {
                m_log.debug((Object)"Initializing ePO database with properties file.");
                m_epoDb = Database.createFromPropertiesFile((Properties)properties, (String)string, (String)Queries.VALIDATE_EPO_DB);
            }
            m_log.info((Object)com.nai.Mead.util.Resource.getString("server_epo_db_init_success"));
        }
        catch (Exception exception) {
            String string2 = com.nai.Mead.util.Resource.formatString("server_template_dbinit_failed", string);
            m_log.error((Object)string2, (Throwable)exception);
            throw new ServerInitException(string2, exception);
        }
    }

    public static final Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        InputStream inputStream = (class$com$nai$Mead$server$Server == null ? (class$com$nai$Mead$server$Server = Server.class$("com.nai.Mead.server.Server")) : class$com$nai$Mead$server$Server).getClassLoader().getResourceAsStream(SERVER_CONFIG_FILENAME);
        if (inputStream == null) {
            throw new ServerInitException(com.nai.Mead.util.Resource.formatString("server_template_load_config_failed", SERVER_CONFIG_FILENAME));
        }
        properties.load(inputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reloadConfiguration() throws SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            m_log.debug((Object)"(re)loading configuration.");
            m_config = AlertingConfig.loadConfig(connection);
            m_tools = Tool.getAll((Connection)connection, (int)2);
            m_notificationTargetFactory = new NotificationTargetFactory(connection);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public static final void loadMappingUtil() throws SQLException, NotificationTargetFactoryException, ClassNotFoundException {
        MappingUtil.setDb(m_db);
        MappingUtil.setConfig(m_config);
        MappingUtil.loadProductsAndCategories();
    }

    public static final boolean isLocal(HttpServletRequest httpServletRequest) {
        Boolean bl = (Boolean)httpServletRequest.getAttribute("ISLOCAL");
        if (bl == null) {
            bl = new Boolean(false);
        }
        return bl;
    }

    public static final void setLocal(HttpServletRequest httpServletRequest) {
        String string;
        Boolean bl = new Boolean(false);
        String string2 = httpServletRequest.getRemoteAddr();
        if (string2.compareTo(string = m_localHost.getHostAddress()) == 0 || string2.compareTo(LOCAL_IP) == 0) {
            bl = new Boolean(true);
        }
        httpServletRequest.setAttribute("ISLOCAL", (Object)bl);
    }

    public static final Tool[] getTools() {
        return m_tools;
    }

    public static AlertingConfig getConfiguration() {
        return m_config;
    }

    public static void reloadRules() throws Exception {
        RuleEngineSingleton.getService().reloadRules();
        MappingUtil.loadProductsAndCategories();
    }

    private static final void setGeneralProperties(Properties properties) throws ResourceException, ServerInitException {
        String string = Locale.getDefault().getLanguage();
        if (string == null) {
            string = "en";
        }
        m_defaultLocale = com.nai.Mead.util.Resource.getStringOrDefault(properties, "server.default.language", string);
        com.nai.Mead.util.Resource.setDefaultLocale(m_defaultLocale);
        Resource.setDefaultLocale((String)m_defaultLocale);
        m_log.info((Object)com.nai.Mead.util.Resource.formatString("server_template_default_lang", Resource.getString((String)("language_" + m_defaultLocale)), m_defaultLocale));
        String string2 = properties.getProperty("log.event.details", "none");
        if (string2.equals("all")) {
            m_logAllEvents = true;
            m_logErrorEvents = false;
        } else if (string2.equals("error")) {
            m_logAllEvents = false;
            m_logErrorEvents = true;
        } else {
            m_logAllEvents = false;
            m_logErrorEvents = false;
        }
        Server.setLocalHost();
        m_ePOInstallDir = com.nai.Mead.util.Resource.getStringOrThrow(properties, "epo.install.dir", SERVER_CONFIG_FILENAME);
        ExtToolAction.setTTL(Integer.parseInt(properties.getProperty("tool.max.runtime", "60000")));
        HandleDesktopFireWall.setFirewallPsuedoEventId(Integer.parseInt(properties.getProperty("alerting.dtfirewall.psudoeventid", "1")));
        AlertAliasMappingCache.setDefaultCacheLifetime(Long.parseLong(properties.getProperty("cache.lifetime.alertaliasmapping", "604800")));
        EventCategoryCache.setDefaultCacheLifetime(Long.parseLong(properties.getProperty("cache.lifetime.eventcategory", "604800")));
        AliasCache.setDefaultCacheLifetime(Long.parseLong(properties.getProperty("cache.lifetime.alias", "3600")));
        EpoHostCache.setDefaultCacheLifetime(Long.parseLong(properties.getProperty("cache.lifetime.epohost", "300")));
        m_allowServletGet = com.nai.Mead.util.Resource.getStringOrDefault(properties, "servlet.allow.get", "false").equals("true");
    }

    private static void setLocalHost() throws ServerInitException {
        try {
            m_localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServerInitException(com.nai.Mead.util.Resource.getString("server_no_localhost_name"));
        }
    }

    public static String getDefaultLocale() {
        return m_defaultLocale;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_allowServletGet = false;
    }
}

