/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db.epo;

import com.nai.mcafee.common.db.epo.EpoPassword;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.log4j.Logger;

public class EpoHttpClient {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$common$db$epo$EpoHttpClient == null ? (class$com$nai$mcafee$common$db$epo$EpoHttpClient = EpoHttpClient.class$("com.nai.mcafee.common.db.epo.EpoHttpClient")) : class$com$nai$mcafee$common$db$epo$EpoHttpClient).getName());
    public static final int PASSWORD_PLAINTEXT = 1;
    public static final int PASSWORD_HASHED = 2;
    static /* synthetic */ Class class$com$nai$mcafee$common$db$epo$EpoHttpClient;

    public static final String getFile(String string, int n, String string2, String string3, int n2, String string4) throws Exception {
        return EpoHttpClient.doEpoHttpRequest(string, n, string2, string3, n2, string4, null);
    }

    public static final void postFile(String string, int n, String string2, String string3, int n2, String string4, String string5) throws Exception {
        EpoHttpClient.doEpoHttpRequest(string, n, string2, string3, n2, string4, string5);
    }

    private static final String readResponseCode(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine().trim();
        m_log.debug((Object)("ReadResponseCode-->" + string));
        String[] stringArray = string.split(" ");
        if (stringArray.length != 3) {
            throw new IOException("Bad HTTP header from ePO server.");
        }
        return stringArray[1];
    }

    private static final String readHeader(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        String string3 = bufferedReader.readLine().trim();
        m_log.debug((Object)("ReadHeader      -->" + string3));
        while (string3.length() > 0) {
            String[] stringArray;
            if (string != null && (stringArray = string3.split(":")).length == 2 && stringArray[0].trim().equals(string)) {
                string2 = stringArray[1].trim();
            }
            string3 = bufferedReader.readLine().trim();
            m_log.debug((Object)("ReadHeader      -->" + string3));
        }
        return string2;
    }

    private static final String readContent(BufferedReader bufferedReader) throws IOException {
        String string = EpoHttpClient.readHeader(bufferedReader, "Content-Length");
        if (string == null) {
            m_log.debug((Object)"Content         --> <empty>");
            return "";
        }
        int n = Integer.parseInt(string);
        if (n <= 0 || n > 1000000) {
            throw new IOException("Invalid content length from ePO server: " + string);
        }
        m_log.debug((Object)("ReadContent--> Content length:" + string));
        char[] cArray = new char[n];
        int n2 = bufferedReader.read(cArray, 0, cArray.length);
        if (n2 != n) {
            throw new IOException("Unable to read all " + n + " bytes.");
        }
        String string2 = new String(cArray);
        m_log.debug((Object)("Content         -->" + string2));
        return string2;
    }

    private static final String doEpoHttpRequest(String string, int n, String string2, String string3, int n2, String string4, String string5) throws Exception {
        String string6;
        block11: {
            BufferedReader bufferedReader;
            OutputStreamWriter outputStreamWriter;
            String string7;
            String string8;
            Socket socket;
            block12: {
                boolean bl;
                boolean bl2;
                block9: {
                    block10: {
                        String string9;
                        bl2 = string5 == null;
                        bl = n2 == 1;
                        String string10 = bl2 ? "GET" : "POST";
                        socket = new Socket(string, n);
                        m_log.debug((Object)"EpoHttpClient - beginning authenticated request.");
                        m_log.debug((Object)("EpoHttpClient - user:" + string2 + " " + string3 + " uri: " + string4 + " port: " + n));
                        string8 = string10 + " " + string4 + " HTTP/1.1\r\n";
                        try {
                            socket.setSoTimeout(10000);
                            m_log.debug((Object)"EpoHttpClient - sending request...");
                            string7 = string8 + "User-Agent: Mozilla/4.0 (Windows; McAfee SecureHttp/1.0; 32bit)\r\n" + "\r\n";
                            outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                            outputStreamWriter.write(string7);
                            outputStreamWriter.flush();
                            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            string6 = EpoHttpClient.readResponseCode(bufferedReader);
                            m_log.debug((Object)("EpoHttpClient - got response code  (1):" + string6));
                            if (!string6.equals("200")) break block9;
                            if (!bl2) break block10;
                            string9 = EpoHttpClient.readContent(bufferedReader);
                            Object var23_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_22 = null;
                            socket.close();
                            throw throwable;
                        }
                        socket.close();
                        return string9;
                    }
                    String string11 = "";
                    Object var23_19 = null;
                    socket.close();
                    return string11;
                }
                if (!string6.equals("401")) break block11;
                String string12 = EpoHttpClient.readHeader(bufferedReader, "SPIPE-Authenticate");
                if (string12 == null) {
                    throw new IOException("didn't find nonce in ePO server reply!");
                }
                m_log.debug((Object)("EpoHttpClient - got nonce:" + string12));
                String string13 = EpoPassword.answerEpoServerChallenge(string12, string2, string3, bl);
                m_log.debug((Object)("EpoHttpClient - my response is:" + string13));
                string7 = string8 + "User-Agent: Mozilla/4.0 (Windows; McAfee SecureHttp/1.0; 32bit)\r\n" + "SPIPE-Authorization: " + string2 + ":" + string13 + "\r\n" + "Host: localhost\r\n" + "Date: 1078263351\r\n\r\n";
                outputStreamWriter.write(string7);
                outputStreamWriter.flush();
                m_log.debug((Object)"EpoHttpClient - wrote response...");
                string6 = EpoHttpClient.readResponseCode(bufferedReader);
                m_log.debug((Object)("EpoHttpClient - got response code (2):" + string6));
                if (!string6.equals("200")) {
                    throw new IOException("Failed to authenticate with ePO server!");
                }
                String string14 = EpoHttpClient.readContent(bufferedReader);
                m_log.debug((Object)"EpoHttpClient - got content.");
                if (!bl2) break block12;
                String string15 = string14;
                Object var23_20 = null;
                socket.close();
                return string15;
            }
            string7 = string8 + "User-Agent: Mozilla/4.0 (Windows; McAfee SecureHttp/1.0; 32bit)\r\n" + "Date: 1078263351\r\n" + "Content-Length: " + string5.length() + "\r\n\r\n" + string5;
            outputStreamWriter.write(string7);
            outputStreamWriter.flush();
            m_log.debug((Object)"EpoHttpClient - wrote 3rd (!) post.");
            string6 = EpoHttpClient.readResponseCode(bufferedReader);
            m_log.debug((Object)("EpoHttpClient - got response code (3):" + string6));
            if (!string6.equals("200") && !string6.equals("202")) {
                throw new IOException("Failed to post to ePO server!");
            }
            String string16 = "";
            Object var23_21 = null;
            socket.close();
            return string16;
        }
        throw new IOException("Unexpected HTTP response from ePO server:" + string6);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

