BEGIN

/* Create test data up to branch nodes */
--EXECUTE AVITEST_truncate_tables 2

-- 0 or 1 deletes under node avitest
-- 2 delete all data

/* Create test data: leafnodes, compprop, prodprop, events */
/* Truncates: ProductSettings, ProductProperties, ComputerProperties, LeafNode, Events */
--EXECUTE AVITEST_Truncate_Tables 0
--GO

-- smb change
--truncate table productproperties
--truncate table events
--truncate table productevents

------------------------------------------------
-- smb changes
-- reset compliance defn
delete reportinputparameters where reportid in ('complianceissues', 'oldcomplianceissues')
and (langid = '' or langid is null)

-- for smb setup inital conditions
-- set last detection and upgrade check to a previous year so that all values are recalculated
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'smbCheckPoint')
Begin
truncate table smbCheckPoint

Insert smbCheckPoint
(UpdateEventsAutoID, LastUpdate, LastComplianceCheck, EventsAutoID, LastDetectionsCheck, LastUpdateCheck) 
values(0, '0', '1/1/2000', 1, '1/1/2000', '1/1/2000')
End

----------------------------------------
-- If protection pilot
-- truncate smb tables
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'smbCompliance')
Begin
truncate table smbCompliance
--go
truncate table smbComplianceRollup
--go
truncate table smbDetectionSummary
--go
truncate table smbDetectionSummaryRollup
--go
truncate table smbUpdateSummary
--go
truncate table smbUpdateSummaryRollup
truncate table smbCurrentProductChanges
truncate table smbCurrentProductChangesLog
--go
End


---------------------------------------------------------------
-- To create a new site just copy this file to a new name
-- remove the first two lines above
-- rename the site node and change all occurrences of S1 to S2


------------------
-- load computers

-- add a computer
--EXECUTE AVITEST_addleaf_plus LeafNodeName, BranchNodeName, LastAsci, 0


-- add some products
-- EXECUTE AVITEST_addProdProp LeafNodeName ,ProductCode, ProductVersion, 0, 
--	EngineVer, DATver, LangID, ExtraDAT, ServicePack, HotFix, LicenseStatus, LiceseExpirationDate
-- ProductEvent table entries automatically made based on version values

--BEGIN
Declare @YYYYMMDD char(30)	
set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), GetDate(),120), '-', ''), ':', ''), ' ', '')

Declare @LastServerUpdate char(30)	
set @LastServerUpdate = Replace( Replace( Replace( convert(char(30), dateadd(hour,+1,GetDate()),120), '-', ''), ':', ''), ' ', '')

Declare @NextServerUpdate char(30)	
set @NextServerUpdate = Replace( Replace( Replace( convert(char(30), dateadd(hour,-1,GetDate()),120), '-', ''), ':', ''), ' ', '')


Declare @Late char(30)	
set @Late = Replace( Replace( Replace( convert(char(30), dateadd(day,-8,GetDate()),120), '-', ''), ':', ''), ' ', '')

Declare @Today DateTime	
set @Today = GetDate()

Declare @Yesterday DateTime	
set @Yesterday = dateadd(day,-1,GetDate())

Declare @LastWeek DateTime	
set @LastWeek = dateadd(day,-7,GetDate())

Declare @2WeeksPast DateTime	
set @2WeeksPast = dateadd(day,-14,GetDate())

Declare @3WeeksPast DateTime	
set @3WeeksPast = dateadd(day,-21,GetDate())

Declare @4WeeksPast DateTime	
set @4WeeksPast = dateadd(day,-28,GetDate())

Declare @5WeeksPast DateTime	
set @5WeeksPast = dateadd(day,-35,GetDate())

Declare @LastMonth DateTime	
set @LastMonth = dateadd(day,-32,GetDate())

Declare @LastQuarter DateTime	
set @LastQuarter = dateadd(day,-96,GetDate())

Declare @Cleaned int	
set @Cleaned = 50
Declare @Deleted int	
set @Deleted = 1280
Declare @Moved int	
set @Moved = 57
Declare @Cleanerror int	
set @Cleanerror = 1502

--------------------------------------------------------
-- Setup Products: fake, real, and product versions
----------------------------------------------------------

Declare @cnt1 int

---------------------------------------------
-- Make sure these products exist for testing
-- Trend fake
declare @TRENDPC char(20)   set @TRENDPC = 'TREND9999'
declare @TRENDPV char(20)   set @TRENDPV = '1.0.123'
declare @TRENDENG char(20)   set @TRENDENG = '12t'
declare @TRENDDAT char(20)   set @TRENDDAT = '1234t'
delete software where productcode = @TRENDPC
select @cnt1= count(*) from software where productcode = @TRENDPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @TRENDPC, @TRENDPC, '', '', @TRENDPV, 'TVD_NC_TREND', '0409'

-- Firewall fake
declare @FIREWALLPC char(20)   set @FIREWALLPC = 'FIREWALL9999'
declare @FIREWALLPV char(20)   set @FIREWALLPV = '1.0.124'
delete software where productcode = 'FIREWALL9999'
select @cnt1= count(*) from software where productcode = 'FIREWALL9999'
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @FIREWALLPC, 'FIREWALL', '', '', @FIREWALLPV, 'SECURE', '0409'

-- NORTONAV7500
declare @NORTONAVPC char(20)   set @NORTONAVPC = 'NORTONAV7500'
declare @NORTONAVPV char(20)   set @NORTONAVPV = '7.5.0'
declare @NORTONAVENG char(20)   set @NORTONAVENG = '11k'
declare @NORTONAVDAT char(20)   set @NORTONAVDAT = '1234g'
select @cnt1= count(*) from software where productcode = @NORTONAVPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @NORTONAVPC, 'NORTON ANTIVIRUS', '', '', @NORTONAVPV, 'TVD_NC', '0409'

-- agent mac fake
declare @EPOAGENTMACPC char(20)   set @EPOAGENTMACPC = 'EPOAGENT2000MAC'
declare @EPOAGENTMACPV char(20)   set @EPOAGENTMACPV = '1.0.123'
select @cnt1= count(*) from software where productcode = @EPOAGENTMACPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @EPOAGENTMACPC, 'ePO Agent for Mac', '', '', @EPOAGENTMACPV, 'EPO', '0409'

-- for some reason stinger is using same product family as norton tvd_nc
-- stinger fake
declare @STINGERPC char(20)   set @STINGERPC = 'STINGER_1234'
declare @STINGERPV char(20)   set @STINGERPV = '1.0.123'
select @cnt1= count(*) from software where productcode = @STINGERPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @STINGERPC, 'STINGER', '', '', @STINGERPV, 'TVD_NC', '0409'

-- Viruscan7500
declare @VIRUSCANPC char(20)   set @VIRUSCANPC = 'VIRUSCAN7500'
declare @VIRUSCANPV char(20)   set @VIRUSCANPV = '7.5.0'
declare @VIRUSCANPVOLD char(20)   set @VIRUSCANPVOLD = '7.5.0.1230wrk'
declare @VIRUSCANPVST char(20)    declare @VIRUSCANPVPP char(20)
select @cnt1= count(*) from software where productcode = @VIRUSCANPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @VIRUSCANPC, 'Virus Scan', '', '', @VIRUSCANPV, 'TVD', '0409'
select @VIRUSCANPVST= max(ProductVersion) from software where ProductCode like 'VIRUSCAN%' 
select @VIRUSCANPVPP= max(ProductVersion) from productproperties where ProductCode like 'VIRUSCAN%' 
set @VIRUSCANPV = @VIRUSCANPVST
if @VIRUSCANPVPP > @VIRUSCANPVST
	set @VIRUSCANPV = @VIRUSCANPVPP
set @VIRUSCANPV = '7.5.0.1234srv' -- override
select @VIRUSCANPV as VIRUSCANPV, @VIRUSCANPVOLD as VIRUSCANPVOLD, @VIRUSCANPVST as VIRUSCANPVST, @VIRUSCANPVPP as VIRUSCANPVPP

-- Viruscan7100
-- VIRUSCAN7000

declare @VIRUSCANOLDOSPC char(20)   set @VIRUSCANOLDOSPC = 'VIRUSCAN7000'
declare @VIRUSCANOLDOSPV char(20)   set @VIRUSCANOLDOSPV = '7.0.0'
declare @VIRUSCANOLDOSPVOLD char(20)   set @VIRUSCANOLDOSPVOLD = '7.0.0'
declare @VIRUSCANOLDOSPVST char(20)    declare @VIRUSCANOLDOSPVPP char(20)
select @cnt1= count(*) from software where productcode = @VIRUSCANOLDOSPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @VIRUSCANOLDOSPC, 'Virus Scan', '', '', @VIRUSCANOLDOSPV, 'TVD', '0409'
select @VIRUSCANOLDOSPVST= max(ProductVersion) from software where ProductCode like @VIRUSCANOLDOSPC 
select @VIRUSCANOLDOSPVPP= max(ProductVersion) from productproperties where ProductCode like @VIRUSCANOLDOSPC 
set @VIRUSCANOLDOSPV = @VIRUSCANOLDOSPVST
if @VIRUSCANOLDOSPVPP > @VIRUSCANOLDOSPVST
	set @VIRUSCANOLDOSPV = @VIRUSCANOLDOSPVPP
--select @VIRUSCANOLDOSPV as VIRUSCANOLDOSPV, @VIRUSCANOLDOSPVOLD as VIRUSCANOLDOSPVOLD, @VIRUSCANOLDOSPVST as VIRUSCANOLDOSPVST, @VIRUSCANOLDOSPVPP as VIRUSCANOLDOSPVPP


-- EPOAGENT3000
declare @EPOAGENTPC char(20)   set @EPOAGENTPC = 'EPOAGENT3000'
declare @EPOAGENTPV char(20)   set @EPOAGENTPV = '3.0.1'
declare @EPOAGENTPVOLD char(20)   set @EPOAGENTPVOLD = '3.0.0.123'
declare @EPOAGENTPVST char(20)    declare @EPOAGENTPVPP char(20)
select @cnt1= count(*) from software where productcode = @EPOAGENTPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @EPOAGENTPC, 'Epo Agent', '', '', @EPOAGENTPV, 'EPO', '0409'
select @EPOAGENTPVST= max(ProductVersion) from software where ProductCode like 'EPOAGENT%' 
select @EPOAGENTPVPP= max(ProductVersion) from productproperties where ProductCode like 'EPOAGENT%' 
set @EPOAGENTPV = @EPOAGENTPVST
if @EPOAGENTPVPP > @EPOAGENTPVST
	set @EPOAGENTPV = @EPOAGENTPVPP
set @EPOAGENTPV = '3.0.2.1234' -- override
select @EPOAGENTPV as EPOAGENTPV, @EPOAGENTPVOLD as EPOAGENTPVOLD, @EPOAGENTPVST as EPOAGENTPVST, @EPOAGENTPVPP as EPOAGENTPVPP

-- EPOAGENT3000WSHD
declare @EPOAGENTWSPC char(20)   set @EPOAGENTWSPC = 'EPOAGENT3000WSHD'
declare @EPOAGENTWSPV char(20)   set @EPOAGENTWSPV = '3.0.0'
declare @EPOAGENTWSPVOLD char(20)   set @EPOAGENTWSPVOLD = '3.0.0.123'
declare @EPOAGENTWSPVST char(20)    declare @EPOAGENTWSPVPP char(20)
select @cnt1= count(*) from software where productcode = @EPOAGENTWSPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @EPOAGENTWSPC, 'Epo Agent for Webshield', '', '', @EPOAGENTWSPV, 'EPO', '0409'
select @EPOAGENTWSPVST= max(ProductVersion) from software where ProductCode like 'EPOAGENT3000WSHD' 
select @EPOAGENTWSPVPP= max(ProductVersion) from productproperties where ProductCode like 'EPOAGENT3000WSHD' 
set @EPOAGENTWSPV = @EPOAGENTWSPVST
if @EPOAGENTWSPVPP > @EPOAGENTWSPVST
	set @EPOAGENTWSPV = @EPOAGENTWSPVPP
set @EPOAGENTWSPV = '3.0.0.1234' -- override
--select @EPOAGENTWSPV as EPOAGENTWSPV, @EPOAGENTWSPVOLD as EPOAGENTWSPVOLD, @EPOAGENTPVST as EPOAGENTWSPVST, @EPOAGENTWSPVPP as EPOAGENTWSPVPP

-- EPOAGENT3000LYNX
declare @EPOAGENTLXPC char(20)   set @EPOAGENTLXPC = 'EPOAGENT3000LYNX'
declare @EPOAGENTLXPV char(20)   set @EPOAGENTLXPV = '3.0.0'
declare @EPOAGENTLXPVOLD char(20)   set @EPOAGENTLXPVOLD = '3.0.0.123'
declare @EPOAGENTLXPVST char(20)    declare @EPOAGENTLXPVPP char(20)
select @cnt1= count(*) from software where productcode = @EPOAGENTLXPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @EPOAGENTLXPC, 'Epo Agent for Linux', '', '', @EPOAGENTLXPV, 'EPO', '0409'
select @EPOAGENTLXPVST= max(ProductVersion) from software where ProductCode like 'EPOAGENT3000LYNX' 
select @EPOAGENTLXPVPP= max(ProductVersion) from productproperties where ProductCode like 'EPOAGENT3000LYNX' 
set @EPOAGENTLXPV = @EPOAGENTLXPVST
if @EPOAGENTLXPVPP > @EPOAGENTLXPVST
	set @EPOAGENTLXPV = @EPOAGENTLXPVPP
set @EPOAGENTLXPV = '3.0.0.1234' -- override
--select @EPOAGENTLXPV as EPOAGENTLXPV, @EPOAGENTLXPVOLD as EPOAGENTLXPVOLD, @EPOAGENTLXPVST as EPOAGENTLXPVST, @EPOAGENTLXPVPP as EPOAGENTLXPVPP

-- EPOAGENT2000NVNW
declare @EPOAGENTNWPC char(20)   set @EPOAGENTNWPC = 'EPOAGENT2000NVNW'
declare @EPOAGENTNWPV char(20)   set @EPOAGENTNWPV = '2.0.1'
declare @EPOAGENTNWPVOLD char(20)   set @EPOAGENTNWPVOLD = '2.0.0.123'
declare @EPOAGENTNWPVST char(20)    declare @EPOAGENTNWPVPP char(20)
select @cnt1= count(*) from software where productcode = @EPOAGENTNWPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @EPOAGENTNWPC, 'Epo Agent fro Netware', '', '', @EPOAGENTNWPV, 'EPO', '0409'
select @EPOAGENTNWPVST= max(ProductVersion) from software where ProductCode like 'EPOAGENT2000NVNW' 
select @EPOAGENTNWPVPP= max(ProductVersion) from productproperties where ProductCode like 'EPOAGENT2000NVNW' 
set @EPOAGENTNWPV = @EPOAGENTNWPVST
if @EPOAGENTNWPVPP > @EPOAGENTNWPVST
	set @EPOAGENTNWPV = @EPOAGENTNWPVPP
set @EPOAGENTNWPV = '2.0.2.1234' -- override
--select @EPOAGENTNWPV as EPOAGENTNWPV, @EPOAGENTNWPVOLD as EPOAGENTNWPVOLD, @EPOAGENTNWPVST as EPOAGENTNWPVST, @EPOAGENTNWPVPP as EPOAGENTNWPVPP

-- NETSHLD_4500
declare @NETSHLDPC char(20)   set @NETSHLDPC = 'NETSHLD_4500'
declare @NETSHLDPV char(20)   set @NETSHLDPV = '4.5.0'
declare @NETSHLDPVOLD char(20)   set @NETSHLDPVOLD = '4.5.0'
declare @NETSHLDPVST char(20)    declare @NETSHLDPVPP char(20)
select @cnt1= count(*) from software where productcode = @NETSHLDPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @NETSHLDPC, 'NetShield', '', '', @NETSHLDPV, 'TVD', '0409'
select @NETSHLDPVST= max(ProductVersion) from software where ProductCode like @NETSHLDPC 
select @NETSHLDPVPP= max(ProductVersion) from productproperties where ProductCode like @NETSHLDPC 
set @NETSHLDPV = @NETSHLDPVST
if @NETSHLDPVPP > @NETSHLDPVST
	set @NETSHLDPV = @NETSHLDPVPP
--select @NETSHLDPV as NETSHLDPV, @NETSHLDPVOLD as NETSHLDPVOLD, @NETSHLDPVST as NETSHLDPVST, @NETSHLDPVPP as NETSHLDPVPP

-- GSDOMINO5000
declare @GSDOMINOPC char(20)   set @GSDOMINOPC = 'GSDOMINO5000'
declare @GSDOMINOPV char(20)   set @GSDOMINOPV = '5.0.1'
declare @GSDOMINOPVOLD char(20)   set @GSDOMINOPVOLD = '5.0.0'
declare @GSDOMINOPVST char(20)    declare @GSDOMINOPVPP char(20)
select @cnt1= count(*) from software where productcode = @GSDOMINOPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @GSDOMINOPC, 'GroupShield Domino', '', '', @GSDOMINOPV, 'TVD', '0409'
select @GSDOMINOPVST= max(ProductVersion) from software where ProductCode like @GSDOMINOPC 
select @GSDOMINOPVPP= max(ProductVersion) from productproperties where ProductCode like @GSDOMINOPC 
set @GSDOMINOPV = @GSDOMINOPVST
if @GSDOMINOPVPP > @GSDOMINOPVST
	set @GSDOMINOPV = @GSDOMINOPVPP
--select @GSDOMINOPV as GSDOMINOPV, @GSDOMINOPVOLD as GSDOMINOPVOLD, @GSDOMINOPVST as GSDOMINOPVST, @GSDOMINOPVPP as GSDOMINOPVPP

-- NSHLDNW_4600
declare @NSHLDNWPC char(20)   set @NSHLDNWPC = 'NSHLDNW_4600'
declare @NSHLDNWPV char(20)   set @NSHLDNWPV = '4.6.1'
declare @NSHLDNWPVOLD char(20)   set @NSHLDNWPVOLD = '4.6.0'
declare @NSHLDNWPVST char(20)    declare @NSHLDNWPVPP char(20)
select @cnt1= count(*) from software where productcode = @NSHLDNWPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @NSHLDNWPC, 'NetShield Netware', '', '', @NSHLDNWPV, 'TVD', '0409'
select @NSHLDNWPVST= max(ProductVersion) from software where ProductCode like @NSHLDNWPC 
select @NSHLDNWPVPP= max(ProductVersion) from productproperties where ProductCode like @NSHLDNWPC 
set @NSHLDNWPV = @NSHLDNWPVST
if @NSHLDNWPVPP > @NSHLDNWPVST
	set @NSHLDNWPV = @NSHLDNWPVPP
--select @NSHLDNWPV as NSHLDNWPV, @NSHLDNWPVOLD as NSHLDNWPVOLD, @NSHLDNWPVST as NSHLDNWPVST, @NSHLDNWPVPP as NSHLDNWPVPP


-- Patch scanner PATCHSCAN
declare @PATCHSCANPC char(20)   set @PATCHSCANPC = 'PATCH___1100'
declare @PATCHSCANPV char(20)   set @PATCHSCANPV = '1.1'
declare @PATCHSCANPVOLD char(20)   set @PATCHSCANPVOLD = '1.1'
declare @PATCHSCANPVST char(20)    declare @PATCHSCANPVPP char(20)
select @cnt1= count(*) from software where productcode = @PATCHSCANPC
if @cnt1 = 0
EXECUTE AVITEST_insertnew_software @PATCHSCANPC, 'PATCHSCAN', '', '', @PATCHSCANPV, 'Secure', '0409'
select @PATCHSCANPVST= max(ProductVersion) from software where ProductCode like @PATCHSCANPC 
select @PATCHSCANPVPP= max(ProductVersion) from productproperties where ProductCode like @PATCHSCANPC 
set @PATCHSCANPV = @PATCHSCANPVST
if @PATCHSCANPVPP > @PATCHSCANPVST
	set @PATCHSCANPV = @PATCHSCANPVPP
--select @NSHLDNWPV as NSHLDNWPV, @NSHLDNWPVOLD as NSHLDNWPVOLD, @NSHLDNWPVST as NSHLDNWPVST, @NSHLDNWPVPP as NSHLDNWPVPP



Declare @ServicePack1 char(10)
set @ServicePack1 = '1'
Declare @ServicePack2 char(10)
set @ServicePack2 = '2'
Declare @Patch1 char(10)
set @Patch1 = '1'
Declare @Patch2 char(10)
set @Patch2 = '2'

------------------------------
-- setup main product versions

/*
Declare @AgentVerPP char(15)   set @AgentVerPP  = '3.1.0.1234' 
Declare @AgentVer char(15)   set @AgentVer  = '3.1.0.1234' 
Declare @AgentVerOld char(15)   set @AgentVerOld  = '3.0.0' 
Declare @ProdVer char(15)   set @ProdVer  = '7.1.0' 
Declare @ProdVerPP char(15)   set @ProdVerPP  = '7.1.0' 

select @AgentVerPP= max(ProductVersion) from productproperties where ProductCode like 'EPOAGENT%' 
select @ProdVerPP= max(ProductVersion) from productproperties where ProductCode like 'VIRUSCAN%' 

select @AgentVer= ProductVersion from Software where ProductCode = 'EPOAGENT3000'  AND Language = '0409'
select @ProdVer= max(ProductVersion) from Software where ProductCode like 'VIRUSCAN%'  AND Language = '0409'

if @AgentVerPP > @AgentVer
	set @AgentVer = @AgentVerPP
select @AgentVerPP as AgentverPP, @AgentVer as Agentver

if @AgentVer = '' or @AgentVer is null
	set @AgentVer  = '3.1.0.1234'  

if @ProdVerPP > @ProdVer
	set @ProdVer = @ProdVerPP
select @ProdVerPP as ProdVerPP, @ProdVer as ProdVer
*/



-------------------------------------------------------
-- If a Dat\ENG is installed in the repository, use it as the top dat & eng

Declare @Dat1 char(15)   set @Dat1  = '4.0.4313'
Declare @Dat2 char(15)   set @Dat2  = '4.0.4312'
Declare @Dat3 char(15)   set @Dat3  = '4.0.4311'
Declare @Dat4 char(15)   set @Dat4  = '4.0.4310'
Declare @Dat5 char(15)   set @Dat5  = '4.0.4309'
Declare @Eng1 char(15)   set @Eng1  = '4.1.60'
Declare @Eng2 char(15)   set @Eng2  = '4.1.40'
Declare @Eng3 char(15)   set @Eng3  = '4.1.20'
Declare @exDat char(15)  set @exDat = 'extraDat'

Declare @TopDAT varchar(20)
Declare @TopENG varchar(20)
select @TopDAT= ProductVersion from Software where ProductCode = 'VSCANDAT1000'
select @TopENG= ProductVersion from Software where ProductCode = 'VSCANENG1000'  

if @TopDAT > ''
	Set @Dat1 = @TopDAT
if @TopENG > ''
	Set @ENG1 = @TopENG

select @TopENG as TopENG, @TopDAT as TopDAT, @Eng1 as Eng, @Dat1 as Dat

-- Buffer overflow DAT Versions
Declare @BFDAT1 varchar(10)
Declare @BFDAT2 varchar(10)
Declare @BFDAT3 varchar(10)
Set @BFDAT1 = '121'
Set @BFDAT2 = '122'
Set @BFDAT3 = '123'

----------------------------------------------------------
-- To create a mirror entry: 
--- copy from here down to a separate file (using the same variables defined above)
--- Change the names or directories and coputers
----------------------------------------------------------

--------------------------------------------------------
-- directory structure and computers
--- Suffix for 25 computers - X1 (use the same 25 computers to create multiples by changing suffix)
--- 200 computers - X1, X1T, X1U, X1V, X1W, X1X, X1Y, X1Z
--- 1000 Computers - X1, WX1, XX1, YX1, ZX1
--- Mulitples of 1000 - X1, X2, X3, ...
----------------------------------------------------------

---------------------------------------------------
-- setup @WorkstationsX1 directory (used in minime)
-- if a directory is not added, then the computers for the directory will be skipped
declare @id int

Declare @TopNode char(20)
Declare @GroupNodeType int
----------------------------------------
-- If protection pilot
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'smbCompliance')
begin
	set @TopNode = 'Directory'
	set @GroupNodeType = 6 
end
else
begin
	set @TopNode = 'TestSite'
	set @GroupNodeType = 3
end

-- setup site if not PRP
IF not EXISTS (SELECT * FROM sysobjects WHERE name = 'smbCompliance')
begin
	declare @TestSite char(20)   	set @TestSite = @TopNode 
	delete BranchNode where NodeName = @TestSite 
	select @cnt1= count(*) from branchnode where nodename = @TestSite 
	if @cnt1 = 0
	EXECUTE AVITEST_insert_branchnode @TestSite, 'Directory', 6,5
end


-- These groups are all sitenodes so type=6
-- @ServersX1 Directory
declare @ServersX1 char(20)   	set @ServersX1 = 'Servers-X1'
delete BranchNode where NodeName = @ServersX1
select @cnt1= count(*) from branchnode where nodename = @ServersX1
if @cnt1 = 0
Begin
EXECUTE AVITEST_insert_branchnode @ServersX1, @TopNode, @GroupNodeType,5

-- epo3.5 Create mapping point for active directory
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Mapping_Points')
Begin
	select @ID=autoid from branchnode where nodename = @ServersX1
	INSERT Mapping_Points
		(Enabled, ePONodeID, LastRunDate, DN, LDAPServer, LDAPUsername, LDAPPassword)
		values(1,@ID,'20040404','ActiveDirectoryNode1','LDAPServer1','LDAPUsername1','LDAPPassword1')
	select @ID=autoid from Mapping_Points where DN = 'ActiveDirectoryNode1'
	INSERT Mapping_Exclusions (ParentID, DN) values(@ID,'ActiveDirectoryEXNode1')
End
End

-- computernames that will be inserted at this node
declare @SRVMAINX1 char(20)   	set @SRVMAINX1 = 'SRV-MAIN-X1'
declare @SRVSATELLITEX1 char(20)  set @SRVSATELLITEX1 = 'SRVSATELLITE-X1'


-- @WorkstationsX1 Directory
declare @WorkstationsX1 char(20)   set @WorkstationsX1 = 'Workstations-X1'
delete BranchNode where NodeName = @WorkstationsX1
select @cnt1= count(*) from branchnode where nodename = @WorkstationsX1
if @cnt1 = 0
Begin
EXECUTE AVITEST_insert_branchnode @WorkstationsX1, @TopNode, @GroupNodeType,5

-- epo3.5 Create mapping point for active directory
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Mapping_Points')
Begin
	select @ID=autoid from branchnode where nodename = @WorkstationsX1
	INSERT Mapping_Points
		(Enabled, ePONodeID, LastRunDate, DN, LDAPServer, LDAPUsername, LDAPPassword)
		values(1,@ID,'20040404','ActiveDirectoryNode2','LDAPServer1','LDAPUsername1','LDAPPassword1')
	select @ID=autoid from Mapping_Points where DN = 'ActiveDirectoryNode2'
	INSERT Mapping_Exclusions (ParentID, DN) values(@ID,'ActiveDirectoryEXNode2')
End
End

-- if not protection pilot, then insert a child directory
IF Not EXISTS (SELECT * FROM sysobjects WHERE name = 'smbCheckPoint')
Begin
	declare @WorkstationChildX1 char(20)   set @WorkstationChildX1 = 'WorkstationChildX1'
	delete BranchNode where NodeName = @WorkstationChildX1
	select @cnt1= count(*) from branchnode where nodename = @WorkstationChildX1
	if @cnt1 = 0
	EXECUTE AVITEST_insert_branchnode @WorkstationChildX1, @WorkstationsX1, 3,5
End

declare @WSSHULLX1 char(20)  	set @WSSHULLX1 = 'WS-SHULL-X1'
declare @WSBGAYLESX1 char(20)  	set @WSBGAYLESX1 = 'WS-BGAYLES-X1'
declare @WSGJOHNSONX1 char(20)  	set @WSGJOHNSONX1 = 'WS-GJOHNSON-X1'
declare @WSPPETTERSONX1 char(20)  set @WSPPETTERSONX1 = 'WS-PPETTERSON-X1'
declare @WSLBINSX1 char(20)  	set @WSLBINSX1 = 'WS-LBINS-X1'
declare @WSLCHANGX1 char(20)  	set @WSLCHANGX1 = 'WS-LCHANG-X1'
declare @WSDPERSONX1 char(20)  	set @WSDPERSONX1 = 'WS-DPERSON-X1'
declare @WSJWILLIAMX1 char(20)  	set @WSJWILLIAMX1 = 'WS-JWILLIAM-X1'
declare @WSTMATTHEWSX1 char(20)  set @WSTMATTHEWSX1 = 'WS-TMATTHEWS-X1'
declare @WSMOLSENX1 char(20)  	set @WSMOLSENX1 = 'WS-MOLSEN-X1'
declare @WSMHILANDX1 char(20)  set @WSMHILANDX1 = 'WS-MHILAND-X1'
declare @WSCYANGX1 char(20)  	set @WSCYANGX1 = 'WS-CYANG-X1'
declare @WSUNPROTECTEDX1 char(20)  set @WSUNPROTECTEDX1 = 'WS-UNPROTECTED-X1'
declare @WSNOAGENTX1 char(20)  	set @WSNOAGENTX1 = 'WS-NOAGENT-X1'



-- Laptops  Directory
declare @LaptopsX1 char(20)   	set @LaptopsX1 = 'Laptops-X1'
delete BranchNode where NodeName = @LaptopsX1
select @cnt1= count(*) from branchnode where nodename = @LaptopsX1
if @cnt1 = 0
EXECUTE AVITEST_insert_branchnode @LaptopsX1, @TopNode, @GroupNodeType,5

declare @LPLOANER1X1 char(20)  	set @LPLOANER1X1 = 'LP-LOANER1-X1'
declare @LPLOANER2X1 char(20)  	set @LPLOANER2X1 = 'LP-LOANER2-X1'
declare @LPENICHOLSX1 char(20)  	set @LPENICHOLSX1 = 'LP-ENICHOLS-X1'
declare @LPMPARTRIDGEX1 char(20) set @LPMPARTRIDGEX1 = 'LP-MPARTRIDGE-X1'
declare @LPGRAILX1 char(20)  	set @LPGRAILX1 = 'LP-GRAIL-X1'


-- HomeUsers  Directory
declare @HomeUsersX1 char(20)   	set @HomeUsersX1 = 'Home Users-X1'
delete BranchNode where NodeName = @HomeUsersX1
select @cnt1= count(*) from branchnode where nodename = @HomeUsersX1
if @cnt1 = 0
EXECUTE AVITEST_insert_branchnode @HomeUsersX1, @TopNode, @GroupNodeType,5

declare @HMACAMPBELX1 char(20)  	set @HMACAMPBELX1 = 'HM-ACAMPBEL-X1'
declare @HMBQUINNX1 char(20)  	set @HMBQUINNX1 = 'HM-BQUINN-X1'
declare @HMMEDUARDOX1 char(20)  	set @HMMEDUARDOX1 = 'HM-MEDUARDO-X1'


-- EmptyGroup (create only one of these - no X1)
declare @EmptyGroup char(20)   	set @EmptyGroup = 'EmptyGroup-X1'
delete BranchNode where NodeName = @EmptyGroup
select @cnt1= count(*) from branchnode where nodename = @EmptyGroup
if @cnt1 = 0
EXECUTE AVITEST_insert_branchnode @EmptyGroup, @TopNode, @GroupNodeType,5
--GO


-- Test  Directory
declare @TestX1 char(20)   	set @TestX1 = 'Test-X1'
delete BranchNode where NodeName = @TestX1
select @cnt1= count(*) from branchnode where nodename = @TestX1
if @cnt1 = 0
EXECUTE AVITEST_insert_branchnode @TestX1, @TopNode, @GroupNodeType,5

declare @TSALPHAX1 char(20)  	set @TSALPHAX1 = 'TS-ALPHA-X1'
declare @TSBETAX1 char(20)  	set @TSBETAX1 = 'TS-BETA-X1'
declare @TSOMEGAX1 char(20)  	set @TSOMEGAX1 = 'TS-OMEGA-X1'

-- recalc node support tables: BranchNodeEnum, ReportFullPathNode, ReportFullPathNodeID
execute AVIDALSP_Generate_BranchNode_Enum

---------------------------------------------------------------------------
---------------------------------------------------------------------------

----------------------------------


----------------------------------------
-- load computers
----------------------------------------

-- clean out snowcap tables
/*IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Hosts')
begin
		delete EventLog 
		delete Hosts 
		-- delete sensors and networks if nothing else point to them
		delete Sensors
		delete Networks where NetworkName > ''
end
*/
----------------------------------------
-- @TestX1 Grab bag of extra products
select @cnt1= count(*) from branchnode where nodename = @TestX1
if @cnt1 > 0
begin

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSALPHAX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSALPHAX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSALPHAX1
Execute dbo.AVITEST_RemoveSnowcapEntries @TSALPHAX1
Delete Leafnode where NodeName = @TSALPHAX1
EXECUTE AVITEST_addleaf_plus @TSALPHAX1, @TestX1, @YYYYMMDD, 0, 'Windows 2000', 'srv', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @TSALPHAX1,@EPOAGENTWSPC , @EPOAGENTWSPV , 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSALPHAX1,@TRENDPC, @TRENDPV, 0, @TRENDENG, @TRENDDAT, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSALPHAX1,@NORTONAVPC, @NORTONAVPV, 0, @NORTONAVENG , @NORTONAVDAT, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSBETAX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSBETAX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSBETAX1
Execute dbo.AVITEST_RemoveSnowcapEntries @TSBETAX1
Delete Leafnode where NodeName = @TSBETAX1
EXECUTE AVITEST_addleaf_plus @TSBETAX1, @TestX1, @YYYYMMDD, 0, 'Windows 2000', 'srv', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @TSBETAX1,@EPOAGENTLXPC , @EPOAGENTLXPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSBETAX1,@VIRUSCANOLDOSPC , @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @TSBETAX1,@VIRUSCANPC, '7.1.0.1234.srv', 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSBETAX1, @STINGERPC , @STINGERPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSBETAX1, @FIREWALLPC  , @FIREWALLPV, 0, '', '', '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSOMEGAX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSOMEGAX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @TSOMEGAX1
Execute dbo.AVITEST_RemoveSnowcapEntries @TSOMEGAX1
Delete Leafnode where NodeName = @TSOMEGAX1
EXECUTE AVITEST_addleaf_plus @TSOMEGAX1, @TestX1, @YYYYMMDD, 0, 'Windows 2000', 'srv', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @TSOMEGAX1,@EPOAGENTNWPC , @EPOAGENTNWPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSOMEGAX1,@NSHLDNWPC , @NSHLDNWPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @TSOMEGAX1,@GSDOMINOPC , @GSDOMINOPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @TSOMEGAX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

end

----------------------------------------
-- @ServersX1
select @cnt1= count(*) from branchnode where nodename = @ServersX1
if @cnt1 > 0
begin

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVMAINX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVMAINX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVMAINX1
Execute dbo.AVITEST_RemoveSnowcapEntries @SRVMAINX1
Delete Leafnode where NodeName = @SRVMAINX1
EXECUTE AVITEST_addleaf_plus @SRVMAINX1, @ServersX1, @YYYYMMDD, 0, 'Windows 2000', 'srv', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @SRVMAINX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', '','AddCompPolicy'
EXECUTE AVITEST_addProdProp @SRVMAINX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', @exDat, @ServicePack1, @Patch1, '', '','AddCompPolicy',@BFDAT1
EXECUTE AVITEST_addProdProp @SRVMAINX1,@PATCHSCANPC, @PATCHSCANPV, 0, '', '', '0409', '', '', '', '', '','AddCompPolicy'
--EXECUTE AVITEST_addProdProp @SRVMAINX1,@VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

--		SELECT  @ruleUpdate = CAST(PolicySettings.Value AS DATETIME)
--		FROM 	{ oj Policy INNER JOIN PolicySettings
--		ON	Policy.AutoID = PolicySettings.ParentID}
--		WHERE 	SettingName = 'LastModified' 
--		AND	Policy.ProductCode = 'PATCH___1100'
--		AND 	Policy.ParentID = @directoryID
--		AND	Policy.ParentType > 2

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVSATELLITEX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVSATELLITEX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @SRVSATELLITEX1
Execute dbo.AVITEST_RemoveSnowcapEntries @SRVSATELLITEX1
Delete Leafnode where NodeName = @SRVSATELLITEX1
EXECUTE AVITEST_addleaf_plus @SRVSATELLITEX1, @ServersX1, @YYYYMMDD, 0, 'Windows 2000', 'srv', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @SRVSATELLITEX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @SRVSATELLITEX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', @ServicePack2, '', '', '','AddBranchPolicy',@BFDAT2
--EXECUTE AVITEST_addProdProp @SRVSATELLITEX1,@VIRUSCANPC, '7.1.0.1234.srv', 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @SRVSATELLITEX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

end

---------------------------------------
-- @WorkstationsX1

select @cnt1= count(*) from branchnode where nodename = @WorkstationsX1
if @cnt1 > 0
begin

-- Old DAT ENG
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSSHULLX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSSHULLX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSSHULLX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSSHULLX1
Delete Leafnode where NodeName = @WSSHULLX1
EXECUTE AVITEST_addleaf_plus @WSSHULLX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSSHULLX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSSHULLX1,@VIRUSCANPC, @VIRUSCANPVOLD, 0, @Eng2, @Dat2, '0409', '', '', '', '', '', '', @BFDAT3
--EXECUTE AVITEST_addProdProp @WSSHULLX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

-- Old PV AV
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSBGAYLESX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSBGAYLESX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSBGAYLESX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSBGAYLESX1
Delete Leafnode where NodeName = @WSBGAYLESX1
EXECUTE AVITEST_addleaf_plus @WSBGAYLESX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSBGAYLESX1,@EPOAGENTPC, @EPOAGENTPVOLD, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSBGAYLESX1,@VIRUSCANPC, '7.1.0', 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSBGAYLESX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSGJOHNSONX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSGJOHNSONX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSGJOHNSONX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSGJOHNSONX1
Delete Leafnode where NodeName = @WSGJOHNSONX1
EXECUTE AVITEST_addleaf_plus @WSGJOHNSONX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastMonth
EXECUTE AVITEST_addProdProp @WSGJOHNSONX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSGJOHNSONX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', @Patch2, '', '', '', @BFDAT3
--EXECUTE AVITEST_addProdProp @WSGJOHNSONX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSPPETTERSONX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSPPETTERSONX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSPPETTERSONX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSPPETTERSONX1
Delete Leafnode where NodeName = @WSPPETTERSONX1
EXECUTE AVITEST_addleaf_plus @WSPPETTERSONX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @Today
EXECUTE AVITEST_addProdProp @WSPPETTERSONX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSPPETTERSONX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '', @BFDAT2
--EXECUTE AVITEST_addProdProp @WSPPETTERSONX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLBINSX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLBINSX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLBINSX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSLBINSX1
Delete Leafnode where NodeName = @WSLBINSX1
EXECUTE AVITEST_addleaf_plus @WSLBINSX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastWeek
EXECUTE AVITEST_addProdProp @WSLBINSX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSLBINSX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '',@BFDAT2
--EXECUTE AVITEST_addProdProp @WSLBINSX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLCHANGX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLCHANGX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSLCHANGX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSLCHANGX1
Delete Leafnode where NodeName = @WSLCHANGX1
EXECUTE AVITEST_addleaf_plus @WSLCHANGX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSLCHANGX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSLCHANGX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '',@BFDAT3
--EXECUTE AVITEST_addProdProp @WSLCHANGX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSDPERSONX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSDPERSONX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSDPERSONX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSDPERSONX1
Delete Leafnode where NodeName = @WSDPERSONX1
EXECUTE AVITEST_addleaf_plus @WSDPERSONX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSDPERSONX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSDPERSONX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '',@BFDAT1
--EXECUTE AVITEST_addProdProp @WSDPERSONX1,@VIRUSCANPC, '7.1.0.1234.wrk', 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSDPERSONX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSJWILLIAMX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSJWILLIAMX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSJWILLIAMX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSJWILLIAMX1
Delete Leafnode where NodeName = @WSJWILLIAMX1
EXECUTE AVITEST_addleaf_plus @WSJWILLIAMX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 98', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSJWILLIAMX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSJWILLIAMX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSJWILLIAMX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''


Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSTMATTHEWSX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSTMATTHEWSX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSTMATTHEWSX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSTMATTHEWSX1
Delete Leafnode where NodeName = @WSTMATTHEWSX1
EXECUTE AVITEST_addleaf_plus @WSTMATTHEWSX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSTMATTHEWSX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSTMATTHEWSX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '',@BFDAT3
--EXECUTE AVITEST_addProdProp @WSTMATTHEWSX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng2, @Dat2, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMOLSENX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMOLSENX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMOLSENX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSMOLSENX1
Delete Leafnode where NodeName = @WSMOLSENX1
EXECUTE AVITEST_addleaf_plus @WSMOLSENX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSMOLSENX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSMOLSENX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', '', '',@BFDAT2
--EXECUTE AVITEST_addProdProp @WSMOLSENX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMHILANDX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMHILANDX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSMHILANDX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSMHILANDX1
Delete Leafnode where NodeName = @WSMHILANDX1
EXECUTE AVITEST_addleaf_plus @WSMHILANDX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSMHILANDX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSMHILANDX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSMHILANDX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSCYANGX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSCYANGX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSCYANGX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSCYANGX1
Delete Leafnode where NodeName = @WSCYANGX1
EXECUTE AVITEST_addleaf_plus @WSCYANGX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSCYANGX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @WSCYANGX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

-- unprotected
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSUNPROTECTEDX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSUNPROTECTEDX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSUNPROTECTEDX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSUNPROTECTEDX1
Delete Leafnode where NodeName = @WSUNPROTECTEDX1
EXECUTE AVITEST_addleaf_plus @WSUNPROTECTEDX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @WSUNPROTECTEDX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSUNPROTECTEDX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @WSUNPROTECTEDX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

-- no agent
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSNOAGENTX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSNOAGENTX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @WSNOAGENTX1
Execute dbo.AVITEST_RemoveSnowcapEntries @WSNOAGENTX1
Delete Leafnode where NodeName = @WSNOAGENTX1
EXECUTE AVITEST_addleaf_plus @WSNOAGENTX1, @WorkstationsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter

end

----------------------------
-- laptops

select @cnt1= count(*) from branchnode where nodename = @LaptopsX1
if @cnt1 > 0
begin

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER1X1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER1X1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER1X1
Execute dbo.AVITEST_RemoveSnowcapEntries @LPLOANER1X1
Delete Leafnode where NodeName = @LPLOANER1X1
EXECUTE AVITEST_addleaf_plus @LPLOANER1X1, @LaptopsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastMonth
EXECUTE AVITEST_addProdProp @LPLOANER1X1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @LPLOANER1X1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @LPLOANER1X1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER2X1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER2X1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPLOANER2X1
Execute dbo.AVITEST_RemoveSnowcapEntries @LPLOANER2X1
Delete Leafnode where NodeName = @LPLOANER2X1
EXECUTE AVITEST_addleaf_plus @LPLOANER2X1, @LaptopsX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @LPLOANER2X1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @LPLOANER2X1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @LPLOANER2X1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPENICHOLSX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPENICHOLSX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPENICHOLSX1
Execute dbo.AVITEST_RemoveSnowcapEntries @LPENICHOLSX1
Delete Leafnode where NodeName = @LPENICHOLSX1
EXECUTE AVITEST_addleaf_plus @LPENICHOLSX1, @LaptopsX1, @YYYYMMDD, 0, 'Windows 98', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @LPENICHOLSX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @LPENICHOLSX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @LPENICHOLSX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

-- late
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPMPARTRIDGEX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPMPARTRIDGEX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPMPARTRIDGEX1
Execute dbo.AVITEST_RemoveSnowcapEntries @LPMPARTRIDGEX1
Delete Leafnode where NodeName = @LPMPARTRIDGEX1
EXECUTE AVITEST_addleaf_plus @LPMPARTRIDGEX1, @LaptopsX1, @Late, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @LPMPARTRIDGEX1,@EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @LPMPARTRIDGEX1,@VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @LPMPARTRIDGEX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

-- late
Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPGRAILX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPGRAILX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @LPGRAILX1
Execute dbo.AVITEST_RemoveSnowcapEntries @LPGRAILX1
Delete Leafnode where NodeName = @LPGRAILX1
EXECUTE AVITEST_addleaf_plus @LPGRAILX1, @LaptopsX1, @Late, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @LPGRAILX1, @EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @LPGRAILX1, @VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @LPGRAILX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

end

----------------------------
-- Home Users

select @cnt1= count(*) from branchnode where nodename = @HomeUsersX1
if @cnt1 > 0
begin

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMACAMPBELX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMACAMPBELX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMACAMPBELX1
Execute dbo.AVITEST_RemoveSnowcapEntries @HMACAMPBELX1
Delete Leafnode where NodeName = @HMACAMPBELX1
EXECUTE AVITEST_addleaf_plus @HMACAMPBELX1, @HomeUsersX1, @YYYYMMDD, 0, 'Windows 98', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @HMACAMPBELX1, @EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @HMACAMPBELX1, @VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @HMACAMPBELX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMBQUINNX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMBQUINNX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMBQUINNX1
Execute dbo.AVITEST_RemoveSnowcapEntries @HMBQUINNX1
Delete Leafnode where NodeName = @HMBQUINNX1
EXECUTE AVITEST_addleaf_plus @HMBQUINNX1, @HomeUsersX1, @YYYYMMDD, 0, 'Windows 98', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @HMBQUINNX1, @EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @HMBQUINNX1, @VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @HMBQUINNX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''

Delete Events from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMMEDUARDOX1
Delete EventDayResolution from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMMEDUARDOX1
Delete ProductEvents from leafnode where NodeID=LeafNode.AutoID and NodeName = @HMMEDUARDOX1
Execute dbo.AVITEST_RemoveSnowcapEntries @HMMEDUARDOX1
Delete Leafnode where NodeName = @HMMEDUARDOX1
EXECUTE AVITEST_addleaf_plus @HMMEDUARDOX1, @HomeUsersX1, @YYYYMMDD, 0, 'Windows 2000', 'wrk', 'MyDomain', @LastQuarter
EXECUTE AVITEST_addProdProp @HMMEDUARDOX1, @EPOAGENTPC, @EPOAGENTPV, 0, '', '', '0409', '', '', '', '', ''
EXECUTE AVITEST_addProdProp @HMMEDUARDOX1, @VIRUSCANPC, @VIRUSCANPV, 0, @Eng1, @Dat1, '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp @HMMEDUARDOX1, @VIRUSCANOLDOSPC, @VIRUSCANOLDOSPV, 0, @Eng2, @Dat1, '0409', '', '', '', '', ''

end

-----------------------------------
-----------------------------------


--------------------------------------------------------
--------------------------------------------------------
-- add infections




/* viruses
Backdoor W32/SQLSlammer.worm Klez W32/Gibe.b@MM X97M/Smack
VBS/Funtime IRC/W32/LovGate.c@M W32/Bugbear@MM orifice2k.svr
*/

/* 
Exploit-MIME.gen	W32/Klez.h@MM	W32/Lovsan.worm.a
W32/SqlSlammer.worm	W97M/Malissa@MM	W32/Nimda.gen@MM
VBS/LoveLetter@MM	W32/Magistr.a@MM	W32/MParty.a@MM
W32/CodeRed.a.worm	W32/Elkern.cav	W32/smash
VBS/Valentin@MM		W32/Sobig.a@MM	W32/Nachi.worm
*/

/*
@SRVMAINX1	@SRVSATELLITEX1
WS-SHULL	WS-BGAYLES	WS-GJOHNSON	WS-PPETTERSON	WS-LBINS
WS-LCHANG	WS-DPERSON	WS-JWILLIAM	WS-TMATTHEWS	WS-MOLSEN
LP-LOANER1	LP-LOANER2	LP-ENICHOLS	LP-MPARTRIDGE	LP-GRAIL
HM-ACAMPBEL	HM-BQUINN	HM-MEDUARDO 
*/


-- action codes: 50=cleaned, 52=deleted, 57=moved, 51=cleanerror

-- Add infections
-- EXECUTE dbo.AVITEST_addInfections VirusName, 
--	LeafNodeName, FileName, ActionID, EventDate
--	Above fields can repeat up to 5 times


-- infection hitting 1 computer & file, 5 different actions, based on dat date
EXECUTE dbo.AVITEST_addInfections
'W32/LovGate.c@M', 'Virus'
,@WSSHULLX1,'FreckyFile',@Cleaned,@LastWeek
,@WSGJOHNSONX1,'FreckyFile',@Cleaned,@LastWeek
,@WSDPERSONX1,'FreckyFile',@Cleaned,@LastWeek
,@WSBGAYLESX1,'c:\windows\system32\FreckyFile',@Cleaned,@LastWeek
,@WSTMATTHEWSX1,'c:\windows\system32\FreckyFile',@Cleaned, @LastWeek


EXECUTE dbo.AVITEST_addInfections
'W32/Klez@M', 'Virus'
,@WSDPERSONX1, 'KlezFile',@Moved, @LastMonth
,@WSSHULLX1, 'KlezFile',@Moved, @LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\KlezFile2',@Moved, @LastWeek
,@WSTMATTHEWSX1, 'c:\windows\system32\KlezFile2',@Moved, @LastQuarter
,@WSBGAYLESX1, 'c:\windows\system32\KlezFile2',@Moved, @2WeeksPast


/* viruses
Backdoor W32/SQLSlammer.worm Klez W32/Gibe.b@MM X97M/Smack
VBS/Funtime IRC/W32/LovGate.c@M W32/Bugbear@MM orifice2k.svr
*/

EXECUTE dbo.AVITEST_addInfections
'Backdoor', 'Virus'
,@SRVMAINX1, 'BackdoorFile', @Moved , @2WeeksPast
,@HMMEDUARDOX1, 'BackdoorFile',@Moved, @4WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\BackdoorFile',@Moved, @LastMonth
,@HMBQUINNX1, 'c:\windows\system32\BackdoorFile2',@Moved, @LastWeek
,@HMACAMPBELX1, 'c:\windows\system32\BackdoorFile',@Moved, @LastQuarter


--

EXECUTE dbo.AVITEST_addInfections
'W32/Gibe.b@MM', 'Virus'
,@HMACAMPBELX1, 'GibeFile',@Cleaned, @5WeeksPast
,@SRVMAINX1, 'GibeFile2',@Cleaned, @LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\GibeFile',@Cleaned, @LastMonth
,@HMACAMPBELX1, 'c:\winnt\system32\GibeFile2',@Cleaned, @LastWeek
,@HMMEDUARDOX1, 'c:\winnt\system32\GibeFile',@Cleaned, @2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'X97M/Smack', 'Virus'
,@SRVMAINX1, 'ShiverFile',@Moved, @3WeeksPast
,@SRVSATELLITEX1, 'ShiverFile',@Moved, @LastMonth
,@HMACAMPBELX1, 'c:\windows\system32\ShiverFile',@Moved, @Today
,@HMBQUINNX1, 'c:\windows\system32\ShiverFile2',@Moved, @LastWeek
,@HMMEDUARDOX1, 'c:\windows\system32\ShiverFile2',@Moved, @2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'VBS/Funtime', 'Virus'
,@LPLOANER2X1, 'Funtimefile',@Deleted, @2WeeksPast
,@LPMPARTRIDGEX1, 'Funtimefile',@Deleted, @LastMonth
,@LPLOANER2X1, 'Funtimefile',@Deleted, @5WeeksPast
,@LPENICHOLSX1, 'c:\windows\system32\Funtimefile',@Deleted, @LastWeek
,@LPLOANER1X1, 'c:\windows\system32\Funtimefile',@Deleted, @5WeeksPast


--
EXECUTE dbo.AVITEST_addInfections
'W32/Bugbear@MM', 'Virus'
,@LPMPARTRIDGEX1, 'BugbearFile',@Moved, @2WeeksPast
,@LPLOANER1X1, 'BugbearFile',@Moved, @LastMonth
,@LPENICHOLSX1, 'c:\windows\system32\BugbearFile',@Moved, @LastWeek
,@LPLOANER1X1, 'c:\windows\system32\BugbearFile',@Moved, @5WeeksPast
,@LPLOANER2X1, 'c:\windows\system32\BugbearFile',@Moved, @2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'orifice2k.svr', 'Virus'
,@LPGRAILX1, 'orificeFile',@Deleted, @3WeeksPast
,@LPLOANER1X1, 'orificeFile',@Deleted, @2WeeksPast
,@LPMPARTRIDGEX1, 'c:\windows\system32\orificeFile2',@Deleted, @2WeeksPast
,@LPENICHOLSX1, 'c:\windows\system32\orificeFile2',@Deleted, @LastWeek
,@LPLOANER2X1, 'c:\windows\system32\orificeFile2',@Deleted, @LastMonth


EXECUTE dbo.AVITEST_addInfections
'W32/Melissa@MM', 'Virus'
,@LPLOANER1X1, 'Melissafile',@Cleaned, @4WeeksPast
,@LPLOANER2X1, 'Melissafile2',@Cleaned, @2WeeksPast
,@LPENICHOLSX1, 'Melissafile',@Cleaned, @2WeeksPast
,@LPMPARTRIDGEX1, 'c:\windows\system32\Melissafile',@Cleaned, @LastWeek
,@LPGRAILX1, 'c:\windows\system32\Melissafile2',@Cleaned, @LastMonth



-- outbreak on one day

EXECUTE dbo.AVITEST_addInfections
'W32/Nachi.worm', 'Virus'
,@WSMOLSENX1, 'Outbreakfile',@Moved, @LastWeek
,@WSTMATTHEWSX1, 'Outbreakfile1',@Moved, @LastWeek
,@WSJWILLIAMX1, 'Outbreakfile',@Moved, @3WeeksPast
,@WSDPERSONX1, 'c:\windows\system32\Outbreakfile',@Moved, @3WeeksPast
,@WSLCHANGX1, 'c:\windows\system32\Outbreakfile',@Moved, @3WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/Nachi.worm', 'Virus'
,@WSLCHANGX1, 'OutbreakFile',@Moved, @3WeeksPast
,@WSJWILLIAMX1, 'OutbreakFile',@Moved, @3WeeksPast
,@WSTMATTHEWSX1, 'OutbreakFile',@Moved, @3WeeksPast
,@WSLCHANGX1, 'c:\windows\system32\OutbreakFile',@Moved, @3WeeksPast
,@WSDPERSONX1, 'c:\windows\system32\OutbreakFile',@Moved, @3WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/Nachi.worm', 'Virus'
,@WSLCHANGX1, 'OutbreakFile',@Moved, @3WeeksPast
,@WSDPERSONX1, 'OutbreakFile',@Moved, @3WeeksPast
,@WSJWILLIAMX1, 'c:\windows\system32\OutbreakFile2',@Moved, @3WeeksPast
,@WSDPERSONX1, 'c:\windows\system32\OutbreakFile2',@Moved, @3WeeksPast
,@WSTMATTHEWSX1, 'c:\windows\system32\OutbreakFile2',@Moved, @3WeeksPast


-- Virus hitting one computer multiple times on same day

EXECUTE dbo.AVITEST_addInfections
'W32/Sobig.a@MM', 'Virus'
,@SRVSATELLITEX1, 'FileJumperFile1',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'FileJumperFile2',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'FileJumperFile3',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile4',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile5',@Deleted, @2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/Sobig.a@MM', 'Virus'
,@SRVSATELLITEX1, 'FileJumperFile6',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'FileJumperFile7',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'FileJumperFile8',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile9',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile10',@Deleted, @2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/Sobig.a@MM', 'Virus'
,@SRVSATELLITEX1, 'FileJumperFile11',@Deleted,'10/15/2003'
,@SRVSATELLITEX1, 'FileJumperFile12',@Deleted, @LastMonth
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile13',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile14',@Deleted, @2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\FileJumperFile15',@Deleted, @2WeeksPast



-- infections hitting all computers over different days
EXECUTE dbo.AVITEST_addInfections
'W32/Magistr.a@M', 'Virus'
,@HMACAMPBELX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@HMBQUINNX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@HMMEDUARDOX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastMonth
,@SRVSATELLITEX1, 'c:\windows\system32\Melissa.exe', @Moved ,@LastQuarter


EXECUTE dbo.AVITEST_addInfections
'W32/Nimda.gen@MM', 'Virus'
,@LPLOANER1X1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@2WeeksPast
,@LPENICHOLSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@3WeeksPast
,@LPMPARTRIDGEX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@4WeeksPast
,@LPGRAILX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@5WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/Nimda.gen@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@Yesterday
,@WSDPERSONX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@Yesterday
,@WSJWILLIAMX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSTMATTHEWSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'W32/smash', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@Yesterday
,@WSTMATTHEWSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'VBS/Valentin@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Melissa.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek



-- deleted
EXECUTE dbo.AVITEST_addInfections
'Exploit-MIME.gen', 'Virus'
,@HMACAMPBELX1, 'c:\windows\system32\ExploitedFile', @Deleted ,@LastWeek
,@HMBQUINNX1, 'c:\windows\system32\ExploitedFile', @Deleted ,@LastWeek
,@HMMEDUARDOX1, 'c:\windows\system32\ExploitedFile', @Deleted ,@LastWeek
,@LPLOANER1X1, 'c:\windows\system32\ExploitedFile', @Deleted ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\ExploitedFile', @Deleted ,@LastWeek


-- moved
EXECUTE dbo.AVITEST_addInfections
'W32/Lovsan.worm.a', 'Virus'
,@LPLOANER1X1, 'c:\windows\system32\mine.sys', @Moved ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\mine.sys', @Moved ,@2WeeksPast
,@LPENICHOLSX1, 'c:\windows\system32\mine.sys', @Moved ,@LastWeek
,@LPMPARTRIDGEX1, 'c:\windows\system32\mine.sys', @Moved ,@LastWeek
,@LPGRAILX1, 'c:\windows\system32\mine.sys', @Moved ,@2WeeksPast


-- hits all @WorkstationsX1 repeatedly, action is moved
EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSJWILLIAMX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSTMATTHEWSX1, 'c:\windows\system32\Love.exe', @Cleanerror ,@LastQuarter
,@WSMOLSENX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSBGAYLESX1, 'c:\windows\system32\Love.exe', @Cleanerror ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Love.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


-- hits all @WorkstationsX1 repeatedly, action is moved
EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSTMATTHEWSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Love.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


-- hits all @WorkstationsX1 repeatedly, action is moved
EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSTMATTHEWSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSBGAYLESX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Love.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


-- hits all @WorkstationsX1 repeatedly, action is moved
EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSDPERSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSTMATTHEWSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastQuarter
,@WSMOLSENX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'VBS/LoveLetter@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Love.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Love.exe', @Cleaned ,@LastWeek


-- infections hitting home computers and some laptops
EXECUTE dbo.AVITEST_addInfections
'W32/MParty.a@MM', 'Virus'
,@HMACAMPBELX1, 'c:\windows\system32\PartFile', @Cleaned ,@LastWeek
,@HMBQUINNX1, 'c:\windows\system32\PartFile', @Cleaned ,@LastMonth
,@HMMEDUARDOX1, 'c:\windows\system32\PartFile', @Cleaned ,@LastWeek
,@LPLOANER1X1, 'c:\windows\system32\PartFile', @Cleaned ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\PartFile', @Cleaned ,@2WeeksPast


-- infections hitting all computers over different days
EXECUTE dbo.AVITEST_addInfections
'W97M/Malissa@MM', 'Virus'
,@HMACAMPBELX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@HMBQUINNX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@HMMEDUARDOX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastMonth
,@SRVSATELLITEX1, 'c:\windows\system32\Melissa.exe', @Moved ,@LastQuarter


EXECUTE dbo.AVITEST_addInfections
'W97M/Malissa@MM', 'Virus'
,@LPLOANER1X1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@2WeeksPast
,@LPENICHOLSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@3WeeksPast
,@LPMPARTRIDGEX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@4WeeksPast
,@LPGRAILX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@5WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W97M/Malissa@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSTMATTHEWSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'W97M/Malissa@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastMonth
,@WSPPETTERSONX1, 'c:\windows\system32\Melissa.exe', @Moved ,@LastQuarter
,@WSLBINSX1, 'c:\windows\system32\Melissa.exe', @Cleaned ,@LastWeek



-- infections hitting every computer once on the same day
EXECUTE dbo.AVITEST_addInfections
'W32/Klez.h@MM', 'Virus'
,@HMACAMPBELX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@HMBQUINNX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@HMMEDUARDOX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'W32/Klez.h@MM', 'Virus'
,@LPLOANER1X1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@LPLOANER2X1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@LPENICHOLSX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@LPMPARTRIDGEX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@LPGRAILX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'W32/Klez.h@MM', 'Virus'
,@WSLCHANGX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSDPERSONX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSJWILLIAMX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSTMATTHEWSX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSMOLSENX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek


EXECUTE dbo.AVITEST_addInfections
'W32/Klez.h@MM', 'Virus'
,@WSSHULLX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSGJOHNSONX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSPPETTERSONX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek
,@WSLBINSX1, 'c:\windows\system32\sys.com', @Moved ,@LastWeek


-- infections hitting one computer with different actions depending on dat
EXECUTE dbo.AVITEST_addInfections
'W32/CodeRed.a.worm', 'Trojan'
,@WSBGAYLESX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@WSBGAYLESX1, 'c:\windows\system32\deletefile', @Deleted ,@LastMonth
,@WSBGAYLESX1, 'c:\windows\system32\Movedfile', @Moved ,@LastQuarter


-- infection hitting one computer in 1 day - cleaned, different file each time
EXECUTE dbo.AVITEST_addInfections
'W32/Elkern.cav', 'Trojan'
,@WSSHULLX1, 'c:\windows\system32\InfectFile1', @Cleaned ,@LastWeek
,@WSSHULLX1, 'c:\windows\system32\InfectFile2', @Cleaned ,@LastWeek
,@WSSHULLX1, 'c:\windows\system32\InfectFile3', @Cleaned ,@LastWeek
,@WSSHULLX1, 'c:\windows\system32\InfectFile4', @Cleaned ,@LastWeek
,@WSSHULLX1, 'c:\windows\system32\InfectFile5', @Cleaned ,@LastWeek


-- server infections
-- infection hitting one computer in the node once on different dates - cleaned
EXECUTE dbo.AVITEST_addInfections
'W32/SQLSlammer.worm', 'Virus'
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@2WeeksPast


EXECUTE dbo.AVITEST_addInfections
'W32/SQLSlammer.worm', 'Virus'
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastQuarter

EXECUTE dbo.AVITEST_addInfections
'Uncategorized', 'Virus'
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', @Cleaned ,@LastQuarter



------------------------------------------------------------------------------
-- add a few non scanning events

EXECUTE AVITEST_addEvent @SRVMAINX1, 'VirusScan', 0, '', '', 0, '', 
		1034, '', '', 1, '', 0, @LastWeek
EXECUTE AVITEST_addEvent @SRVMAINX1, 'VirusScan', 0, '', '', 0, '', 
		1035, '', '', 1, '', 0, @LastWeek
EXECUTE AVITEST_addEvent @SRVSATELLITEX1, 'VirusScan', 0, '', '', 0, '', 
		1034, '', '', 1, '', 0, @LastWeek
EXECUTE AVITEST_addEvent @SRVSATELLITEX1, 'VirusScan', 0, '', '', 0, '', 
		1035, '', '', 1, '', 0, @LastWeek


----------------------------------------------------------------------
-- add some unwanted programs

-- virustype fields, lvirustype (int value)
--  Virus 	0
--  Trojan 	1
--  app_pua  UnwantedProgram 17
--  app_Adware 		13
--  app_Dialer 		15
--  app_PWCracker 	16
--  app_Remoteadmin 	14
--  app_Spyware 	12

EXECUTE dbo.AVITEST_addInfections
'Spyware Pgm', 'app_spyware'
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21025 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21025 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21025 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21025 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21025 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID


EXECUTE dbo.AVITEST_addInfections
'Adware Pgm', 'app_adware'
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID

EXECUTE dbo.AVITEST_addInfections
'Dialer Pgm', 'app_Dialer'
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID

EXECUTE dbo.AVITEST_addInfections
'PasswordCracker Pgm', 'app_PWCracker'
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21033 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21033 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21033 ,@2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21033 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID

EXECUTE dbo.AVITEST_addInfections
'RemoteAdmin Pgm', 'app_Remoteadmin'
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID

EXECUTE dbo.AVITEST_addInfections
'Unwanted Pgm', 'app_pua'
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastWeek
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@2WeeksPast
,@SRVSATELLITEX1, 'c:\windows\system32\cleanfile', 21027 ,@LastMonth
,@SRVMAINX1, 'c:\windows\system32\cleanfile', 21027 ,@LastQuarter
,1  -- This parm sets TVDEventID = ActionID


------------------------------------------------------------
-- Add some virus sources, epo3.5
execute dbo.AVITEST_addVirusSource
@SRVMAINX1, 'W32/SQLSlammer.worm', 'Virus', 'Filename1', @Cleaned, 'Source1', 1024, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User1', @SRVMAINX1

execute dbo.AVITEST_addVirusSource
@SRVMAINX1, 'W32/SQLSlammer.worm', 'Virus', 'Filename3', @Cleaned, 'Source1', 1024, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User1', @SRVSATELLITEX1

execute dbo.AVITEST_addVirusSource
@SRVSATELLITEX1, 'W32/SQLSlammer.worm', 'Virus', 'Filename2', @Cleaned, 'Source2', 1024, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User2', @SRVMAINX1


-----------------------------------------------------
-- add some buffer overflow events, epo3.5
execute dbo.AVITEST_addBufferOverflow
@SRVMAINX1, 'bo:stack', 'BufOvfl', 'g:\temp\bot.exe', 'Modname1', 'LoadLibA', 1093, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User1', @SRVMAINX1

execute dbo.AVITEST_addBufferOverflow
@SRVMAINX1, 'bo:heap', 'BufOvfl', 'g:\temp\mop.exe', 'Modname2', 'LoadLibB', 1093, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User1', @SRVSATELLITEX1

execute dbo.AVITEST_addBufferOverflow
@SRVSATELLITEX1, 'bo:stack', 'BufOvfl', 'g:\temp\bot.exe', 'Modname1', 'LoadLibA', 1093, 3,
'VirusScan 8.0', '4.0.60', '4.0.1.1111', 16,
'', '8.0', 'User2', @SRVMAINX1


------------------------------------------------------------------
-- add port and behavior blocking events

-- cleanup
delete Events_VSEBehaviourBlock where HostName = @SRVMAINX1
delete Events_VSEBehaviourBlock where HostName = @SRVSATELLITEX1

execute dbo.AVITEST_addEvents_VSEBehaviourBlock
@SRVMAINX1, 'Rule1', 'Process1', 1094, 'source1', 'filename1', 32, 'user1',
@SRVMAINX1, 'VirusScan', '8.0', 1094, 3

execute dbo.AVITEST_addEvents_VSEBehaviourBlock
@SRVMAINX1, 'Rule2', 'Process1', 1094, 'source1', 'filename1', 64, 'user1',
@SRVMAINX1, 'VirusScan', '8.0', 1094, 3

execute dbo.AVITEST_addEvents_VSEBehaviourBlock
@SRVSATELLITEX1, 'Rule2', 'Process2', 1095, 'source2', 'filename2', 16, 'user2',
@SRVSATELLITEX1, 'VirusScan', '8.0', 1095, 5

execute dbo.AVITEST_addEvents_VSEBehaviourBlock
@SRVMAINX1, 'Rule1', 'Process1', 1092, 'source1', 'filename1', 32, 'user1',
@SRVMAINX1, 'VirusScan', '8.0', 1092, 10





-- last thing make sure detections have a productname
-- should not be needed anymore
--Update events
--set ProductName = 'VirusScan'
--where virusname > ''
--go

--------------------------------------------------------
--------------------------------------------------------
-- Add update events
-- EXECUTE dbo.AVITEST_addUpdateEvents HostName, 
--	Type, Version, ErrorID, EventDateTime, AgentVersion, ProductCode, SiteName, InitiatorID, InitiatorType
--	Above fields can repeat up to 5 times

-- put update events only on computer 1 for now to save time

/*
@SRVMAINX1	@SRVSATELLITEX1
WS-SHULL	WS-BGAYLES	WS-GJOHNSON	WS-PPETTERSON	WS-LBINS
WS-LCHANG	WS-DPERSON	WS-JWILLIAM	WS-TMATTHEWS	WS-MOLSEN
LP-LOANER1	LP-LOANER2	LP-ENICHOLS	LP-MPARTRIDGE	LP-GRAIL
HM-ACAMPBEL	HM-BQUINN	HM-MEDUARDO 
*/

EXECUTE dbo.AVITEST_addUpdateEvents
@HMMEDUARDOX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@HMBQUINNX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@HMACAMPBELX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@LPGRAILX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@LPLOANER2X1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@LPENICHOLSX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@LPMPARTRIDGEX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@LPLOANER1X1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSMOLSENX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSTMATTHEWSX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSLCHANGX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSDPERSONX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSJWILLIAMX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSLBINSX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSPPETTERSONX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSGJOHNSONX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSBGAYLESX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@WSSHULLX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@SRVSATELLITEX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'


EXECUTE dbo.AVITEST_addUpdateEvents
@SRVMAINX1
,'DAT', @Dat1, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'DAT', @Dat2, 0, @LastWeek, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'DAT', @Dat3, 0, @2WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'
,'Engine', @ENG1, 0, @3WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename1', 'me', 'task'
,'Install', '7.1.0', 0, @5WeeksPast, '3.0', 'VIRUSCAN6500', 'sitename2', 'me', 'task'



-------------------------------------------------------------
--------------------------------
-- add some webshield events

Declare @WSSever varchar(50)
Set @WSSever = '%' + @SRVSATELLITEX1

delete events where hostname like @WSSever and tvdeventid in (1503,1506,4600,4650,4651)
delete eventdayresolution where hostname like @WSSever and tvdeventid in (1503,1506,4600,4650,4651)



EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/SQLSlammer.worm', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/SQLSlammer.worm', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer2'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/SQLSlammer.worm', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/SQLSlammer.worm', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/SQLSlammer.worm', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/Bugbear@MM', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/Bugbear@MM', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer2'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/Bugbear@MM', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'W32/Bugbear@MM', 1503, 'c:\docs\memo.doc', 50, 1, 'Worm',
0, @LastWeek, '2.5', 'User1', 'Computer1'


-- Content filters & Spam
-- Older versions of webshield stored this data in the events table

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer2'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Body', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Body', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email2', 'Computer1'


-- old spam

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer2'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Body', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Body', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

-- new spam

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'Recipient1', 4650, 'Message Header', 50, 1, 'source ip1',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'Recipient2', 4650, 'Message Body', 50, 1, 'source ip2',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

-- new spam stats

insert events 
	(TVDEventID, VirusName, EventDateTime, HostIPAddress, HostName)
	values (4651, 21, getdate(), '123', @SRVSATELLITEX1)

insert events 
	(TVDEventID, VirusName, EventDateTime, HostIPAddress, HostName)
	values (4651, 42, @LastWeek, '123', @SRVSATELLITEX1)

insert events 
	(TVDEventID, VirusName, EventDateTime, HostIPAddress, HostName)
	values (4651, 60, @LastMonth, '123', @SRVSATELLITEX1)

---------------------------------------------------
-- spam events in new separate table (events_spam)

--@NodeName @ProdName @EngineVer @DATVer @TVDEventID @TVDSeverity 
--@MinusDays @Date @User @Computer 
--@SpamRulesBroken @SpamScore @SpamRecipients @MessageSize @SourceIPAddress

delete Events_spam where HostName = @SRVSATELLITEX1

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @Today, 'MyUser', @SRVSATELLITEX1  
,'SpamRule1', '80', 'Recipient1', '1000', '123.45.6789'

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @LastWeek, 'MyUser', @SRVSATELLITEX1  
,'SpamRule1', '80', 'Recipient1', '1000', '123.45.6789'

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @Today, 'MyUser', @SRVSATELLITEX1  
,'SpamRule1', '80', 'Recipient2', '1000', '123.45.6789'

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @LastWeek, 'MyUser', @SRVSATELLITEX1  
,'SpamRule2', '80', 'Recipient1', '1000', '333.45.6789'

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @LastWeek, 'MyUser', @SRVSATELLITEX1  
,'SpamRule2', '80', 'Recipient2', '1000', '444.45.6789'

execute dbo.AVITEST_addEventSpam
@SRVSATELLITEX1, 'webshield', '123', '1234', 4650, 4
,0, @Today, 'MyUser', @SRVSATELLITEX1  
,'SpamRule1', '80', 'Recipient1', '1000', '333.45.6789'


---------------------------------------------------
-- spam statistic events (Events_Statistics)

--@NodeName @ProdName @TVDEventID @TVDSeverity @MinusDays @Date @User @Computer 
--@StatisticsCounter @StatisticsValue 

delete Events_Statistics where HostName = @SRVSATELLITEX1

execute dbo.AVITEST_addEventWebShieldStatistics
@SRVSATELLITEX1, 'webshield', 4651, 4, 0, @Today, 'MyUser', @SRVSATELLITEX1 
,'StatsCount1', 123 

execute dbo.AVITEST_addEventWebShieldStatistics
@SRVSATELLITEX1, 'webshield', 4651, 4, 0, @Today, 'MyUser', @SRVSATELLITEX1 
,'StatsCount2', 234 

execute dbo.AVITEST_addEventWebShieldStatistics
@SRVSATELLITEX1, 'webshield', 4651, 4, 0, @LastWeek, 'MyUser', @SRVSATELLITEX1 
,'StatsCount1', 345 


-----------------------------------------------------
-- webshield url
-- Older versions of webshield stored this data in the events table

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'BlockRule1', 4600, 'URL1', 50, 1, 'url',
0, @LastWeek, '2.5', 'Email2', 'Computer2'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'BlockRule2', 4600, 'URL1', 50, 1, 'url',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'BlockRule1', 4600, 'URL2', 50, 1, 'url',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'BlockRule2', 4600, 'URL2', 50, 1, 'url',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEvent
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'BlockRule2', 4600, 'URL2', 50, 1, 'url',
0, @LastWeek, '2.5', 'Email2', 'Computer1'


-- Content filters & Spam
-- Newer versions of webshield stored this data in their own events table

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Events_ContentFilter]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
begin

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer2'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Body', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Body', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Header', 50, 1, 'content-scanning',
0, @LastWeek, '2.5', 'Email2', 'Computer1'


EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer2'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1', 
1, '4.1.40', '4.0.4133',
0, 'ContentRule1', 1506, 'Message Body', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Body', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email1', 'Computer1'

EXECUTE AVITEST_addEventContentFilter
@SRVSATELLITEX1, 'WebShield1',  
1, '4.1.40', '4.0.4133',
0, 'ContentRule2', 1506, 'Message Header', 50, 1, 'spam',
0, @LastWeek, '2.5', 'Email2', 'Computer1'

end


------------------------------------------------------
-- add some patch compliance data
Declare @Guid1 UNIQUEIDENTIFIER
Declare @Guid2 UNIQUEIDENTIFIER
Declare @Guid3 UNIQUEIDENTIFIER
Declare @Guid4 UNIQUEIDENTIFIER
Declare @Guid5 UNIQUEIDENTIFIER
Declare @Guid6 UNIQUEIDENTIFIER

Select @Guid1 = AgentGuid from leafnode where nodename = @SRVMAINX1
Select @Guid2 = AgentGuid from leafnode where nodename = @SRVSATELLITEX1
Select @Guid3 = AgentGuid from leafnode where nodename = @WSSHULLX1
Select @Guid4 = AgentGuid from leafnode where nodename = @WSBGAYLESX1
Select @Guid5 = AgentGuid from leafnode where nodename = @WSGJOHNSONX1
Select @Guid6 = AgentGuid from leafnode where nodename = @WSPPETTERSONX1


--@WSSHULLX1, @WSBGAYLESX1, @WSGJOHNSONX1, @WSPPETTERSONX1

-- cleanup
--delete Patch_RuleGroups from Patch_RuleViolations, Patch_Compliance where 
--Patch_RuleGroups.autoid = Patch_RuleViolations.groupid 
--and Patch_RuleViolations.machineid = Patch_Compliance.machineid
--and MachineName in (@SRVMAINX1, @SRVSATELLITEX1, @WSSHULLX1, @WSBGAYLESX1, @WSGJOHNSONX1, @WSPPETTERSONX1)
--Declare @PatchRuleGroupPathID int
--select @PatchRuleGroupPathID=min(autoid) from Patch_RuleGroups

delete Patch_RuleViolations from Patch_Compliance where 
Patch_RuleViolations.machineid = Patch_Compliance.machineid
and MachineName in (@SRVMAINX1, @SRVSATELLITEX1, @WSSHULLX1, @WSBGAYLESX1, @WSGJOHNSONX1, @WSPPETTERSONX1)

delete Patch_Compliance where MachineName in (@SRVMAINX1, @SRVSATELLITEX1, @WSSHULLX1, @WSBGAYLESX1, @WSGJOHNSONX1, @WSPPETTERSONX1)

/*
execute dbo.PATCHSCANSP_SetCompliance
@szHostName @iCompliant @dtEventTimeStr @dtEventLocalTimeStr @dtPolicyTimeStr
@guidAgent @iReboot
*/

--select @Guid1, @Guid2

execute dbo.PATCHSCANSP_SetCompliance
@SRVMAINX1, 1, @LastWeek, @LastWeek, '05/05/2005', @Guid1, 0

execute dbo.PATCHSCANSP_SetCompliance
@SRVSATELLITEX1, 0, @Today, @Today, '05/05/2005', @Guid2, 0

execute dbo.PATCHSCANSP_SetCompliance
@WSSHULLX1, 1, @LastWeek, @LastWeek, '05/05/2005', @Guid3, 0

execute dbo.PATCHSCANSP_SetCompliance
@WSBGAYLESX1, 1, @LastWeek, @LastWeek, '05/05/2005', @Guid4, 0

execute dbo.PATCHSCANSP_SetCompliance
@WSGJOHNSONX1, 1, @LastWeek, @LastWeek, '05/05/2005', @Guid5, 0

execute dbo.PATCHSCANSP_SetCompliance
@WSPPETTERSONX1, 1, @LastWeek, @LastWeek, '05/05/2005', @Guid6, 0


/*
execute dbo.PATCHSCANSP_InsertViolation
@szHostName, @iEventID, @szVersion, @szLocalIP, @szRuleDesc, @iRuleID, 
@dtEventTimeStr @dtEventLocalTimeStr, @iSeverity, @iRuleType, @iCompliant, 
@szGroupPath, @dtPolicyTimeStr, @guidAgent, @iReboot	
*/
Declare @GroupPath nvarchar(255)
Set @GroupPath = 'MS05-016 (Q893086)\Patch 3: Windows 2000 SP3 & SP4\Service Packs'

execute dbo.PATCHSCANSP_InsertViolation
@SRVMAINX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid1, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVMAINX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastWeek, 2, 1, 0,
@GroupPath, @LastWeek, @Guid1, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVMAINX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid1, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVMAINX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid1, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVMAINX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastMonth, 2, 1, 0,
@GroupPath, @LastMonth, @Guid1, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVSATELLITEX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid2, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVSATELLITEX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid2, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVSATELLITEX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 1, 1, 0,
@GroupPath, @2WeeksPast, @Guid2, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVSATELLITEX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 3, 1, 0,
@GroupPath, @2WeeksPast, @Guid2, 0

execute dbo.PATCHSCANSP_InsertViolation
@SRVSATELLITEX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid2, 0


execute dbo.PATCHSCANSP_InsertViolation
@WSSHULLX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid3, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSSHULLX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid3, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSSHULLX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 1, 1, 0,
@GroupPath, @2WeeksPast, @Guid3, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSSHULLX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 3, 1, 0,
@GroupPath, @2WeeksPast, @Guid3, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSSHULLX1, 13002, 'ver1', '123.45.6789', 'Detection Rule 1: Windows 2000 SP3', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid3, 0


execute dbo.PATCHSCANSP_InsertViolation
@WSBGAYLESX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid4, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSBGAYLESX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid4, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSBGAYLESX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 1, 1, 0,
@GroupPath, @2WeeksPast, @Guid4, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSBGAYLESX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 3, 1, 0,
@GroupPath, @2WeeksPast, @Guid4, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSBGAYLESX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid4, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSGJOHNSONX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid5, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSGJOHNSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid5, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSGJOHNSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 1, 1, 0,
@GroupPath, @2WeeksPast, @Guid5, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSGJOHNSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 3, 1, 0,
@GroupPath, @2WeeksPast, @Guid5, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSGJOHNSONX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid5, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSPPETTERSONX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastWeek, 1, 1, 0,
@GroupPath, @LastWeek, @Guid6, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSPPETTERSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 2, 1, 0,
@GroupPath, @2WeeksPast, @Guid6, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSPPETTERSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 1, 1, 0,
@GroupPath, @2WeeksPast, @Guid6, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSPPETTERSONX1, 13002, 'ver1', '123.45.6789', 'File version: Gdi32.dll', 1, 
@LastWeek, @2WeeksPast, 3, 1, 0,
@GroupPath, @2WeeksPast, @Guid6, 0

execute dbo.PATCHSCANSP_InsertViolation
@WSPPETTERSONX1, 13002, 'ver1', '123.45.6789', 'File existence: Ksecdd.sys', 1, 
@LastWeek, @LastMonth, 3, 1, 0,
@GroupPath, @LastMonth, @Guid6, 0

-- match Policysetting value to Patch_Compliance.PolicyTime table so report will show data

/*
//Syntax error converting datetime from character string.
Update
Patch_compliance
set PolicyTime = convert(datetime, value)
from policysettings, policy, leafnode
where
	Policy.AutoID = PolicySettings.ParentID
	and Policy.parentid = leafnode.autoid
	and leafnode.nodename in (@SRVMAINX1, @SRVSATELLITEX1, @WSSHULLX1, @WSBGAYLESX1, @WSGJOHNSONX1, @WSPPETTERSONX1)
*/



-------------------------------------------------
-- Set defaults for Last Server update and Next Server Update

--	Update ServerTask set NextRunTime = @NextServerUpdate
--	Where
--		ServerTask.TaskTypeCode = 'Mirror'
--		and ServerTask.ServerTaskName = 'DefaultServerUpdate'


	Insert ServerTaskLog
	(TheDate, ServerTaskID, ServerTaskName, ServerTaskTypeName, Status)
	Select	@YYYYMMDD
		,1 
		,'DefaultServerUpdate', 109, 2
	From ServerTask
	Where
		ServerTask.TaskTypeCode = 'Mirror'
		and ServerTask.ServerTaskName = 'DefaultServerUpdate'


--End
--Go

---------------------------
-- Add new producttype
-- dont include these for smb
--EXECUTE AVITEST_addProdProp 'TENRY','TREND9999', '1.0.123', 0, 't234', 't3456', '0409', '', '', '', '', ''
--EXECUTE AVITEST_addProdProp 'TENRY','FIREWALL9999', '2.0.999', 0, '', '', '0409', '', '', '', '', ''

-------------------------------
-- clear out ReportComplianceComparison

truncate table reportcompliancecomparison
--go

END
GO

-----