-- ePO3.0
-- Loads report metadata tables and lookup tables (non localized data tables)
-- ReportInputParameters
-- ReportUICustPages
-- ReportInputParameterValues
-- Virus Type data lookup tables


-- Report metadata
-- CREATE TABLE [dbo].[ReportUICustPages] (
--  [ReportID] [nvarchar] (64) NOT NULL
--  , [RptGroupID] [nvarchar] (20) NOT NULL
--  , [Name] [nvarchar] (64) NOT NULL				// Unique name for selection page
--								//  if = SaveSettings then save settings screen
--  , [TYpe] [nvarchar] (64) constraint TYpe default ''		// Corresponds to the selection page UI to use
--  , [Prompt] [nvarchar] (256) constraint Prompt default ''	// Page tab title
--  , [Desc] [nvarchar] (256) constraint Desc default ''	// Description at top of tab page
--  , [Storedproc] [nvarchar] (256) constraint Storedproc default '' // Data lookup stored procedure
--  , [WritebackStoredproc] [nvarchar] (256) constraint Storedproc default '' // Data writeback stored procedure, called when iSaveUserEntry is set
--  , [Dll] [nvarchar] (256) constraint Dll default ''		// Currently unused
--  , [iOptionalPage] [int] constraint iOptionalPage default 0	// 0 = InputTabs page always shown when run report
--							// 2 = InputsTabs page - SaveSettings
--							// >10 = CustTabs page shown when user requests customizations
-- ) ON [PRIMARY]


-- Report metadata
-- CREATE TABLE [dbo].[ReportInputParameters] (
--  [ReportID] [nvarchar] (64) NOT NULL
--  , [RptGroupID] [nvarchar] (20) NOT NULL
--  , [ReportSavedSettingsName] [nvarchar] (64) NULL	// Designated that this is a user's saved & named setting
--  , [ParmName] [nvarchar] (64) NOT NULL		// Unique name for report parameter
--  , [DBFldName] [nvarchar] (64) constraint DBFldName default ''	// Fieldname of value in database, used by server side selection filter.
--  , [ParmValue] [nvarchar] (256) constraint ParmValue default ''	// Report Data Value (Can be a data value, localized report text string)
--  , [Prompt] [nvarchar] (256) constraint Prompt default ''		// Localized Name for the field, filled by text string lookup
--  , [Desc] [nvarchar] (256) constraint Desc default ''		// Localized Description for the field, filled by text string loopup
--  , [CustPageName] [nvarchar] (256) constraint CustPageName default '' // Set if this input appears in one of the customization UI pages
--									 // key to ReportUICustPages.name
--  , [iType] [int] constraint iType default 0		// CustType: 0=all (numeric), 1=string, 2=fixed list etc, 
--							// InputParm Type: 4= datetime, 5= int, 6= save
--  , [iSaveUserEntry] [int] constraint iSaveUserEntry default 0 // =1 means save last entry as default
--								 //  must be =1 for all parms if using save settings screen
--  , [iDefaultFlag] [int] constraint iDefaultFlag default 0	// =1 means pass param value to crystal only as a default field value
--  , [iUseDefault] [int] constraint iUseDefault default 0	// =1 Use value as default that user can override
--  , [iCrystalParm] [int] constraint iCrystalParm default 1	// =1 means Crystal report input (default=1)
--  , [iCrystalFieldCust] [int] constraint iCrystalFieldCust default 0  // =1 means crystal customization field
--  , [iLocalizedField] [int] constraint iLocalizedField default 0	// =1 means, fetch 2 values from DB: Value & Localized PromptValue 
--							//  localized prompt value shown to user != nonlocalized value passed to report
--  , [iDBField] [int] constraint iDBField default 0	// =1 Internal stored procedure field
--					// or hidden crystal parameter that is set by other parameters
-- ) ON [PRIMARY]
-- END
--GO

-- Report metadata - Report Parameter Values

-- CREATE TABLE [dbo].[ReportInputParameterValues] (
--  [AutoID] [int] IDENTITY (1, 1) NOT NULL
--  , [ReportID] [nvarchar] (64) NOT NULL
--  , [RptGroupID] [nvarchar] (20) NOT NULL
--  , [ParmValue] [nvarchar] (256) constraint ParmValuer default ''	// Parm value passed to crystal 
--  , [Prompt] [nvarchar] (256) constraint Promptr default ''		// Optional: Parm value localized name that user sees
-- ) ON [PRIMARY]


----------------------------------------------------------------------
-- Make sure proper version of epo is loaded
-- This change must also be made in defaults.sql and sql-jobs.sql files
UPDATE ServerInfo SET ePOVersion='3.5.0'
GO


-- Note: Do not add indexes in this script since its run after the stored procedures are loaded
--	put before stored procedures get loaded so that they can be included in execution plan





-------------------------------------------------------------------------
-- japanese characters do not display in crystal charts so untranslate some
--	text strings: actions, virustypes, compliant/uncompliant

-- asian chars should now display in charts, so remove this code 


-------------------------------------------------------------------
-- Add any new eventids here

-- add new vs7.5 event if its not present
-- gets filled in by alerting procedures

--Begin
--Update EventFilter set EventID = '1093' where EventID = '1093'
--
--if @@rowcount = 0
--	INSERT EventFilter VALUES('1093',0x04000001,NULL,NULL)
--End
--GO   


----------------------------------
-- Upgrade maintenance section

truncate table ReportComputerSummary
GO

-- epo3.5: epo3.0 code can leave daat in leafnode.agentversion even when agent is deleted (trigger issue)
--	This is fixed in 3.5, this code does a cleanup
Update leafnode set agentversion = ''
	where autoid not in
	( select parentid from productproperties where productcode like 'epoagent%' )
GO
	
-------------------------------------------------------------------------
-- Move localization table to a smaller one using just the fields we need

Truncate table EventFilterDescFast
GO

Insert EventFilterDescFast
( EventID ,Name ,Language )
select
EventID, Name, Language
from EventFilterDesc
GO

-- set translated severity values
-- load english as default

Update 
EventFilterDescFast
Set Severity = 'Critical'
from EventFilter
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x08000001, 0x08000000)
GO

Update 
EventFilterDescFast
Set Severity = 'Major'
from EventFilter
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x04000001, 0x04000000)
GO

Update 
EventFilterDescFast
Set Severity = 'Minor'
from EventFilter
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x02000001, 0x02000000)
GO

Update 
EventFilterDescFast
Set Severity = 'Warning'
from EventFilter
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x01000001, 0x01000000)
GO

Update 
EventFilterDescFast
Set Severity = 'Informational'
from EventFilter
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x00000001, 0x00000000)
GO



Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from EventFilter, ReportTranslations
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x08000001, 0x08000000)
and EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Critical' 
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from EventFilter, ReportTranslations
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x04000001, 0x04000000)
and EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Major' 
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from EventFilter, ReportTranslations
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x02000001, 0x02000000)
and EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Minor' 
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from EventFilter, ReportTranslations
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x01000001, 0x01000000)
and EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Warning' 
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from EventFilter, ReportTranslations
Where
EventFilterDescFast.EventID = EventFilter.EventID
and EventFilter.Flag in (0x00000001, 0x00000000)
and EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Informational' 
GO

-- postepo3 - certain events are not in eventfilter yet, this means that they will
--		not be assigned a severity, which causes some reports to fails
--		assign the severity here
Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from ReportTranslations
Where
EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Informational' 
and EventFilterDescFast.EventID in (2401, 2411, 4651)
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from ReportTranslations
Where
EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Warning' 
and EventFilterDescFast.EventID in (4600, 4650)
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from ReportTranslations
Where
EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Major' 
and EventFilterDescFast.EventID in (1270,1271,1272,1273,1278,1279,1280,1281,1293,1297)
GO

Update 
EventFilterDescFast
Set Severity = ReportTranslations.TranslatedValue
from ReportTranslations
Where
EventFilterDescFast.Language = ReportTranslations.LanguageID
and ReportTranslations.Subject = 'Severity'
and ReportTranslations.TextID = 'Critical' 
and EventFilterDescFast.EventID in (1274,1275,1276,1277,1282,1283,1284,1285,1292,1294,1295,1296,1298,1299,1300,2232,2264,2328)
GO



-----------------------------------------------------------------------------
-- epo3.5 bugfix only
-- remove for next release after a localization drop is made
-- Unwanted action descriptions were added until after localization freeze
-- so fetch translated strings from other events
-- Fetch translated values

-- This section creates non english entries for all new eventids which have not been
-- localized yet (inserted after 3.5 ship)

CREATE TABLE [dbo].[UPActionNames] (
	[ActionName0409] [nvarchar] (128) NOT NULL, 
	[TranslatedActionName] [nvarchar] (128) NULL, 
	[TranslatedResolution] [nvarchar] (128) NULL, 
	[LanguageID] [nchar] (12) NULL,
	[LanguageSuffix] [nchar] (12) NULL )
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Access Denied', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '56' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Cleaned', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '50' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'ContinuedScan', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '2' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Moved', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '57' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Deleted', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '52' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Clean Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '51' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Delete Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '53' 
GO

INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Move Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '58' 
GO


INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Clean-Move Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '1277' 
GO


INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Clean-Delete Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '1283' 
GO


INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'No Cleaner', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '1286' 
GO


INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Move-Delete Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '1294' 
GO



INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix)
select 'Delete-Move Error', ActionName, Resolution, LanguageID, LanguageSuffix from ReportActionDesc 
where languageid != '0409' and actionid = '1298' 
GO

-- epo3.5 patch5 bz244796 add missing reportactiondesc entries and 
-- add an entry for warning: taken from ReportTranslations table
INSERT UPActionNames
(ActionName0409, TranslatedActionName, TranslatedResolution, LanguageID, LanguageSuffix) 
select 'Warning', TranslatedValue, '52', LanguageID, Right(LanguageID,2) 
from ReportTranslations 
where languageid != '0409' and subject = 'Severity' and TextID = 'Warning' 
GO

-- warning entry: translate resolution
update UPActionNames
set TranslatedResolution = Resolution
from ReportActionDesc
where 
UPActionNames.TranslatedResolution = ReportActionDesc.actionid
and UPActionNames.languageid = ReportActionDesc.languageid
and ReportActionDesc.languageid != '0409' and actionid = '52'



-----------------------------------------------------------------------
-- Create non englisg action entries for new eventids (after 3.5 ship)
-- English entries are added to 0409\PopulateEventFilterDesc.sql

-- 
DELETE ReportActionDesc 
where LanguageID != '0409'
and 
(ActionID in 
(21024, 21025, 21026, 21027, 21028,
21031, 21032, 21033, 21036, 21054, 21055, 21056, 21057,
21270, 21271, 21272, 21273, 21274, 21275, 21276, 21277, 21278, 21279,
21280, 21281, 21282, 21283, 21284, 21285, 21286, 21287, 21288, 21289,
21290, 21291, 21292, 21293, 21294, 21295, 21296, 21297, 21298, 21299, 21300,
21400, 21401, 21402, 21403, 21404, 21405, 21406, 21407, 21408, 21409,
21410, 21411, 21412, 21413,
-- epo3.5 patch5 bz244796 add missing reportactiondesc entries and 
1099, 70
) 
)
GO

 
INSERT ReportActionDesc 
(LanguageID, LanguageSuffix, ActionID,  ActionName, Resolution, ResolutionID)
Select 
UPActionNames.LanguageID, UPActionNames.LanguageSuffix, 
ReportActionDesc.ActionID,  
UPActionNames.TranslatedActionName, UPActionNames.TranslatedResolution, 
ReportActionDesc.ResolutionID
from ReportActionDesc, UPActionNames
where 
ReportActionDesc.actionname =  UPActionNames.actionname0409
and ReportActionDesc.LanguageID = '0409'
and 
(ActionID in 
(21024, 21025, 21026, 21027, 21028,
21031, 21032, 21033, 21036, 21054, 21055, 21056, 21057,
21270, 21271, 21272, 21273, 21274, 21275, 21276, 21277, 21278, 21279,
21280, 21281, 21282, 21283, 21284, 21285, 21286, 21287, 21288, 21289,
21290, 21291, 21292, 21293, 21294, 21295, 21296, 21297, 21298, 21299, 21300,
21400, 21401, 21402, 21403, 21404, 21405, 21406, 21407, 21408, 21409,
21410, 21411, 21412, 21413,
-- epo3.5 patch5 bz244796 add missing reportactiondesc entries and 
1099, 70
) 
)
GO 

-- end fix
-------------------------------------------

---------------------------------------------------------
--
-- drop this table later it may be needed below
--Drop Table UPActionNames
--Go 


-----
-- Populate ActionIntID field after data is loaded

Update ReportActionDesc
Set ActionIntID = ActionID
GO

------------------------------------------------------------------------
-- epo3.5 patch5 bz244796  
-- Add entries to this table whenever they are missing.
-- Check for new entries in EventFilterDesc and adds then to ReportActionDesc automatically
-- Protection code: catches missing data from point product teams

delete reportactiondesc
where ActionName = '---'
GO


-- new fields for reportactiondesc
if  not exists (select * from sysobjects, syscolumns
			where sysobjects.id = syscolumns.id 
			and sysobjects.id = object_id(N'[dbo].[reportactiondesc]')
			and COL_NAME ( object_id(N'[dbo].[reportactiondesc]') , syscolumns.colid ) = 'CategoryID'
			)
ALTER TABLE [dbo].[reportactiondesc]
ADD
	CategoryID INT NULL
	,SeverityID INT NULL
	,EventID INT NULL
go


insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0409' --LanguageID	
,'09' --LanguageSuffix	
,eventfilter.eventid --ActionID	
,eventfilter.eventid --ActionIntID	
,'---' --ActionName	
,'---' --Resolution	
,0 --ResolutionID	
,null --intLanguageID	
from eventfilterdesc, eventfilter, eventcategory
where 
eventfilter.eventcategory = eventcategory.eventcategoryid
and eventcategory.eventcategoryid in (8,9,11,14,15,33,34,37,38,39,40)
and eventfilterdesc.eventid = eventfilter.eventid
and eventfilterdesc.language='0409'
and eventfilter.eventid not in (select reportactiondesc.actionid from reportactiondesc)
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0407' ,'07' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'040a' ,'0a' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'040c' ,'0c' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0411' ,'11' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0404' ,'04' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0412' ,'12' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
GO

-- set other languages
insert reportactiondesc
(LanguageID, LanguageSuffix, ActionID,  ActionIntID, ActionName, Resolution, ResolutionID, intLanguageID)
select
'0804' ,'04' ,reportactiondesc.actionid ,reportactiondesc.actionid,'---','---',0,null --intLanguageID	
from reportactiondesc
where 
reportactiondesc.actionname='---' and languageid='0409'
go


-- populate new reportactiondesc fields
update reportactiondesc 
set reportactiondesc.CategoryID=eventfilter.EventCategory, reportactiondesc.eventid=eventfilter.eventid 
from eventfilter 
where reportactiondesc.actionid=eventfilter.eventid
go

update reportactiondesc  
set reportactiondesc.SeverityID=(eventfilter.flag / 0x00ffffff) 
from eventfilter
where reportactiondesc.actionid=eventfilter.eventid
go

update reportactiondesc set SeverityID=3 where SeverityID=4
go

update reportactiondesc set SeverityID=4 where SeverityID=8 or SeverityID is null
go



-- create temp table
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ResolutionActionMap')
DROP TABLE dbo.ResolutionActionMap 
GO 
 
-- create actionname translation table
CREATE TABLE [dbo].[ResolutionActionMap] (
	[ResolutionID] [int] NULL ,
	[ActionName] [nvarchar] (50) NULL ,
	[Resolution] [nvarchar] (50) NULL,
	[LanguageID] [nvarchar] (5) null
) 
GO

insert ResolutionActionMap
select resolutionid, actionname, resolution, languageid from reportactiondesc
where actionname not in ('blocked', 'warning', 'clean-delete error', 'continuedscan')
group by resolutionid, actionname, resolution, languageid
go


-- set actions and resolutions

-- unresolved actions
update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (14,33,37,38)
and 
(eventfilterdescfast.name like '%unable to clean%'
or eventfilterdescfast.name like '%clean error%'
or eventfilterdescfast.name like '%clean failure%'
)
and ResolutionActionMap.resolutionid = -1
GO

update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (14,33,37,38)
and 
(eventfilterdescfast.name like '%unable to delete%'
or eventfilterdescfast.name like '%delete error%'
or eventfilterdescfast.name like '%delete failure%'
)
and ResolutionActionMap.resolutionid = -2
GO

update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (14,33,37,38)
and 
(eventfilterdescfast.name like '%unable to move%'
or eventfilterdescfast.name like '%move error%'
or eventfilterdescfast.name like '%move failure%'
or eventfilterdescfast.name like '%quarantine error%'
or eventfilterdescfast.name like '%quarantine failure%'
or eventfilterdescfast.name like '%unable to quarantine%'
)
and ResolutionActionMap.resolutionid = -3
GO

update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (14,33,37,38)
and 
(eventfilterdescfast.name like '%access denied%'
)
and ResolutionActionMap.resolutionid = -6
GO

-- resolved actions
update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (15,34,39,40)
and eventfilterdescfast.name like '%cleaned%'
and ResolutionActionMap.resolutionid = 1
GO

update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (15,34,39,40)
and eventfilterdescfast.name like '%delete%'
and ResolutionActionMap.resolutionid = 2
GO

update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap, eventfilterdescfast
where reportactiondesc.actionname = '---' 
and eventfilterdescfast.eventid = reportactiondesc.eventid
and reportactiondesc.languageid=ResolutionActionMap.languageid
and reportactiondesc.categoryid in (15,34,39,40)
and 
(eventfilterdescfast.name like '%move%'
or eventfilterdescfast.name like '%quarantine%'
)
and ResolutionActionMap.resolutionid = 3
GO


-- default action: continued scan 
update reportactiondesc
set reportactiondesc.actionname=ResolutionActionMap.actionname, resolution=ResolutionActionMap.resolution, ResolutionID=ResolutionActionMap.resolutionid
from ResolutionActionMap
where reportactiondesc.actionname = '---' 
and reportactiondesc.languageid=ResolutionActionMap.languageid
--and reportactiondesc.categoryid in ()
and ResolutionActionMap.resolutionid = 5
GO

-- always do this at the end
Update ReportActionDesc
Set ActionIntID = ActionID
GO

drop table ResolutionActionMap
go

Drop Table UPActionNames
go 




-- end
-------------------------------------------------------------------------



-------------------------------------------------------------------------
-------------------------------------------------------------------------

TRUNCATE TABLE ReportInputParameters 
GO

TRUNCATE TABLE ReportUICustPages
GO

TRUNCATE TABLE ReportInputParameterValues
GO


---------------------------------------------------------

-- populate new field: leafnode.agentversion

update leafnode
set agentversion = productproperties.productversion
from productproperties, leafnode, aviview_software
where 
productproperties.parentid = leafnode.autoid
and productproperties.productcode = aviview_software.productcode
and aviview_software.productfamily = 'EPO'
and aviview_software.productcode like 'ePOAgent%'
GO

-- Make the import table able to handle more than one table
-- Default existing entries to Events
UPDATE AVI_AlertImport_History 
	SET szTableName = 'Events'
	Where szTableName is null
GO





---------------------------------------------------------------------------------------------------
-- Default inputs used for infection reports grouping on username, hostname, filename
--	fields that cannot be used in fast group summary mode
--	Flag a report to use these inputs by setting its report group to: 

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'',  'LIMIT'
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited and formatted'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'',  'LIMIT', ''
	, '@InfectAfterYYYYMMDD', '', '', ''
	, 'Event Date', 'Shows Events after this absolute date (This overrides the Event Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'',  'LIMIT', ''
	, '@InfectAfterRule', '', 'All', 'All Values'
	, 'Event Rule', 'Show Events after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'',  'LIMIT', ''
	, '@szDrilldown1', '', 'FAST', 'Fast Drilldown (no subreports)'
	, 'Layout', 'Report layout: Drilldown with Subreports, Printable format (no drilldowns)'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT', '@szDrilldown1', 'FAST', 'Fast Drilldown (no subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT', '@szDrilldown1', 'DRILLDOWN', 'Drilldown (show subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@szDrilldown1', 'PRINTABLE', 'No Drilldowns (print all details)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'CurrentMonth', 'Current Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT', '@InfectAfterRule', 'CurrentQuarter', 'Current Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'CurrentYear', 'Current Year'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'day1', 'Days Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'day2', 'Days Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'day3', 'Days Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'day4', 'Days Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',   '@InfectAfterRule', 'week1', 'Week Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',   '@InfectAfterRule', 'week2', 'Weeks Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'week3', 'Weeks Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'week4', 'Weeks Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'month1', 'Month Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'month2', 'Months Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'month3', 'Months Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'',  'LIMIT',  '@InfectAfterRule', 'year1', 'Years Past 1'
)
GO




---------------------------------------------------------------------------------------------------
-- Infection Event User Group Report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'INFECTGROUP', ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'INFECTGROUP', ''
	, 'Layout', 'Parameters'
	, 'Layout', 'Select the chart and drilldown layout options for this report'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'INFECTGROUP', ''
	, 'UserGroups', 'Parameters'
	, 'Data Groupings', 'Select the data fields for which summarized group totals will be returned. The report will allow drilling down through the group summaries to the details page. One to four groups can be selected.'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'INFECTGROUP', ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited (Date or Type categories)'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO


--------------------------
-- Event User Group Report
-- ReportInputParameters table

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, 'ChartType', '', 'Bar', 'Bar Chart'
	, 'Chart Type', 'Enter the Type of Chart To Display'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@szDrilldown1', '', 'FAST', 'Fast Drilldown (no subreports)'
	, 'Layout', 'Report layout: Fast Fetch with Drilldowns/No subreports, Drilldown with Subreports, Printable format (no drilldowns)'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO



INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@szGroupName1', '', 'Month', 'Month'
	, 'First Group', 'Enter the First Group Name (Must have at least one)'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@szGroupName2', '', 'VirusName', 'Virus Name'
	, 'Second Group', 'Enter the Second Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@szGroupName3', '', 'FullProductName', 'ProductVersion'
	, 'Third Group', 'Enter the Third Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@szGroupName4', '', '', ''
	, 'Fourth Group', 'Enter the Fourth Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@InfectAfterYYYYMMDD', '', '', ''
	, 'Event Date', 'Shows Events after this absolute date (This overrides the Event Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@InfectAfterRule', '', 'All', 'All Values'
	, 'Event Rule', 'Show Events after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, '@EventType', '', 'Infection', 'Infection'
	, 'Event Type', 'Type of Event to display: Infections, Non Infections, All'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'INFECTGROUP', '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO


----------------------------------------------------------------
-- Event User Group Report
-- ReportInputParameterValues table

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP', '', 'ChartType', 'Bar', 'Bar Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', 'ChartType', 'Pie', 'Pie Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', 'ChartType', 'Sbar', 'Stacked Bar Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', 'ChartType', 'Line', 'Line Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'INFECTGROUP',  '', 'ChartType', 'PieBar', 'Pie & Bar Chart'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', 'ChartType', '3D Bar', '3D Bar Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'INFECTGROUP',  '', 'ChartType', 'CrossTab', 'CrossTab Table'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', ' ', '...'	-- generates an empty field, parmvalue must be 1 space
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Year', 'Year'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Quarter', 'Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Month', 'Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Week', 'Week'
)
GO

-- vs7.5: change name to detection
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Virusname', 'Detection'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'Action', 'Action'
)
GO


--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'INFECTGROUP',  '', '@szGroupName_', 'Filename', 'File Name'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'INFECTGROUP',  '', '@szGroupName_', 'Hostname', 'Host Name'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '',  '@szGroupName_', 'NodeName', 'Directory'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '',  '@szGroupName_', 'DomainName', 'Domain Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '',  '@szGroupName_', 'OSType', 'OS Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '',  '@szGroupName_', 'OSPlatform', 'OS Platform'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'FullProductName', 'Product Version'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'EngineDAT', 'Engine DAT Versions'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'INFECTGROUP',  '', '@szGroupName_', 'TVDEventID', 'Event ID'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'TVDSeverity', 'Severity'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'TVDTaskName', 'Task Name'
)
GO

-- vs7.5: change name to type (detection type)
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'VirusType', 'Type'
)
GO

-- vs7.5: field can be used for eventdesc or source
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'EventDesc', 'Source / Event Description'
)
GO

-- new entry for vs7.5 (EventDesc used twice, event type determines which field is returned)
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szGroupName_', 'EventDesc', 'DetectionSource'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szDrilldown1', 'FAST', 'Fast Drilldown (no subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szDrilldown1', 'DRILLDOWN', 'Drilldown (show subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@szDrilldown1', 'PRINTABLE', 'No Drilldowns (print all details)'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'CurrentMonth', 'Current Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'CurrentQuarter', 'Current Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'CurrentYear', 'Current Year'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'day1', 'Days Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'day2', 'Days Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'day3', 'Days Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'day4', 'Days Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'week1', 'Week Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'week2', 'Weeks Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'week3', 'Weeks Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'week4', 'Weeks Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'month1', 'Month Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'month2', 'Months Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'month3', 'Months Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@InfectAfterRule', 'year1', 'Years Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Infection', 'Infection'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'NotInfection', 'Non Infection'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'All', 'All'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Infection-Cle', 'Infections Cleaned'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Infection-Del', 'Infections Deleted'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Infection-Mov', 'Infections Moved'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Infection-Unr', 'Infections Unresolved'
)
GO

-- vs7.5 

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'Programs', 'Unwanted Programs'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'INFECTGROUP',  '', '@EventType', 'BufrOvfl', 'Buffer Overflow'
)
GO


---------------
-- vs7.5 New buffer overflow dat report
-----------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------
-- DAT/Eng report
-- ReportUICustPages table

DELETE ReportUICustPages 
	WHERE ReportID = 'BFDAT'
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'BFDAT', ''
	, 'TVDszBufferOverflowDAT', 'Parameters'	--'DATEngine'
	, 'McAfee', 'Enter Top 5 Buffer Overflow DAT/Definition (DAT) versions, by default the most recent values are loaded'
	, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO


------------------------------
-- BFDAT report parms
-- ReportInputParameters table

DELETE ReportInputParameters 
	WHERE ReportID = 'BFDAT'
GO

--BFDAT
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'BFDAT', '', ''
	, 'TVDszBufferOverflowDAT1', '', '', ''
	, '(DAT) - 1', 'Enter minimum compliant version'
	, 'TVDszBufferOverflowDAT'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'BFDAT', '', ''
	, 'TVDszBufferOverflowDAT2', '', '', ''
	, '(DAT) - 2', 'Enter minimum compliant version'
	, 'TVDszBufferOverflowDAT'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'BFDAT', '', ''
	, 'TVDszBufferOverflowDAT3', '', '', ''
	, '(DAT) - 3', 'Enter minimum compliant version'
	, 'TVDszBufferOverflowDAT'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO





---------------------------------------------------------------------------------------------------
-- Product Update Event User Group Report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUPDATEGROUP', ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUPDATEGROUP', ''
	, 'Layout', 'Parameters'
	, 'Layout', 'Select the chart and drilldown layout options for this report'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUPDATEGROUP', ''
	, 'UserGroups', 'Parameters'
	, 'Data Groupings', 'Select the data fields for which summarized group totals will be returned. The report will allow drilling down through the group summaries to the details page. One to four groups can be selected.'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUPDATEGROUP', ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited (Date or Type categories)'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO



--------------------------
-- Product Update User Group Report
-- ReportInputParameters table

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, 'ChartType', '', 'Sbar', 'Stacked Bar Chart'
	, 'Chart Type', 'Enter the Type of Chart To Display'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@szDrilldown1', '', 'FAST', 'Fast Drilldown (no subreports)'
	, 'Layout', 'Report layout: Fast Fetch with Drilldowns/No subreports, Drilldown with Subreports, Printable format (no drilldowns)'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@szGroupName1', '', 'SiteName', ''
	, 'First Group', 'Enter the First Group Name (Must have at least one)'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@szGroupName2', '', 'Type', ''
	, 'Second Group', 'Enter the Second Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@szGroupName3', '', 'InitiatorType', ''
	, 'Third Group', 'Enter the Third Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@szGroupName4', '', '', ''
	, 'Fourth Group', 'Enter the Fourth Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@AfterYYYYMMDD', '', '', ''
	, 'Product Upgrade Date', 'Shows Product Upgrades occurring after this absolute date (This overrides the Product Upgrade Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, '@AfterRule', '', 'All', ''
	, 'Product Upgrade Rule', 'Show Product Upgrades occurring after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUPDATEGROUP', '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO


----------------------------------------------------------------
-- Product Update User Group Report
-- ReportInputParameterValues table

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', 'ChartType', 'Bar', 'Bar Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', 'ChartType', 'Pie', 'Pie Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', 'ChartType', 'Sbar', 'Stacked Bar Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', 'ChartType', 'Line', 'Line Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUPDATEGROUP', '', 'ChartType', 'PieBar', 'Pie & Bar Chart'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', 'ChartType', '3D Bar', '3D Bar Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUPDATEGROUP', '', 'ChartType', 'CrossTab', 'CrossTab Table'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt	
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', ' ', '...'		-- generates an empty field, parmvalue must be 1 space
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Year', 'Year'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Quarter', 'Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Month', 'Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Week', 'Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Productname', 'Product Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'ProductVersion', 'Product Version'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Type', 'Update Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Version', 'Update Version'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Error', 'Update Error'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'Sitename', 'Repository Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'InitiatorID', 'Initiator'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'InitiatorType', 'Initiator Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '',  '@szGroupName_', 'nodename', 'Directory'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '',  '@szGroupName_', 'DomainName', 'Domain Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '',  '@szGroupName_', 'OSType', 'OS Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '',  '@szGroupName_', 'OSPlatform', 'OS Platform'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szGroupName_', 'FullProductName', 'Product Version'
)
GO



-- layout
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szDrilldown1', 'FAST', 'Fast Drilldown (no subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szDrilldown1', 'DRILLDOWN', 'Drilldown (show subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@szDrilldown1', 'PRINTABLE', 'No Drilldowns (print all details)'
)
GO


-- timerule
INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'CurrentMonth', 'Current Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'CurrentQuarter', 'Current Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'CurrentYear', 'Current Year'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'day1', 'Days Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'day2', 'Days Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'day3', 'Days Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'day4', 'Days Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'week1', 'Week Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'week2', 'Weeks Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'week3', 'Weeks Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'week4', 'Weeks Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'month1', 'Month Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'month2', 'Months Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'month3', 'Months Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUPDATEGROUP', '', '@AfterRule', 'year1', 'Years Past 1'
)
GO



---------------------------------------------------------------------------------------------------
-- Product User Group Report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUCTGROUP', ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUCTGROUP', ''
	, 'Layout', 'Parameters'
	, 'Layout', 'Select the chart and drilldown layout options for this report'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUCTGROUP', ''
	, 'UserGroups', 'Parameters'
	, 'Data Groupings', 'Select the data fields for which summarized group totals will be returned. The report will allow drilling down through the group summaries to the details page. One to four groups can be selected.'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'PRODUCTGROUP', ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited (Date or Type categories)'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO


--------------------------
-- Event User Group Report
-- ReportInputParameters table

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, 'ChartType', '', 'Sbar', 'Stacked Bar Chart'
	, 'Chart Type', 'Enter the Type of Chart To Display'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

--  chart type determines this 
--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'PRODUCTGROUP', '', ''
--	, 'NumGroupsOnMainPage', '', '1', ''
--	, 'Number of Groups on Main Page', 'Enter the number of Groups to display on the main page (1 or 2)'
--	, 'Layout'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,0 ,1
--)
--GO



INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@szDrilldown1', '', 'FAST', 'Fast Drilldown (no subreports)'
	, 'Layout', 'Report layout: Fast Fetch with Drilldowns/No subreports, Drilldown with Subreports, Printable format (no drilldowns)'
	, 'Layout'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@ConnectAfterYYYYMMDD', '', '', ''
	, 'Agent Connection Date', 'Shows Computers connecting after this absolute date (This overrides the Agent Connection Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@ConnectAfterRule', '', 'ALL', 'All Values'
	, 'Agent Connection Rule', 'Show Computers connecting after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@ConnectType', '', 'CURRENT', 'Currently Conecting Computers'
	, 'Connection Status', 'Show Computers Based on Connection rule, shows only: Current, Late, All'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@ProductType', '', 'AntiVirus', 'AntiVirus'
	, 'Product Type', 'Show Products of the specified type: AntiVirus, Security, All, Agent Only'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@szGroupName1', '', 'ProductName', 'Product Name'
	, 'First Group', 'Enter the First Group Name (Must have at least one)'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@szGroupName2', '', 'ProductVersion', 'Product Version'
	, 'Second Group', 'Enter the Second Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@szGroupName3', '', '', ''
	, 'Third Group', 'Enter the Third Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, '@szGroupName4', '', '', ''
	, 'Fourth Group', 'Enter the Fourth Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'PRODUCTGROUP', '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO


----------------------------------------------------------------
-- Event User Group Report
-- ReportInputParameterValues table

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', 'ChartType', 'Bar', 'Bar Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', 'ChartType', 'Pie', 'Pie Chart'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', 'ChartType', 'Sbar', 'Stacked Bar Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', 'ChartType', 'PieBar', 'Pie & Bar Chart'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', 'ChartType', '3D Bar', '3D Bar Chart'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', 'ChartType', 'CrossTab', 'CrossTab Table'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', '@szGroupName_', 'Year', 'Year'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', '@szGroupName_', 'Quarter', 'Quarter'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', '@szGroupName_', 'Month', 'Month'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '', '@szGroupName_', 'Week', 'Week'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', ' ', '...'		-- generates an empty field, parmvalue must be 1 space
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'Day', 'Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'nodename', 'Directory'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'FullProductName', 'Full Product Version'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'EngineDAT', 'Engine & DAT Versions'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'ProductName', 'Product Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'ProductVersion', 'Product Version'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'EngineVersion', 'Engine Version'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szGroupName_', 'DATVersion', 'DAT Version'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'DatExtraDAT', 'DAT ExtraDAT'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '',  '@szGroupName_', 'Servicepack', 'Service Pack'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '',  '@szGroupName_', 'Hotfix', 'Hotfix'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '',  '@szGroupName_', 'LicenseStatus', 'License Status'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '',  '@szGroupName_', 'ExpirationDate', 'License Expiration'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'DomainName', 'Domain Name'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'OSVersion', 'OS Version'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'OSType', 'OS Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'OSPlatform', 'OS Platform'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'Language', 'Language'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'AgentVersion', 'AgentVersion'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'PRODUCTGROUP', '',  '@szGroupName_', 'Licensed', 'Agent Licensed'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'AgentType', 'Agent Type'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '',  '@szGroupName_', 'ConnectStatus', 'Connect Status'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szDrilldown1', 'FAST', 'Fast Drilldown (no subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szDrilldown1', 'DRILLDOWN', 'Drilldown (show subreports)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@szDrilldown1', 'PRINTABLE', 'No Drilldowns (print all details)'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'day1', '1 Day Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'day2', '2 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'day3', '3 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'day4', '4 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectAfterRule', 'week1', '1 Week Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectType', 'ALL', 'Show All Computers'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectType', 'CURRENT', 'Show Currently connecting Computers only'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ConnectType', 'LATE', 'Show Late Computers only'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ProductType', 'AntiVirus', 'AntiVirus'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ProductType', 'Security', 'Security - Not AntiVirus'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ProductType', 'All', 'All - AntiVirus and Security'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'PRODUCTGROUP', '', '@ProductType', 'Agent', 'Agent Only'
)
GO


---------------------------------------------------------------------------------------------------
-- ASCI input dialog


INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'ASCI', ''
	, 'Within', 'Parameters'
	, 'Within', 'Define a Late Connection'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO


--------------------------
-- ASCI report dialog



INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ASCI', '', ''
	, '@ConnectAfterYYYYMMDD', '', '', ''
	, 'Agent Connection Date', 'Shows Computers connecting after this absolute date (This overrides the Agent Connection Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ASCI', '', ''
	, '@ConnectAfterRule', '', 'day1', '1 Day Past'
	, 'Agent Connection Rule', 'Show Computers connecting after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


----------------------------------------------------------------
-- ASCI




INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'day1', '1 Day Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'day2', '2 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'day3', '3 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'day4', '4 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'ASCI', '', '@ConnectAfterRule', 'week1', '1 Week Past'
)
GO



---------------------------------------------------------------------------------------------------------
-- Compliance Issues Report
-- ReportUICustPages table


INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'COMPLIANCEISSUES',  ''
	, 'ProductVersions', 'Parameters'
	, 'Product Version Rules', 'Define compliance rules for product versions, use other tabs to define engine and DAT/Definition compliance rules and limit the data returned by the server.'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'COMPLIANCEISSUES',  ''
--	, 'Engines', 'Parameters'
--	, 'Engines', ''
--	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
--	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
--)
--GO

--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'COMPLIANCEISSUES',  ''
--	, 'DATs', 'Parameters'
--	, 'Definitions\DATs', ''
--	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
--	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
--)
--GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'COMPLIANCEISSUES',  ''
	, 'EngineDATs', 'Parameters'
	, 'Engines\DAT Rules', 'Define compliance rules for engine and DAT/definitions'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'COMPLIANCEISSUES',  ''
	, 'ComplianceRules', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'COMPLIANCEISSUES',  ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO

--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'COMPLIANCEISSUES',  ''
--	, 'Actions', 'Parameters'
--	, 'Actions', ''
--	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
--	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 0 
--)
--GO

------------------------------
-- Compliance issues
-- ReportInputParameters table


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, '@AsciCheckPoint', '', '', ''
	, 'Late Agent Connection Date', 'A Late Computer is one whose last connection is before this absolute date (This overrides the Late Agent Connection Rule parameter)'
	, 'ComplianceRules'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO



INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, '@AsciRule', '', 'ALL', 'All Values'
	, 'Late Agent Connection Rule', 'A Late Computer is one whose last connection is before this relative date rule'
	, 'ComplianceRules'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, '@InfectionCheckPoint', '', '', ''
	, 'Recent Infection Date', 'Defines Recent Infections as ocurring after this absolute date (This overrides the Recent Infection Rule parameter)'
	, 'ComplianceRules'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

-- postepo3 33401 - change CI parm name to @ciInfectAfterRule, so its no longer a dup with CustGroup parmname
--	Also requires a similar change to all language specific localization string files.
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, '@ciInfectAfterRule', '', 'week4', '4 Weeks Past'
	, 'Recent Infection Rule', 'Defines Recent Infections as ocurring after this relative rule'
	, 'ComplianceRules'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCEISSUES',  '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,1 ,0
)
GO


--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', 'No Action'
--	, '@Action', '', '', ''
--	, 'Action', 'Define action for handling dead agents and duplicate computers'
--	, 'Actions'
--	, 0 ,1 ,0 ,0
--	, 0 ,0 ,0 ,0
--)
--GO

--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', 'Dead'
--	, '@DestFolder', '', '', ''
--	, 'Move Folder', 'Enter folder name where moved computers will be located (Applicable if Action=Move)'
--	, 'Actions'
--	, 0 ,1 ,0 ,0
--	, 0 ,0 ,0 ,0
--)
--GO

--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '7'
--	, '@StrNumDays', '', '', ''
--	, 'Dead after this many days', 'After this many days of no connections, the computers agent will be considered dead'
--	, 'Actions'
--	, 0 ,1 ,0 ,0
--	, 0 ,0 ,0 ,0
--)
--GO

-----------------------------------
-- Compliance Issues
-- ReportInputParameterValues table

-- remove these three values, functionality is broken and their is no time to fix

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@MinVersion%', '1st Most Recent Version', '1st Most Recent Version'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@MinVersion%', '2nd Most Recent Version', '2nd Most Recent Version'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@MinVersion%', '3rd Most Recent Version', '3rd Most Recent Version'
--)
--GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'day1', '1 Day Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'day2', '2 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'day3', '3 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'day4', '4 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@AsciRule', 'week1', '1 Week Past'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'ALL', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'day1', '1 Day Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'day2', '2 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'day3', '3 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'day4', '4 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'week1', '1 Week Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'week2', '2 Weeks Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'week3', '3 Weeks Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'COMPLIANCEISSUES',  '', '@ciInfectAfterRule', 'week4', '4 Weeks Past'
)
GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@Action', 'No Action', 'No Action Taken'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@Action', 'Delete', 'Delete'
--)
--GO

--INSERT ReportInputParameterValues
--( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
--)
--VALUES(
--	'COMPLIANCEISSUES',  '', '@Action', 'Remove', 'Move'
--)
--GO

-----------------------------------------------------------------------------------------
-- Compliance Summary
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'COMPLIANCE',  ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'COMPLIANCE',  '', ''
	, '@dtInfectionCheckPoint', '', ''
	, 'Recent Infection Date', 'Defines Recent Infections as ocurring after this absolute date'
	, 'Within'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO




-----------------------------------------------------------------------------------------
-- Compliance Summary
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'SECURITYSUMMARY',  ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SECURITYSUMMARY',  '', ''
	, '@dtInfectionCheckPoint', '', '', ''
	, 'Recent Infection Date', 'Defines Recent Infections as ocurring after this absolute date'
	, 'Within'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

---------------------------------------------------------------------------------------------------------
-- Outbreak Report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'OUTBREAK',  ''
	, 'OutBreakDefn', 'Parameters'
	, 'Outbreak Rules', 'Define an outbreak as affecting a specified number of machines or files over a given time range'
	, '{CALL dbo.AVISP_FieldGetOutbreak (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutOutbreak (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'OUTBREAK',  ''
	, 'OutBreakStart', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited'
	, '{CALL dbo.AVISP_FieldGetOutbreak (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutOutbreak (?,?,?,?,?,?,?)}', 0 
)
GO


INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'OUTBREAK',  ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO


------------------------------
-- Outbreak
-- ReportInputParameters table


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, '@szMinMachineCount', '', '5', ''
	, 'Minimum Machines Infected', 'Minimum number of machines infected to be considered an outbreak (numeric value)'
	, 'OutBreakDefn'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, '@szMinFilenameCount', '', '5', ''
	, 'Minimum Files Infected', 'Minimum number of unique files infected to be considered an outbreak (numeric value)'
	, 'OutBreakDefn'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, '@szHourRange', '', '2', ''
	, 'Hour Range', 'Maximum number of hours over which infections occur to be considered an outbreak (numeric value)'
	, 'OutBreakDefn'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, '@dtStartDate', '', '', ''
	, 'Start Date', 'Starting date from which to look for outbreaks (Overrides Outbreak Start Date Rule)'
	, 'OutBreakStart'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, '@InfectAfterRule', '', 'week4', '4 weeks past'
	, 'Outbreak Start Date Rule', 'Show Outbreaks occurring after this rule'
	, 'OutBreakStart'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'OUTBREAK',  '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO



--------------------------

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'ALL', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'CurrentMonth', 'Current Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'CurrentQuarter', 'Current Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'CurrentYear', 'Current Year'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'day1', 'Days Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'day2', 'Days Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'day3', 'Days Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'day4', 'Days Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'week1', 'Week Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'week2', 'Weeks Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'week3', 'Weeks Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'week4', 'Weeks Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'month1', 'Month Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'month2', 'Months Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'month3', 'Months Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'OUTBREAK',  '', '@InfectAfterRule', 'year1', 'Years Past 1'
)
GO



---------------------------------------------------------------------------------------------------------
-- Outbreak History Report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'ATTACKS',  ''
	, 'OutBreakDefn', 'Parameters'
	, 'Outbreak Rules', 'Define an outbreak as affecting a specified number of machines or files (Time component will be displayed per week)'
	, '{CALL dbo.AVISP_FieldGetOutbreak (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutOutbreak (?,?,?,?,?,?,?)}', 0 
)
GO

--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'ATTACKS',  ''
--	, 'OutBreakStart1', 'Parameters'
--	, 'Start Date', ''
--	, '{CALL dbo.AVISP_FieldGetOutbreak (?,?,?,?,?)}', ''
--	, '{CALL dbo.AVISP_FieldPutOutbreak (?,?,?,?,?,?,?)}', 0 
--)
--GO


INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'ATTACKS',  ''
	, 'SaveSettings', 'Parameters'
	, 'Saved Settings', 'Save the existing report inputs or open a saved setting'
	, '{CALL dbo.AVISP_FieldGetSavedSettings (?,?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutSavedSettings (?,?,?,?,?,?,?)}', 2 
)
GO




------------------------------
-- Outbreak History Report
-- ReportInputParameters table


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, '@szMinMachineCount', '', '25', ''
	, 'Minimum Machines Infected', 'Minimum number of machines infected to be considered an outbreak (numeric value)'
	, 'OutBreakDefn'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, '@szMinFilenameCount', '', '25', ''
	, 'Minimum Files Infected', 'Minimum number of unique files infected to be considered an outbreak (numeric value)'
	, 'OutBreakDefn'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'ATTACKS',  '', ''
--	, '@iHourRange', '', '', ''
--	, 'Hour Range', 'Maximum number of hours over which infections occur to be considered an outbreak (numeric value)'
--	, 'OutBreakDefn1'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,0 ,0
--)
--GO

--INSERT ReportInputParameters 
--( 	ReportID, RptGroupID, ReportSavedSettingsName
--	, ParmName, DBFldName, ParmValue, ParmValuePrompt
--	, Prompt, PDesc 
--	, CustPageName 
--	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
--	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
--)
--VALUES(
--	'ATTACKS',  '', ''
--	, '@dtStartDate', '', '', ''
--	, 'Start Date', 'Starting date from which to look for outbreaks'
--	, 'OutBreakStart1'
--	, 4 ,0 ,0 ,0
--	, 1 ,0 ,0 ,0
--)
--GO



-- Save settings
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, 'RestoreSettings', '', '', ''
	, 'Open', 'Open a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, 'SaveSettingsVar', '', '', ''
	, 'Save', 'Save the current input settings to an existing name'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, 'SaveSettingsAs', '', '', ''
	, 'Save As', 'Save the current input settings (type a new name and press save)'
	, 'SaveSettings'
	, 6 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ATTACKS',  '', ''
	, 'DeleteSettings', '', '', ''
	, 'Delete', 'Delete a previously saved set of input settings'
	, 'SaveSettings'
	, 0 ,1 ,0 ,0
	, 0 ,0 ,0 ,0
)
GO



-----------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------
-- Removable media Report
-- ReportUICustPages table
-- epo3.5: must call tabname Within in order for it to be passed to report as text for inout display

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'DETMEDIA', ''
	, 'Within', 'Parameters'
	, 'Media Rules', 'Scans the Infected filename for the input string. Can be used to identify Viruses infecting a removable drive (A:), can also search for infections of specific file types (.com)'
	, '{CALL dbo.AVISP_FieldGetComplianceIssues (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DETMEDIA', '', ''
	, '@RemovableMedia', '', 'A:', 'A:'
	, 'Filename substring', 'Enter the removable media drive letter (A:) or filename substring'
	, 'Within'
	, 7 ,1 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

-------------------------------------
-- -- Property Settings Issues Report
-- ReportInputParameterValues table

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'DETMEDIA', '', 'Enter the removable media drive letter', 'A:', 'A:'
)
GO




-----------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------
-- DAT/Eng report
-- ReportUICustPages table

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'DAT', ''
	, 'TVD', 'Parameters'	--'DATEngine'
	, 'McAfee', 'Enter Top 5 DAT/Definition (DAT) versions, by default the most recent values are loaded'
	, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'ENG', ''
	, 'TVD', 'Parameters'	--'DATEngine'
	, 'McAfee', 'Enter Top 3 Engine (ENG) versions, by default the most recent values are loaded'
	, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'DATENG', ''
	, 'TVD', 'Parameters'	--'DATEngine'
	, 'McAfee', 'Enter compliant DAT/Definition (DAT) and Engine(ENG) versions, by default the most recent values are loaded'
	, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutComplianceIssues (?,?,?,?,?,?,?)}', 0 
)
GO



-- new products get added dynamically, name=productfamily
-- ISSUE??? How do new products get storedproc & writebackstoredproc fields set

-- This is dynamically added if Symantec products exist by avisp_reportparmloadingdatengine
--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'', 'DATENG'
--	, 'SymantecDATEngine', 'DATEngine'
--	, 'Symantec', ''
--	, '{CALL dbo.AVISP_GetDistDATVer (?,?,?,?)}', ''
--	, '', 0 
--)
--GO


--INSERT ReportUICustPages
--( 	ReportID, RptGroupID
--	, Name, Type
--	, Prompt, PDesc 
--	, Storedproc, dll 
--	, WritebackStoredproc, iOptionalPage
--)
--VALUES(
--	'', 'DATENG'
--	, 'TrendDATEngine', 'DATEngine'
--	, 'Trend', ''
--	, '{CALL dbo.AVISP_GetDistDATVer (?,?,?,?)}', ''
--	, '', 0 
--)
--GO


------------------------------
-- DAT/Eng report parms
-- ReportInputParameters table

--DAT
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DAT', '', ''
	, 'TVDDAT1', '', '', ''
	, '(DAT) - 1', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DAT', '', ''
	, 'TVDDAT2', '', '', ''
	, '(DAT) - 2', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DAT', '', ''
	, 'TVDDAT3', '', '', ''
	, '(DAT) - 3', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DAT', '', ''
	, 'TVDDAT4', '', '', ''
	, '(DAT) - 4', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DAT', '', ''
	, 'TVDDAT5', '', '', ''
	, '(DAT) - 5', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

-- ENG
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ENG', '', ''
	, 'TVDEngine1', '', '', ''
	, '(ENG) - 1', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ENG', '', ''
	, 'TVDEngine2', '', '', ''
	, '(ENG) - 2', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'ENG', '', ''
	, 'TVDEngine3', '', '', ''
	, '(ENG) - 3', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

-- DATENG
INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DATENG', '', ''
	, 'TVDDAT1DE', '', '', ''
	, '(DAT)', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'DATENG', '', ''
	, 'TVDEngine1DE', '', '', ''
	, '(ENG)', 'Enter minimum compliant version'
	, 'TVD'
	, 0 ,1 ,0 ,1
	, 0 ,0 ,0 ,0
)
GO


-- within tab
INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'', 'DATENG'
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited'
	, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?,?)}', ''
	, '', 0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'', 'DATENG', ''
	, '@ConnectAfterYYYYMMDD', '', '', ''
	, 'Agent Connection Date', 'Shows Computers connecting after this absolute date (This overrides the Agent Connection Rule parameter)'
	, 'Within'
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'', 'DATENG', ''
	, '@ConnectAfterRule', '', 'ALL', 'All Values'
	, 'Agent Connection Rule', 'Show Computers connecting after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

-- ConnectAfterRule values 

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'day1', '1 Day Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'day2', '2 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'day3', '3 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'day4', '4 Days Past'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'', 'DATENG', '@ConnectAfterRule', 'week1', '1 Week Past'
)
GO






-- end




/***************************************************************/
/***************************************************************/
/***************************************************************/
/***************************************************************/
/* Load default report settings in ReportInputParametersSaved  */


--ReportID,RptGroupID,ReportSavedSettingsName,ParmName,DBFldName,ParmValue,Prompt,PDesc,CustPageName,iType,iSaveUserEntry,iDefaultFlag,iUseDefault,iCrystalParm,iCrystalFieldCust,iLocalizedField,iDBField,ParmValuePrompt,LangID

Truncate Table ReportInputParametersSaved 
go

-- PRODUCTGROUP


insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@szGroupName1','','ConnectStatus','First Group','','',0,1,0,0,0,0,0,0,'Connect Status',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@szGroupName2','','','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Last Contact','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','ChartType','','3D Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@szGroupName1','','AgentType','First Group','','',0,1,0,0,0,0,0,0,'Agent Type',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@szGroupName2','','AgentVersion','Second Group','','',0,1,0,0,0,0,0,0,'AgentVersion',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@szGroupName3','','ConnectStatus','Third Group','','',0,1,0,0,0,0,0,0,'Connect Status',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Agent Version','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@ConnectAfterRule','','','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@szGroupName1','','Language','First Group','','',0,1,0,0,0,0,0,0,'Language',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@szGroupName2','','','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Language','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@ConnectType','','CURRENT','Connection Type','','',0,1,0,0,0,0,0,0,'Show Currently connecting Computers only',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@szGroupName1','','EngineVersion','First Group','','',0,1,0,0,0,0,0,0,'Engine Version',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@szGroupName2','','DATVersion','Second Group','','',0,1,0,0,0,0,0,0,'DAT Version',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@szGroupName3','','ExtraDAT','Third Group','','',0,1,0,0,0,0,0,0,'ExtraDAT',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (show subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@ProductType','','ALL','Product Type','','',0,1,0,0,0,0,0,0,'Show All Products',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@szGroupName1','','ProductName','First Group','','',0,1,0,0,0,0,0,0,'Product Name',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@szGroupName2','','ProductVersion','Second Group','','',0,1,0,0,0,0,0,0,'Product Version',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Product Protection','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (show subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Engine Dat','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@ConnectType','','CURRENT','Connection Type','','',0,1,0,0,0,0,0,0,'Show Currently connecting Computers only',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@szGroupName1','','OSType','First Group','','',0,1,0,0,0,0,0,0,'OS Type',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@szGroupName2','','OSPlatform','Second Group','','',0,1,0,0,0,0,0,0,'OS Platform',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@szGroupName3','','ProductNameVersion','Third Group','','',0,1,0,0,0,0,0,0,'Product Name & Version',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','OS Product','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (show subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@szGroupName1','','DomainName','First Group','','',0,1,0,0,0,0,0,0,'Domain Name',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@szGroupName2','','nodename','Second Group','','',0,1,0,0,0,0,0,0,'Directory',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Domain to Group','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (show subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@ConnectAfterRule','','week1','Agent Connection Rule','','',0,1,0,0,0,0,0,0,'1 Week Past',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@ConnectType','','ALL','Connection Type','','',0,1,0,0,0,0,0,0,'Show All Computers',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@szGroupName1','','nodename','First Group','','',0,1,0,0,0,0,0,0,'Directory',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@szGroupName2','','DomainName','Second Group','','',0,1,0,0,0,0,0,0,'Domain Name',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUCTGROUP','','Group to Domain','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go



-- PRODUPDATEGROUP



insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@szGroupName1','','SiteName','First Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@szGroupName2','','Type','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@szGroupName3','','InitiatorID','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@szGroupName4','','InitiatorType','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Repository Activity','@AfterRule','','All','Product Upgrade Rule','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@szGroupName1','','InitiatorID','First Group','','',0,1,0,0,0,0,0,0,'Initiator',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@szGroupName2','','InitiatorType','Second Group','','',0,1,0,0,0,0,0,0,'Initiator Type',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Initiator Summary','@AfterRule','','All','Product Upgrade Rule','','',0,1,0,0,0,0,0,0,'',''
)
go

insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','ChartType','','Line','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@szGroupName1','','Week','First Group','','',0,1,0,0,0,0,0,0,'Week',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@szGroupName2','','Type','Second Group','','',0,1,0,0,0,0,0,0,'Update Type',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@szGroupName3','','Version','Third Group','','',0,1,0,0,0,0,0,0,'Update Version',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Weekly updates','@AfterRule','','month3','Product Upgrade Rule','','',0,1,0,0,0,0,0,0,'',''
)
go


insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (show subreports)',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@szGroupName1','','Error','First Group','','',0,1,0,0,0,0,0,0,'Update Error',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@szGroupName2','','','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'PRODUPDATEGROUP','','Update Errors','@AfterRule','','All','Product Upgrade Rule','','',0,1,0,0,0,0,0,0,'',''
)
go



-- INFECTGROUP


insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@szGroupName1','','Month','First Group','','',0,1,0,0,0,0,0,0,'Month',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@szGroupName2','','Virusname','Second Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@szGroupName3','','FullProductName','Third Group','','',0,1,0,0,0,0,0,0,'Product Name & Version',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Virus Name','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','ChartType','','Sbar','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@szGroupName1','','Week','First Group','','',0,1,0,0,0,0,0,0,'Week',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Product over last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','ChartType','','Line','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@szGroupName1','','Month','First Group','','',0,1,0,0,0,0,0,0,'Month',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Monthly Infections by Product','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@szGroupName1','','Week','First Group','','',0,1,0,0,0,0,0,0,'Week',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@szGroupName2','','Virusname','Second Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@szGroupName3','','FullProductName','Third Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','@InfectAfterRule','','month3','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Weekly Infections by Virus Name','ChartType','','Line','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','ChartType','','Line','Chart Type','','',0,1,0,0,0,0,0,0,'Stacked Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@szGroupName1','','Quarter','First Group','','',0,1,0,0,0,0,0,0,'Quarter',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@szGroupName2','','Month','Second Group','','',0,1,0,0,0,0,0,0,'Month',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@szGroupName4','','FullProductName','Fourth Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infection History','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@szGroupName1','','Virusname','First Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Viruses found over last 7 days','@InfectAfterRule','','week1','Event Rule','','',0,1,0,0,0,0,0,0,'Week Past 1',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@szGroupName1','','TVDTaskName','First Group','','',0,1,0,0,0,0,0,0,'Task Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@szGroupName2','','','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections by Task Type','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@szGroupName1','','Action','First Group','','',0,1,0,0,0,0,0,0,'Action',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Action Summary for last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@szGroupName1','','FullProductName','First Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@szGroupName2','','','Second Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@InfectAfterRule','','day1','Event Rule','','',0,1,0,0,0,0,0,0,'Days Past 1',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Infections over last 24 hours','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@szGroupName1','','TVDSeverity','First Group','','',0,1,0,0,0,0,0,0,'Severity',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@szGroupName2','','EventDesc','Second Group','','',0,1,0,0,0,0,0,0,'Event Description',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@EventType','','NotInfection','Event Type','','',0,1,0,0,0,0,0,0,'Non Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','ChartType','','Pie2G','Chart Type','','',0,1,0,0,0,0,0,0,'Pie2G',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - NonInfection events','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@szDrilldown1','','FAST','Layout','','',0,1,0,0,0,0,0,0,'Fast Drilldown (no subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@EventType','','All','Event Type','','',0,1,0,0,0,0,0,0,'All',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@szGroupName1','','TVDSeverity','First Group','','',0,1,0,0,0,0,0,0,'Severity',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@szGroupName2','','EventDesc','Second Group','','',0,1,0,0,0,0,0,0,'Event Description',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Events by Severity - All events','@InfectAfterRule','','All','Event Rule','','',0,1,0,0,0,0,0,0,'All Values',''
)
go


--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@szGroupName2','','Virusname','Second Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go


insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@szGroupName1','','Virusname','First Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@szGroupName2','','Action','Second Group','','',0,1,0,0,0,0,0,0,'Action',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
)
go
insert ReportInputParametersSaved values (
'INFECTGROUP','','Virus Actions over last 4 weeks','ChartType','','Pie2G','Chart Type','','',0,1,0,0,0,0,0,0,'Pie2G',''
)
go


--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@szGroupName1','','Hostname','First Group','','',0,1,0,0,0,0,0,0,'Hostname',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@szGroupName2','','Virusname','Second Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Machines over last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
--)
--go



--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','ChartType','','Pie','Chart Type','','',0,1,0,0,0,0,0,0,'Pie Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@szGroupName2','','Virusname','Second Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@szGroupName3','','FullProductName','Third Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Files over last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@EventType','','Infection','Event Type','','',0,1,0,0,0,0,0,0,'Infection',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@szGroupName3','','','Third Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Infected Users over last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go



--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@EventType','','Infection-Cle','Event Type','','',0,1,0,0,0,0,0,0,'Infection-Cle',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Cleaned for past 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go



--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@EventType','','Infection-Del','Event Type','','',0,1,0,0,0,0,0,0,'Infection-Del',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Deleted for past 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go



--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@EventType','','Infection-Mov','Event Type','','',0,1,0,0,0,0,0,0,'Infection-Mov',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Moved for last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go



--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','ChartType','','Bar','Chart Type','','',0,1,0,0,0,0,0,0,'Bar Chart',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@szDrilldown1','','DRILLDOWN','Layout','','',0,1,0,0,0,0,0,0,'Drilldown (subreports)',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@EventType','','Infection-Unr','Event Type','','',0,1,0,0,0,0,0,0,'Infection-Unr',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@szGroupName1','','Filename','First Group','','',0,1,0,0,0,0,0,0,'Filename',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@szGroupName2','','FullProductName','Second Group','','',0,1,0,0,0,0,0,0,'ProductVersion',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@szGroupName3','','Virusname','Third Group','','',0,1,0,0,0,0,0,0,'Virus Name',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@szGroupName4','','','Fourth Group','','',0,1,0,0,0,0,0,0,'',''
--)
--go
--insert ReportInputParametersSaved values (
--'INFECTGROUP','','Top 10 Files Unresolved for last 4 weeks','@InfectAfterRule','','week4','Event Rule','','',0,1,0,0,0,0,0,0,'Weeks Past 4',''
--)
--go

/***************************************************************/
/***************************************************************/
/***************************************************************/
/***************************************************************/
/* Load lookup tables */

/* Virus Type lookup tables */

DELETE VirusTypeDesc
GO


/* These entries must be made in priority order */
/* multiple matches will take the one with the smaller autoid */
/* entries here have a higher virus type priority than those below */

INSERT VirusTypeDesc VALUES('0409', '09',  '.MP.',
'Multi-Partite', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '@MM',
'Mass Mailer', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '@M',
'Mass Mailer', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.CAV',
'Worm', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.CLI',
'Trojan', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.SVR',
'Trojan', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.worm',
'Worm', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'worm',
'Worm', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'troj',
'Trojan', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'boot',
'Boot', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.mbr',
'Boot', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.bs',
'Boot', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.SFX',
'Trojan', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'ow-',
'File Infector', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'com.',
'File Infector', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.com',
'File Infector', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.cmp',
'File Infector', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  '.ow',
'File Infector', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'MACRO',
'Macro', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'joke',
'Joke', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'Spam/',
'Mass Mailer', NULL, NULL)
GO

INSERT VirusTypeDesc VALUES('0409', '09',  'exploit',
'Exploit', NULL, NULL)
GO

/* This must always be the last entry */

INSERT VirusTypeDesc VALUES('0409', '09',  'LastEntry',
'UnCategorized', NULL, NULL)
GO



DELETE VirusFilePlatformTypeDesc
GO

/* virus vehicle - file type, platform, additional info */
/* Assigns a default type along with it */
/* These entries must be made in priority order */
/* multiple matches will take the one with the smaller autoid */

/* prefixes showing file type */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'VBS/',
'VBScript', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W97M/',
'Microsoft Word 97', 'Word 97', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WScript',
'VBScript', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'A97M/',
'Microsoft Access 97', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'APM/',
'Ami Pro', 'Any', 'Macro|Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'BV/',
'Batch-file Program', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'BAT/',
'Batch-file Program', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'BAT.',
'Batch-file Program', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'BATCH',
'Batch-file Program', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'CSC/',
'Corel Draw', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'HLL',
'HighLevel Lang', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'HTML/',
'HTML Infector', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'IRC',
'IRC-Chat', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'ICQ',
'ICQ-Chat', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'JS/',
'JavaScript', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'JVS/',
'JavaScript', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'JV/',
'Java', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'O2KM/',
'Micorsoft Office', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'OF97/',
'Micorsoft Office', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'O97M/',
'Micorsoft Office', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'P98M/',
'Microsoft Project', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'PP97M/',
'Power Point 97', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'V5M/',
'Visio VBA', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'VBA/',
'Visual Basic 4/Applic', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WM/',
'Microsoft Word 95', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WM97/',
'Microsoft Word 97', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'X97F/',
'Excel 97 formulas', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'X97M/',
'Excel 97', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'XM97/',
'Excel 97', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'XF/',
'Excel 95/97 formulas', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'XM/',
'Excel 95', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Eicar',
'Test', 'Any', 'Test', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Installation Check',
'Test', 'Any', 'Test', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'VBS',
'VBScript', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'VBasic',
'Visual Basic', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'AX/',
'ActiveX', 'Any', 'Exploit', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'PalmOS/',
'PalmOS', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'PHP/',
'PHP', 'Any', 'Script', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'ELF/',
'ELF', 'Any', 'File Infector', NULL, NULL)
GO


/* suffix info describing more information */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.DoS',
'Denial of Service', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'DoS.',
'Denial of Service', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'DoS/',
'Denial of Service', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'pws',
'Password Stealer', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.CAV',
'Cavity', 'Any', 'Worm', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.CLI',
'Internet', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.SVR',
'Internet', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.DAM',
'Damaged File', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.CMP.',
'Companion', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.OW.',
'Overwriter', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.DR',
'Dropper File', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.APP',
'Appended', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.INTD',
'Intended', 'Any', 'UnCategorized', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.SFX',
'Self Extracting', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.SRC',
'Source Code', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.APP',
'Non Replicator', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.INTD',
'Non Replicator', 'Any', 'File Infector', NULL, NULL)
GO



/* generic platform prefixes */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W32/',
'Win32', 'Win32/Win95', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W31/',
'Win3.1', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WIN/',
'Win16/32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WIN.',
'Win16/32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W95/',
'Win16/32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WNT/',
'WinNT', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WinNT.',
'WinNT', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WinNT/',
'WinNT', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'WNT.',
'WinNT', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W32.',
'Win32', 'Win32/Win95', 'File/Boot Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W95.',
'Win16/32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W9x',
'Win16/32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W98',
'Win32', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W2K',
'Win2K', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'W2KM',
'Win2K', 'Any', 'Macro', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Win2k',
'Win2K', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Linux',
'Linux', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Unix',
'Unix', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Mac/',
'Mac', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'SunOS',
'Unix', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Salaris',
'Unix', 'Any', 'File Infector', NULL, NULL)
GO


/* specific virus names that ID virustype */
/* This section is meant to categorize common virus names that dont often come with */
/* prefixes and suffixes */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'joke',
'UnCategorized', 'Any', 'Joke', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Stoned',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Michelangelo',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'Form',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'backdoor',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'multidropper',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'orifice',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'bearded',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'exitwin',
'Win32', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'exploid',
'Exploit', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'mailbomb',
'Denial of Service', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'bitchslap',
'Denial of Service', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'netbus',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'qfile4',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'rootcmd',
'UnCategorized', 'Any', 'Trojan', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'parity',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'alfons',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'amoeba',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'bath',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'blackjet',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'bomber',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'chill',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'desperado',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'die-hard',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'fairz',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'frodo',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'hidenowt',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'jeru',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'liberty',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'mummy',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'necros',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'nightfall',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'nofrills',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'nov17',
'UnCategorized', 'Any', 'File Infector', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'anticmos',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'antiexe',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'brasil',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'byebye',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'chance',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'chinesefish',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'cruel',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'daboys',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'denzuk',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'diablo',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'dir-',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'empire.monkey',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'exebug',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'filler',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'flame',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'frankenstein',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'J&M',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'jumper',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'leandro',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'moloch',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'musicbug',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'NYB',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'welcomb',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'wyx',
'UnCategorized', 'Any', 'Boot', NULL, NULL)
GO


/* Really scratching the bottom */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.GR',
'Generic', 'Any', 'UnCategorized', NULL, NULL)
GO

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  '.gen',
'Generic', 'Any', 'UnCategorized', NULL, NULL)
GO



/* This must always be the last entry: guarantees at least one value matches */

INSERT VirusFilePlatformTypeDesc VALUES('0409', '09',  'LastEntry',
'UnCategorized', 'none', 'UnCategorized', NULL, NULL)
GO


---------------------------------------------------------------------------

--------------------------------------------------------------
--------------------------------------------------------------
-- Snowcap metadata
-------------------------

---------------------------------------------------------------------------------------------------
-- Snowcap Metadata
-- cleanup

Delete ReportUICustPages
Where ReportID = 'SNOWCAPGROUP'
GO

Delete ReportInputParameters
Where ReportID = 'SNOWCAPGROUP'
GO

Delete ReportInputParameterValues
Where ReportID = 'SNOWCAPGROUP'
GO



------------------------------------------
-- ReportUICustPages table


INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'SNOWCAPGROUP', ''
	, 'UserGroups', 'Parameters'
	, 'Data Groupings', 'Select the data fields for which summarized group totals will be returned. The report will allow drilling down through the group summaries to the details page. One to four groups can be selected.'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO

INSERT ReportUICustPages
( 	ReportID, RptGroupID
	, Name, Type
	, Prompt, PDesc 
	, Storedproc, dll 
	, WritebackStoredproc, iOptionalPage
)
VALUES(
	'SNOWCAPGROUP', ''
	, 'Within', 'Parameters'
	, 'Within', 'Select how the data returned by the server should be limited (Date or Type categories)'
	, '{CALL dbo.AVISP_FieldGetInfectionGroup (?,?,?,?,?)}', ''
	, '{CALL dbo.AVISP_FieldPutInfectionGroup (?,?,?,?,?,?,?)}', 0
)
GO


--------------------------
-- Event User Group Report
-- ReportInputParameters table


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@szGroupName1', '', 'Month', 'Month'
	, 'First Group', 'Enter the First Group Name (Must have at least one)'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@szGroupName2', '', 'Week', 'Week'
	, 'Second Group', 'Enter the Second Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@szGroupName3', '', '', ''
	, 'Third Group', 'Enter the Third Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@szGroupName4', '', '', ''
	, 'Fourth Group', 'Enter the Fourth Group Name'
	, 'UserGroups'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO


INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@InfectAfterYYYYMMDD', '', '', ''
	, 'Event Date', 'Shows Events after this absolute date (This overrides the Event Rule parameter)'
	, 'Within'
--	, 0 ,1 ,0 ,0
--	, 1 ,0 ,1 ,0
	, 4 ,0 ,0 ,0
	, 1 ,0 ,0 ,0
)
GO

INSERT ReportInputParameters 
( 	ReportID, RptGroupID, ReportSavedSettingsName
	, ParmName, DBFldName, ParmValue, ParmValuePrompt
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
VALUES(
	'SNOWCAPGROUP', '', ''
	, '@InfectAfterRule', '', 'All', 'All Values'
	, 'Event Rule', 'Show Events after this relative rule'
	, 'Within'
	, 0 ,1 ,0 ,0
	, 1 ,0 ,1 ,0
)
GO



----------------------------------------------------------------
-- Event User Group Report
-- ReportInputParameterValues table



INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@szGroupName_', ' ', '...'	-- generates an empty field, parmvalue must be 1 space
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@szGroupName_', 'Year', 'Year'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@szGroupName_', 'Quarter', 'Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@szGroupName_', 'Month', 'Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@szGroupName_', 'Week', 'Week'
)
GO



INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'All', 'All Values'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'CurrentDay', 'Current Day'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'CurrentWeek', 'Current Week'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'CurrentMonth', 'Current Month'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'CurrentQuarter', 'Current Quarter'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'CurrentYear', 'Current Year'
)
GO


INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'day1', 'Days Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'day2', 'Days Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'day3', 'Days Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'day4', 'Days Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'week1', 'Week Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'week2', 'Weeks Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'week3', 'Weeks Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'week4', 'Weeks Past 4'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'month1', 'Month Past 1'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'month2', 'Months Past 2'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'month3', 'Months Past 3'
)
GO

INSERT ReportInputParameterValues
( 	ReportID, RptGroupID, ParmName, ParmValue, Prompt
)
VALUES(
	'SNOWCAPGROUP',  '', '@InfectAfterRule', 'year1', 'Years Past 1'
)
GO



----------------------------------------------------------------------------
-- Last thing section: always keep this stuff at the very end of this script

-------------------------------------------------------
-------------------------------------------------------
-- set all localized langid to english by default

update ReportInputParameters 
set LangID = '0409'
GO

update ReportInputParametersSaved 
set LangID = '0409'
GO

update ReportInputParameterValues
set LangID = '0409'
GO

update ReportUICustPages 
set LangID = '0409'
GO

-- set defaults for prompts if they are empty

update ReportInputParameters 
set ParmValuePrompt = ParmValue
where ParmValuePrompt is null and ParmValue is not null 
GO

update ReportInputParameterValues
set Prompt = ParmValue
where Prompt is null and ParmValue is not null
GO

-- virustype fix: always use Mass Mailer to avoid confusion
Update ReportTranslations
Set TextID = 'Mass Mailer' where TextID = 'MassMailer'
GO

------------
-- Last thing Generate starting Branchnodeenum and ReportFullPathNodeID tables
execute AVIDALSP_Generate_BranchNode_Enum
Go


-- end

-- end
