/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.action;

import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogTable;
import com.mcafee.epo.webui.servlet.AuthorizedAction;
import java.sql.Connection;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class SchedulerPurgeTaskLogAction
extends ActionBeanBase
implements AuthorizedAction {
    private final Logger m_log = Logger.getLogger(this.getClass());

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        return null;
    }

    public boolean isAuthorized(EpoUser epoUser) throws Exception {
        return epoUser.isGlobalAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        this.m_log.debug((Object)"Received request for PurgeTaskLog");
        String string = null;
        int n = -1;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.compareToIgnoreCase("daysold") != 0) continue;
            object = httpServletRequest.getParameter(string);
            if (NumberUtils.isNumber((String)object)) {
                try {
                    n = Integer.parseInt((String)object);
                    this.m_log.debug((Object)("Purging records older than " + n + " days"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_log.debug((Object)("While \"" + (String)object + "\" is a number, it's not a usable one.  Not purging anything."));
                }
                continue;
            }
            this.m_log.debug((Object)("Value " + (String)object + " is not a recognized number.  Not purging anything."));
        }
        if (n < 0) {
            this.m_log.debug((Object)"Error, PurgeTaskLog invalid or missing parameter (daysold)");
            httpServletResponse.sendError(409, "Conflict, daysold parameter must be greater than zero");
            return "blankJSP";
        }
        object = null;
        try {
            try {
                object = EpoCore.getEpoDb().getConnection();
                ServerTaskLogTable.purgeDaysOld((Connection)object, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                httpServletResponse.sendError(500, "Server error.");
                Object var9_10 = null;
                DatabaseUtil.close((Connection)object);
                return "blankJSP";
            }
            Object var9_9 = null;
            DatabaseUtil.close((Connection)object);
            return "blankJSP";
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            DatabaseUtil.close((Connection)object);
            throw throwable;
        }
    }
}

