/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.schedule;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.quartz.Trigger;

public abstract class Schedule {
    public static final String DEFAULT_TRIGGER_GROUP = "Default ePO Trigger Group";
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    private static final int UNKNOWN = -1;
    private boolean m_enabled = false;
    private Date m_startTime = null;
    private Date m_endTime = null;
    private boolean m_repeatable = false;
    private int m_repeatEvery = -1;
    private int m_repeatUntilHour = -1;
    private int m_repeatUntilMinute = -1;
    private int m_repeatUntilSecond = -1;

    public abstract List getSpecificTriggers();

    private void setTriggerValues(Trigger trigger) {
        if (this.getEndTime() != null) {
            trigger.setEndTime(this.getEndTime());
        }
        trigger.setName(ClassUtils.getShortClassName(this.getClass()) + ":" + ClassUtils.getShortClassName(trigger.getClass()) + "(" + this.hashCode() + "." + trigger.hashCode() + "." + trigger.getStartTime().getTime() + ")");
        trigger.setGroup(DEFAULT_TRIGGER_GROUP);
    }

    public List getTriggers() {
        LinkedList<Trigger> linkedList = new LinkedList<Trigger>();
        Iterator iterator = this.getSpecificTriggers().iterator();
        while (iterator.hasNext()) {
            Trigger trigger = (Trigger)iterator.next();
            this.setTriggerValues(trigger);
            linkedList.add(trigger);
        }
        return linkedList;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Date date) {
        this.m_startTime = date;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Date date) {
        this.m_endTime = date;
    }

    public boolean isRepeatable() {
        return this.m_repeatable;
    }

    public void setRepeatable(boolean bl) {
        this.m_repeatable = bl;
    }

    public int getRepeatEvery() {
        return this.m_repeatEvery;
    }

    public void setRepeatEvery(int n) {
        this.m_repeatEvery = n;
    }

    public int getRepeatUntilHour() {
        return this.m_repeatUntilHour;
    }

    public void setRepeatUntilHour(int n) {
        this.m_repeatUntilHour = n;
    }

    public int getRepeatUntilMinute() {
        return this.m_repeatUntilMinute;
    }

    public void setRepeatUntilMinute(int n) {
        this.m_repeatUntilMinute = n;
    }

    public int getRepeatUntilSecond() {
        return this.m_repeatUntilSecond;
    }

    public void setRepeatUntilSecond(int n) {
        this.m_repeatUntilSecond = n;
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 37).appendSuper(super.hashCode()).append((Object)this.getStartTime()).toHashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

