/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.schedule;

import com.mcafee.epo.webui.scheduler.schedule.Schedule;
import com.mcafee.epo.webui.scheduler.schedule.SchedulerSimpleTrigger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.SimpleTrigger;

public class Weekly
extends Schedule {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    private long m_repeatWeeks = 0L;
    private int m_maskDaysOfWeek = 0;

    public List getSpecificTriggers() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.getStartTime());
        LinkedList<SchedulerSimpleTrigger> linkedList = new LinkedList<SchedulerSimpleTrigger>();
        Iterator iterator = this.calcDOW().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            SchedulerSimpleTrigger schedulerSimpleTrigger = new SchedulerSimpleTrigger();
            schedulerSimpleTrigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
            schedulerSimpleTrigger.setRepeatInterval(this.getRepeatWeeks() * 604800000L);
            calendar.set(7, n);
            schedulerSimpleTrigger.setStartTime(calendar.getTime());
            linkedList.add(schedulerSimpleTrigger);
        }
        return linkedList;
    }

    private List calcDOW() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.getMaskDaysOfWeek() == 255) {
            arrayList.add(new Integer(1));
            arrayList.add(new Integer(2));
            arrayList.add(new Integer(3));
            arrayList.add(new Integer(4));
            arrayList.add(new Integer(5));
            arrayList.add(new Integer(6));
            arrayList.add(new Integer(7));
            return arrayList;
        }
        if ((this.getMaskDaysOfWeek() & 1) == 1) {
            arrayList.add(new Integer(1));
        }
        if ((this.getMaskDaysOfWeek() & 2) == 2) {
            arrayList.add(new Integer(2));
        }
        if ((this.getMaskDaysOfWeek() & 4) == 4) {
            arrayList.add(new Integer(3));
        }
        if ((this.getMaskDaysOfWeek() & 8) == 8) {
            arrayList.add(new Integer(4));
        }
        if ((this.getMaskDaysOfWeek() & 0x10) == 16) {
            arrayList.add(new Integer(5));
        }
        if ((this.getMaskDaysOfWeek() & 0x20) == 32) {
            arrayList.add(new Integer(6));
        }
        if ((this.getMaskDaysOfWeek() & 0x40) == 64) {
            arrayList.add(new Integer(7));
        }
        return arrayList;
    }

    public long getRepeatWeeks() {
        return this.m_repeatWeeks;
    }

    public void setRepeatWeeks(long l) {
        this.m_repeatWeeks = l;
    }

    public int getMaskDaysOfWeek() {
        return this.m_maskDaysOfWeek;
    }

    public void setMaskDaysOfWeek(int n) {
        this.m_maskDaysOfWeek = n;
    }
}

