/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.db;

import com.mcafee.epo.common.db.SettingsTable;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AlertingConfig
extends SettingsTable {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$db$AlertingConfig == null ? (class$com$mcafee$epo$notifications$db$AlertingConfig = AlertingConfig.class$("com.mcafee.epo.notifications.db.AlertingConfig")) : class$com$mcafee$epo$notifications$db$AlertingConfig));
    public static final int MAX_LEN_NAME = 64;
    public static final int MAX_LEN_VALUE = 2048;
    private static final int PROP_SCHEMA_VERSION = 0;
    private static final int PROP_PAGE_COUNT = 1;
    private static final int PROP_AUTO_REFRESH_PERIOD = 2;
    private static final int PROP_AUTO_FRESH_ACTIVATED = 3;
    private static final int PROP_ALLOW_SITE_TO_VIEW_GLOBAL = 4;
    private static final int PROP_SMTP_SERVER = 5;
    private static final int PROP_SMTP_FROM_ADDR = 6;
    private static final int PROP_ALLOW_SITE_TO_EDIT_TARGETS = 7;
    private static final String[] PROPERTY_NAMES = new String[]{"SchemaVersion", "pageCount", "autoRefreshPeriod", "autoRefreshActivated", "allowSiteToViewGlobal", "smtpServer", "smtpFromAddr", "allowSiteToEditTargets"};
    public static final String TABLE_NAME = "AlertingConfig";
    static /* synthetic */ Class class$com$mcafee$epo$notifications$db$AlertingConfig;

    public AlertingConfig() {
        this.initDefaultValues(new String[]{"0", "10", "30000", "1", "true", "(unset)", "nobody", "true"});
    }

    public static final AlertingConfig loadConfig(Connection connection) throws SQLException {
        return AlertingConfig.loadConfig(connection, null);
    }

    public static final AlertingConfig loadConfig(Connection connection, String string) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)"select * from AlertingConfig", (Class)(class$com$mcafee$epo$notifications$db$AlertingConfig == null ? (class$com$mcafee$epo$notifications$db$AlertingConfig = AlertingConfig.class$("com.mcafee.epo.notifications.db.AlertingConfig")) : class$com$mcafee$epo$notifications$db$AlertingConfig));
        if (vector.size() < 1) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException(Resource.getString("userrule_morethan_one_userrule", string));
        }
        return (AlertingConfig)((Object)vector.firstElement());
    }

    protected String getTable() {
        return TABLE_NAME;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public void setAdditionalValues(ResultSet resultSet) throws SQLException {
    }

    public int getNameCol() {
        return 1;
    }

    public int getValueCol() {
        return 2;
    }

    public int getNameColLength() {
        return 64;
    }

    public int getValueColLength() {
        return 2048;
    }

    protected String getClearSql() {
        return "delete from AlertingConfig";
    }

    public void setUniqueID(int n) throws SQLException {
    }

    private Boolean getBoolean(int n, String string) {
        return new Boolean(this.getString(n, string));
    }

    private String getString(int n, String string) {
        String string2 = null;
        try {
            string2 = (String)this.getProperty(PROPERTY_NAMES[n]);
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString(string), (Throwable)exception);
        }
        return string2;
    }

    private int getInteger(int n, String string) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt((String)this.getProperty(PROPERTY_NAMES[n]));
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString(string), (Throwable)exception);
        }
        return n2;
    }

    private long getLong(int n, String string) {
        long l = 0L;
        try {
            l = Long.parseLong((String)this.getProperty(PROPERTY_NAMES[n]));
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString(string), (Throwable)exception);
        }
        return l;
    }

    public int getSchemaVersion() {
        return this.getInteger(0, "config_bad_schema_version");
    }

    public int getPageCount() {
        return this.getInteger(1, "config_bad_page_count");
    }

    public void setPageCount(int n) {
        this.setProperty(PROPERTY_NAMES[1], Integer.toString(n));
    }

    public long getAutoRefreshPeriod() {
        return this.getLong(2, "config_bad_auto_refresh_period");
    }

    public void setAutoRefreshPeriod(long l) {
        this.setProperty(PROPERTY_NAMES[2], Long.toString(l));
    }

    public int getAutoRefreshActivated() {
        return this.getInteger(3, "config_bad_auto_refresh_activated");
    }

    public void setAutoRefreshActivated(int n) {
        this.setProperty(PROPERTY_NAMES[3], Integer.toString(n));
    }

    public Boolean getAllowSiteToViewGlobal() {
        return this.getBoolean(4, "config_bad_site_admin");
    }

    public void setAllowSiteToViewGlobal(Boolean bl) {
        this.setProperty(PROPERTY_NAMES[4], bl.toString());
    }

    public Boolean getAllowSiteToEditTargets() {
        return this.getBoolean(7, "config_bad_site_admin");
    }

    public void setAllowSiteToEditTargets(Boolean bl) {
        this.setProperty(PROPERTY_NAMES[7], bl.toString());
    }

    public void setSmtpServer(String string) {
        this.setProperty(PROPERTY_NAMES[5], string);
    }

    public String getSmtpServer() {
        return this.getString(5, "config_no_smtp_server");
    }

    public void setSmtpFromAddr(String string) {
        this.setProperty(PROPERTY_NAMES[6], string);
    }

    public String getSmtpFromAddr() {
        return this.getString(6, "config_no_smtp_from_addr");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

