/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.db;

import com.mcafee.epo.common.util.IPFormatException;
import com.mcafee.epo.common.util.IPUtil;
import com.mcafee.epo.core.condition.SerializationException;
import com.mcafee.epo.core.condition.Sexp;
import com.mcafee.epo.core.condition.SexpException;
import com.mcafee.epo.core.condition.SexpLong;
import com.mcafee.epo.core.condition.SexpProp;
import com.mcafee.epo.core.condition.SexpSerializer;
import com.mcafee.epo.core.condition.SexpString;
import com.mcafee.epo.notifications.db.NotificationLog;
import java.sql.Timestamp;

public class SexpQueryUtil {
    public static final String makeWhereSnippet(String string) throws SexpException {
        if (string == null || string.length() == 0) {
            return "";
        }
        Sexp sexp = null;
        try {
            sexp = SexpSerializer.read((String)string);
        }
        catch (SerializationException serializationException) {
            throw new SexpException("Error parsing expression:" + string);
        }
        return SexpQueryUtil.makeWhereSnippet(sexp);
    }

    public static final String makeWhereSnippet(Sexp sexp) throws SexpException {
        if (sexp == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        SexpQueryUtil.makeWhereSnippet(sexp, stringBuffer);
        return stringBuffer.toString();
    }

    private static final void makeWhereSnippet(Sexp sexp, StringBuffer stringBuffer) throws SexpException {
        String string = sexp.type();
        if ((string == "and" || string == "or") && sexp.numChildren() == 2 && sexp.childAt(1).type() == "bool") {
            SexpQueryUtil.makeWhereSnippet(sexp.childAt(0), stringBuffer);
            return;
        }
        stringBuffer.append("( ");
        if (string == "and") {
            SexpQueryUtil.makeMultiTermSql("and", sexp, stringBuffer);
        } else if (string == "or") {
            SexpQueryUtil.makeMultiTermSql("or", sexp, stringBuffer);
        } else if (string == "startsWith" || string == "endsWith" || string == "contains") {
            SexpQueryUtil.makeTwoTermSql("like", sexp, stringBuffer);
        } else if (string == "isNull") {
            String string2 = ((SexpProp)sexp.childAt(0)).getPropName();
            stringBuffer.append(string2).append(" is null ");
        } else if (string == "doesntContain") {
            stringBuffer.append(" not ");
            SexpQueryUtil.makeTwoTermSql("like", sexp, stringBuffer);
        } else if (string == "olderThan") {
            SexpQueryUtil.makeTwoTermSql("<", sexp, stringBuffer);
        } else if (string == "newerThan") {
            SexpQueryUtil.makeTwoTermSql(">=", sexp, stringBuffer);
        } else if (string == "eq") {
            SexpQueryUtil.makeTwoTermSql("=", sexp, stringBuffer);
        } else if (string == "ne") {
            SexpQueryUtil.makeTwoTermSql("!=", sexp, stringBuffer);
        } else if (string == "ipInRange" || string == "ipNotInRange") {
            SexpQueryUtil.makeThreeTermSql(sexp, stringBuffer);
        } else {
            throw new SexpException("Unable to make SQL for type:" + string);
        }
        stringBuffer.append(" ) ");
    }

    private static final void makeMultiTermSql(String string, Sexp sexp, StringBuffer stringBuffer) throws SexpException {
        int n = 0;
        while (n < sexp.numChildren()) {
            if (n != 0) {
                stringBuffer.append(" ").append(string).append(" ");
            }
            SexpQueryUtil.makeWhereSnippet(sexp.childAt(n), stringBuffer);
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void makeThreeTermSql(Sexp sexp, StringBuffer stringBuffer) throws SexpException {
        if (sexp.numChildren() != 3) {
            throw new SexpException("Invalid expression: Operation: " + sexp.type() + " didn't have two children!");
        }
        if (sexp.childAt(0).type() != "prop") {
            throw new SexpException("Invalid expression: lhs of " + sexp.type() + " not of type PROP.");
        }
        if (sexp.childAt(1).type() != "string" || sexp.childAt(2).type() != "string") {
            throw new SexpException("Invalid expression: rhs of " + sexp.type() + " not of type String.");
        }
        if (sexp.type() != "ipInRange" && sexp.type() != "ipNotInRange") throw new SexpException("Unknown three-term expresion: " + sexp.type());
        boolean bl = sexp.type() == "ipNotInRange";
        try {
            String string = ((SexpProp)sexp.childAt(0)).getPropName() + "Num";
            long l = IPUtil.convert((String)((SexpString)sexp.childAt(1)).getValue());
            long l2 = IPUtil.convert((String)((SexpString)sexp.childAt(2)).getValue());
            if (bl) {
                stringBuffer.append(" not ( ");
            }
            stringBuffer.append("( ").append(string).append(" >= ").append(l).append(" ) and ( ").append(string).append(" <= ").append(l2).append(" ) ");
            if (!bl) return;
            stringBuffer.append(" ) ");
            return;
        }
        catch (IPFormatException iPFormatException) {
            throw new SexpException("Invalid IP address format", (Throwable)iPFormatException);
        }
    }

    private static final void makeTwoTermSql(String string, Sexp sexp, StringBuffer stringBuffer) throws SexpException {
        if (sexp.numChildren() != 2) {
            throw new SexpException("Invalid expression: Operation: " + sexp.type() + " didn't have two children!");
        }
        if (sexp.childAt(0).type() != "prop") {
            throw new SexpException("Invalid expression: lhs of " + sexp.type() + " not of type PROP.");
        }
        String string2 = ((SexpProp)sexp.childAt(0)).getPropName();
        if (string2.equals(NotificationLog.PROPERTY_NAMES[11])) {
            stringBuffer.append(NotificationLog.PROPERTY_NAMES[10]);
        } else if (string2.equals(NotificationLog.PROPERTY_NAMES[9])) {
            stringBuffer.append(NotificationLog.PROPERTY_NAMES[8]);
        } else if (string2.equals(NotificationLog.PROPERTY_NAMES[13])) {
            stringBuffer.append(" ").append(NotificationLog.PROPERTY_NAMES[13]).append(" ");
        } else if (string2.equals(NotificationLog.PROPERTY_NAMES[14])) {
            stringBuffer.append(" ").append(NotificationLog.PROPERTY_NAMES[14]).append(" ");
        } else {
            stringBuffer.append(string2);
        }
        Sexp sexp2 = sexp.childAt(1);
        stringBuffer.append(" ").append(string).append(" ").append(SexpQueryUtil.rhsToSql(sexp.type(), sexp2));
    }

    private static final String rhsToSql(String string, Sexp sexp) throws SexpException {
        if (string == "olderThan" || string == "newerThan") {
            if (sexp.type() != "long") {
                throw new SexpException("Expected LONG type; got:" + sexp.type());
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis() - ((SexpLong)sexp).getValue());
            return "'" + timestamp.toString() + "'";
        }
        String string2 = "";
        String string3 = sexp.type();
        if (string3 == "string") {
            String string4 = ((SexpString)sexp).getValue();
            string4 = string4.replaceAll("'", "''");
            string2 = string == "startsWith" ? "'" + SexpQueryUtil.escapeWildcards(string4) + "%'" : (string == "endsWith" ? "'%" + SexpQueryUtil.escapeWildcards(string4) + "'" : (string == "contains" || string == "doesntContain" ? "'%" + SexpQueryUtil.escapeWildcards(string4) + "%'" : "'" + string4 + "'"));
        } else if (string3 == "long") {
            string2 = "" + ((SexpLong)sexp).getValue();
        } else {
            throw new SexpException("Invalid rhs type for creating SQL:" + string);
        }
        return string2;
    }

    private static String escapeWildcards(String string) {
        string = string.replaceAll("([\\[%])", "[$1]");
        return string;
    }
}

