/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.db.tests;

import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseTestSetup;
import com.mcafee.epo.core.util.DateParser;
import com.mcafee.epo.core.util.DateParserException;
import com.mcafee.epo.notifications.db.AlertUserRule;
import com.mcafee.epo.notifications.db.NotificationLog;
import com.mcafee.epo.notifications.db.QueryUtil;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.ActionEnvironment;
import com.mcafee.epo.notifications.server.ActionEnvironmentTestImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DatabaseObjectTestBase
extends TestCase {
    protected Connection m_con = null;

    public DatabaseObjectTestBase(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        ActionEnvironment.setInstance(new ActionEnvironmentTestImpl());
        this.m_con = DatabaseTestSetup.instance().getConnection();
        try {
            this.removeTestData();
        }
        catch (Exception exception) {
            this.m_con.close();
            throw exception;
        }
    }

    public void tearDown() throws Exception {
        if (this.m_con != null) {
            this.m_con.close();
            this.m_con = null;
        }
    }

    private void removeTestData() throws SQLException {
        QueryUtil.clearAllTables(this.m_con);
        this.m_con.commit();
    }

    public static final Timestamp timestampFromString(String string) throws DateParserException {
        DateParser dateParser = new DateParser();
        return new Timestamp(dateParser.convert(string).getTime());
    }

    public static final AlertUserRule createTestRule() throws DateParserException {
        Boolean bl = new Boolean(false);
        Boolean bl2 = new Boolean(true);
        AlertUserRule alertUserRule = new AlertUserRule();
        alertUserRule.setId(-1);
        alertUserRule.setAggregate(bl2);
        alertUserRule.setAggregationTime(new Long(3600L));
        alertUserRule.setAggByComputer(bl);
        alertUserRule.setNumAggComputers(null);
        alertUserRule.setAggByEvents(bl2);
        alertUserRule.setNumAggEvents(new Integer(1000));
        alertUserRule.setAnyCategory(bl);
        alertUserRule.setAnyAlertFamily(bl2);
        alertUserRule.setBranchNodeId(8L);
        alertUserRule.setBranchNodePath("{Directory}");
        alertUserRule.setCreateDate(DatabaseObjectTestBase.timestampFromString("2001-05-31T23:23:23.000-08:00"));
        alertUserRule.setDescription("The sys admin is out to lunch.");
        alertUserRule.setEnabled(true);
        alertUserRule.setModifyDate(null);
        alertUserRule.setRuleName("AlertUserRule 0001");
        alertUserRule.setPriority(1);
        alertUserRule.setThreatExp("begins with");
        alertUserRule.setThreatText("monkey");
        alertUserRule.setThrottle(true);
        alertUserRule.setThrottleTime(new Long(600L));
        alertUserRule.setWorkstationOS(bl);
        alertUserRule.setServerOS(bl2);
        alertUserRule.setUnknownOS(bl2);
        return alertUserRule;
    }

    public static final NotificationLog createTestLog() throws DateParserException {
        NotificationLog notificationLog = new NotificationLog();
        notificationLog.setNotificationType("smtp");
        notificationLog.setNotificationDetails("Standare E-Mail");
        notificationLog.setNotificationRecipients("bob@example.com");
        notificationLog.setStatus(14);
        notificationLog.setTimeNotificationSent(System.currentTimeMillis() / 1000L * 1000L);
        notificationLog.setPriority(3);
        notificationLog.setNotificationRuleId(8L);
        notificationLog.setNotificationRuleName("Alert On Anything Rule");
        notificationLog.setSiteId(7L);
        notificationLog.setSiteNodeName("Directory");
        notificationLog.setBranchNodePath("Directory");
        notificationLog.setReceivedProductFamilies(":FAMONE:");
        notificationLog.setReceivedEventCategories(":CATONE:");
        notificationLog.setFirstEventTime(DatabaseObjectTestBase.timestampFromString("2004-03-29T23:23:23.000-08:00"));
        notificationLog.setReceivedNumComputers(1400);
        notificationLog.setReceivedNumEvents(67000000);
        notificationLog.setConfiguredProductFamilies(":FAMONE:FAMTWO:FAMTHREE:");
        notificationLog.setConfiguredEventCategories(":FAMTWO:CATTWO:CATTHRE:");
        notificationLog.setThreatText("Beagle");
        notificationLog.setThreatTextOperator("contains");
        notificationLog.setReceivedThreatNames("Beagle;Harpy;Netsky");
        notificationLog.setSourceComputers("larry;curly;mo");
        notificationLog.setAffectedComputerIPs("192.168.1.1;192.16.1.2;192.168.1.3");
        notificationLog.setAffectedComputerNames("one;two;three");
        notificationLog.setAffectedObjects("obj1;obj2;obj3");
        notificationLog.setAdditionalInformation("more;and more;and then more");
        notificationLog.setMessageSubject("Alert! Barbarians at the gate!");
        notificationLog.setMessageBody("The little brown cow jumped over the fence, and so did 1400 of our computers!");
        notificationLog.setActionOutput("NMap found an XBox sneaking on your network at xxx");
        notificationLog.setEventIDs("1001;1002;1003;1004;1005");
        notificationLog.setEventDescriptions("desc1;description number two;D#3");
        return notificationLog;
    }

    public static final NotificationLog createAggregatedTestLog() throws DateParserException {
        NotificationLog notificationLog = DatabaseObjectTestBase.createTestLog();
        notificationLog.setConfiguredProductFamilies(":DRAHN:EPOAGENT:EPOSERVER:VSCAN:UNKNOWN_PRODUCT:");
        notificationLog.setConfiguredEventCategories(":NON_COMPLIANCE:NORMAL_OPERATION:SOFTWARE_DEPLOY_FAILED:VIRUS_DETECTED_NOT_REMOVED:UNKNOWN_CATEGORY:");
        notificationLog.addEventID("50");
        notificationLog.addEventID("53");
        notificationLog.addEventID("475");
        notificationLog.addEventID("464");
        notificationLog.addEventID("13000");
        notificationLog.addEventID("52");
        notificationLog.addEventID("13201");
        notificationLog.addEventID("466");
        notificationLog.addEventID("13305");
        notificationLog.addEventID("13500");
        notificationLog.addEventID("13256");
        notificationLog.addEventID("8");
        notificationLog.addEventID("51");
        notificationLog.addReceivedProductFamily("EPOSERVER");
        notificationLog.addReceivedProductFamily("VSCAN");
        notificationLog.addReceivedEventCategory("VIRUS_DETECTED_NOT_REMOVED");
        notificationLog.addReceivedEventCategory("NON_COMPLIANCE");
        notificationLog.addThreatName("Beagle");
        notificationLog.addThreatName("Nachi");
        notificationLog.addThreatName("Wowzer");
        notificationLog.addSourceComputer("192.168.1.1");
        notificationLog.addSourceComputer("192.168.1.100");
        notificationLog.addSourceComputer("192.168.1.104");
        notificationLog.addSourceComputer("192.168.1.120");
        notificationLog.addSourceComputer("192.168.1.101");
        notificationLog.addAffectedComputerIP("192.168.1.2");
        notificationLog.addAffectedComputerIP("192.168.1.3");
        notificationLog.addAffectedComputerIP("192.168.1.4");
        notificationLog.addAffectedComputerIP("192.168.1.5");
        notificationLog.addAffectedComputerIP("192.168.1.6");
        notificationLog.addAffectedComputerIP("192.168.1.7");
        notificationLog.addAffectedComputerNames("Stealth Bunny");
        notificationLog.addAffectedComputerNames("L33t lU5or");
        return notificationLog;
    }

    public static final void assertNotEquals(Object object, Object object2) {
        if (object == null && object2 != null) {
            return;
        }
        if (object != null && object2 == null) {
            return;
        }
        if (object == null && object2 == null) {
            Assert.fail((String)"Expected to be unequal; got two nulls!");
        }
        if (object.equals(object2)) {
            Assert.fail((String)("Expected to be non-equal:" + object + " " + object2));
        }
    }

    public static final void assertNotEquals(int n, int n2) {
        DatabaseObjectTestBase.assertNotEquals(new Integer(n), new Integer(n2));
    }

    public static final void assertNotEquals(long l, long l2) {
        DatabaseObjectTestBase.assertNotEquals(new Long(l), new Long(l2));
    }

    public static final void assertNotEquals(boolean bl, boolean bl2) {
        DatabaseObjectTestBase.assertNotEquals(new Boolean(bl), new Boolean(bl2));
    }

    public void testProperties(DatabaseObject databaseObject) {
        int n = 1;
        while (n < databaseObject.getNumColumns()) {
            try {
                databaseObject.getProperty(n);
            }
            catch (Exception exception) {
                Assert.fail((String)("Error:" + exception + "getProperty failed for class " + databaseObject.getClass().toString() + " property index:" + n));
            }
            ++n;
        }
    }
}

