/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ruleEngine.rules;

import com.mcafee.epo.notifications.ruleEngine.MessageAdaptorInterface;
import com.mcafee.epo.notifications.ruleEngine.messages.JDomFixture;
import com.mcafee.epo.notifications.ruleEngine.rules.IsXmlRule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class HandleEpoMultiEventRule
extends IsXmlRule {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ruleEngine$rules$HandleEpoMultiEventRule == null ? (class$com$mcafee$epo$notifications$ruleEngine$rules$HandleEpoMultiEventRule = HandleEpoMultiEventRule.class$("com.mcafee.epo.notifications.ruleEngine.rules.HandleEpoMultiEventRule")) : class$com$mcafee$epo$notifications$ruleEngine$rules$HandleEpoMultiEventRule));
    static final String EPO_MULTI_EVENT_SIGNATURE = "epoMultipleEventContainer";
    static final String MACHINE_INFO = "MachineInfo";
    static final String PRODUCTS = "Product";
    static final String EVENT_LIST = "EventList";
    static final String EVENT_TAG = "event";
    private Element productNode = null;
    private Element eventNode = null;
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ruleEngine$rules$HandleEpoMultiEventRule;

    public boolean evaluate(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        Document document = (Document)messageAdaptorInterface.getMessage();
        Element element = document.getRootElement();
        String string = element.getName();
        m_log.debug((Object)("Check for EPO_MULTI_EVENT_SIGNATURE in " + string));
        if (string != null) {
            try {
                m_log.debug((Object)("*****************\n" + messageAdaptorInterface.getFixture().toString(messageAdaptorInterface.getMessage()) + "\n*****************"));
                List list = element.getChildren(PRODUCTS);
                if (list.size() == 0) {
                    throw new NotMultiEventException();
                }
                m_log.debug((Object)("I found these products: " + list));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.productNode = (Element)iterator.next();
                    m_log.debug((Object)("Product: " + this.productNode.getAttributeValue("ProductName")));
                    if (this.productNode == null) {
                        throw new NotMultiEventException();
                    }
                    Element element2 = this.productNode.getChild(EVENT_LIST);
                    m_log.debug((Object)("I found an eventList: " + element2));
                    if (element2 == null) {
                        throw new NotMultiEventException();
                    }
                    List list2 = element2.getChildren(EVENT_TAG);
                    m_log.debug((Object)("I found events: " + list2));
                    if (list2.size() == 0) {
                        throw new NotMultiEventException();
                    }
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        this.eventNode = (Element)iterator2.next();
                        m_log.debug((Object)("Processing event: " + this.eventNode.getAttribute("format")));
                        messageAdaptorInterface.setFixture(new JDomMultiEventFixture());
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("..............\n" + messageAdaptorInterface.getFixture().toString(messageAdaptorInterface.getMessage()) + "\n.............."));
                        }
                        this.doTrueRules(messageAdaptorInterface, hashtable);
                    }
                }
                m_log.debug((Object)"================= Processing of this message is done =================");
                return true;
            }
            catch (NotMultiEventException notMultiEventException) {
                // empty catch block
            }
        }
        this.doFalseRules(messageAdaptorInterface, hashtable);
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class JDomMultiEventFixture
    extends JDomFixture {
        static final String PRODUCT_SECTION = "*.Product.";
        static final String EVENT_SECTION = "*.Product.EventList.event.";
        static final String EVENT_TYPE = "*.Product.EventList.event.format";

        JDomMultiEventFixture() {
        }

        public Object get(Object object, Object object2) {
            String string = object2.toString();
            Object object3 = null;
            m_log.debug((Object)("GET: " + string));
            if (string.startsWith(EVENT_SECTION)) {
                m_log.debug((Object)("Process event section: " + string.substring(EVENT_SECTION.length())));
                object3 = this.getValueFromElement(HandleEpoMultiEventRule.this.eventNode, "*." + string.substring(EVENT_SECTION.length()));
            } else if (string.startsWith(PRODUCT_SECTION)) {
                m_log.debug((Object)("Process product section: " + string.substring(PRODUCT_SECTION.length())));
                object3 = this.getValueFromElement(HandleEpoMultiEventRule.this.productNode, "*." + string.substring(PRODUCT_SECTION.length()));
            } else {
                object3 = super.get(object, object2);
            }
            return object3 != null ? object3 : null;
        }

        public String getSecondMarker(MessageAdaptorInterface messageAdaptorInterface) {
            String string = (String)this.get(messageAdaptorInterface, EVENT_TYPE);
            return string != null ? string : "";
        }

        private Document createFromVirtualDocument(Document document) {
            Element element = (Element)document.getRootElement().clone();
            Document document2 = new Document(element);
            element.removeChildren(HandleEpoMultiEventRule.PRODUCTS);
            Element element2 = (Element)HandleEpoMultiEventRule.this.productNode.clone();
            element2.removeChildren(HandleEpoMultiEventRule.EVENT_LIST);
            element.addContent(element2);
            element2.addContent(new Element(HandleEpoMultiEventRule.EVENT_LIST).addContent((Element)HandleEpoMultiEventRule.this.eventNode.clone()));
            return document2;
        }

        public String toString(Object object) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLOutputter xMLOutputter = new XMLOutputter();
            xMLOutputter.setTextTrim(true);
            xMLOutputter.setIndent(" ");
            xMLOutputter.setNewlines(true);
            try {
                Document document = (Document)object;
                xMLOutputter.output(this.createFromVirtualDocument(document), (OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                m_log.debug((Object)"this errror should never be displayed...", (Throwable)iOException);
            }
            return byteArrayOutputStream.toString();
        }
    }

    class NotMultiEventException
    extends Exception {
        NotMultiEventException() {
        }
    }
}

