/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui;

import com.mcafee.epo.common.db.Tool;
import com.mcafee.epo.common.db.ToolRegistry;
import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.ui.SaveExeAction;
import com.mcafee.epo.notifications.ui.util.SessionUtil;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public class DisplayCommandsAction
extends ActionBeanBase {
    protected EpoUser m_epoUser = null;
    boolean m_canEdit = false;
    private boolean m_isLocal = false;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        this.m_isLocal = Server.isLocal(httpServletRequest);
        this.m_epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        return null;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.m_canEdit = SessionUtil.canEdit(this.m_epoUser);
        Vector vector = SaveExeAction.saveRegisteredExes(httpServletRequest);
        httpServletRequest.setAttribute("toolsCommandToolbar", (Object)this.getCmdToolbarHtml());
        httpServletRequest.setAttribute("toolsCommandTable", (Object)this.getCmdTableHtml());
        httpServletRequest.setAttribute("toolsExeToolbar", (Object)this.getExeToolbarHtml());
        httpServletRequest.setAttribute("toolsExeTable", (Object)this.getExeTableHtml(vector));
        return "commands.jsp";
    }

    private String getCmdToolbarHtml() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<table id='toolbar1' cellSpacing=3 cellPadding=3 border=0 class='Toolbar' width='100%'>\n").append("<tr valign=center>\n<td>");
        if (this.m_canEdit) {
            if (Server.getToolRegistry().getExeCount() > 0) {
                stringBuffer.append("<a href=\"Javascript:doAction( 'createcommand.do' )\"> ").append("<img src='images/AddItem.gif' align=absMiddle border=0 />");
            } else {
                stringBuffer.append("<a style='CURSOR:default; color:#AAAAAA' ").append("title='").append(Resource.getString("commands_req_at_least_one_reg_exe", this.m_lang)).append("' >").append("<img src='images/AddItemDisabled.gif' align=absMiddle border=0 />");
            }
        } else {
            stringBuffer.append("<a style='CURSOR:default; color:#AAAAAA' > ").append("<img src='images/AddItemDisabled.gif' align=absMiddle border=0 />");
        }
        stringBuffer.append(" ").append(Resource.getString("commands_add_command_line", this.m_lang)).append("</a>\n</td></tr></table>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCmdTableHtml() throws Exception {
        HtmlTable htmlTable = new HtmlTable();
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        htmlTable.setId("cmdTable");
        htmlTableHeader.addCell(Resource.getString("common_name", this.m_lang));
        htmlTableHeader.addCell(Resource.getString("common_registered_executable", this.m_lang));
        htmlTableHeader.addCell(Resource.getString("common_arguments", this.m_lang));
        htmlTableHeader.addCell(Resource.getString("common_delete", this.m_lang));
        Tool[] toolArray = Server.getTools();
        Tool tool = null;
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        if (toolArray != null) {
            Connection connection = null;
            try {
                connection = Server.getDb().getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < toolArray.length) {
                    tool = toolArray[n];
                    String string = "editCmd(\"" + tool.getId() + "\")";
                    htmlTableRow = htmlTable.addRow();
                    htmlTableCell = htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)tool.getDisplayName()));
                    if (this.m_canEdit) {
                        htmlTableCell.setOnClick(string);
                    }
                    htmlTableCell = htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)tool.getExeName()));
                    if (this.m_canEdit) {
                        htmlTableCell.setOnClick(string);
                    }
                    htmlTableCell = htmlTableRow.addCell(StringUtil.addNbsp((String)StringEscapeUtils.escapeHtml((String)tool.getCmdLine())));
                    if (this.m_canEdit) {
                        htmlTableCell.setOnClick(string);
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    if (this.m_canEdit) {
                        if (ToolRegistry.isCmdLineUsedByResponse((Connection)connection, (int)tool.getId())) {
                            htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' alt='" + Resource.getString("commands_command_line_in_use") + "' title='" + Resource.getString("commands_command_line_in_use") + "' ");
                            htmlTableCell.setStyle("cursor:default");
                        } else {
                            htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItem.gif' alt='" + Resource.getString("commands_delete_command_line", this.m_lang) + "' " + "title='" + Resource.getString("commands_delete_command_line", this.m_lang) + "'>");
                            htmlTableCell.setOnClick("deleteCmd(\"" + tool.getId() + "\")");
                        }
                    } else {
                        htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' alt='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "' " + "title='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "'>");
                        htmlTableCell.setStyle("cursor:default");
                    }
                    htmlTableCell.setAlign("center");
                    ++n;
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            {
            }
        }
        return htmlTable.getHtml(this.m_lang);
    }

    private String getExeToolbarHtml() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<table id='toolbar2' cellSpacing=3 cellPadding=3 border=0 class='Toolbar' ").append("style='CURSOR: default;' width='100%'>\n").append("<tr valign=center><td>");
        if (this.m_canEdit) {
            if (this.m_isLocal) {
                stringBuffer.append("<a href=\"Javascript:doAction( 'createexe.do' )\" ").append("title='").append(Resource.getString("commands_add_registered_exe", this.m_lang)).append("'>").append("<img src='images/AddItem.gif' align=absMiddle border=0>");
            } else {
                stringBuffer.append("<a style='CURSOR:default; color:#AAAAAA' ").append("title='").append(Resource.getString("commands_must_be_on_local_machine", this.m_lang)).append("'>").append("<img src='images/AddItemDisabled.gif' align=absMiddle border=0>");
            }
        } else {
            stringBuffer.append("<a style='CURSOR:default; color:#AAAAAA' >").append("<img src='images/AddItemDisabled.gif' align=absMiddle border=0>");
        }
        stringBuffer.append(" ").append(Resource.getString("commands_add_registered_exe", this.m_lang)).append("</a>\n</td></tr></table>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExeTableHtml(Vector vector) throws Exception {
        HtmlTable htmlTable = new HtmlTable();
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        htmlTable.setId("exeTable");
        htmlTableHeader.addCell(Resource.getString("commands_name", this.m_lang));
        htmlTableHeader.addCell(Resource.getString("commands_path", this.m_lang));
        htmlTableHeader.addCell(Resource.getString("common_delete", this.m_lang));
        Connection connection = null;
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        String string = null;
        Iterator iterator = vector.iterator();
        try {
            connection = Server.getDb().getConnection();
            ToolRegistry toolRegistry = Server.getToolRegistry();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                htmlTableRow = htmlTable.addRow();
                if (this.m_isLocal) {
                    htmlTableCell = htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)string));
                    if (this.m_canEdit) {
                        htmlTableCell.setOnClick("editExe(event)");
                    }
                    htmlTableCell = htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)toolRegistry.getExeCommand(string)));
                    if (this.m_canEdit) {
                        htmlTableCell.setOnClick("editExe(event)");
                    }
                    if (this.m_canEdit) {
                        if (ToolRegistry.isExeUsedByCmdLine((Connection)connection, (String)string, (int)2)) {
                            htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' align=absMiddle border=0alt='" + Resource.getString("commands_registered_exe_in_use", this.m_lang) + "' title='" + Resource.getString("commands_registered_exe_in_use", this.m_lang) + "' ");
                            htmlTableCell.setStyle("cursor:default");
                        } else {
                            htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItem.gif' align=absMiddle border=0alt='" + Resource.getString("commands_delete_registered_exe", this.m_lang) + "' title='" + Resource.getString("commands_delete_registered_exe", this.m_lang) + "' ");
                            htmlTableCell.setOnClick("deleteExe(event)");
                        }
                    } else {
                        htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' align=absMiddle border=0alt='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "' title='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "' ");
                        htmlTableCell.setStyle("cursor:default");
                    }
                    htmlTableCell.setAlign("center");
                    continue;
                }
                htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)string));
                htmlTableRow.addCell(StringEscapeUtils.escapeHtml((String)toolRegistry.getExeCommand(string)));
                htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' align=absMiddle border=0alt='" + Resource.getString("commands_delete_registered_exe_local_only", this.m_lang) + "' title='" + Resource.getString("commands_delete_registered_exe_local_only", this.m_lang) + "' ");
                htmlTableCell.setStyle("cursor:default");
                htmlTableCell.setAlign("center");
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {}
        return htmlTable.getHtml(this.m_lang);
    }
}

