/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui;

import com.mcafee.epo.common.db.destination.DestinationTable;
import com.mcafee.epo.common.ui.tables.HtmlTable;
import com.mcafee.epo.common.ui.tables.HtmlTableCell;
import com.mcafee.epo.common.ui.tables.HtmlTableHeader;
import com.mcafee.epo.common.ui.tables.HtmlTableRow;
import com.mcafee.epo.core.db.EpoUser;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBeanBase;
import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.notifications.ui.util.SessionUtil;
import com.mcafee.epo.notifications.util.Resource;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DisplayDestinationsActionBase
extends ActionBeanBase {
    protected String m_returnPage = null;
    protected EpoUser m_epoUser = null;

    public abstract DestinationTable[] getTableData() throws SQLException;

    public abstract String getThirdColumnLabel(String var1);

    public abstract int countActionsWithUse(long var1) throws SQLException;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        this.m_epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        return null;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        DestinationTable[] destinationTableArray = this.getTableData();
        HtmlTable htmlTable = null;
        HtmlTableHeader htmlTableHeader = null;
        htmlTable = new HtmlTable();
        htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.addCell(Resource.getString("genericdestination_name", this.m_lang));
        htmlTableHeader.addCell(this.getThirdColumnLabel(this.m_lang));
        htmlTableHeader.addCell(Resource.getString("common_delete", this.m_lang));
        this.addRows(htmlTable, destinationTableArray, httpServletRequest);
        httpServletRequest.setAttribute("genericDestTable", (Object)htmlTable.getHtml(this.m_lang));
        return this.m_returnPage;
    }

    private void addRows(HtmlTable htmlTable, DestinationTable[] destinationTableArray, HttpServletRequest httpServletRequest) throws Exception {
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        int n = 0;
        int n2 = destinationTableArray.length;
        DestinationTable destinationTable = null;
        while (n < n2) {
            destinationTable = destinationTableArray[n];
            htmlTableRow = htmlTable.addRow(4);
            htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)destinationTable.getName()));
            htmlTableCell.setId("row_" + n);
            if (SessionUtil.canEdit(httpServletRequest)) {
                htmlTableCell.setOnClick("editItem(" + destinationTable.getId() + ")");
            }
            htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)destinationTable.getThirdColumnValue()));
            if (SessionUtil.canEdit(httpServletRequest)) {
                htmlTableCell.setOnClick("editItem(" + destinationTable.getId() + ")");
            }
            if (!SessionUtil.canEdit(httpServletRequest)) {
                htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' alt='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "' " + "title='" + Resource.getString("genericdestination_cannot_delete_no_perms", this.m_lang) + "' ");
                htmlTableCell.setStyle("cursor:default");
            } else if (this.countActionsWithUse(destinationTable.getId()) != 0) {
                String string = Resource.formatString("genericdestination_in_use", this.getThirdColumnLabel(this.m_lang), this.m_lang);
                htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItemDisabled.gif' alt='" + string + "' title='" + string + "' ");
                htmlTableCell.setStyle("cursor:default");
            } else {
                htmlTableCell = htmlTableRow.addCell("<img src='images/DeleteItem.gif' alt='" + Resource.getString("common_delete", this.m_lang) + "' " + "title='" + Resource.getString("common_delete", this.m_lang) + "' " + "onclick='deleteItem(" + destinationTable.getId() + ")' " + "style='cursor:pointer;'>");
            }
            htmlTableCell.setAlign("center");
            ++n;
        }
    }
}

