/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.notifications.ui;

import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.notifications.db.AlertUserRule;
import com.mcafee.epo.notifications.db.TokenList;
import com.mcafee.epo.notifications.ruleEngine.MessageAdaptorInterface;
import com.mcafee.epo.notifications.ruleEngine.rules.UserNotificationRule;
import com.mcafee.epo.notifications.ruleEngine.rules.notificationTarget.NotificationTargetBase;
import com.mcafee.epo.notifications.ruleEngine.service.RuleEngineSingleton;
import com.mcafee.epo.notifications.server.Server;
import com.mcafee.epo.notifications.ui.ActionValidatorBase;
import com.mcafee.epo.notifications.ui.UserRuleBean;
import com.mcafee.epo.notifications.ui.util.SessionUtil;
import com.mcafee.epo.notifications.util.Resource;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class VerifyNotTargetAction
extends ActionValidatorBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction == null ? (class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction = VerifyNotTargetAction.class$("com.mcafee.epo.notifications.ui.VerifyNotTargetAction")) : class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction));
    public static final String BEAN_ID = "userRuleBean";
    int m_index = -1;
    AlertUserRule m_rule = null;
    NotificationTargetBase m_target = null;
    static /* synthetic */ Class class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction;

    public String setError(HttpServletRequest httpServletRequest, String string, String string2) {
        Logger.getLogger((Class)(class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction == null ? (class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction = VerifyNotTargetAction.class$("com.mcafee.epo.notifications.ui.VerifyNotTargetAction")) : class$com$mcafee$epo$notifications$ui$VerifyNotTargetAction)).error((Object)(Resource.getString(string) + "\n" + Resource.getString(string2)));
        SessionUtil.setActionTakenPageAttr(httpServletRequest, Resource.getString(string, this.m_lang), Resource.getString(string2, this.m_lang), "createrule.do");
        return "actiontaken.jsp";
    }

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        this.m_rule = UserRuleBean.getFromInternalSessionMap(httpServletRequest.getParameter("SESSIONID"));
        if (this.m_rule == null) {
            return this.setError(httpServletRequest, "testnottargetaction_validationfailed", "testnottargetaction_nouserrule");
        }
        Vector vector = this.m_rule.getNotificationTargets();
        if (vector.size() == 0) {
            return this.setError(httpServletRequest, "testnottargetaction_validationfailed", "testnottargetation_notargets");
        }
        if (this.m_index == -1) {
            return this.setError(httpServletRequest, "testnottargetaction_validationfailed", "testnottargetaction_indexnotset");
        }
        this.m_target = (NotificationTargetBase)vector.get(this.m_index);
        this.m_target.setIsSynchronous(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        m_log.debug((Object)"Calculating properties on the rule.");
        Connection connection = null;
        Connection connection2 = null;
        try {
            connection2 = Server.getDb().getConnection();
            connection = Server.getEpoDb().getConnection();
            this.m_rule.calculateProperties(connection2, connection, Server.getNotificationTargetFactory());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DatabaseUtil.close((Connection)connection2);
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection2);
        DatabaseUtil.close((Connection)connection);
        m_log.debug((Object)("Testing notification target: " + this.m_target));
        m_log.debug((Object)"Setting up an empty event message and associating with the rule.");
        MessageAdaptorInterface messageAdaptorInterface = RuleEngineSingleton.getSingleton().getMessageAdaptor();
        messageAdaptorInterface.setMessage("", System.currentTimeMillis());
        m_log.debug((Object)"Invoking test.");
        this.setupProgressListeners(this.m_target, httpServletResponse);
        this.m_target.evaluate(messageAdaptorInterface, this.generateFakeContext());
        this.removeProgressListeners(this.m_target);
        this.addPopupBottom(new BufferedWriter(httpServletResponse.getWriter()));
        return "popup_bottom.jsp";
    }

    private Hashtable generateFakeContext() {
        m_log.debug((Object)"Generating fake context.");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = TokenList.getTokenList(this.m_rule);
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            try {
                object = this.m_rule.getProperty(stringArray[n]);
            }
            catch (Exception exception) {
                m_log.debug((Object)("Couldn't find property in the rule for: " + stringArray[n] + " setting to default"));
                object = new String("test-" + stringArray[n] + "-test");
            }
            m_log.debug((Object)("Adding: " + stringArray[n] + " - Value: " + object));
            hashtable.put(stringArray[n], object);
            ++n;
        }
        m_log.debug((Object)"Adding the rule to the context.");
        hashtable.put(UserNotificationRule.RULE_OBJECT_TAG, (Object)this.m_rule);
        hashtable.put("FirstEventTime", new Timestamp(System.currentTimeMillis()));
        m_log.debug((Object)"Adding event 9999 as a HashMap to the test context.");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("9999", null);
        hashtable.put("EventIDs", hashMap);
        return hashtable;
    }

    public void setNotificationIndex(int n) {
        this.m_index = n;
    }

    public int getNotificationIndex() {
        return this.m_index;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

