/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.utility;

import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.db.base.Queries;
import com.mcafee.epo.core.util.BeanUtil;
import com.mcafee.epo.notifications.db.EventCategory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EventIdDatabase
implements Serializable {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$utility$EventIdDatabase == null ? (class$com$mcafee$epo$utility$EventIdDatabase = EventIdDatabase.class$("com.mcafee.epo.utility.EventIdDatabase")) : class$com$mcafee$epo$utility$EventIdDatabase));
    final String EVENTID_UNKNOWN = "UNKNOWN EVENT ID";
    Hashtable eventIds = new Hashtable();
    Hashtable unknownEventId = new Hashtable();
    static /* synthetic */ Class class$com$mcafee$epo$utility$EventIdDatabase;

    public EventIdDatabase() {
        this.unknownEventId.put("UNKNOWN EVENT ID", "UNKNOWN EVENT ID");
    }

    public Hashtable getEventIds() {
        return this.eventIds;
    }

    public void setEventIds(Hashtable hashtable) {
        this.eventIds = hashtable;
    }

    public Hashtable getProperties(String string) {
        Hashtable hashtable = this.eventIds == null ? (Hashtable)this.eventIds.get(string) : null;
        return hashtable != null ? hashtable : this.unknownEventId;
    }

    public void setProperties(String string, Hashtable hashtable) {
        this.eventIds.put(string, hashtable);
    }

    public void setProperty(String string, String string2, String string3) {
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this.eventIds.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.eventIds.put(string, hashtable);
        }
        hashtable.put(string2, string3);
    }

    public static EventIdDatabase load(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        EventIdDatabase eventIdDatabase = new EventIdDatabase();
        String string = null;
        while (reader != null) {
            try {
                string = bufferedReader.readLine();
                if (string == null) break;
                String[] stringArray = string.split("[ \t]*::[ \t]*");
                if (stringArray.length != 3) {
                    m_log.debug((Object)("Can't handle: " + string));
                    continue;
                }
                eventIdDatabase.setProperty(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (IOException iOException) {
                m_log.error((Object)"", (Throwable)iOException);
                break;
            }
        }
        return eventIdDatabase;
    }

    public static EventIdDatabase load(String string) throws FileNotFoundException, IOException {
        EventIdDatabase eventIdDatabase = null;
        eventIdDatabase = EventIdDatabase.load(new InputStreamReader(new FileInputStream(string)));
        return eventIdDatabase;
    }

    public static EventIdDatabase load(Connection connection) throws SQLException {
        EventIdDatabase eventIdDatabase = new EventIdDatabase();
        Vector vector = EventCategory.getAllEventIdsWithCategory(connection);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            EventCategory eventCategory = (EventCategory)((Object)iterator.next());
            eventIdDatabase.setProperty("" + eventCategory.getId(), eventCategory.getName(), "<not set>");
        }
        return eventIdDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        block5: {
            Database database = null;
            Connection connection = null;
            EventIdDatabase eventIdDatabase = null;
            System.out.println("Starting...");
            try {
                try {
                    Properties properties = new Properties();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("Alerting.properties"));
                    properties.load(bufferedInputStream);
                    ((InputStream)bufferedInputStream).close();
                    System.out.println(properties.toString());
                    database = new Database(properties, "alerting", Queries.VALIDATE_SALT_DB);
                    connection = database.getConnection();
                    eventIdDatabase = EventIdDatabase.load(connection);
                    BeanUtil.writeObject((OutputStream)System.out, (Object)eventIdDatabase);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    Object var7_9 = null;
                    DatabaseUtil.close(connection);
                    break block5;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_10 = null;
                    DatabaseUtil.close(connection);
                    break block5;
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                DatabaseUtil.close(connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
        }
        System.out.println("Done");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

