/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.repoman;

import com.mcafee.epo.common.server.ServerNative;
import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.webui.repoman.AgentPackage;
import com.mcafee.epo.webui.repoman.BackgroundSitelistUpdater;
import com.mcafee.epo.webui.repoman.RManJNI;
import com.mcafee.epo.webui.repoman.RManTst;
import com.mcafee.epo.webui.repoman.RepoLock;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RepositoryManager {
    private final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$webui$repoman$RepositoryManager == null ? (class$com$mcafee$epo$webui$repoman$RepositoryManager = RepositoryManager.class$("com.mcafee.epo.webui.repoman.RepositoryManager")) : class$com$mcafee$epo$webui$repoman$RepositoryManager));
    private boolean m_fSiteManagerXMLLocked = false;
    private long m_SiteManagerLockExpiresTime = 0L;
    private String m_SiteManagerLockedBy = null;
    public int m_iDebugLastMirrorResult = -3500;
    public int m_iDebugLastReplicationResult = -3500;
    private static RepositoryManager repositoryManager = new RepositoryManager();
    public AgentPackage m_agentPackage = new AgentPackage();
    public RManJNI m_rmanJNI = new RManJNI();
    public RManTst m_RManTst = new RManTst();
    public RepoLock m_RepoLock = new RepoLock();
    private boolean initialized = false;
    private String m_strGlobalAutoUpdateProductID = "";
    private boolean m_fGlobalAutoUpdatePending = false;
    private BackgroundSitelistUpdater m_bsu = new BackgroundSitelistUpdater();
    static /* synthetic */ Class class$com$mcafee$epo$webui$repoman$RepositoryManager;

    public synchronized void initialize() {
        this.m_log.debug((Object)"Repository Manager initializing");
        if (!this.initialized) {
            String string = EpoCore.getEpoDb().getEPOInstallDir() + "/RmanJNI.dll";
            this.m_log.debug((Object)("Repository Manager loading " + string));
            System.load(string);
            this.m_log.debug((Object)("Repository Manager loaded " + string));
            RepositoryManager.singleton().m_rmanJNI.BackgroundUpdateSiteList_JNI(false);
            this.m_log.info((Object)"Creating agent package(s)");
            RepositoryManager.singleton().m_agentPackage.InitAgentPackage_JNI(false);
            this.m_log.debug((Object)"Repository Manager Signaling ready event");
            RepositoryManager.singleton().m_rmanJNI.SignalOpenForBusiness_JNI();
            this.initialized = true;
        }
        this.m_log.debug((Object)"Repository Manager initialized");
    }

    void Exec_RepositoryUnlockedTrigger(int n) {
        block4: {
            if (n != 2 || !this.m_fGlobalAutoUpdatePending) break block4;
            String string = this.m_strGlobalAutoUpdateProductID;
            this.m_fGlobalAutoUpdatePending = false;
            try {
                String string2 = this.m_rmanJNI.CreateSuperAgentPingRequest_JNI(this.m_strGlobalAutoUpdateProductID);
                if (string2 == null) break block4;
                try {
                    ServerNative.processAgentWakeUpCall((String)string2);
                }
                catch (Exception exception) {
                    this.m_log.debug((Object)"Unhandled exception thrown by ServerNative.processAgentWakeUpCall()");
                }
            }
            catch (Exception exception) {
                this.m_log.debug((Object)"Unhandled exception thrown by m_rmanJNI.CreateSuperAgentPingRequest_JNI()");
            }
        }
    }

    public void TriggerBackgroundSitelistProcessing() {
        RepositoryManager.singleton().m_bsu.RunOnce();
    }

    public static RepositoryManager singleton() {
        return repositoryManager;
    }

    public void Shutdown() {
        this.m_bsu.cancel();
        this.m_bsu = null;
    }

    public synchronized void SetGlobalAutoUpdateProductID(String string) {
        this.m_strGlobalAutoUpdateProductID = string;
        this.m_fGlobalAutoUpdatePending = true;
    }

    public boolean Debug_GetSiteManagerLockedState() {
        long l = System.currentTimeMillis();
        boolean bl = this.m_fSiteManagerXMLLocked;
        if (this.m_SiteManagerLockExpiresTime < l) {
            bl = false;
        }
        return bl;
    }

    public long Debug_GetSiteManagerLockExpiresTime() {
        return this.m_SiteManagerLockExpiresTime;
    }

    public String Debug_GetSiteManagerLockedBy() {
        return this.m_SiteManagerLockedBy;
    }

    public boolean LockSiteManagerXML(String string) {
        long l = System.currentTimeMillis();
        if (this.m_fSiteManagerXMLLocked && string.compareTo(this.m_SiteManagerLockedBy) != 0 && this.m_SiteManagerLockExpiresTime >= l) {
            this.m_log.warn((Object)("Unable to lock sitemanager XML by " + string + ", already locked by " + this.m_SiteManagerLockedBy));
            return false;
        }
        this.m_SiteManagerLockedBy = string;
        this.m_SiteManagerLockExpiresTime = l + 300000L;
        this.m_fSiteManagerXMLLocked = true;
        return this.m_fSiteManagerXMLLocked;
    }

    public boolean LockRefreshSiteManagerXML(String string) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        if (this.m_fSiteManagerXMLLocked) {
            if (this.m_SiteManagerLockedBy != null) {
                if (string.compareTo(this.m_SiteManagerLockedBy) == 0) {
                    if (this.m_SiteManagerLockExpiresTime > l) {
                        this.m_SiteManagerLockExpiresTime = l + 300000L;
                        this.m_fSiteManagerXMLLocked = true;
                        bl = true;
                    } else {
                        this.m_log.warn((Object)("Unlock sitemanager requested by " + string + " but lock is expired.  Time now=" + l + ", expires=" + this.m_SiteManagerLockExpiresTime));
                    }
                } else {
                    this.m_log.warn((Object)("Failed to unlock sitemanager. Requested by " + string + " but locked by " + this.m_SiteManagerLockedBy));
                }
            } else {
                this.m_log.warn((Object)("Failed to unlock sitemanager. Requested by " + string + " but locked by " + this.m_SiteManagerLockedBy));
            }
        } else {
            this.m_log.warn((Object)"Failed to unlock sitemanager. Not currently locked");
        }
        return bl;
    }

    public boolean UnLockSiteManagerXML(String string) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        if (this.m_fSiteManagerXMLLocked) {
            if (this.m_SiteManagerLockedBy != null) {
                if (string.compareTo(this.m_SiteManagerLockedBy) == 0) {
                    if (this.m_SiteManagerLockExpiresTime > l) {
                        this.m_fSiteManagerXMLLocked = false;
                        bl = true;
                    } else {
                        this.m_log.warn((Object)("Unlock sitemanager requested by " + string + " but lock is expired.  Time now=" + l + ", expires=" + this.m_SiteManagerLockExpiresTime));
                    }
                } else {
                    this.m_log.warn((Object)("Failed to unlock sitemanager. Requested by " + string + " but locked by " + this.m_SiteManagerLockedBy));
                }
            } else {
                this.m_log.warn((Object)("Failed to unlock sitemanager. Requested by " + string + " but locked by " + this.m_SiteManagerLockedBy));
            }
        } else {
            this.m_log.warn((Object)"Failed to unlock sitemanager. Not currently locked");
        }
        return bl;
    }

    public static void SendRepomanErrorResponse(HttpServletResponse httpServletResponse, int n, Properties properties) {
        try {
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<RepomanResponse error=\"1\">");
            printWriter.println("<Message StringID=\"" + n + "\">");
            if (properties != null) {
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = properties.getProperty(string);
                    printWriter.println("<Param ID=\"" + string + "\">" + string2 + "</Param>");
                }
            }
            printWriter.println("</Message>");
            printWriter.println("</RepomanResponse>");
            printWriter.close();
        }
        catch (IOException iOException) {}
    }

    public static void SendRepomanErrorResponse(HttpServletResponse httpServletResponse, int n, String string, String string2, String string3, String string4) {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("%1", string);
        }
        if (string2 != null) {
            properties.setProperty("%1", string2);
        }
        if (string3 != null) {
            properties.setProperty("%1", string3);
        }
        if (string4 != null) {
            properties.setProperty("%1", string4);
        }
        RepositoryManager.SendRepomanErrorResponse(httpServletResponse, n, properties);
    }

    public static void SendRepomanSuccessResponse(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<RepomanResponse error=\"0\"><!-- 0 = No error -->");
            printWriter.println("</RepomanResponse>");
            printWriter.close();
        }
        catch (IOException iOException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

