/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler;

import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskSettingTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskTypeTable;
import com.mcafee.epo.webui.scheduler.schedule.Immediate;
import com.mcafee.epo.webui.scheduler.schedule.Once;
import com.mcafee.epo.webui.scheduler.schedule.Schedule;
import com.mcafee.epo.webui.scheduler.task.TaskDetail;
import com.mcafee.epo.webui.scheduler.util.SchedulerUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerEngine {
    private final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$webui$scheduler$SchedulerEngine == null ? (class$com$mcafee$epo$webui$scheduler$SchedulerEngine = SchedulerEngine.class$("com.mcafee.epo.webui.scheduler.SchedulerEngine")) : class$com$mcafee$epo$webui$scheduler$SchedulerEngine));
    private Map m_serverTaskTypeMap = new HashMap();
    private Map m_serverTaskByIdMap = new HashMap();
    private Map m_serverTaskSettingMap = new HashMap();
    private Database m_db = null;
    private static final int MODIF_UNCHANGED = 0;
    private static final int MODIF_NEW = 1;
    private static final int MODIF_SCHEDULE_CHANGED = 2;
    private static final int MODIF_DELETE = 3;
    public static final String DEFAULT_EPO_GROUP = "ePO Server Task Group";
    private static SchedulerEngine schedulerEngine = new SchedulerEngine();
    private boolean initialized = false;
    private Scheduler scheduler = null;
    static /* synthetic */ Class class$com$mcafee$epo$webui$scheduler$SchedulerEngine;
    static /* synthetic */ Class class$com$mcafee$epo$webui$scheduler$task$UnknownTask;

    private SchedulerEngine() {
    }

    public static SchedulerEngine singleton() {
        return schedulerEngine;
    }

    public synchronized void initialize() throws SchedulerException {
        if (!this.isInitialized()) {
            this.cleanUpServerTaskLog();
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            this.scheduler = stdSchedulerFactory.getScheduler();
            this.scheduler.start();
            this.m_log.debug((Object)("SchedulerClass: " + this.scheduler.getClass().getName()));
            this.loadExistingScheduledTasks();
            this.setInitialized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws SchedulerException {
        this.m_log.info((Object)"Scheduler shutdown called...");
        if (this.scheduler != null) {
            SchedulerEngine schedulerEngine = this;
            synchronized (schedulerEngine) {
                List list = this.scheduler.getCurrentlyExecutingJobs();
                this.m_log.info((Object)("Currently " + list.size() + " ServerTasks are running..."));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JobExecutionContext jobExecutionContext = (JobExecutionContext)iterator.next();
                    Job job = jobExecutionContext.getJobInstance();
                    this.m_log.info((Object)("Try to interrupt: " + job.toString()));
                    if (job instanceof InterruptableJob) {
                        try {
                            ((InterruptableJob)job).interrupt();
                        }
                        catch (UnableToInterruptJobException unableToInterruptJobException) {
                            this.m_log.error((Object)"Unable to interrupt job!", (Throwable)unableToInterruptJobException);
                        }
                    }
                    job = null;
                    jobExecutionContext = null;
                }
                this.scheduler.shutdown();
                this.setInitialized(false);
            }
        }
    }

    public void finalize() throws Throwable {
        this.m_log.info((Object)(this.getClass().getName() + " finalize called..."));
        this.shutdown();
        super.finalize();
    }

    private void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Database getDatabase() {
        if (this.m_db == null) {
            this.m_db = EpoCore.getEpoDb();
        }
        return this.m_db;
    }

    protected void setDatabase(Database database) {
        this.m_db = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanUpServerTaskLog() {
        Connection connection = null;
        try {
            try {
                this.m_log.info((Object)"Cleaning up ServerTask log entries...");
                connection = this.getDatabase().getConnection();
                Collection collection = ServerTaskLogTable.getInitCleanup(connection);
                connection.commit();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ServerTaskLogTable serverTaskLogTable = (ServerTaskLogTable)((Object)iterator.next());
                    this.m_log.info((Object)("Server Task " + serverTaskLogTable.getServerTaskName() + " has an invalid log status (" + serverTaskLogTable.getStatus() + "), setting log entry to FAILED."));
                    if (serverTaskLogTable.getStatus() == 4) {
                        this.m_log.debug((Object)("Deleting: " + serverTaskLogTable.getServerTaskName()));
                        DatabaseUtil.executeUpdate((Connection)connection, (String)("delete from ServerTaskLog where AutoID = " + serverTaskLogTable.getAutoID()));
                    } else {
                        this.m_log.debug((Object)("Marking " + serverTaskLogTable.getServerTaskName() + " as FAILED..."));
                        serverTaskLogTable.setStatus(3);
                        serverTaskLogTable.update(connection);
                    }
                    connection.commit();
                }
            }
            catch (Exception exception) {
                this.m_log.warn((Object)("ServerTaskLog cleanup failed on Scheduler initialization: " + exception.toString()), (Throwable)exception);
                Object var6_7 = null;
                DatabaseUtil.close((Connection)connection);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    private void loadExistingScheduledTasks() throws SchedulerException {
        Connection connection = null;
        try {
            try {
                connection = this.getDatabase().getConnection();
                this.loadServerTaskTypeMap(connection);
                this.loadServerTaskMap(connection);
                Iterator iterator = this.m_serverTaskByIdMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    this.loadServerTaskSettingMap(connection, n);
                }
            }
            catch (Exception exception) {
                throw new SchedulerException("Problem loading Server Tasks: " + exception.getMessage(), exception);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        this.scheduleExistingTasks();
    }

    private void loadServerTaskTypeMap() throws SchedulerException {
        Connection connection = null;
        try {
            try {
                connection = this.getDatabase().getConnection();
                this.loadServerTaskTypeMap(connection);
            }
            catch (Exception exception) {
                throw new SchedulerException("Problem loading Server Tasks: " + exception.getMessage(), exception);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    private void loadServerTaskTypeMap(Connection connection) throws SchedulerException {
        try {
            Collection collection = ServerTaskTypeTable.getAllTasks(connection);
            if (collection != null) {
                this.m_serverTaskTypeMap.clear();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ServerTaskTypeTable serverTaskTypeTable = (ServerTaskTypeTable)((Object)iterator.next());
                    this.addServerTaskType(serverTaskTypeTable.getTaskTypeCode(), serverTaskTypeTable);
                }
            } else {
                this.m_log.error((Object)"Failed to read the ePO database.");
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Load Existing Scheduled Tasks failed: " + exception.getMessage(), exception);
        }
    }

    private void addServerTaskType(String string, ServerTaskTypeTable serverTaskTypeTable) {
        this.m_serverTaskTypeMap.put(string, serverTaskTypeTable);
    }

    private ServerTaskTypeTable getServerTaskType(String string) {
        return (ServerTaskTypeTable)((Object)this.m_serverTaskTypeMap.get(string));
    }

    private void loadServerTaskMap() throws SchedulerException {
        Connection connection = null;
        try {
            try {
                connection = this.getDatabase().getConnection();
                this.loadServerTaskMap(connection);
            }
            catch (Exception exception) {
                throw new SchedulerException("Problem loading Server Tasks: " + exception.getMessage(), exception);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    private void loadServerTaskMap(Connection connection) throws SchedulerException {
        try {
            Collection collection = ServerTaskTable.getAllTasks(connection);
            if (collection != null) {
                this.m_serverTaskByIdMap.clear();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ServerTaskTable serverTaskTable = (ServerTaskTable)((Object)iterator.next());
                    if (this.deleteTask(connection, serverTaskTable)) continue;
                    this.addServerTaskById(serverTaskTable.getTaskId(), serverTaskTable);
                    this.m_log.debug((Object)("ServerTask: \n" + serverTaskTable.toString()));
                }
            } else {
                this.m_log.warn((Object)"No Server Tasks available in the ePO database.");
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Load Existing Scheduled Tasks failed: " + exception.getMessage(), exception);
        }
    }

    private boolean deleteTask(Connection connection, ServerTaskTable serverTaskTable) throws Exception {
        boolean bl = false;
        if (serverTaskTable.getModifState() == 3) {
            this.deleteTask(serverTaskTable.getTaskId());
            bl = true;
            PreparedStatement preparedStatement = connection.prepareStatement("delete from ServerTask where AutoID = ?");
            preparedStatement.setInt(1, serverTaskTable.getTaskId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            PreparedStatement preparedStatement2 = connection.prepareStatement("delete from ServerTaskSetting where ParentID = ?");
            preparedStatement2.setInt(1, serverTaskTable.getTaskId());
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
            connection.commit();
            this.m_log.debug((Object)("Deleting task (" + serverTaskTable.getTaskId() + "): " + serverTaskTable.toString()));
        }
        return bl;
    }

    private boolean deleteTask(int n) throws Exception {
        this.m_log.debug((Object)("Deleting task: " + n));
        boolean bl = this.scheduler.deleteJob(Integer.toString(n), DEFAULT_EPO_GROUP);
        this.m_log.debug((Object)("Did Delete: " + bl));
        return bl;
    }

    private void addServerTaskById(int n, ServerTaskTable serverTaskTable) {
        this.m_serverTaskByIdMap.put(new Integer(n), serverTaskTable);
    }

    public Collection getServerTasks() {
        return this.m_serverTaskByIdMap.values();
    }

    private ServerTaskTable getServerTaskById(int n) {
        return (ServerTaskTable)((Object)this.m_serverTaskByIdMap.get(new Integer(n)));
    }

    private void loadServerTaskSettingMap(int n) throws SchedulerException {
        Connection connection = null;
        try {
            try {
                connection = this.getDatabase().getConnection();
                this.loadServerTaskSettingMap(connection, n);
            }
            catch (Exception exception) {
                throw new SchedulerException("Load Existing Scheduled Tasks failed: " + exception.getMessage(), exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    private void loadServerTaskSettingMap(Connection connection, int n) throws SchedulerException {
        try {
            this.m_serverTaskSettingMap.remove(new Integer(n));
            Collection collection = ServerTaskSettingTable.getByTaskId(connection, n);
            this.m_log.debug((Object)("Number of settings for " + n + ": " + collection.size()));
            if (collection != null) {
                this.m_serverTaskSettingMap.put(new Integer(n), collection);
            } else {
                this.m_log.error((Object)"Failed to read the ePO database.  No settings found.");
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Load Existing Scheduled Tasks failed: " + exception.getMessage(), exception);
        }
    }

    private Collection getServerTaskSetting(int n) {
        return (Collection)this.m_serverTaskSettingMap.get(new Integer(n));
    }

    private void scheduleExistingTasks() throws SchedulerException {
        this.m_log.debug((Object)"Creating Scheduleable Tasks");
        Iterator iterator = this.m_serverTaskByIdMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            if (0 != this.handleModifState(n)) continue;
            this.scheduleTask(n);
        }
        this.dumpJobsAndTriggers(null);
    }

    public void reloadAllServerTasks() throws SchedulerException {
        this.shutdown();
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int handleModifState(Integer n) throws SchedulerException {
        ServerTaskTable serverTaskTable = (ServerTaskTable)((Object)this.m_serverTaskByIdMap.get(n));
        int n2 = serverTaskTable.getModifState();
        if (serverTaskTable.getModifState() == 0) {
            return n2;
        }
        if (serverTaskTable.getModifState() == 1 || serverTaskTable.getModifState() == 2) {
            this.loadServerTaskSettingMap(n);
            TaskDetail taskDetail = this.createTaskDetail(n);
            if (serverTaskTable.getModifState() == 2) {
                if ("NEVER".equals(serverTaskTable.getNextRunTime())) {
                    serverTaskTable.setNextRunTime("0");
                }
                try {
                    this.deleteTask(taskDetail.getTaskId());
                }
                catch (Exception exception) {
                    this.m_log.error((Object)("Unable to delete existing scheduled task: " + exception.getMessage()), (Throwable)exception);
                }
            }
            Connection connection = null;
            try {
                try {
                    connection = this.getDatabase().getConnection();
                    serverTaskTable.setModifState(0);
                    serverTaskTable.update(connection);
                    connection.commit();
                }
                catch (Exception exception) {
                    throw new SchedulerException("Problem updating Server Tasks: " + exception.getMessage(), exception);
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            this.scheduleTask(taskDetail);
            return n2;
        }
        if (serverTaskTable.getModifState() != 3) return n2;
        Connection connection = null;
        try {
            try {
                this.m_log.debug((Object)"In handleModifState, trying to delete...");
                connection = this.getDatabase().getConnection();
                boolean bl = this.deleteTask(connection, serverTaskTable);
                this.m_log.debug((Object)("In handleModifState, deleting task " + serverTaskTable.getTaskId() + ": " + bl));
            }
            catch (Exception exception) {
                throw new SchedulerException("Unable to delete task: " + exception.getMessage(), exception);
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return n2;
    }

    public void loadNewOrChangedServerTasks() throws Exception {
        this.loadServerTaskMap();
        Iterator iterator = this.m_serverTaskByIdMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            this.handleModifState(n);
        }
        this.dumpJobsAndTriggers(null);
    }

    private void dumpJobsAndTriggers(PrintWriter printWriter) {
        block9: {
            if (!this.m_log.isDebugEnabled() && printWriter == null) break block9;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                String[] stringArray = this.scheduler.getJobNames(DEFAULT_EPO_GROUP);
                if (stringArray == null || stringArray.length == 0) {
                    this.m_log.debug((Object)"No jobs!\n");
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        JobDetail jobDetail = this.scheduler.getJobDetail(stringArray[n], DEFAULT_EPO_GROUP);
                        stringBuffer.append("\nTaskName: ").append(jobDetail.getJobDataMap().getString("NAME"));
                        stringBuffer.append("\n  TaskID: ").append(jobDetail.getJobDataMap().getString("TASKID"));
                        Trigger[] triggerArray = this.scheduler.getTriggersOfJob(stringArray[n], DEFAULT_EPO_GROUP);
                        if (triggerArray == null || triggerArray.length == 0) {
                            stringBuffer.append("\n  Not scheduled!");
                        } else {
                            int n2 = 0;
                            while (n2 < triggerArray.length) {
                                stringBuffer.append("\n  Schedule: ").append(triggerArray[n2].getName());
                                stringBuffer.append("\n    StartTime:").append(triggerArray[n2].getStartTime());
                                stringBuffer.append("\n    EndTime:  ").append(triggerArray[n2].getEndTime());
                                stringBuffer.append("\n    NextTime: ").append(triggerArray[n2].getNextFireTime());
                                stringBuffer.append("\n    PrevTime: ").append(triggerArray[n2].getPreviousFireTime());
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    this.m_log.debug((Object)("Current scheduled tasks in SchedulerEngine memory:\n" + stringBuffer.toString() + "\n"));
                }
                if (printWriter != null) {
                    printWriter.println(stringBuffer.toString());
                }
            }
            catch (Exception exception) {
                this.m_log.debug((Object)"Job Info log creation failed... ", (Throwable)exception);
                if (printWriter == null) break block9;
                exception.printStackTrace(printWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(PrintWriter printWriter) {
        this.dumpJobsAndTriggers(printWriter);
        try {
            SchedulerEngine schedulerEngine = this;
            synchronized (schedulerEngine) {
                List list = this.scheduler.getCurrentlyExecutingJobs();
                printWriter.println("Currently " + list.size() + " ServerTasks are running...");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JobExecutionContext jobExecutionContext = (JobExecutionContext)iterator.next();
                    Job job = jobExecutionContext.getJobInstance();
                    printWriter.println(" - Job: " + job.toString());
                }
            }
        }
        catch (SchedulerException schedulerException) {
            schedulerException.printStackTrace(printWriter);
        }
    }

    public void runTaskNow(int n) throws SchedulerException {
        TaskDetail taskDetail = this.createTaskDetail(n);
        JobDetail jobDetail = this.getSchedulerJobDetail(taskDetail);
        jobDetail.getJobDataMap().put("RUNNOW", "true");
        Immediate immediate = new Immediate();
        Trigger trigger = (Trigger)immediate.getTriggers().iterator().next();
        trigger.setJobName(Integer.toString(n));
        trigger.setJobGroup(jobDetail.getGroup());
        this.m_log.debug((Object)("RunTaskNow: Scheduling and adding immediate trigger for " + jobDetail.getName() + " - " + taskDetail.getName()));
        this.scheduler.scheduleJob(trigger);
    }

    public TaskDetail createTaskDetail(int n) throws SchedulerException {
        ServerTaskTypeTable serverTaskTypeTable;
        TaskDetail taskDetail = new TaskDetail();
        ServerTaskTable serverTaskTable = this.getServerTaskById(n);
        if (serverTaskTable == null) {
            this.loadServerTaskMap();
            serverTaskTable = this.getServerTaskById(n);
            if (serverTaskTable == null) {
                throw new SchedulerException("Unable to find task with associated taskId: " + n);
            }
        }
        if ((serverTaskTypeTable = this.getServerTaskType(serverTaskTable.getTaskTypeCode())) == null) {
            this.loadServerTaskTypeMap();
            serverTaskTypeTable = this.getServerTaskType(serverTaskTable.getTaskTypeCode());
            if (serverTaskTypeTable == null) {
                throw new SchedulerException("Unable to find task type with associated taskTypeCode: " + serverTaskTable.getTaskTypeCode());
            }
        }
        taskDetail.setCommand(serverTaskTypeTable.getCommand());
        taskDetail.setName(serverTaskTable.getServerTaskName());
        taskDetail.setTaskTypeCode(serverTaskTable.getTaskTypeCode());
        taskDetail.setServerTask(serverTaskTypeTable.getJavaClass());
        taskDetail.setTaskTypeName(serverTaskTypeTable.getServerTaskTypeName());
        taskDetail.setTaskId(serverTaskTable.getTaskId());
        taskDetail.setFlags(serverTaskTypeTable.getFlags());
        this.loadServerTaskSettingMap(n);
        Collection collection = this.getServerTaskSetting(n);
        taskDetail.updateParameters(this.extractParametersFromServerTaskSetting(collection));
        return taskDetail;
    }

    public void scheduleTask(int n) throws SchedulerException {
        this.scheduleTask(this.createTaskDetail(n));
    }

    private Map extractParametersFromServerTaskSetting(Collection collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ServerTaskSettingTable serverTaskSettingTable = (ServerTaskSettingTable)((Object)iterator.next());
            hashMap.put(serverTaskSettingTable.getSectionName() + "." + serverTaskSettingTable.getSettingName(), serverTaskSettingTable.getSettingValue());
        }
        return hashMap;
    }

    private JobDetail getSchedulerJobDetail(TaskDetail taskDetail) throws SchedulerException {
        JobDetail jobDetail = this.scheduler.getJobDetail(Integer.toString(taskDetail.getTaskId()), DEFAULT_EPO_GROUP);
        if (jobDetail == null) {
            this.m_log.debug((Object)("Creating new JobDetail for task (" + taskDetail.getTaskId() + "): " + taskDetail.getName()));
            Class clazz = null;
            try {
                clazz = Class.forName(taskDetail.getServerTask());
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = class$com$mcafee$epo$webui$scheduler$task$UnknownTask == null ? (class$com$mcafee$epo$webui$scheduler$task$UnknownTask = SchedulerEngine.class$("com.mcafee.epo.webui.scheduler.task.UnknownTask")) : class$com$mcafee$epo$webui$scheduler$task$UnknownTask;
                this.m_log.error((Object)("Unable to find class \"" + taskDetail.getServerTask() + "\": " + classNotFoundException.getMessage()), (Throwable)classNotFoundException);
            }
            catch (NullPointerException nullPointerException) {
                clazz = class$com$mcafee$epo$webui$scheduler$task$UnknownTask == null ? (class$com$mcafee$epo$webui$scheduler$task$UnknownTask = SchedulerEngine.class$("com.mcafee.epo.webui.scheduler.task.UnknownTask")) : class$com$mcafee$epo$webui$scheduler$task$UnknownTask;
                this.m_log.error((Object)("No class found for task: \"" + taskDetail.getName() + "\": " + nullPointerException.getMessage()), (Throwable)nullPointerException);
            }
            catch (Exception exception) {
                String string = null;
                string = taskDetail == null ? "TaskDetail is null!" : "Unable to create task " + taskDetail.getName() + "(" + taskDetail.getServerTask() + "): " + exception.getMessage();
                this.m_log.error((Object)string, (Throwable)exception);
                throw new SchedulerException(string, exception);
            }
            jobDetail = new JobDetail(Integer.toString(taskDetail.getTaskId()), DEFAULT_EPO_GROUP, clazz);
            this.m_log.debug((Object)("Add ServerTask: " + taskDetail));
            this.updateJobDetail(jobDetail, taskDetail);
            this.scheduler.addJob(jobDetail, true);
        } else {
            this.updateJobDetail(jobDetail, taskDetail);
            this.m_log.debug((Object)("Using existing JobDetail (w/ updated params) for task (" + taskDetail.getTaskId() + "): " + taskDetail.getName()));
        }
        return jobDetail;
    }

    private void updateJobDetail(JobDetail jobDetail, TaskDetail taskDetail) {
        jobDetail.getJobDataMap().putAll(taskDetail.getParameters());
        jobDetail.getJobDataMap().put("COMMAND", taskDetail.getCommand());
        jobDetail.getJobDataMap().put("NAME", taskDetail.getName());
        jobDetail.getJobDataMap().put("TASKTYPECODE", taskDetail.getTaskTypeCode());
        jobDetail.getJobDataMap().put("TASKTYPENAME", Integer.toString(taskDetail.getTaskTypeName()));
        jobDetail.getJobDataMap().put("TASKID", Integer.toString(taskDetail.getTaskId()));
        jobDetail.getJobDataMap().put("FLAGS", taskDetail.getFlags());
    }

    public void scheduleTask(TaskDetail taskDetail) throws SchedulerException {
        Schedule schedule;
        JobDetail jobDetail = this.getSchedulerJobDetail(taskDetail);
        String string = this.getNextRunTimeString(taskDetail.getTaskId());
        this.m_log.debug((Object)("Task (" + taskDetail.getTaskId() + ") " + taskDetail.getName() + " - NextRunTime: \"" + string + "\""));
        Date date = SchedulerUtil.getDate(string);
        boolean bl = false;
        if (date != null && taskDetail.isRunIfMissed() && date.before(new Date())) {
            schedule = new Once();
            Date date2 = new Date();
            long l = date2.getTime() + (long)taskDetail.getRunIfMissedDelayMins() * 60000L;
            schedule.setStartTime(new Date(l));
            this.m_log.debug((Object)("RunMissed: new Once trigger and scheduling new job for " + jobDetail.getName() + " - " + taskDetail.getName()));
            Trigger trigger = (Trigger)schedule.getTriggers().iterator().next();
            trigger.setJobName(Integer.toString(taskDetail.getTaskId()));
            trigger.setJobGroup(jobDetail.getGroup());
            this.scheduler.scheduleJob(trigger);
            bl = true;
        }
        if ((schedule = SchedulerUtil.createSchedule(taskDetail)) == null) {
            this.m_log.error((Object)("No Schedule found for Task: " + taskDetail.getName()));
        } else {
            if (schedule.isEnabled()) {
                if ("NEVER".equals(string) && schedule instanceof Immediate) {
                    this.m_log.info((Object)("Immediate Schedule has a next run time of NEVER, will not schedule this task: " + taskDetail.getName()));
                } else {
                    boolean bl2 = true;
                    if ("NEVER".equals(string) && schedule instanceof Once) {
                        if (schedule.getStartTime().before(new Date())) {
                            this.m_log.info((Object)("Once schedule has a next run time in the past, will not schedule this task: " + taskDetail.getName()));
                            bl2 = false;
                        }
                    } else if (schedule instanceof Once && bl) {
                        this.m_log.info((Object)"Once schedule was already scheduled due to RunIfMissed, don't schedule again...");
                        bl2 = false;
                    }
                    if (bl2) {
                        if (schedule instanceof Immediate) {
                            schedule.setStartTime(new Date());
                        }
                        this.m_log.debug((Object)("Found Schedule: " + schedule));
                        Iterator iterator = schedule.getTriggers().iterator();
                        while (iterator.hasNext()) {
                            Trigger trigger = (Trigger)iterator.next();
                            trigger.setJobName(Integer.toString(taskDetail.getTaskId()));
                            trigger.setJobGroup(jobDetail.getGroup());
                            this.m_log.debug((Object)("Schedule: Adding associated trigger and scheduling " + jobDetail.getName() + " - " + taskDetail.getName()));
                            this.scheduler.scheduleJob(trigger);
                        }
                    }
                    date = this.getNextRunTime(jobDetail);
                }
            } else {
                this.m_log.warn((Object)"Schedule is not enabled, no schedule created.");
                date = null;
            }
            this.m_log.debug((Object)("NextRunTime is: " + date));
            this.updateDatabaseWithNextRunTime(date, taskDetail.getTaskId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNextRunTimeString(int n) {
        Connection connection = null;
        String string = null;
        try {
            try {
                connection = this.getDatabase().getConnection();
                ServerTaskTable serverTaskTable = ServerTaskTable.getByTaskId(connection, n);
                string = serverTaskTable.getNextRunTime();
            }
            catch (SQLException sQLException) {
                this.m_log.error((Object)("Unable to update NextRunTime: " + sQLException.getMessage()), (Throwable)sQLException);
                Object var6_7 = null;
                DatabaseUtil.close((Connection)connection);
                return string;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return string;
    }

    public Date getNextRunTime(JobDetail jobDetail) throws SchedulerException {
        Date date = null;
        Trigger[] triggerArray = this.scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
        this.m_log.debug((Object)("Number of triggers for job: " + jobDetail.getJobDataMap().getString("NAME") + " - " + triggerArray.length));
        int n = 0;
        while (n < triggerArray.length) {
            Trigger trigger = triggerArray[n];
            this.m_log.debug((Object)("Trigger: " + trigger.getNextFireTime()));
            Date date2 = trigger.getFireTimeAfter(new Date());
            this.m_log.debug((Object)(" FireTime after now: " + date2));
            if (date == null || date2 != null && date.after(date2)) {
                date = date2;
            }
            ++n;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDatabaseWithNextRunTime(Date date, int n) {
        Connection connection = null;
        try {
            try {
                String string = null;
                int n2 = 0;
                if (date != null) {
                    string = SchedulerUtil.getString(date);
                    n2 = 4;
                } else {
                    string = "NEVER";
                    n2 = 0;
                }
                this.m_log.debug((Object)("Updating DB with NextRunTime=" + string + "; Status=" + n2));
                connection = this.getDatabase().getConnection();
                ServerTaskTable serverTaskTable = ServerTaskTable.getByTaskId(connection, n);
                serverTaskTable.setNextRunTime(string);
                serverTaskTable.setStatus(n2);
                serverTaskTable.update(connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.m_log.error((Object)("Unable to update NextRunTime: " + sQLException.getMessage()), (Throwable)sQLException);
                Object var8_9 = null;
                DatabaseUtil.close(connection);
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public void interrupt(int n) throws SchedulerException {
        this.scheduler.interrupt(Integer.toString(n), DEFAULT_EPO_GROUP);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Collection getScheduledTasks() throws SchedulerException {
        HashSet<JobDetail> hashSet = new HashSet<JobDetail>();
        String[] stringArray = this.scheduler.getJobGroupNames();
        if (stringArray == null) {
            return hashSet;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = this.scheduler.getJobNames(stringArray[n]);
            if (stringArray2 != null) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    JobDetail jobDetail = this.scheduler.getJobDetail(stringArray2[n2], stringArray[n]);
                    hashSet.add(jobDetail);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public Collection getTriggers(JobDetail jobDetail) throws SchedulerException {
        HashSet<Trigger> hashSet = new HashSet<Trigger>();
        Trigger[] triggerArray = this.scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
        int n = 0;
        while (n < triggerArray.length) {
            hashSet.add(triggerArray[n]);
            ++n;
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

