/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.task;

import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.webui.scheduler.SchedulerEngine;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskTable;
import com.mcafee.epo.webui.scheduler.task.ServerTaskException;
import com.mcafee.epo.webui.scheduler.task.ServerTaskLogger;
import com.mcafee.epo.webui.scheduler.util.SchedulerUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.UnableToInterruptJobException;

public abstract class ServerTask
implements InterruptableJob {
    public static final String SCHEDULE_DATE_NEVER = "NEVER";
    public static final int SCHEDULER_LOG = 1;
    public static final int STATUS_WAITING = 0;
    public static final int STATUS_EXECUTING = 1;
    public static final int STATUS_SUCCESS = 2;
    public static final int STATUS_FAIL = 3;
    public static final int STATUS_SCHEDULED = 4;
    public static final String TASKTYPENAME = "TASKTYPENAME";
    public static final String TASKTYPECODE = "TASKTYPECODE";
    public static final String COMMAND = "COMMAND";
    public static final String NAME = "NAME";
    public static final String TASKID = "TASKID";
    public static final String FLAGS = "FLAGS";
    public static final String RUNNOW = "RUNNOW";
    private Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$webui$scheduler$task$ServerTask == null ? (class$com$mcafee$epo$webui$scheduler$task$ServerTask = ServerTask.class$("com.mcafee.epo.webui.scheduler.task.ServerTask")) : class$com$mcafee$epo$webui$scheduler$task$ServerTask));
    private JobDataMap m_jobDataMap = null;
    private ServerTaskLogger m_serverTaskLogger = null;
    static /* synthetic */ Class class$com$mcafee$epo$webui$scheduler$task$ServerTask;

    public abstract void executeTask() throws ServerTaskException;

    public void interruptTask() throws ServerTaskException {
        throw new ServerTaskException("User did not create an interruptTask() function!");
    }

    public String getTaskSetting(String string, String string2) {
        return this.getParameter(string + "." + string2);
    }

    private String getParameter(String string) {
        if (this.m_jobDataMap != null) {
            return this.m_jobDataMap.getString(string);
        }
        return null;
    }

    private int getIntParameter(String string) {
        if (this.m_jobDataMap != null) {
            return this.m_jobDataMap.getInt(string);
        }
        return Integer.parseInt(this.getParameter(string));
    }

    public boolean isTaskLoggingEnabled() {
        return (this.getFlags() & 1) == 1;
    }

    public String getCommand() {
        return this.getParameter(COMMAND);
    }

    public String getName() {
        return this.getParameter(NAME);
    }

    public String getTaskTypeCode() {
        return this.getParameter(TASKTYPECODE);
    }

    public String getTaskTypeName() {
        return this.getParameter(TASKTYPENAME);
    }

    public String getTaskId() {
        return this.getParameter(TASKID);
    }

    public int getFlags() {
        return this.getIntParameter(FLAGS);
    }

    public boolean isRunNow() {
        return "true".equals(this.getParameter(RUNNOW));
    }

    public final void interrupt() throws UnableToInterruptJobException {
        this.m_log.info((Object)("Interrupt " + this.getClass().getName() + " called!"));
        try {
            this.interruptTask();
        }
        catch (ServerTaskException serverTaskException) {
            this.m_log.error((Object)("Interrupt Task Failure: " + serverTaskException.getMessage()), (Throwable)serverTaskException);
            if (this.m_serverTaskLogger != null) {
                try {
                    this.m_serverTaskLogger.logStatus(3);
                }
                catch (SQLException sQLException) {
                    this.m_log.error((Object)"Unable to set log status to FAIL!", (Throwable)sQLException);
                }
            }
            throw new UnableToInterruptJobException((Exception)serverTaskException);
        }
    }

    public boolean isTaskRunning(JobExecutionContext jobExecutionContext) throws SchedulerException {
        if (jobExecutionContext == null || this.isRunNow()) {
            return false;
        }
        List list = SchedulerEngine.singleton().getScheduler().getCurrentlyExecutingJobs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            JobExecutionContext jobExecutionContext2 = (JobExecutionContext)iterator.next();
            String string2 = jobExecutionContext.getJobDetail().getJobDataMap().getString(NAME);
            if (!string2.equals(string = jobExecutionContext2.getJobDetail().getJobDataMap().getString(NAME))) continue;
            long l = jobExecutionContext.getFireTime().getTime();
            long l2 = jobExecutionContext2.getFireTime().getTime();
            this.m_log.debug((Object)("Found running task " + string + " with a fire time of " + l2 + "; check fire = " + l));
            if (l == l2) continue;
            this.m_log.debug((Object)("Match found.  Task " + jobExecutionContext.getJobDetail().getJobDataMap().getString(NAME) + " is already running!"));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(JobExecutionContext jobExecutionContext) {
        block10: {
            this.m_jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            try {
                if (this.isTaskRunning(jobExecutionContext)) {
                    this.m_log.warn((Object)("Task " + this.getName() + " is already running, do not schedule again."));
                    this.writeNextRunTimeToDatabase(jobExecutionContext);
                    return;
                }
            }
            catch (Exception exception) {
                this.m_log.error((Object)("Error occurred checking to see if task was running: " + exception.toString()), (Throwable)exception);
            }
            this.m_serverTaskLogger = this.getServerTaskLogger();
            try {
                try {
                    this.m_serverTaskLogger.logStatus(1);
                    this.executeTask();
                    this.m_serverTaskLogger.logStatus(2);
                }
                catch (SQLException sQLException) {
                    this.m_log.error((Object)("ServerTask execute failed on DB call: " + sQLException.getMessage()), (Throwable)sQLException);
                    Object var6_5 = null;
                    this.writeNextRunTimeToDatabase(jobExecutionContext);
                    break block10;
                }
                catch (ServerTaskException serverTaskException) {
                    this.m_log.error((Object)("Execute Task Failure: " + serverTaskException.getMessage()), (Throwable)serverTaskException);
                    try {
                        this.m_serverTaskLogger.logStatus(3);
                    }
                    catch (SQLException sQLException) {
                        this.m_log.error((Object)"Unable to update ServerTaskLog table with failure status.");
                    }
                    Object var6_6 = null;
                    this.writeNextRunTimeToDatabase(jobExecutionContext);
                }
                Object var6_4 = null;
                this.writeNextRunTimeToDatabase(jobExecutionContext);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.writeNextRunTimeToDatabase(jobExecutionContext);
                throw throwable;
            }
        }
    }

    private Date getNextRunTime(JobExecutionContext jobExecutionContext) {
        Date date = null;
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        try {
            Trigger[] triggerArray = jobExecutionContext.getScheduler().getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
            this.m_log.debug((Object)("Number of triggers for job: " + jobDetail.getName() + " - " + triggerArray.length));
            int n = 0;
            while (n < triggerArray.length) {
                Trigger trigger = triggerArray[n];
                this.m_log.debug((Object)("Trigger: " + trigger.getNextFireTime()));
                Date date2 = trigger.getFireTimeAfter(new Date());
                this.m_log.debug((Object)(" FireTime after now: " + date2));
                if (date == null || date2 != null && date.after(date2)) {
                    date = date2;
                }
                ++n;
            }
        }
        catch (SchedulerException schedulerException) {
            this.m_log.error((Object)("Unable to determine next run time for " + jobDetail.getName()), (Throwable)schedulerException);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeNextRunTimeToDatabase(JobExecutionContext jobExecutionContext) {
        int n = 0;
        Connection connection = null;
        try {
            try {
                String string = null;
                Date date = this.getNextRunTime(jobExecutionContext);
                if (date != null) {
                    string = SchedulerUtil.getString(date);
                    n = 4;
                } else {
                    string = SCHEDULE_DATE_NEVER;
                    n = 0;
                }
                connection = EpoCore.getEpoDb().getConnection();
                ServerTaskTable serverTaskTable = ServerTaskTable.getByTaskId(connection, this.getTaskId());
                serverTaskTable.setNextRunTime(string);
                serverTaskTable.setStatus(n);
                serverTaskTable.update(connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.m_log.error((Object)("Unable to update NextRunTime: " + sQLException.getMessage()), (Throwable)sQLException);
                Object var8_9 = null;
                DatabaseUtil.close((Connection)connection);
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerTaskLogger getServerTaskLogger() {
        if (this.m_serverTaskLogger != null) return this.m_serverTaskLogger;
        this.m_serverTaskLogger = new ServerTaskLogger();
        this.m_serverTaskLogger.setLoggingFlag(this.getFlags());
        if (!this.isTaskLoggingEnabled()) return this.m_serverTaskLogger;
        String string = SchedulerUtil.getString(new Date());
        ServerTaskLogTable serverTaskLogTable = new ServerTaskLogTable();
        serverTaskLogTable.setServerTaskID(Integer.parseInt(this.getTaskId()));
        serverTaskLogTable.setServerTaskName(this.getName());
        serverTaskLogTable.setServerTaskTypeCode(this.getTaskTypeCode());
        serverTaskLogTable.setServerTaskTypeName(Integer.parseInt(this.getTaskTypeName()));
        serverTaskLogTable.setTheDate(string);
        serverTaskLogTable.setStartDate(string);
        serverTaskLogTable.setEndDate(string);
        serverTaskLogTable.setStatus(0);
        Connection connection = null;
        try {
            try {
                connection = EpoCore.getEpoDb().getConnection();
                serverTaskLogTable.add(connection, true);
                connection.commit();
                this.m_serverTaskLogger.setLogID(serverTaskLogTable.getAutoID());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.m_log.error((Object)("Creating Log entry failed: " + sQLException.getMessage()), (Throwable)sQLException);
                Object var6_5 = null;
                DatabaseUtil.close((Connection)connection);
                return this.m_serverTaskLogger;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return this.m_serverTaskLogger;
    }

    public void setServerTaskLogger(ServerTaskLogger serverTaskLogger) {
        this.m_serverTaskLogger = serverTaskLogger;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

