/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.task;

import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogDetailTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogMessageParamTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogMessageTable;
import com.mcafee.epo.webui.scheduler.db.ServerTaskLogTable;
import com.mcafee.epo.webui.scheduler.util.SchedulerUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class ServerTaskLogger {
    private Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$webui$scheduler$task$ServerTaskLogger == null ? (class$com$mcafee$epo$webui$scheduler$task$ServerTaskLogger = ServerTaskLogger.class$("com.mcafee.epo.webui.scheduler.task.ServerTaskLogger")) : class$com$mcafee$epo$webui$scheduler$task$ServerTaskLogger));
    private final int UNKNOWN = -1;
    public final int MSGDETAIL_ERROR = 1;
    public final int MSGDETAIL_INFO = 2;
    public final int MSGDETAIL_DEBUG = 3;
    private ServerTaskLogTable m_serverTaskLog = null;
    private int m_logID = -1;
    private int m_loggingFlag = 1;
    static /* synthetic */ Class class$com$mcafee$epo$webui$scheduler$task$ServerTaskLogger;

    public ServerTaskLogTable getServerTaskLog() {
        return this.m_serverTaskLog;
    }

    public void setServerTaskLog(ServerTaskLogTable serverTaskLogTable) {
        this.m_serverTaskLog = serverTaskLogTable;
    }

    public int getLogID() {
        return this.m_logID;
    }

    public void setLogID(int n) {
        this.m_logID = n;
    }

    public int getLoggingFlag() {
        return this.m_loggingFlag;
    }

    public void setLoggingFlag(int n) {
        this.m_loggingFlag = n;
    }

    public final boolean isEnabled() {
        return (this.getLoggingFlag() & 1) == 1;
    }

    public final void logStatus(int n) throws SQLException {
        if (!this.isEnabled()) {
            return;
        }
        Connection connection = null;
        try {
            try {
                connection = EpoCore.getEpoDb().getConnection();
                this.logStatus(connection, n);
                connection.commit();
            }
            catch (SQLException sQLException) {
                this.m_log.error((Object)("Updating ServerTaskLog table failed: " + sQLException.getMessage()), (Throwable)sQLException);
                throw sQLException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public final void logStatus(Connection connection, int n) throws SQLException {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getLogID() == -1) {
            this.m_log.error((Object)("Cannot write status: " + n));
            return;
        }
        ServerTaskLogTable serverTaskLogTable = this.getServerTaskLog();
        if (serverTaskLogTable == null) {
            serverTaskLogTable = ServerTaskLogTable.getByUniqueId(connection, this.getLogID());
            this.setServerTaskLog(serverTaskLogTable);
        }
        String string = SchedulerUtil.getString(new Date());
        serverTaskLogTable.setTheDate(string);
        switch (n) {
            case 1: {
                serverTaskLogTable.setStartDate(string);
                break;
            }
            case 3: {
                serverTaskLogTable.setEndDate(string);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                serverTaskLogTable.setEndDate(string);
                break;
            }
            default: {
                serverTaskLogTable.setEndDate(string);
            }
        }
        serverTaskLogTable.setStatus(n);
        serverTaskLogTable.update(connection);
    }

    public final void logDetail(String string, int n) throws SQLException {
        this.logDetail(string, n, -1, -1, null);
    }

    public final void logDetail(Connection connection, String string, int n) throws SQLException {
        this.logDetail(connection, string, n, -1, -1, null);
    }

    public final void logDetail(String string, int n, int n2, Properties properties) throws SQLException {
        this.logDetail(string, -1, n, n2, properties);
    }

    public final void logDetail(String string, int n, int n2, String string2, String string3, String string4, String string5) throws SQLException {
        if (!this.isEnabled()) {
            return;
        }
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("%1", string2);
        }
        if (string3 != null) {
            properties.setProperty("%2", string3);
        }
        if (string4 != null) {
            properties.setProperty("%3", string4);
        }
        if (string5 != null) {
            properties.setProperty("%4", string5);
        }
        this.logDetail(string, -1, n, n2, properties);
    }

    public final void logDetail(Connection connection, String string, int n, int n2, Properties properties) throws SQLException {
        this.logDetail(connection, string, -1, n, n2, properties);
    }

    private final synchronized void logDetail(String string, int n, int n2, int n3, Properties properties) throws SQLException {
        if (!this.isEnabled()) {
            return;
        }
        Connection connection = null;
        try {
            this.m_log.debug((Object)("Acquiring DB Connection for logDetail: " + string + " (" + n + "%)"));
            connection = EpoCore.getEpoDb().getConnection();
            this.logDetail(connection, string, n, n2, n3, properties);
            connection.commit();
            this.m_log.debug((Object)("After commit logDetail: " + string + " (" + n + "%)"));
        }
        catch (SQLException sQLException) {
            try {
                this.m_log.error((Object)("Updating ServerTaskLogDetail table failed: " + sQLException.getMessage()), (Throwable)sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                DatabaseUtil.close(connection);
                this.m_log.debug((Object)("After closing DB Connection for logDetail: " + string + " (" + n + "%)"));
                throw throwable;
            }
        }
        DatabaseUtil.close((Connection)connection);
        this.m_log.debug((Object)("After closing DB Connection for logDetail: " + string + " (" + n + "%)"));
    }

    private final synchronized void logDetail(Connection connection, String string, int n, int n2, int n3, Properties properties) throws SQLException {
        if (!this.isEnabled()) {
            return;
        }
        ServerTaskLogDetailTable serverTaskLogDetailTable = ServerTaskLogDetailTable.getByTaskIdAndInstanceName(connection, this.getLogID(), string);
        if (serverTaskLogDetailTable == null) {
            serverTaskLogDetailTable = new ServerTaskLogDetailTable();
            serverTaskLogDetailTable.setInstanceName(string);
            serverTaskLogDetailTable.setPercentComplete(n);
            serverTaskLogDetailTable.setTaskLogID(this.getLogID());
            serverTaskLogDetailTable.add(connection, true);
        } else if (n != -1) {
            this.m_log.debug((Object)("+++Updating " + string + " to " + n + " percent"));
            serverTaskLogDetailTable.setPercentComplete(n);
            serverTaskLogDetailTable.update(connection);
            this.m_log.debug((Object)"---Update complete");
        }
        if (n2 != -1) {
            ServerTaskLogMessageTable serverTaskLogMessageTable = new ServerTaskLogMessageTable();
            serverTaskLogMessageTable.setTaskLogDetailID(serverTaskLogDetailTable.getAutoID());
            serverTaskLogMessageTable.setMsgLevel(n2);
            serverTaskLogMessageTable.setMsgFormatCode(n3);
            serverTaskLogMessageTable.setTheDate(SchedulerUtil.getString(new Date()));
            serverTaskLogMessageTable.add(connection, true);
            if (properties != null) {
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    ServerTaskLogMessageParamTable serverTaskLogMessageParamTable = new ServerTaskLogMessageParamTable();
                    serverTaskLogMessageParamTable.setTaskLogMsgID(serverTaskLogMessageTable.getAutoID());
                    serverTaskLogMessageParamTable.setName(string2);
                    serverTaskLogMessageParamTable.setValue(properties.getProperty(string2));
                    serverTaskLogMessageParamTable.add(connection);
                }
            }
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

