/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.scheduler.util;

import com.mcafee.epo.webui.scheduler.schedule.Daily;
import com.mcafee.epo.webui.scheduler.schedule.Hourly;
import com.mcafee.epo.webui.scheduler.schedule.Immediate;
import com.mcafee.epo.webui.scheduler.schedule.Monthly;
import com.mcafee.epo.webui.scheduler.schedule.Once;
import com.mcafee.epo.webui.scheduler.schedule.Schedule;
import com.mcafee.epo.webui.scheduler.schedule.Weekly;
import com.mcafee.epo.webui.scheduler.task.TaskDetail;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class SchedulerUtil {
    private static Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$webui$scheduler$util$SchedulerUtil == null ? (class$com$mcafee$epo$webui$scheduler$util$SchedulerUtil = SchedulerUtil.class$("com.mcafee.epo.webui.scheduler.util.SchedulerUtil")) : class$com$mcafee$epo$webui$scheduler$util$SchedulerUtil));
    public static final String SCHEDULE_SECTION = "Schedule";
    public static final String SETTINGS_SECTION = "Settings";
    public static final String TYPE = "Type";
    public static final String GMTTIME = "GMTTime";
    public static final String START_DATE_TIME = "StartDateTime";
    public static final String STOP_DATE_TIME = "StopDateTime";
    public static final String STOP_DATE_VALID = "StopDateValid";
    public static final String TASK_REPEATABLE = "TaskRepeatable";
    public static final String REPEAT_OPTION = "RepeatOption";
    public static final String REPEAT_INTERVAL = "RepeatInterval";
    public static final String UNTIL_OPTION = "UntilOption";
    public static final String UNTIL_DURATION = "UntilDuration";
    public static final String UNTIL_TIME = "UntilTime";
    public static final String ENABLE_RANDOM = "RandomizationEnabled";
    public static final String RANDOM_WND_MINS = "RandomizationWndMins";
    public static final String ENABLE_ONCE_A_DAY = "EnableRunTaskOnceADay";
    public static final String REPEAT_HOURS = "RepeatHours";
    public static final String HOURLY_REPEAT_ENABLED = "HourlyRepeatEnabled";
    public static final String HOURLY_REPEAT_START_TIME = "HourlyRepeatStartTime";
    public static final String HOURLY_REPEAT_END_TIME = "HourlyRepeatEndTime";
    public static final String REPEAT_DAYS = "RepeatDays";
    public static final String REPEAT_WEEKS = "RepeatWeeks";
    public static final String MASK_DAYS_OF_WEEK = "MaskDaysOfWeek";
    public static final String MONTH_OPTION = "MonthOption";
    public static final String DAY_NUM_OF_MONTH = "DayNumOfMonth";
    public static final String WEEK_NUM_OF_MONTH = "WeekNumOfMonth";
    public static final String DAY_OF_WEEK = "DayOfWeek";
    public static final String MASK_MONTHS_OF_YEAR = "MaskMonthsOfYear";
    public static final String IDLE_MINUTES = "IdleMinutes";
    public static final String DELETE_WHEN_FINISHED = "DeleteWhenFinished";
    public static final String STOP_AFTER_MINUTES = "StopAfterMinutes";
    public static final String ONLY_START_WHEN_IDLE = "OnlyStartWhenIdle";
    public static final String RUN_IF_MISSED = "RunIfMissed";
    public static final String RUN_IF_MISSED_DELAY_MINS = "RunIfMissedDelayMins";
    public static final String FINISHED = "TaskFinished";
    public static final String ENABLED = "Enabled";
    public static final int ST_DAILY = 0;
    public static final int ST_WEEKLY = 1;
    public static final int ST_MONTHLY = 2;
    public static final int ST_ONCE = 3;
    public static final int ST_AT_STARTUP = 4;
    public static final int ST_AT_LOGON = 5;
    public static final int ST_WHEN_IDLE = 6;
    public static final int ST_IMMEDIATE = 7;
    public static final int ST_DIALUP = 8;
    public static final int ST_HOURLY = 9;
    public static final int ST_ALL = 255;
    public static final int DOW_SUN = 1;
    public static final int DOW_MON = 2;
    public static final int DOW_TUE = 4;
    public static final int DOW_WED = 8;
    public static final int DOW_THU = 16;
    public static final int DOW_FRI = 32;
    public static final int DOW_SAT = 64;
    public static final int DOW_ALL = 255;
    public static final int MOY_JAN = 1;
    public static final int MOY_FEB = 2;
    public static final int MOY_MAR = 4;
    public static final int MOY_APR = 8;
    public static final int MOY_MAY = 16;
    public static final int MOY_JUN = 32;
    public static final int MOY_JUL = 64;
    public static final int MOY_AUG = 128;
    public static final int MOY_SEP = 256;
    public static final int MOY_OCT = 512;
    public static final int MOY_NOV = 1024;
    public static final int MOY_DEC = 2048;
    public static final int MOY_ALL = 4095;
    public static final int MO_DOM = 0;
    public static final int MO_DOW = 1;
    public static final int RO_HOURS = 0;
    public static final int RO_MINUTES = 1;
    public static final int UO_TIME = 0;
    public static final int UO_DURATION = 1;
    public static final int TF_DISABLED = 1;
    public static final int TF_DELETE = 2;
    public static final String EPO_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String EPO_TIME_FORMAT = "HHmmss";
    static /* synthetic */ Class class$com$mcafee$epo$webui$scheduler$util$SchedulerUtil;

    public static final Integer getInteger(String string) {
        if (string == null || "".equals(string) || !NumberUtils.isNumber((String)string)) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static final Boolean getBoolean(String string) {
        if (string == null || "".equals(string) || !NumberUtils.isDigits((String)string)) {
            return null;
        }
        return !"0".equals(string);
    }

    public static final Date getDate(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() != 14) {
            return null;
        }
        if (string.startsWith("00000000")) {
            string = string.substring(8);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EPO_TIME_FORMAT);
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return null;
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EPO_DATE_FORMAT);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public static final String getString(Date date) {
        return new SimpleDateFormat(EPO_DATE_FORMAT).format(date);
    }

    public static Schedule createSchedule(TaskDetail taskDetail) {
        Comparable<Date> comparable;
        Object object;
        Object object2;
        m_log.debug((Object)("TaskDetail Map:" + taskDetail.getParameters()));
        if (taskDetail.getParameters().isEmpty()) {
            return null;
        }
        Integer n = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, TYPE));
        if (n == null) {
            m_log.debug((Object)"Task Type was null!");
            return null;
        }
        Boolean bl = SchedulerUtil.getBoolean(taskDetail.getTaskSetting(SETTINGS_SECTION, ENABLED));
        Date date = SchedulerUtil.getDate(taskDetail.getTaskSetting(SCHEDULE_SECTION, START_DATE_TIME));
        Date date2 = SchedulerUtil.getDate(taskDetail.getTaskSetting(SCHEDULE_SECTION, STOP_DATE_TIME));
        Boolean bl2 = SchedulerUtil.getBoolean(taskDetail.getTaskSetting(SCHEDULE_SECTION, STOP_DATE_VALID));
        Boolean bl3 = SchedulerUtil.getBoolean(taskDetail.getTaskSetting(SCHEDULE_SECTION, TASK_REPEATABLE));
        Integer n2 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, REPEAT_OPTION));
        Integer n3 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, REPEAT_INTERVAL));
        Integer n4 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, UNTIL_OPTION));
        Integer n5 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, UNTIL_DURATION));
        Date date3 = SchedulerUtil.getDate(taskDetail.getTaskSetting(SCHEDULE_SECTION, UNTIL_TIME));
        Schedule schedule = null;
        switch (n) {
            case 9: {
                schedule = new Hourly();
                break;
            }
            case 0: {
                schedule = new Daily();
                break;
            }
            case 1: {
                schedule = new Weekly();
                break;
            }
            case 2: {
                schedule = new Monthly();
                break;
            }
            case 3: {
                schedule = new Once();
                break;
            }
            case 7: {
                schedule = new Immediate();
                break;
            }
            default: {
                m_log.error((Object)("Couldn't determine Schedule Type: " + n));
            }
        }
        schedule.setEnabled(bl);
        schedule.setStartTime(date);
        if (bl2 != null && bl2.booleanValue()) {
            schedule.setEndTime(date2);
        }
        if (bl3 != null && bl3.booleanValue()) {
            schedule.setRepeatable(true);
            if (n2 == 0) {
                schedule.setRepeatEvery(n3 * 60);
            } else if (n2 == 1) {
                schedule.setRepeatEvery(n3);
            }
            if (n4 == 0) {
                object2 = GregorianCalendar.getInstance();
                ((Calendar)object2).setTime(date3);
                schedule.setRepeatUntilHour(((Calendar)object2).get(11));
                schedule.setRepeatUntilMinute(((Calendar)object2).get(12));
                schedule.setRepeatUntilSecond(((Calendar)object2).get(13));
            } else if (n4 == 1) {
                long l = date.getTime();
                object = new Date(l += (long)(n5 * 1000));
                comparable = GregorianCalendar.getInstance();
                ((Calendar)comparable).setTime((Date)object);
                schedule.setRepeatUntilHour(((Calendar)comparable).get(11));
                schedule.setRepeatUntilMinute(((Calendar)comparable).get(12));
                schedule.setRepeatUntilSecond(((Calendar)comparable).get(13));
            }
        } else {
            schedule.setRepeatable(false);
        }
        if (schedule instanceof Hourly) {
            object2 = taskDetail.getTaskSetting(SCHEDULE_SECTION, REPEAT_HOURS);
            Boolean bl4 = SchedulerUtil.getBoolean(taskDetail.getTaskSetting(SCHEDULE_SECTION, HOURLY_REPEAT_ENABLED));
            object = SchedulerUtil.getDate(taskDetail.getTaskSetting(SCHEDULE_SECTION, HOURLY_REPEAT_START_TIME));
            comparable = SchedulerUtil.getDate(taskDetail.getTaskSetting(SCHEDULE_SECTION, HOURLY_REPEAT_END_TIME));
            Hourly hourly = (Hourly)schedule;
            hourly.setRepeatHours((String)object2);
            hourly.setRepeatEnabled(bl4 == null ? false : bl4);
            hourly.setRepeatStartTime((Date)object);
            hourly.setRepeatEndTime((Date)comparable);
            return hourly;
        }
        if (schedule instanceof Daily) {
            object2 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, REPEAT_DAYS));
            Daily daily = (Daily)schedule;
            daily.setRepeatDays(((Integer)object2).longValue());
            return daily;
        }
        if (schedule instanceof Weekly) {
            object2 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, REPEAT_WEEKS));
            Integer n6 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, MASK_DAYS_OF_WEEK));
            object = (Weekly)schedule;
            ((Weekly)object).setRepeatWeeks(((Integer)object2).longValue());
            ((Weekly)object).setMaskDaysOfWeek(n6);
            return object;
        }
        if (schedule instanceof Monthly) {
            object2 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, DAY_NUM_OF_MONTH));
            Integer n7 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, DAY_OF_WEEK));
            object = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, MASK_MONTHS_OF_YEAR));
            comparable = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, MONTH_OPTION));
            Integer n8 = SchedulerUtil.getInteger(taskDetail.getTaskSetting(SCHEDULE_SECTION, WEEK_NUM_OF_MONTH));
            Monthly monthly = (Monthly)schedule;
            monthly.setMaskMonthsOfYear((Integer)object);
            monthly.setMonthOption((Integer)comparable);
            if ((Integer)comparable == 0) {
                monthly.setDayNumOfMonth((Integer)object2);
            } else if ((Integer)comparable == 1) {
                monthly.setDayOfWeek(n7);
                monthly.setWeekNumOfMonth(n8);
            } else {
                return null;
            }
            return monthly;
        }
        if (schedule instanceof Once) {
            object2 = (Once)schedule;
            return object2;
        }
        if (schedule instanceof Immediate) {
            return schedule;
        }
        m_log.warn((Object)"Did not create a schedule, returning null");
        return null;
    }

    public static Date createDate(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(n5, n4, n3, n2, n);
        return calendar.getTime();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

