/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.server;

import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.db.ServerInfo;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.webui.server.ServerInitException;
import com.mcafee.epo.webui.util.Resource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Server {
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$webui$server$Server == null ? (class$com$mcafee$epo$webui$server$Server = Server.class$("com.mcafee.epo.webui.server.Server")) : class$com$mcafee$epo$webui$server$Server).getName());
    public static final String DEFAULT_LOG_FILENAME = "c:/webui.log";
    public static final String LOG_CONFIG_FILENAME = "log_config.xml";
    public static final String SERVER_CONFIG_FILENAME = "webui.properties";
    public static final String LOCAL_IP = "127.0.0.1";
    private static boolean m_logAllEvents = false;
    private static boolean m_logErrorEvents = false;
    private static boolean m_sInitialized = false;
    private static boolean m_sInitFailed = false;
    private static String m_initErrorString = "";
    private static boolean m_shuttingDown = false;
    private static String m_tomcatPort = "";
    private static String m_agentHttpPort = "8080";
    private static String m_defaultLocale = null;
    private static InetAddress m_localHost = null;
    private static boolean m_allowServletGet = false;
    static /* synthetic */ Class class$com$mcafee$epo$webui$server$Server;

    public static synchronized void init() throws Exception {
        if (m_sInitialized) {
            return;
        }
        m_sInitFailed = true;
        try {
            m_log.debug((Object)"Starting to load our config file...");
            Properties properties = Server.loadProperties();
            m_log.debug((Object)"Starting to read the general properties...");
            Server.setGeneralProperties(properties);
            m_log.debug((Object)"Starting to reload configuration info from the database...");
            Server.reloadConfiguration();
            m_sInitFailed = false;
            m_initErrorString = "";
            m_sInitialized = true;
        }
        catch (Exception exception) {
            m_log.error((Object)exception);
            m_initErrorString = exception.getMessage();
            throw exception;
        }
    }

    public static synchronized void shutdown() {
        if (!m_sInitialized) {
            return;
        }
        m_sInitialized = false;
    }

    public static String getInitErrorString() {
        return m_initErrorString;
    }

    public static final String getTomcatPort() {
        return m_tomcatPort;
    }

    public static final String getLocalHostName() {
        return m_localHost.getHostName();
    }

    public static final InetAddress getLocalHost() {
        return m_localHost;
    }

    public static final String getAgentHttpPort() {
        return m_agentHttpPort;
    }

    public static final boolean shouldLogAllEvents() {
        return m_logAllEvents;
    }

    public static final boolean shouldLogErrorEvents() {
        return m_logErrorEvents;
    }

    public static synchronized void cleanup() {
    }

    public static final synchronized boolean initialized() {
        return m_sInitialized;
    }

    public static final synchronized boolean initFailed() {
        return m_sInitFailed;
    }

    public static final boolean getAllowServletGet() {
        return m_allowServletGet;
    }

    public static final void logError(String string) {
        m_log.error((Object)string);
    }

    public static final Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reloadConfiguration() throws SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = EpoCore.getEpoDb().getConnection();
            m_log.debug((Object)"(re)loading configuration.");
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public static final boolean isLocal(HttpServletRequest httpServletRequest) {
        Boolean bl = (Boolean)httpServletRequest.getAttribute("ISLOCAL");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public static final void setLocal(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = httpServletRequest.getRemoteAddr();
        boolean bl = string2.compareTo(string = m_localHost.getHostAddress()) == 0 || string2.compareTo(LOCAL_IP) == 0;
        httpServletRequest.setAttribute("ISLOCAL", (Object)bl);
    }

    private static final void setGeneralProperties(Properties properties) throws Exception {
        String string = Locale.getDefault().getLanguage();
        if (string == null) {
            string = "en";
        }
        m_defaultLocale = Resource.getStringOrDefault(properties, "server.default.language", string);
        m_log.info((Object)Resource.formatString("server_template_default_lang", Resource.getString("language_" + m_defaultLocale), m_defaultLocale));
        String string2 = properties.getProperty("log.event.details", "none");
        if (string2.equals("all")) {
            m_logAllEvents = true;
            m_logErrorEvents = false;
        } else if (string2.equals("error")) {
            m_logAllEvents = false;
            m_logErrorEvents = true;
        } else {
            m_logAllEvents = false;
            m_logErrorEvents = false;
        }
        Server.setLocalHost();
        m_allowServletGet = Resource.getStringOrDefault(properties, "servlet.allow.get", "false").equals("true");
    }

    private static void setLocalHost() throws Exception {
        Database database = EpoCore.getEpoDb();
        Connection connection = null;
        try {
            block6: {
                try {
                    if (database != null) {
                        String string = database.getEPOAppServerIP();
                        if ("".equals(string)) {
                            connection = database.getConnection();
                            string = ServerInfo.load((Connection)connection).getLastKnownTCPIP();
                        }
                        m_localHost = InetAddress.getByName(string);
                        break block6;
                    }
                    m_log.debug((Object)"Failed to get epoDB");
                }
                catch (UnknownHostException unknownHostException) {
                    throw new ServerInitException(Resource.getString("server_no_localhost_name"));
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            DatabaseUtil.close(connection);
            throw throwable;
        }
        DatabaseUtil.close(connection);
    }

    public static String getDefaultLocale() {
        return m_defaultLocale;
    }

    public static void setShutdownFlag() {
        m_log.debug((Object)"Server shutting down...");
        m_shuttingDown = true;
    }

    public static boolean getShutdownFlag() {
        return m_shuttingDown;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

