/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.servlet;

import com.mcafee.epo.common.ui.util.SessionUtil;
import com.mcafee.epo.core.EpoCore;
import com.mcafee.epo.core.servlet.util.UserUtil;
import com.mcafee.epo.core.ui.ActionBean;
import com.mcafee.epo.core.ui.ErrorMsgBean;
import com.mcafee.epo.core.util.FileUtil;
import com.mcafee.epo.webui.repoman.RepositoryManager;
import com.mcafee.epo.webui.scheduler.SchedulerEngine;
import com.mcafee.epo.webui.server.Server;
import com.mcafee.epo.webui.servlet.AuthorizedAction;
import com.mcafee.epo.webui.util.ActionMap;
import com.mcafee.epo.webui.util.ActionProcessor;
import com.mcafee.epo.webui.util.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.quartz.SchedulerException;

public class ControllerServlet
extends HttpServlet {
    public static final String LOGIN_ACTION = "com.mcafee.epo.webui.ui.LoginAction";
    public static final String LOGOUT_ACTION = "com.mcafee.epo.webui.ui.LogoutAction";
    public static final String BLANK_JSP = "blankJSP";
    public static final String MCUPLOAD_USER_AGENT = "McUpload 1.0";
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$webui$servlet$ControllerServlet == null ? (class$com$mcafee$epo$webui$servlet$ControllerServlet = ControllerServlet.class$("com.mcafee.epo.webui.servlet.ControllerServlet")) : class$com$mcafee$epo$webui$servlet$ControllerServlet).getName());
    private static final String actionMapXml = "com/mcafee/epo/webui/servlet/actionmap.xml";
    private ActionMap m_actionMap = null;
    private HashMap m_noRepeatMap = new HashMap();
    private String m_lastAction = "";
    static /* synthetic */ Class class$com$mcafee$epo$webui$servlet$ControllerServlet;

    public void init() throws ServletException {
        this.getServletContext().setAttribute("ClassBundle", (Object)Resource.getInstance());
        try {
            Server.init();
            m_log.info((Object)Resource.getString("controllerservlet_init_complete"));
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("controllerservlet_template_error_initializing", exception.getMessage()), (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
        try {
            SchedulerEngine.singleton().initialize();
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("controllerservlet_error_schedulerengine", exception.getMessage()), (Throwable)exception);
        }
        try {
            RepositoryManager.singleton().initialize();
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.formatString("controllerservlet_error_repositorymanager", exception.getMessage()), (Throwable)exception);
        }
        try {
            URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource(actionMapXml);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            this.m_actionMap = ActionProcessor.singleton().loadActionMap(inputStreamReader);
            this.m_actionMap.addAction("login.do", this.getLoginActionClass());
            this.m_actionMap.addAction("logout.do", this.getLogoutActionClass());
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{actionMapXml, exception.getMessage()};
            m_log.error((Object)Resource.formatString("controllerservlet_error_actionmap", objectArray), (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
    }

    public void destroy() {
        try {
            Server.setShutdownFlag();
        }
        catch (Exception exception) {
            m_log.error((Object)("Unable to shut down the Server: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            SchedulerEngine.singleton().shutdown();
        }
        catch (SchedulerException schedulerException) {
            m_log.error((Object)("Unable to shut down the Scheduler: " + schedulerException.getMessage()), (Throwable)schedulerException);
        }
        try {
            RepositoryManager.singleton().Shutdown();
        }
        catch (Exception exception) {
            m_log.error((Object)("Unable to shut down the Repository Manager: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            String string = EpoCore.getEpoDb().getEPODBDir() + "/temp";
            File file = new File(string);
            FileUtil.deleteTree((File)file);
        }
        catch (Exception exception) {
            m_log.error((Object)("Unable to clean up repository temp dir: " + exception.getMessage()), (Throwable)exception);
        }
        super.destroy();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        boolean bl = false;
        String string2 = (String)httpServletRequest.getAttribute("__REAL_ACTION__");
        if (string2 == null) {
            string2 = this.extractActionName(httpServletRequest.getRequestURI());
        }
        m_log.debug((Object)("Requested action: " + string2));
        if (string2.endsWith(".do") || string2.equals("start")) {
            m_log.debug((Object)"Action name ends with .do.. good action");
            if (UserUtil.isUserAuthenticated((HttpServletRequest)httpServletRequest) || string2.equals("login.do")) {
                m_log.debug((Object)"User is authenticated or attempting to authenticate, allowing connection.");
                this.doPost(httpServletRequest, httpServletResponse);
            } else {
                string = httpServletRequest.getHeader("user-agent");
                m_log.debug((Object)("http user-agent is: " + string));
                if (string != null && string.equalsIgnoreCase(MCUPLOAD_USER_AGENT)) {
                    httpServletResponse.sendError(401, "Authentication Required");
                    return;
                }
                bl = true;
            }
        }
        if (bl) {
            string = "login.do";
            if (Server.initFailed()) {
                this.setResourceBundle(httpServletRequest);
                this.noDbErrorMsg(httpServletRequest);
                string = "actiontaken.jsp";
            }
            httpServletResponse.setContentType("text/html; charset=UTF-8");
            httpServletRequest.setAttribute("__REAL_ACTION__", (Object)string);
            m_log.debug((Object)("Bad action or unauthenticated user, redirecting to " + string));
            httpServletRequest.getRequestDispatcher(string).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private void setResourceBundle(HttpServletRequest httpServletRequest) {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        ResourceBundle resourceBundle = Resource.getClassBundle(string);
        m_log.debug((Object)("Setting resource bundle for this session to: " + string));
        httpServletRequest.setAttribute("ClassBundle", (Object)resourceBundle);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        m_log.debug((Object)"Starting new doPost request.");
        if (httpServletRequest.getCharacterEncoding() == null) {
            m_log.debug((Object)"Setting the default character encoding to UTF-8");
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setHeader("Cache-Control", "yes-cache");
        httpServletResponse.setHeader("Pragma", "yes-cache");
        httpServletResponse.setDateHeader("Expires", System.currentTimeMillis());
        String string = null;
        if (Server.initFailed()) {
            this.setResourceBundle(httpServletRequest);
            this.noDbErrorMsg(httpServletRequest);
            string = "actiontaken.jsp";
        } else {
            String string2;
            Server.setLocal(httpServletRequest);
            String string3 = this.extractActionName(httpServletRequest.getRequestURI());
            m_log.debug((Object)("action is: " + string3));
            if (this.m_lastAction.compareTo(string3) == 0) {
                string2 = (String)this.m_noRepeatMap.get(string3);
                if (string2 != null) {
                    m_log.debug((Object)("Attempting to repeat action: " + string3 + " forwarding to " + string2 + " instead."));
                    string3 = string2;
                } else {
                    SessionUtil.setScrollY((HttpServletRequest)httpServletRequest);
                }
            } else {
                this.m_lastAction = string3;
            }
            if (!UserUtil.isUserAuthenticated((HttpServletRequest)httpServletRequest) && string3.compareTo("login.do") != 0) {
                string2 = httpServletRequest.getHeader("user-agent");
                m_log.debug((Object)("http user-agent is: " + string2));
                if (string2 != null && string2.equalsIgnoreCase(MCUPLOAD_USER_AGENT)) {
                    httpServletResponse.sendError(401, "Authentication Required");
                    return;
                }
                string3 = "logout.do";
            }
            try {
                boolean bl = false;
                while (null == string) {
                    ActionBean actionBean;
                    if (!bl && !string3.equals("login.do")) {
                        this.setResourceBundle(httpServletRequest);
                        bl = true;
                    }
                    if ((actionBean = this.m_actionMap.getActionBean(string3)) == null) {
                        String string4 = "Action was unable to create the appropriate ActionBean: " + string3;
                        m_log.error((Object)string4);
                        throw new ServletException(string4);
                    }
                    if (actionBean instanceof AuthorizedAction) {
                        if (!((AuthorizedAction)actionBean).isAuthorized(UserUtil.getEpoUser((HttpServletRequest)httpServletRequest))) {
                            String string5 = "Unauthorized User for action: " + string3;
                            m_log.error((Object)string5);
                            httpServletResponse.sendError(403, "Forbidden");
                            return;
                        }
                    } else if (!"login.do".equals(string3) && !"logout.do".equals(string3)) {
                        m_log.debug((Object)("Action " + string3 + " in Webui does not implement AuthorizedAction."));
                    }
                    m_log.debug((Object)("Got action bean for action " + string3));
                    actionBean.initBean(httpServletRequest);
                    string = actionBean.validate(httpServletRequest);
                    if (string != null) {
                        m_log.warn((Object)("Warning: validation of action " + string3 + " failed."));
                        string3 = string;
                    } else {
                        m_log.debug((Object)("Executing action: " + string3));
                        string = actionBean.execute(httpServletRequest, httpServletResponse);
                        m_log.debug((Object)("Done executing action: " + string3));
                    }
                    if (string == null || !string.endsWith(".do")) continue;
                    string3 = string;
                    string = null;
                }
            }
            catch (Exception exception) {
                m_log.error((Object)"Exception thrown by ActionBean:", (Throwable)exception);
                httpServletRequest.setAttribute("errorBean", (Object)new ErrorMsgBean((Throwable)exception));
                string = "error.jsp";
            }
        }
        if (string.compareTo("sspiContinue") == 0) {
            m_log.debug((Object)"sspi NT authentication continue response");
            httpServletResponse.sendError(401, "Authentication Required");
            return;
        }
        if (string.compareTo(BLANK_JSP) != 0) {
            if (string.endsWith(".jsp")) {
                httpServletRequest.getRequestDispatcher(string).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendRedirect(string);
            }
        }
    }

    private String extractActionName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void noDbErrorMsg(HttpServletRequest httpServletRequest) {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = Resource.formatString("controllerservlet_template_init_errors", Server.getInitErrorString(), string);
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getString("common_server_error", string), (String)string2, (String)"start.jsp");
    }

    private String getLoginActionClass() {
        return LOGIN_ACTION;
    }

    private String getLogoutActionClass() {
        return LOGOUT_ACTION;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

