/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.webui.ui.util;

import com.mcafee.epo.core.util.StringUtil;
import com.mcafee.epo.webui.util.Resource;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class Tabs {
    public static final String TABS = "webuiTabs";
    private String m_page = null;
    private String m_curTab = null;
    private ArrayList m_data;
    private Hashtable m_activeAction;
    private String m_lang = null;

    public Tabs(String string) {
        this.m_lang = string;
        this.init();
    }

    private void init() {
        this.m_data = new ArrayList();
        this.m_data.add(new Tab(Resource.getString("tabs_machines", this.m_lang), Resource.getString("tabs_view_summary", this.m_lang), "displaynag.do", "nag.jsp", Resource.getString("page_view_summary", this.m_lang), "RMD_DisplayNag.html"));
        this.m_data.add(new Tab(null, null, "displayconfiguretable.do", "configuretable.jsp", Resource.getString("page_configure_table", this.m_lang), "RMD_DisplayConfigureTable.html"));
        this.m_activeAction = new Hashtable();
        this.m_activeAction.put(Resource.getString("tabs_machines", this.m_lang), "displaynag.do");
        this.m_activeAction.put(Resource.getString("tabs_subnets", this.m_lang), "displaysubnets.do");
        this.setPage("nag.jsp");
    }

    public String drawLocation() {
        return this.getTabFromPage((String)this.m_page).m_pageTitle;
    }

    public String drawHelp() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.getTabFromPage((String)this.m_page).m_helpID != null && this.getTabFromPage((String)this.m_page).m_helpID.length() != 0) {
            stringBuffer.append("<span onclick=\"callingHelp=true;\" >").append("<a href=\"javascript:try{ stopTimer();showHelp(").append(Resource.getString("help_locale", this.m_lang)).append(", '").append(this.getTabFromPage((String)this.m_page).m_helpID).append("') } catch(e){ alert('").append(StringUtil.safeHtml((String)Resource.getString("help_not_supported_in_browser_mode", this.m_lang), (boolean)false)).append("'); } \">").append(StringUtil.safeHtml((String)Resource.getString("help_help", this.m_lang), (boolean)false)).append("</a></span>");
        }
        return stringBuffer.toString();
    }

    public String drawTabs() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string = "";
        Iterator iterator = this.m_data.iterator();
        while (iterator.hasNext()) {
            Tab tab = (Tab)iterator.next();
            if (tab.m_tabName == null || string.compareTo(tab.m_tabName) == 0) continue;
            string = tab.m_tabName;
            if (this.m_curTab != null && this.m_curTab.compareTo(tab.m_tabName) == 0) {
                stringBuffer.append("<td bgcolor=\"#99CCCC\" class=\"bottomNoRule\" width=\"9\">");
                stringBuffer.append("<img src=\"images/tab_tanL.gif\" class=\"tabCapImg\" width=\"9\" height=\"17\" border=\"0\">");
                stringBuffer.append("</td>\n");
                stringBuffer.append("<td class=\"TabTan\" nowrap>").append(tab.m_tabName).append("</td>\n");
                stringBuffer.append("<td bgcolor=\"#99CCCC\" class=\"bottomNoRule\" width=\"9\">");
                stringBuffer.append("<img src=\"images/tab_tanR.gif\" class=\"tabCapImg\" width=\"9\" height=\"17\" border=\"0\">");
                stringBuffer.append("</td>\n");
            } else {
                stringBuffer.append("<td bgcolor=\"#99CCCC\" class=\"bottomBlckRule\" width=\"9\">");
                stringBuffer.append("<img src=\"images/tab_blueL.gif\" class=\"tabCapImg\" width=\"9\" height=\"17\" border=\"0\">");
                stringBuffer.append("</td>\n");
                stringBuffer.append("<td class=\"TabBlue2\" nowrap LANGUAGE=javascript onclick=\"doAction('").append(this.m_activeAction.get(string)).append("')\">").append(tab.m_tabName).append("</td>\n");
                stringBuffer.append("<td bgcolor=\"#99CCCC\" class=\"bottomBlckRule\" width=\"9\">");
                stringBuffer.append("<img src=\"images/tab_blueR.gif\" class=\"tabCapImg\" width=\"9\" height=\"17\" border=\"0\">");
                stringBuffer.append("</td>\n");
            }
            stringBuffer.append("<td width=\"1\" class=\"bottomBlckRule\">");
            stringBuffer.append("<img src=\"images/px_trans.gif\" alt=\"Spacer\" width=\"1\" height=\"1\" border=\"0\">");
            stringBuffer.append("</td>\n\n");
        }
        return stringBuffer.toString();
    }

    public String drawSubTabs() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        Iterator iterator = this.m_data.iterator();
        String string = "                        ";
        String string2 = "                            ";
        stringBuffer.append("<tr>\n");
        stringBuffer2.append(string).append("<tr>\n");
        while (iterator.hasNext()) {
            Tab tab = (Tab)iterator.next();
            if (this.m_curTab == null || tab.m_tabName == null || this.m_curTab.compareTo(tab.m_tabName) != 0 || tab.m_subName == null) continue;
            if (this.getTabFromPage((String)this.m_page).m_subName != null && this.getTabFromPage((String)this.m_page).m_subName.compareTo(tab.m_subName) == 0) {
                stringBuffer.append(string2).append("<td><b>").append(tab.m_subName).append("</b></td>\n");
                stringBuffer2.append(string2).append("<td align='center'>").append("<img src='images/tri_tan.gif' width='8' height='6'>").append("</td>\n");
            } else {
                stringBuffer.append(string2).append("<td>").append("<a href='").append(tab.m_action).append("' >").append(tab.m_subName).append("</a>").append("</td>\n");
                stringBuffer2.append(string2).append("<td align='center'>").append("<img src='images/px_trans.gif' width='8' height='6'>").append("</td>\n");
            }
            stringBuffer.append(string2).append("<td class='clsSubTabSeparator'> ").append("&nbsp;|&nbsp; ").append("</td>\n");
            stringBuffer2.append(string2).append("<td>").append("</td>\n");
        }
        int n = stringBuffer.lastIndexOf(string2 + "<td");
        if (n > 0) {
            stringBuffer.delete(n, stringBuffer.length());
        }
        if ((n = stringBuffer2.lastIndexOf(string2 + "<td")) > 0) {
            stringBuffer2.delete(n, stringBuffer2.length());
        }
        stringBuffer.append(string).append("</tr>\n");
        stringBuffer2.append(string).append("</tr>");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public void setPage(String string) {
        Tab tab = this.getTabFromPage(string);
        if (tab != null) {
            this.m_page = string;
            if (tab.m_tabName != null) {
                this.m_activeAction.put(tab.m_tabName, tab.m_action);
                this.m_curTab = tab.m_tabName;
            }
        }
    }

    public boolean isValidAction(String string) {
        boolean bl = false;
        Iterator iterator = this.m_data.iterator();
        Tab tab = null;
        while (!bl && iterator.hasNext()) {
            tab = (Tab)iterator.next();
            if (string.compareTo(tab.m_action) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public String getActiveAction(String string) {
        return (String)this.m_activeAction.get(string);
    }

    private Tab getTabFromPage(String string) {
        Iterator iterator = this.m_data.iterator();
        while (iterator.hasNext()) {
            Tab tab = (Tab)iterator.next();
            if (string.compareTo(tab.m_tabPage) != 0) continue;
            return tab;
        }
        return null;
    }

    class Tab {
        public String m_tabName = null;
        public String m_subName = null;
        public String m_action = null;
        public String m_tabPage = null;
        public String m_pageTitle = null;
        public String m_helpID = null;

        public Tab(String string, String string2, String string3, String string4, String string5, String string6) {
            this.m_tabName = string;
            this.m_subName = string2;
            this.m_action = string3;
            this.m_tabPage = string4;
            this.m_pageTitle = string5;
            this.m_helpID = string6;
        }
    }
}

