/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.action;

import com.mcafee.epo.compliance.action.Action;
import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionEnvironment;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.event.Response;
import com.mcafee.epo.compliance.server.ActionEnvironmentImpl;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ActionInvoker
implements Runnable {
    private final LinkedList m_queue = new LinkedList();
    private final LinkedList m_workers = new LinkedList();
    private boolean m_shutdown = false;
    private Response.ActionErrorHandler m_errorHandler = null;
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$action$ActionInvoker == null ? (class$com$mcafee$epo$compliance$action$ActionInvoker = ActionInvoker.class$("com.mcafee.epo.compliance.action.ActionInvoker")) : class$com$mcafee$epo$compliance$action$ActionInvoker).getName());
    static /* synthetic */ Class class$com$mcafee$epo$compliance$action$ActionInvoker;

    public static ActionQueueEntry makeAQE(Action action, ActionContext actionContext) {
        ActionQueueEntry actionQueueEntry = new ActionQueueEntry(action, actionContext);
        try {
            actionQueueEntry.createActionStatus();
        }
        catch (SQLException sQLException) {
            m_log.error((Object)"Unable to create ActionStatus.", (Throwable)sQLException);
        }
        return actionQueueEntry;
    }

    public ActionInvoker(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.addThread();
            ++n2;
        }
    }

    public void setErrorHandler(Response.ActionErrorHandler actionErrorHandler) {
        this.m_errorHandler = actionErrorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread() {
        LinkedList linkedList = this.m_workers;
        synchronized (linkedList) {
            Thread thread = new Thread(this);
            this.m_workers.add(thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.m_shutdown = true;
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.clear();
            this.m_queue.notifyAll();
        }
        LinkedList linkedList2 = this.m_workers;
        synchronized (linkedList2) {
            Thread thread;
            Iterator iterator = this.m_workers.iterator();
            while (iterator.hasNext()) {
                thread = (Thread)iterator.next();
                thread.interrupt();
            }
            iterator = this.m_workers.iterator();
            while (iterator.hasNext()) {
                thread = (Thread)iterator.next();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionQueueEntry getNextFromQueue() {
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            m_log.debug((Object)("Action queue size is: " + this.m_queue.size()));
            if (this.m_queue.size() > 0) {
                m_log.debug((Object)"Picking up an action from the action queue.");
                return (ActionQueueEntry)this.m_queue.removeFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(Action action, ActionContext actionContext) {
        m_log.debug((Object)"Adding a new action to the action queue.");
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            this.m_queue.addLast(ActionInvoker.makeAQE(action, actionContext));
            this.m_queue.notify();
        }
    }

    private static void setASParams(ActionStatus actionStatus, ActionContext actionContext, Connection connection) throws SQLException {
        Integer n;
        Host host = actionContext.getHost();
        Network network = actionContext.getNetwork();
        Sensor sensor = actionContext.getSensor();
        if (host != null) {
            actionStatus.setHostId(new Integer(host.getId()), connection);
        }
        if (network != null) {
            actionStatus.setNetworkId(new Integer(network.getId()), connection);
        }
        if (sensor != null) {
            actionStatus.setSensorId(new Integer(sensor.getId()), connection);
        }
        if ((n = actionContext.getEventId()) != null) {
            actionStatus.setEventLogId(n);
        } else {
            actionStatus.setEventLogId(new Integer(-1));
        }
    }

    public static ActionStatus invokeAction(Action action, ActionContext actionContext) throws ActionInvocationException {
        return ActionInvoker.doInvoke(ActionInvoker.makeAQE(action, actionContext));
    }

    private static ActionStatus doInvoke(ActionQueueEntry actionQueueEntry) throws ActionInvocationException {
        Action action = actionQueueEntry.getAction();
        ActionContext actionContext = actionQueueEntry.getContext();
        if (action != null && actionContext != null) {
            m_log.debug((Object)("Invoking action: " + action.toString()));
            ActionStatus actionStatus = actionQueueEntry.getActionStatus();
            try {
                int n = action.invoke(actionContext, actionStatus);
                actionStatus.setStatus(new Integer(n));
            }
            catch (ActionInvocationException actionInvocationException) {
                byte[] byArray;
                m_log.error((Object)"", (Throwable)actionInvocationException);
                StringWriter stringWriter = new StringWriter();
                actionInvocationException.printStackTrace(new PrintWriter(stringWriter));
                if (actionStatus.getStatus() == -1) {
                    actionStatus.setStatus(new Integer(1));
                }
                String string = (byArray = actionStatus.getActionOutput()) != null ? new String(byArray) : new String();
                string = string + actionInvocationException.getMessage() + "\n\n";
                string = string + stringWriter.toString();
                actionStatus.setActionOutputString(string);
                m_log.debug((Object)("Action " + action.toString() + " complete updating ActionStatus..."));
                actionQueueEntry.updateActionStatus();
                throw actionInvocationException;
            }
            m_log.debug((Object)("Action " + action.toString() + " complete updating ActionStatus..."));
            actionQueueEntry.updateActionStatus();
        }
        return actionQueueEntry.getActionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        ** GOTO lbl23
        {
            block9: {
                try {
                    ActionInvoker.doInvoke(var1_1);
                }
                catch (ActionInvocationException var2_3) {
                    if (this.m_errorHandler == null) break block9;
                    this.m_errorHandler.handleError(var1_1.getAction(), var1_1.getContext(), var2_3);
                }
            }
            do {
                if ((var1_1 = this.getNextFromQueue()) != null) continue block7;
                try {
                    var2_2 = this.m_queue;
                    synchronized (var2_2) {
                        this.m_queue.wait();
                    }
                }
                catch (InterruptedException var2_4) {
                    // empty catch block
                }
lbl23:
                // 3 sources

            } while (!this.m_shutdown);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ActionQueueEntry {
        Action m_action = null;
        ActionContext m_context = null;
        ActionStatus m_status = null;

        public ActionQueueEntry(Action action, ActionContext actionContext) {
            this.m_action = action;
            this.m_context = actionContext;
        }

        public Action getAction() {
            return this.m_action;
        }

        public ActionContext getContext() {
            return this.m_context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createActionStatus() throws SQLException {
            block5: {
                Connection connection = null;
                this.m_status = new ActionStatus();
                ActionEnvironment actionEnvironment = ActionEnvironment.instance();
                if (actionEnvironment != null) {
                    try {
                        connection = actionEnvironment.getDbConnection();
                        if (connection != null) {
                            m_log.debug((Object)"Got a database connection, adding ActionStatus to DB.");
                            ActionInvoker.setASParams(this.m_status, this.m_context, connection);
                            this.m_status.setActionType(this.m_action.getActionStatusBaseKey());
                            this.m_status.setStartTime(new Timestamp(System.currentTimeMillis()));
                            this.m_status.add(connection, true);
                            connection.commit();
                        } else {
                            m_log.debug((Object)"Got no database connection, skipping ActionStatus insert.");
                        }
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        DatabaseUtil.close((Connection)connection);
                        throw throwable;
                    }
                    DatabaseUtil.close((Connection)connection);
                    {
                        break block5;
                    }
                }
                m_log.debug((Object)"ActionEnvironment was NULL!");
            }
        }

        public ActionStatus getActionStatus() {
            return this.m_status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateActionStatus() {
            block6: {
                try {
                    if (this.m_status.getStatus() != -1) {
                        this.m_status.setEndTime(new Timestamp(System.currentTimeMillis()));
                    }
                    Connection connection = null;
                    ActionEnvironment actionEnvironment = ActionEnvironmentImpl.instance();
                    if (actionEnvironment == null) break block6;
                    try {
                        connection = actionEnvironment.getDbConnection();
                        if (connection != null) {
                            this.m_status.update(connection);
                            connection.commit();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        DatabaseUtil.close((Connection)connection);
                        throw throwable;
                    }
                    DatabaseUtil.close((Connection)connection);
                    {
                    }
                }
                catch (SQLException sQLException) {
                    m_log.error((Object)"Unable to update action status.", (Throwable)sQLException);
                }
            }
        }
    }
}

