/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.action.concrete;

import com.mcafee.epo.common.db.Tool;
import com.mcafee.epo.common.db.ToolRegistry;
import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionEnvironment;
import com.mcafee.epo.compliance.action.ActionImplBase;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.action.concrete.ETA.ExternalToolRunner;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.core.util.StringUtil;
import org.apache.log4j.Logger;

public class ExternalToolAction
extends ActionImplBase {
    public static final String TYPE = "external tool";
    public static final String[] PARAM_NAMES = new String[]{"ToolId"};
    private static final Logger m_log = Logger.getLogger((Class)(class$com$mcafee$epo$compliance$action$concrete$ExternalToolAction == null ? (class$com$mcafee$epo$compliance$action$concrete$ExternalToolAction = ExternalToolAction.class$("com.mcafee.epo.compliance.action.concrete.ExternalToolAction")) : class$com$mcafee$epo$compliance$action$concrete$ExternalToolAction));
    private static int m_ttl = 0;
    boolean m_blocking = true;
    private boolean m_killit = true;
    private int m_toolId = 0;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$action$concrete$ExternalToolAction;

    public boolean showInActionList() {
        return false;
    }

    public void killit() {
        this.m_killit = true;
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        block7: {
            ExternalToolRunner externalToolRunner = null;
            Tool tool = null;
            tool = this.findTool(ActionEnvironment.instance().getTools());
            if (tool == null) {
                throw new NullPointerException("The tool id could not be found.");
            }
            String string = StringUtil.substitute((String)tool.getCmdLine(), (StringUtil.Map)actionContext.getMap());
            String string2 = ToolRegistry.getExeCommandForApp((int)1, (String)tool.getExeName());
            if (string2 == null) {
                throw new NullPointerException("The tool command line could not be found.");
            }
            string2 = string2 + " " + string;
            externalToolRunner = new ExternalToolRunner(string2, Thread.currentThread(), actionStatus, actionContext.getHost());
            externalToolRunner.addActionStatusListener(this);
            externalToolRunner.start();
            if (!this.m_blocking) break block7;
            try {
                int n;
                if (m_ttl == 0) {
                    this.m_killit = false;
                    n = 500;
                } else {
                    n = m_ttl;
                }
                while (externalToolRunner.isAlive()) {
                    Thread.sleep(n);
                    if (!externalToolRunner.isAlive() || !this.m_killit) continue;
                    m_log.debug((Object)"The runner is still alive after the timeout.  Attempting to kill it.");
                    externalToolRunner.interrupt();
                    Thread.sleep(n);
                }
            }
            catch (InterruptedException interruptedException) {
                m_log.debug((Object)"Received an interrupt from child thread... exiting.");
            }
        }
        return actionStatus.getStatus();
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_tool_run";
    }

    public void setBlocking(boolean bl) {
        this.m_blocking = bl;
    }

    public boolean getBlocking() {
        return this.m_blocking;
    }

    private Tool findTool(Tool[] toolArray) {
        Tool tool = null;
        int n = 0;
        while (n < toolArray.length) {
            if (toolArray[n].getId() == this.m_toolId) {
                tool = toolArray[n];
                break;
            }
            ++n;
        }
        return tool;
    }

    public static void setTTL(int n) {
        m_ttl = n;
    }

    public static int getTTL() {
        return m_ttl;
    }

    public void setToolId(int n) {
        this.m_toolId = n;
    }

    public void setToolId(Integer n) {
        this.m_toolId = n;
    }

    public int getToolId() {
        return this.m_toolId;
    }

    public String getToolIdAsString() {
        return Integer.toString(this.m_toolId);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return PARAM_NAMES.length;
    }

    public String getPropertyName(int n) {
        if (n >= 1 && n <= this.getNumProperties()) {
            return PARAM_NAMES[n - 1];
        }
        return null;
    }

    public boolean isAsyncAction() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

