/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.action.concrete;

import com.mcafee.epo.compliance.action.ActionContext;
import com.mcafee.epo.compliance.action.ActionImplBase;
import com.mcafee.epo.compliance.action.ActionInvocationException;
import com.mcafee.epo.compliance.db.ActionStatus;
import com.mcafee.epo.core.EpoCore;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class SendEpoServerEventAction
extends ActionImplBase {
    public static final String TYPE = "send_event";
    public static final int EVENT_ID_ROGUE_SYSTEM = 16006;
    public static final int EVENT_ID_SUBNET_UNCOVERED = 16007;
    private static final String EVENT_PART_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ePOServerEvent>\r\n  <MachineInfo>\r\n    <AgentGUID>";
    private static final String EVENT_PART_1_5 = "</AgentGUID>\r\n  </MachineInfo>\r\n  <ePOSoftware ProductName=\"ePolicyOrchestrator\" ProductVersion=\"3.5.0\" ProductFamily=\"\">\r\n    <Event>\r\n      <EventID>";
    private static final String EVENT_PART_2 = "</EventID>\r\n      <Severity>1</Severity>\r\n      <GMTTime>";
    private static final String EVENT_PART_3 = "</GMTTime>\r\n      <ProductID>EPOSRVR_3500</ProductID>\r\n      <SourceComputers></SourceComputers>\r\n      <AffectedComputerNames>";
    private static final String EVENT_PART_4 = "</AffectedComputerNames>\r\n      <AdditionalInformation></AdditionalInformation>\r\n      <AffectedObjects>";
    private static final String EVENT_PART_5 = "</AffectedObjects>\r\n      <AffectedComputerIPs>";
    private static final String EVENT_PART_6 = "</AffectedComputerIPs>\r\n      <ThreatName></ThreatName>\r\n    </Event>\r\n  </ePOSoftware>\r\n</ePOServerEvent>\r\n";
    static /* synthetic */ Class class$com$mcafee$epo$compliance$action$concrete$SendEpoServerEventAction;

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        String string = EpoCore.getEpoDb().getEPODBDir();
        String string2 = SendEpoServerEventAction.generateRandomFilename(string);
        try {
            if (actionContext.getEventType() == 1 || actionContext.getEventType() == 3) {
                FileWriter fileWriter = new FileWriter(string2);
                this.writeEvent(actionContext, fileWriter);
                fileWriter.close();
            } else {
                Logger.getLogger((Class)(class$com$mcafee$epo$compliance$action$concrete$SendEpoServerEventAction == null ? (class$com$mcafee$epo$compliance$action$concrete$SendEpoServerEventAction = SendEpoServerEventAction.class$("com.mcafee.epo.compliance.action.concrete.SendEpoServerEventAction")) : class$com$mcafee$epo$compliance$action$concrete$SendEpoServerEventAction)).debug((Object)("SendEpoServerEventAction: Ignoring unknown event type:" + actionContext.getEventType()));
            }
        }
        catch (IOException iOException) {
            throw new ActionInvocationException(iOException);
        }
        return 0;
    }

    public boolean showInActionList() {
        return true;
    }

    public void writeEvent(ActionContext actionContext, Writer writer) throws IOException {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = null;
        switch (actionContext.getEventType()) {
            case 1: {
                n = 16006;
                if (actionContext.getHost() == null) break;
                string = actionContext.getHost().getFriendlyName();
                string2 = actionContext.getHost().getNetworkAddress();
                string4 = actionContext.getHost().getMAC();
                break;
            }
            case 3: {
                n = 16007;
                if (actionContext.getNetwork() == null) break;
                int n2 = actionContext.getNetwork().getNetworkAddressNum();
                string4 = Integer.toString(n2, 16);
                while (string4.length() < 12) {
                    string4 = string4 + "0";
                }
                string3 = actionContext.getNetwork().getAddressAndMask();
            }
        }
        writer.write(EVENT_PART_1);
        writer.write(this.makeFakeGUID(string4));
        writer.write(EVENT_PART_1_5);
        writer.write("" + n);
        writer.write(EVENT_PART_2);
        writer.write(SendEpoServerEventAction.getTimeISO8601());
        writer.write(EVENT_PART_3);
        writer.write(string);
        writer.write(EVENT_PART_4);
        writer.write(string3);
        writer.write(EVENT_PART_5);
        writer.write(string2);
        writer.write(EVENT_PART_6);
    }

    private final String makeFakeGUID(String string) {
        String string2 = "{00000000-0000-0000-0000-";
        string2 = string != null ? string2 + string : string2 + "000000000000";
        string2 = string2 + "}";
        return string2;
    }

    private static final String generateRandomFilename(String string) {
        int n = (int)(Math.random() * 2.147483647E9);
        return string + "/Events/SnowcapEvent" + n + ".xml";
    }

    private static final String getTimeISO8601() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    public String toString() {
        return "<send ePO event>";
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return 0;
    }

    public String getPropertyName(int n) {
        return "";
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_send_event";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

