/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db;

import com.mcafee.epo.compliance.db.EventLog;
import com.mcafee.epo.compliance.db.HNSParameterizer;
import com.mcafee.epo.compliance.db.Host;
import com.mcafee.epo.compliance.db.Network;
import com.mcafee.epo.compliance.db.Sensor;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.DatabaseObject;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import com.mcafee.epo.core.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;

public class ActionStatus
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_EVENT_LOG_ID = 2;
    public static final int COL_HOST_ID = 3;
    public static final int COL_NETWORK_ID = 4;
    public static final int COL_SENSOR_ID = 5;
    public static final int COL_ACTION_TYPE = 6;
    public static final int COL_STATUS = 7;
    public static final int COL_START_TIME = 8;
    public static final int COL_END_TIME = 9;
    public static final int COL_END_KEY = 10;
    public static final int COL_ARCHIVE = 11;
    public static final int COL_ACTION_OUTPUT = 12;
    public static final int COL_ACTION_DETAIL = 13;
    public static final int NUM_COLUMNS = 13;
    public static final int COL_EVENTLOG_TYPE = 14;
    public static final int COL_EVENTLOG_TIMESTAMP = 15;
    public static final int COL_H_FRIENDLY_NAME = 16;
    public static final int COL_N_SUBNET_MASK = 17;
    public static final int COL_N_NETWORK_ADDRESS = 18;
    public static final int COL_S_SENSOR_NAME = 19;
    public static final int PROP_STATUS_STRING = 20;
    public static final int PROP_START_TIME_FORMATTED = 21;
    public static final int PROP_END_TIME_FORMATTED = 22;
    public static final int PROP_EVENT_CREATE_TIME_FORMATTED = 23;
    public static final int PROP_DESCRIPTION = 24;
    public static final int PROP_NETWORKNAME = 25;
    public static final int PROP_ACTION_TYPE_STRING = 26;
    public static final int MAX_LEN_END_KEY = 128;
    public static final int MAX_LEN_TYPE = 128;
    public static final int MAX_DETAIL_LEN = 128;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_IN_PROGRESS = -1;
    public static final int STATUS_ERROR = 1;
    public static final String TYPE_NEW_ROGUE = "actionstatus_markasrogue";
    public static final String TYPE_SENSOR_INSTALL = "actionstatus_sensor_install";
    public static final String TYPE_AGENT_PUSH = "actionstatus_agent_push";
    public static final String TYPE_TOOL_RUN = "actionstatus_tool_run";
    public static final String TYPE_EXCEPT_HOST = "actionstatus_except_host";
    public static final String TYPE_UNEXCEPT_HOST = "actionstatus_unexcept_host";
    public static final String TYPE_ADDTO_EPO_TREE = "actionstatus_addto_epo_tree";
    public static final String TYPE_REMOVE_HOST = "actionstatus_remove_host";
    public static final String TYPE_QUERY_EPOAGENT = "actionstatus_query_epoagent";
    public static final String TYPE_MARK_FOR_ACTION = "actionstatus_mark_for_action";
    public static final String TYPE_UNMARK_FOR_ACTION = "actionstatus_unmark_for_action";
    public static final String[] PROPERTY_NAMES = new String[]{"", "ActionStatusId", "EventLogId", "TargetHostId", "TargetNetworkId", "TargetSensorId", "ActionType", "Status", "StartTime", "EndTime", "EndKey", "Archive", "ActionOutput", "ActionDetail", "EventType", "EventLogTimestamp", "TargetHostName", "TargetSubnetMask", "TargetNetworkAddr", "TargetSensorName", "StatusString", "FormattedStartTime", "FormattedEndTime", "FormattedEventTime", "Description", "TargetNetworkName", "ActionTypeString"};
    private static final String UPDATE_STMTSQL = "update ActionStatus set EndTime=?, Status=? where <FIELD>=? and ActionType=? and EndTime is null";
    private int m_id = -1;
    private Integer m_eventLogId = new Integer(-1);
    private Integer m_hostId = null;
    private Integer m_networkId = null;
    private Integer m_sensorId = null;
    private String m_actionType = "actionstatus_sensor_install";
    private Integer m_status = new Integer(-1);
    private Timestamp m_startTime = null;
    private Timestamp m_endTime = null;
    private String m_endKey = "";
    private boolean m_archive = false;
    private byte[] m_actionOutput = null;
    private String m_actionDetail = "";
    private String m_HFriendlyName = null;
    private String m_NNetworkAddr = null;
    private String m_NSubnetMask = null;
    private String m_SSensorName = null;
    private int m_eventType = 0;
    private Timestamp m_eventLogTimestamp = null;
    private HNSParameterizer m_paramMap = new HNSParameterizer();
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$ActionStatus;

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public int getNumProperties() {
        return PROPERTY_NAMES.length;
    }

    public static final void removeHostReference(Connection connection, int n) throws SQLException {
        DatabaseUtil.executeUpdate((Connection)connection, (String)("update ActionStatus set TargetHostId=null where TargetHostId=" + n));
    }

    public static final ActionStatus[] getByQuery(Connection connection, String string) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$mcafee$epo$compliance$db$ActionStatus == null ? (class$com$mcafee$epo$compliance$db$ActionStatus = ActionStatus.class$("com.mcafee.epo.compliance.db.ActionStatus")) : class$com$mcafee$epo$compliance$db$ActionStatus));
        return ActionStatus.vectorToArray(vector, connection);
    }

    public static final ActionStatus[] getByQuery(Connection connection, String string, int n, int n2) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$mcafee$epo$compliance$db$ActionStatus == null ? (class$com$mcafee$epo$compliance$db$ActionStatus = ActionStatus.class$("com.mcafee.epo.compliance.db.ActionStatus")) : class$com$mcafee$epo$compliance$db$ActionStatus), (int)n, (int)n2);
        return ActionStatus.vectorToArray(vector, connection);
    }

    public static final ActionStatus[] getNonRMD(Connection connection) throws SQLException {
        return ActionStatus.getByQuery(connection, "select * from ActionStatus where ActionType!='actionstatus_markasrogue' order by ActionStatusId desc");
    }

    public static final ActionStatus[] getAll(Connection connection) throws SQLException {
        return ActionStatus.getByQuery(connection, "select * from ActionStatus order by StartTime desc");
    }

    public static final ActionStatus getByID(Connection connection, int n) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)("select * from ActionStatus where ActionStatusID=" + n), (Class)(class$com$mcafee$epo$compliance$db$ActionStatus == null ? (class$com$mcafee$epo$compliance$db$ActionStatus = ActionStatus.class$("com.mcafee.epo.compliance.db.ActionStatus")) : class$com$mcafee$epo$compliance$db$ActionStatus));
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException("Internal Error: ActionStatus.getById() returned >1 row!");
        }
        ActionStatus actionStatus = (ActionStatus)((Object)vector.get(0));
        actionStatus.loadParamMap(connection);
        return actionStatus;
    }

    public static final void deleteByID(Connection connection, int n) throws SQLException {
        ActionStatus.deleteByID(connection, Integer.toString(n));
    }

    public static final void deleteByID(Connection connection, String string) throws SQLException {
        DatabaseUtil.executeUpdate((Connection)connection, (String)("update ActionStatus set Archive='1' where ActionStatusId=" + string));
    }

    public void loadParamMap(Connection connection) throws SQLException {
        Integer n = this.m_hostId != null ? this.m_hostId : new Integer(-1);
        Integer n2 = this.m_networkId != null ? this.m_networkId : new Integer(-1);
        Integer n3 = this.m_sensorId != null ? this.m_sensorId : new Integer(-1);
        this.m_paramMap.loadParamMap(connection, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void updateSenorDeployedStatus(Connection connection, String string, Timestamp timestamp) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string2 = UPDATE_STMTSQL.replaceFirst("<FIELD>", "Endkey");
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setTimestamp(1, timestamp);
            preparedStatement.setInt(2, 0);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, TYPE_SENSOR_INSTALL);
            preparedStatement.executeUpdate();
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void updateAgentDeployedStatus(Connection connection, int n, Timestamp timestamp) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = UPDATE_STMTSQL.replaceFirst("<FIELD>", "TargetHostId");
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setTimestamp(1, timestamp);
            preparedStatement.setInt(2, 0);
            preparedStatement.setInt(3, n);
            preparedStatement.setString(4, TYPE_AGENT_PUSH);
            preparedStatement.executeUpdate();
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public String getActionTypeString() {
        String string = this.getActionType();
        if (string == null) {
            return "--";
        }
        return string;
    }

    public String getFormattedStartTime() {
        return StringUtil.formatDateTime((Timestamp)this.m_startTime, (int)2, (int)1, (String)Server.getDefaultLocale());
    }

    public String getFormattedEndTime() {
        return StringUtil.formatDateTime((Timestamp)this.m_endTime, (int)2, (int)1, (String)Server.getDefaultLocale());
    }

    public void setFormattedEndTime() {
    }

    public String getFormattedEventTime() {
        return EventLog.formatTimestamp(this.m_eventLogTimestamp);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String string) {
        String string2 = Resource.getDataString(this.m_actionType + "_description", string);
        if (this.m_actionDetail != null) {
            String string3 = Resource.getString(this.m_actionDetail, string);
            String string4 = "{ActionDetail}";
            int n = string2.indexOf(string4);
            if (n != -1) {
                String string5 = string2.substring(0, n);
                string5 = string5 + string3;
                int n2 = n + string4.length();
                if (n2 < string2.length()) {
                    string5 = string5 + string2.substring(n2);
                }
                string2 = string5;
            }
        }
        return StringUtil.substitute((String)string2, (StringUtil.Map)this.m_paramMap.getMap());
    }

    public void setDescription() {
    }

    public String getInsertSql() {
        return "insert into ActionStatus values (?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    public String getUpdateSql() {
        return "update ActionStatus set EventLogId=?, TargetHostId=?, TargetNetworkId=?, TargetSensorId=?, ActionType=?, Status=?, StartTime=?, EndTime=?, Endkey=?, Archive=?, ActionOutput=?, ActionDetail=? where ActionStatusID=?";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (Integer)this.m_eventLogId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (Integer)this.m_hostId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (Integer)this.m_networkId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (Integer)this.m_sensorId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (String)this.m_actionType, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (Integer)this.m_status);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (Timestamp)this.m_startTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (Timestamp)this.m_endTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)9, (String)this.m_endKey, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)10, (boolean)this.m_archive);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)11, (byte[])this.m_actionOutput);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)12, (String)this.m_actionDetail);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)13, (int)this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public int getId() {
        return this.m_id;
    }

    public int getActionStatusId() {
        return this.getId();
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public void setActionStatusId(int n) {
        this.setId(n);
    }

    public String getEndKey() {
        return this.m_endKey;
    }

    public void setEndKey(String string) {
        this.m_endKey = string;
    }

    public void setAgentGUID(String string) {
        this.m_endKey = string;
    }

    public String getActionType() {
        return this.m_actionType;
    }

    public void setActionType(String string) {
        this.m_actionType = string;
    }

    public Integer getStatus() {
        return this.m_status;
    }

    public void setStatus(Integer n) {
        this.m_status = n;
    }

    public Timestamp getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Timestamp timestamp) {
        this.m_startTime = timestamp;
    }

    public Timestamp getEndTime() {
        return this.m_endTime;
    }

    public void setEndTime(Timestamp timestamp) {
        this.m_endTime = timestamp;
    }

    public Integer getTargetHostId() {
        return this.m_hostId;
    }

    public void setTargetHostId(Integer n) {
        this.m_hostId = n;
    }

    public void setHostId(Integer n, Connection connection) throws SQLException {
        if (n != -1) {
            this.m_hostId = n;
            this.m_paramMap.setHost(Host.getByID(connection, n));
        }
    }

    public void setEventLogId(Integer n) {
        this.m_eventLogId = n;
    }

    public Integer getEventLogId() {
        return this.m_eventLogId;
    }

    public Integer getTargetNetworkId() {
        return this.m_networkId;
    }

    public void setTargetNetworkId(Integer n) {
        this.m_networkId = n;
    }

    public void setNetworkId(Integer n, Connection connection) throws SQLException {
        if (n != -1) {
            this.m_networkId = n;
            this.m_paramMap.setNetwork(Network.getByID(connection, n));
        }
    }

    public void setTargetSensorId(Integer n) {
        this.m_sensorId = n;
    }

    public void setSensorId(Integer n, Connection connection) throws SQLException {
        if (n != -1) {
            this.m_sensorId = n;
            this.m_paramMap.setSensor(Sensor.getByID(connection, n));
        }
    }

    public Integer getTargetSensorId() {
        return this.m_sensorId;
    }

    public void setArchive(boolean bl) {
        this.m_archive = bl;
    }

    public boolean getArchive() {
        return this.m_archive;
    }

    public void setActionOutput(byte[] byArray) {
        this.m_actionOutput = byArray;
    }

    public void setActionOutputString(String string) {
        block2: {
            if (string == null || string.length() <= 0) break block2;
            try {
                this.m_actionOutput = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    public byte[] getActionOutput() {
        return this.m_actionOutput;
    }

    public void setActionDetail(String string) {
        this.m_actionDetail = string;
    }

    public String getActionDetail() {
        return this.m_actionDetail;
    }

    public void setTargetHostName(String string) {
        this.m_HFriendlyName = string;
    }

    public String getTargetHostName() {
        return this.m_HFriendlyName;
    }

    public void setTargetSubnetMask(String string) {
        this.m_NSubnetMask = string;
    }

    public String getTargetSubnetMask() {
        return this.m_NSubnetMask;
    }

    public void setTargetNetworkAddr(String string) {
        this.m_NNetworkAddr = string;
    }

    public String getTargetNetworkAddr() {
        return this.m_NNetworkAddr;
    }

    public String getTargetNetworkName() {
        if (this.m_NNetworkAddr == null || this.m_NSubnetMask == null) {
            return null;
        }
        return this.m_NNetworkAddr + StringUtil.getShortNetmask((String)this.m_NSubnetMask);
    }

    public void setTargetSensorName(String string) {
        this.m_SSensorName = string;
    }

    public String getTargetSensorName() {
        return this.m_SSensorName;
    }

    public void setEventType(int n) {
        this.m_eventType = n;
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public void setEventLogTimestamp(Timestamp timestamp) {
        this.m_eventLogTimestamp = timestamp;
    }

    public Timestamp getEventLogTimestamp() {
        return this.m_eventLogTimestamp;
    }

    public String getEventLogTimestampAsString() {
        return StringUtil.formatDateTime((Timestamp)this.m_eventLogTimestamp);
    }

    public HNSParameterizer getParameterizer() {
        return this.m_paramMap;
    }

    private static ActionStatus[] vectorToArray(Vector vector, Connection connection) throws SQLException {
        Object object;
        if (vector.size() == 0) {
            return null;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (ActionStatus)((Object)iterator.next());
            ((ActionStatus)((Object)object)).loadParamMap(connection);
        }
        object = new ActionStatus[]{};
        return vector.toArray((T[])object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

