/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db.action;

import com.mcafee.epo.compliance.db.action.ActionBase;
import com.mcafee.epo.compliance.db.action.ActionFactoryException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class ActionFactory {
    private ArrayList m_createInfo = new ArrayList();

    public ActionFactory() {
    }

    public ActionFactory(Connection connection) throws SQLException {
        this.load(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(Connection connection) throws SQLException {
        Statement statement = null;
        this.m_createInfo.clear();
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from ActionClasses");
            while (resultSet.next()) {
                this.register(resultSet.getString(1), resultSet.getString(2));
            }
            Object var5_4 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    public ActionBase create(String string) throws ActionFactoryException {
        int n = 0;
        while (n < this.m_createInfo.size()) {
            CreateInfo createInfo = (CreateInfo)this.m_createInfo.get(n);
            if (createInfo.m_type.equals(string)) {
                return this.create(createInfo);
            }
            ++n;
        }
        throw new ActionFactoryException("Could not find creation information for action type:" + string);
    }

    private ActionBase create(CreateInfo createInfo) throws ActionFactoryException {
        ActionBase actionBase;
        try {
            actionBase = (ActionBase)Class.forName(createInfo.m_className).newInstance();
        }
        catch (Exception exception) {
            throw new ActionFactoryException("Error creating Action class:" + createInfo.m_className, exception);
        }
        return actionBase;
    }

    public ActionBase[] createAll() throws ActionFactoryException {
        Vector<ActionBase> vector = new Vector<ActionBase>();
        ActionBase[] actionBaseArray = new ActionBase[]{};
        int n = 0;
        while (n < this.m_createInfo.size()) {
            CreateInfo createInfo = (CreateInfo)this.m_createInfo.get(n);
            vector.add(this.create(createInfo));
            ++n;
        }
        return vector.toArray(actionBaseArray);
    }

    public final void register(String string, String string2) {
        this.m_createInfo.add(new CreateInfo(string, string2));
    }

    public int getNumActions() {
        return this.m_createInfo.size();
    }

    public String getTypeName(int n) {
        return ((CreateInfo)this.m_createInfo.get((int)n)).m_type;
    }

    public String getClassName(int n) {
        return ((CreateInfo)this.m_createInfo.get((int)n)).m_className;
    }

    private static class CreateInfo {
        public String m_type;
        public String m_className;

        public CreateInfo(String string, String string2) {
            this.m_type = string;
            this.m_className = string2;
        }
    }
}

