/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db.io;

import com.mcafee.epo.compliance.db.SchemaVersion;
import com.mcafee.epo.compliance.db.SchemaVersionException;
import com.mcafee.epo.compliance.db.io.Docks;
import com.mcafee.epo.compliance.server.Server;
import com.mcafee.epo.compliance.util.Resource;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.db.base.DatabaseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DockMonkey {
    private Docks m_dock;
    private Database m_db = Server.getDb();
    private static final Logger m_log = Logger.getLogger((String)(class$com$mcafee$epo$compliance$db$io$DockMonkey == null ? (class$com$mcafee$epo$compliance$db$io$DockMonkey = DockMonkey.class$("com.mcafee.epo.compliance.db.io.DockMonkey")) : class$com$mcafee$epo$compliance$db$io$DockMonkey).getName());
    private HashMap m_colNameToTypeMap;
    private String m_defaultLocale = null;
    static /* synthetic */ Class class$com$mcafee$epo$compliance$db$io$DockMonkey;

    public void setDefaultLocale(String string) {
        this.m_defaultLocale = string;
    }

    public String getDefaultLocale() {
        return this.m_defaultLocale;
    }

    public DockMonkey(Docks docks) {
        this.m_dock = docks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(String string, OutputStream outputStream) throws SQLException, IOException {
        block9: {
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            Statement statement = null;
            Connection connection = null;
            try {
                String string2;
                m_log.debug((Object)"Unloading the data from the database to the requested dock.");
                m_log.debug((Object)"Getting database connection...");
                connection = this.m_db.getConnection();
                m_log.debug((Object)"Creating the database statement.");
                statement = connection.createStatement();
                m_log.debug((Object)"Getting the current schema version #.");
                statement.execute(SchemaVersion.GET_SCHEMA_VERSION);
                resultSet2 = statement.getResultSet();
                if (resultSet2 != null) {
                    resultSet2.next();
                    string2 = resultSet2.getString(1);
                } else {
                    string2 = "unknown";
                }
                m_log.debug((Object)("Current schema version # is: " + string2));
                m_log.debug((Object)("Querying for export data.  SQL: " + string));
                statement.execute(string);
                resultSet = statement.getResultSet();
                if (resultSet != null) {
                    m_log.debug((Object)"Doing the export.");
                    this.m_dock.Export(string2, resultSet, outputStream);
                    break block9;
                }
                throw new NullPointerException(Resource.getString("dockmonkey_no_data", this.m_defaultLocale));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (resultSet2 != null) {
                    resultSet2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                DatabaseUtil.close((Connection)connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getColNameToTypeMapping(Connection connection, String string) throws SQLException {
        Object object;
        block4: {
            ResultSet resultSet = null;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getColumns(connection.getCatalog(), null, string, null);
                if (resultSet != null) {
                    m_log.debug((Object)"Associating columId's with column names...");
                    while (resultSet.next()) {
                        object = resultSet.getString(6);
                        String string2 = resultSet.getString(4);
                        m_log.debug((Object)("Associating column ID: " + (String)object + " with column: " + string2));
                        hashMap.put(string2, object);
                    }
                }
                object = hashMap;
                Object var9_8 = null;
                if (resultSet == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var9_9 = null;
                    if (resultSet == null) break block5;
                    resultSet.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        return object;
    }

    private String handleQuotes(String string) {
        m_log.debug((Object)("Doubling up all quotes in the string: " + string));
        int n = 0;
        while ((n = string.indexOf(39, n)) != -1) {
            String string2 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
            string = string + "''";
            string = string + string2;
            n += 2;
            n += 2;
        }
        return string;
    }

    private HashMap getDBPairs(HashMap hashMap, int n) {
        Iterator iterator = hashMap.entrySet().iterator();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = hashMap.get(string);
            if (!(v instanceof Vector)) continue;
            Vector vector = (Vector)v;
            String string2 = this.handleQuotes((String)vector.get(n));
            hashMap2.put(string, string2);
        }
        return hashMap2;
    }

    public void trimSQL(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n) == ',' || stringBuffer.charAt(n) == ' ') {
            stringBuffer.deleteCharAt(n);
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream, String string, String string2, HashMap hashMap) throws SQLException, IOException, SchemaVersionException, ParseException {
        Connection connection = null;
        m_log.debug((Object)"Parsing XML document.");
        HashMap hashMap2 = this.m_dock.Import(inputStream);
        m_log.debug((Object)"Done parsing XML..");
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        Statement statement = null;
        try {
            Vector vector;
            m_log.debug((Object)"Loading the database with import data.");
            connection = this.m_db.getConnection();
            statement = connection.createStatement();
            this.m_colNameToTypeMap = this.getColNameToTypeMapping(connection, string);
            String string3 = "insert into " + string + " ";
            String string4 = "update " + string + " ";
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("Joining import to database along key: " + string2));
            }
            if ((vector = (Vector)hashMap2.get(string2)) == null) {
                String string5 = Resource.getString("dockmonkey_no_datatoimport", this.m_defaultLocale);
                m_log.warn((Object)string5);
                throw new IOException(string5);
            }
            String string6 = "select * from " + string + " where " + string2 + "=";
            m_log.info((Object)Resource.formatString("dockmonkey_template_importing", vector.size(), this.m_defaultLocale));
            int n = 0;
            while (n < vector.size()) {
                String string7 = string6 + "'" + (String)vector.get(n) + "'";
                statement.execute(string7);
                resultSet = statement.getResultSet();
                if (resultSet != null) {
                    String string8;
                    String string9;
                    Iterator iterator;
                    StringBuffer stringBuffer;
                    HashMap hashMap3 = this.getDBPairs(hashMap2, n);
                    if (resultSet.next()) {
                        stringBuffer = new StringBuffer(string4);
                        stringBuffer.append("set ");
                        iterator = this.m_colNameToTypeMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            string9 = (String)iterator.next();
                            if (((String)this.m_colNameToTypeMap.get(string9)).indexOf("identity") != -1 || (string8 = (String)hashMap3.get(string9)) == null) continue;
                            stringBuffer.append(string9);
                            stringBuffer.append("=");
                            stringBuffer.append("'");
                            stringBuffer.append(string8);
                            stringBuffer.append("', ");
                        }
                        stringBuffer.deleteCharAt(stringBuffer.length() - 2);
                        String string10 = (String)hashMap3.get(string2);
                        stringBuffer.append(" where ");
                        stringBuffer.append(string2);
                        stringBuffer.append("='");
                        stringBuffer.append(string10);
                        stringBuffer.append("'");
                    } else {
                        stringBuffer = new StringBuffer(string3);
                        stringBuffer.append("(");
                        iterator = this.m_colNameToTypeMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            string9 = (String)iterator.next();
                            if (((String)this.m_colNameToTypeMap.get(string9)).indexOf("identity") != -1) continue;
                            stringBuffer.append(string9);
                            stringBuffer.append(",");
                        }
                        this.trimSQL(stringBuffer);
                        stringBuffer.append(") VALUES(");
                        iterator = this.m_colNameToTypeMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            string9 = (String)iterator.next();
                            if (((String)this.m_colNameToTypeMap.get(string9)).indexOf("identity") != -1) continue;
                            string8 = (String)hashMap3.get(string9);
                            if (string8 == null) {
                                string8 = (String)hashMap.get(string9);
                            }
                            if (string8 == null) {
                                string8 = "";
                            }
                            if (!string8.equals("NULL")) {
                                stringBuffer.append("'");
                                stringBuffer.append(string8);
                                stringBuffer.append("', ");
                                continue;
                            }
                            stringBuffer.append(string8 + " ,");
                        }
                        this.trimSQL(stringBuffer);
                        stringBuffer.append(")");
                    }
                    m_log.debug((Object)("Excecuting the SQL: " + stringBuffer));
                    statement.execute(stringBuffer.toString());
                    connection.commit();
                }
                ++n;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (resultSet2 != null) {
                resultSet2.close();
            }
            if (statement != null) {
                statement.close();
            }
            DatabaseUtil.close((Connection)connection);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

