/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.db.policymgt;

import com.mcafee.epo.common.policy.db.PolicySettings;
import com.mcafee.epo.core.db.base.Database;
import com.mcafee.epo.core.util.thread.FileBiff;
import com.mcafee.epo.core.util.thread.FileChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class PolicySyncBase
implements FileChangeListener {
    private static PolicySyncBase m_singleton = null;
    private URL m_fileUrl;
    private Database m_db = null;

    public abstract void loadFile() throws IOException, ParserConfigurationException, SAXException;

    public abstract void setPolicyValues(PolicySettings var1) throws SQLException;

    public abstract URL getFileUrl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init(Database database, FileBiff fileBiff) throws IOException, ParserConfigurationException, SAXException, SQLException {
        PolicySyncBase policySyncBase = m_singleton;
        synchronized (policySyncBase) {
            m_singleton.setDb(database);
            m_singleton.doUpdate();
            m_singleton.setupChangeListeners(fileBiff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PolicySyncBase instance() {
        PolicySyncBase policySyncBase = m_singleton;
        synchronized (policySyncBase) {
            return m_singleton;
        }
    }

    protected void setDb(Database database) {
        this.m_db = database;
    }

    private void setupChangeListeners(FileBiff fileBiff) throws FileNotFoundException {
        fileBiff.addChangeListener(this.m_fileUrl.getFile(), 5000L, (FileChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate() throws SQLException, IOException, ParserConfigurationException, SAXException {
        PolicySyncBase policySyncBase = this;
        synchronized (policySyncBase) {
            try {
                this.loadFile();
                this.doPolicyStuff();
                Object var3_2 = null;
                this.notifyAll();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.notifyAll();
                throw throwable;
            }
        }
    }

    private void doPolicyStuff() throws SQLException {
    }
}

