/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.epo.compliance.event;

import com.mcafee.epo.compliance.event.Event;
import com.mcafee.epo.compliance.event.EventHandler;
import java.util.ArrayList;
import java.util.LinkedList;

public class EventDispatcher
implements Runnable {
    private volatile ArrayList m_handlers = new ArrayList();
    private LinkedList m_events = new LinkedList();
    private Thread[] m_threads = null;
    private volatile boolean m_bShouldStop = false;

    public void replaceHandlers(EventHandler[] eventHandlerArray) {
        ArrayList<EventHandler> arrayList = new ArrayList<EventHandler>();
        int n = 0;
        while (n < eventHandlerArray.length) {
            arrayList.add(eventHandlerArray[n]);
            ++n;
        }
        this.m_handlers = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) {
        LinkedList linkedList = this.m_events;
        synchronized (linkedList) {
            this.m_events.add(event);
            this.m_events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numEvents() {
        LinkedList linkedList = this.m_events;
        synchronized (linkedList) {
            return this.m_events.size();
        }
    }

    public synchronized void start(int n) {
        if (this.m_threads != null) {
            throw new IllegalStateException("Internal error: call to EventDispatcher.start() twice!");
        }
        this.m_bShouldStop = false;
        this.m_threads = new Thread[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_threads[n2] = new Thread((Runnable)this, "EventDispatcher" + n2);
            this.m_threads[n2].setDaemon(true);
            this.m_threads[n2].start();
            ++n2;
        }
    }

    public synchronized void stop(boolean bl) {
        if (this.m_threads == null) {
            return;
        }
        this.m_bShouldStop = true;
        int n = 0;
        while (n < this.m_threads.length) {
            this.m_threads[n].interrupt();
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < this.m_threads.length) {
                try {
                    this.m_threads[n2].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.m_threads = null;
    }

    public void stop() {
        this.stop(true);
    }

    public void run() {
        while (!this.m_bShouldStop) {
            try {
                this.dispatchEvent(this.getNextEvent());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void dispatchEvent(Event event) {
        ArrayList arrayList = this.m_handlers;
        int n = 0;
        while (n < arrayList.size()) {
            ((EventHandler)arrayList.get(n)).handleEvent(event);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event getNextEvent() throws InterruptedException {
        LinkedList linkedList = this.m_events;
        synchronized (linkedList) {
            while (this.m_events.isEmpty()) {
                this.m_events.wait();
            }
            return (Event)this.m_events.removeFirst();
        }
    }
}

